/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.common.re.handlers.location;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashSet;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.resource.Resource;
import org.polarsys.capella.common.flexibility.properties.schema.IProperty;
import org.polarsys.capella.common.flexibility.properties.schema.IPropertyContext;
import org.polarsys.capella.common.re.CatalogElement;
import org.polarsys.capella.common.re.CatalogElementLink;
import org.polarsys.capella.common.re.handlers.location.ILocationHandler;
import org.polarsys.capella.common.re.handlers.replicable.ReplicableElementHandlerHelper;
import org.polarsys.capella.core.transition.common.handlers.attachment.AttachmentHelper;
import org.polarsys.capella.core.transition.common.handlers.contextscope.ContextScopeHandlerHelper;
import org.polarsys.capella.core.transition.common.handlers.options.IPropertyHandler;
import org.polarsys.capella.core.transition.common.handlers.options.OptionsHandlerHelper;
import org.polarsys.capella.core.transition.common.handlers.traceability.TraceabilityHandlerHelper;
import org.polarsys.capella.core.transition.common.rules.IRuleAttachment;
import org.polarsys.kitalpha.transposer.rules.handler.api.IRulesHandler;
import org.polarsys.kitalpha.transposer.rules.handler.exceptions.possibilities.MappingPossibilityResolutionException;
import org.polarsys.kitalpha.transposer.rules.handler.rules.api.IContext;
import org.polarsys.kitalpha.transposer.rules.handler.rules.api.IRule;
import org.polarsys.kitalpha.transposer.rules.handler.rules.common.MappingPossibility;

public class DefaultLocationHandler
implements ILocationHandler {
    HashMap<EObject, EObject> currentLocation = new HashMap();
    HashMap<CatalogElementLink, EObject> locations = new HashMap();
    HashMap<CatalogElementLink, EObject> defaultLocations = new HashMap();

    @Override
    public EObject getCurrentLocation(CatalogElementLink object, IContext context) {
        if (this.currentLocation.containsKey(object)) {
            return this.currentLocation.get(object);
        }
        return null;
    }

    private boolean isInvalidResourceLocation(CatalogElementLink link, EObject location, IContext context) {
        Resource targetElementResource;
        Resource targetResource;
        Resource sourceElementResource;
        if (location == null) {
            return true;
        }
        Collection elements = (Collection)context.get((Object)"TRANSITION_SOURCES");
        CatalogElement sourceElement = ReplicableElementHandlerHelper.getInstance(context).getSource(context);
        CatalogElement targetElement = ReplicableElementHandlerHelper.getInstance(context).getTarget(context);
        Resource destinationResource = ((EObject)elements.iterator().next()).eResource();
        boolean isSource = false;
        CatalogElement elementSource = link.getSource();
        if (elementSource == null) {
            return true;
        }
        if (elementSource.equals(sourceElement)) {
            isSource = true;
        } else if (elementSource.equals(targetElement)) {
            isSource = false;
        }
        boolean isSelectionForSource = false;
        String value = (String)context.get((Object)"COMMAND__CURRENT_VALUE");
        if ("COMMAND__UPDATE_DEFINITION_REPLICA_FROM_REPLICA".equals(value)) {
            isSelectionForSource = true;
        } else if ("COMMAND__CREATE_REPLICABLE_ELEMENT".equals(value)) {
            isSelectionForSource = true;
        }
        Resource sourceResource = sourceElement == null || (sourceElementResource = sourceElement.eResource()) == null ? destinationResource : sourceElementResource;
        Resource resource = targetResource = targetElement == null || (targetElementResource = targetElement.eResource()) == null ? destinationResource : targetElementResource;
        if (isSelectionForSource) {
            sourceResource = destinationResource;
        } else {
            targetResource = destinationResource;
        }
        if (isSource && sourceResource != location.eResource()) {
            return true;
        }
        return !isSource && targetResource != location.eResource();
    }

    @Override
    public void setCurrentLocation(CatalogElementLink object, EObject container, IContext context) {
        this.currentLocation.put((EObject)object, container);
    }

    protected CatalogElementLink getLink(CatalogElement element, EObject target, IContext context) {
        for (CatalogElementLink link : element.getOwnedLinks()) {
            if (target == null || !target.equals(link.getTarget())) continue;
            return link;
        }
        return null;
    }

    protected CatalogElementLink getAllLink(CatalogElement element, EObject target, IContext context) {
        Collection<CatalogElementLink> links = ReplicableElementHandlerHelper.getInstance(context).getAllElementsLinks(element);
        for (CatalogElementLink link : links) {
            if (target == null || !target.equals(link.getTarget())) continue;
            return link;
        }
        return null;
    }

    protected CatalogElementLink getLinkContainer(CatalogElementLink link, IContext context) {
        EObject target = link.getTarget();
        return this.getAllLink(link.getSource(), target.eContainer(), context);
    }

    protected CatalogElementLink getLinkRelatedElement(CatalogElementLink link, IContext context) {
        return null;
    }

    @Override
    public void cleanLocations(IContext context) {
        this.currentLocation.clear();
        this.locations.clear();
        this.defaultLocations.clear();
    }

    @Override
    public EObject getLocation(CatalogElementLink object, CatalogElementLink origin, IContext context) {
        CatalogElementLink link = object;
        EObject target = link.getTarget();
        if (target == null) {
            return null;
        }
        if (this.locations.containsKey(link)) {
            return this.locations.get(link);
        }
        CatalogElementLink container = this.getLinkContainer(link, context);
        if (container != null) {
            this.locations.put(link, (EObject)container);
            return container;
        }
        CatalogElementLink relatedElement = this.getLinkRelatedElement(link, context);
        if (relatedElement != null) {
            this.locations.put(link, (EObject)relatedElement);
            return relatedElement;
        }
        if (!(!(target instanceof CatalogElement) && ContextScopeHandlerHelper.getInstance((IContext)context).contains("CREATED_LINKS", (EObject)object, context) || this.isInvalidResourceLocation(link, object.getTarget().eContainer(), context))) {
            this.locations.put(link, object.getTarget().eContainer());
            return object.getTarget().eContainer();
        }
        CatalogElement element = ReplicableElementHandlerHelper.getInstance(context).getInitialTarget(context);
        for (CatalogElementLink linkA : ReplicableElementHandlerHelper.getInstance(context).getAllElementsLinks(element)) {
            if (linkA.getOrigin() == null || linkA.getOrigin().getTarget() == null || link.getTarget() == null || !linkA.getOrigin().getTarget().equals(link.getTarget().eContainer())) continue;
            this.locations.put(link, (EObject)linkA);
            return linkA;
        }
        this.locations.put(link, null);
        return null;
    }

    protected boolean isValidContainement(EObject targetContainer, EObject target) {
        return true;
    }

    protected boolean isInitialSelectionValidContainer(EObject selection, CatalogElementLink link, IContext context) {
        String value;
        return !context.exists((Object)"COMMAND__CURRENT_VALUE") || !"COMMAND__UPDATE_DEFINITION_REPLICA_FROM_REPLICA".equals(value = (String)context.get((Object)"COMMAND__CURRENT_VALUE")) || !link.getSource().equals(ReplicableElementHandlerHelper.getInstance(context).getTarget(context));
    }

    protected Collection<EObject> getRelatedElements(EObject element) {
        return Collections.singleton(element);
    }

    @Override
    public EObject getDefaultLocation(CatalogElementLink source, CatalogElementLink origin, IContext context) {
        block8: {
            EObject result;
            block9: {
                CatalogElementLink linkSource;
                block10: {
                    linkSource = source;
                    if (linkSource == null || linkSource.getTarget() == null) {
                        return null;
                    }
                    if (this.defaultLocations.containsKey(source)) {
                        return this.defaultLocations.get(source);
                    }
                    Collection<EObject> elementsContainers = this.retrieveDefaultContainers(source, origin, context);
                    IRuleAttachment arule = this.getRule(linkSource.getTarget(), context);
                    for (EObject targetContainer : elementsContainers) {
                        EStructuralFeature sourceFeature;
                        if (this.isInvalidResourceLocation(linkSource, targetContainer, context) || !this.isValidContainement(targetContainer, linkSource.getTarget())) continue;
                        EStructuralFeature targetFeature = sourceFeature = linkSource.getTarget().eContainingFeature();
                        if (arule != null && ((targetFeature = this.getFeature(arule, linkSource.getTarget(), linkSource.getTarget(), targetContainer, context)) == null || targetFeature == sourceFeature) && linkSource.getOrigin() != null && linkSource.getOrigin().getTarget() != null) {
                            targetFeature = this.getFeature(arule, linkSource.getOrigin().getTarget(), linkSource.getTarget(), targetContainer, context);
                        }
                        if (targetFeature == null || !AttachmentHelper.getInstance((IContext)context).isApplicable(targetContainer.eClass(), targetFeature)) continue;
                        this.defaultLocations.put(source, targetContainer);
                        return targetContainer;
                    }
                    CatalogElementLink linkSourceOrigin = linkSource.getOrigin();
                    EObject other = (EObject)TraceabilityHandlerHelper.getInstance((IContext)context).retrieveSourceElements(linkSource.getTarget(), context).iterator().next();
                    if (arule == null) break block8;
                    result = arule.retrieveDefaultContainer(linkSourceOrigin == null ? other : linkSourceOrigin.getTarget(), linkSource.getTarget(), context);
                    if (result == null) break block9;
                    if (this.isValidContainement(result, linkSource.getTarget())) break block10;
                    this.defaultLocations.put(source, null);
                    return null;
                }
                if (!this.isInvalidResourceLocation(linkSource, result, context)) break block9;
                this.defaultLocations.put(source, null);
                return null;
            }
            try {
                this.defaultLocations.put(source, result);
                return result;
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        this.defaultLocations.put(source, null);
        return null;
    }

    @Override
    public EStructuralFeature getFeature(EObject source, EObject target, EObject currentLocation, IContext context) {
        if (source == null) {
            return null;
        }
        IRuleAttachment arule = this.getRule(source, context);
        return this.getFeature(arule, source, target, currentLocation, context);
    }

    protected EStructuralFeature getFeature(IRuleAttachment rule, EObject source, EObject target, EObject currentLocation, IContext context) {
        EStructuralFeature targetFeature;
        if (source == null) {
            return null;
        }
        if (rule != null && (targetFeature = rule.retrieveTargetContainementFeature(source, target, currentLocation, context)) != null && AttachmentHelper.getInstance((IContext)context).isApplicable(currentLocation.eClass(), targetFeature)) {
            return targetFeature;
        }
        return source.eContainingFeature();
    }

    protected Collection<EObject> retrieveDefaultContainers(CatalogElementLink target, CatalogElementLink source, IContext context) {
        Collection elements;
        CatalogElement element = ReplicableElementHandlerHelper.getInstance(context).getInitialTarget(context);
        CatalogElementLink linkSource = target;
        LinkedHashSet<EObject> elementsContainers = new LinkedHashSet<EObject>();
        CatalogElement recUsingSource = null;
        CatalogElement recUsingTarget = null;
        block0: for (CatalogElement referencingElement : ReplicableElementHandlerHelper.getInstance(context).getLinkingReplicableElements(context, Collections.singletonList(linkSource.getSource()))) {
            for (CatalogElement referencingElement2 : ReplicableElementHandlerHelper.getInstance(context).getLinkingReplicableElements(context, Collections.singletonList(element.getOrigin()))) {
                if (!referencingElement.getOrigin().equals(referencingElement2)) continue;
                recUsingSource = referencingElement2;
                recUsingTarget = referencingElement;
                continue block0;
            }
        }
        CatalogElementLink linkToLocate = linkSource;
        if (recUsingSource != null && recUsingTarget != null) {
            for (CatalogElementLink linke : ReplicableElementHandlerHelper.getInstance(context).getElementsLinks(recUsingSource)) {
                if (linkToLocate.getTarget() == null || linkToLocate.getTarget().eContainer() == null || !linkToLocate.getTarget().eContainer().equals(linke.getTarget())) continue;
                for (CatalogElementLink link : recUsingTarget.getOwnedLinks()) {
                    if (link == null || link.getOrigin() == null || !link.getOrigin().equals(linke)) continue;
                    elementsContainers.add(link.getTarget());
                }
            }
        }
        if ((elements = (Collection)context.get((Object)"TRANSITION_SOURCES")) != null) {
            for (EObject ppp : elements) {
                for (EObject item : this.getRelatedElements(ppp)) {
                    if (this.isInvalidResourceLocation(linkSource, item, context)) continue;
                    if (item instanceof CatalogElement) {
                        String value = (String)context.get((Object)"COMMAND__CURRENT_VALUE");
                        if ("COMMAND__UPDATE_DEFINITION_REPLICA_FROM_REPLICA".equals(value)) {
                            elementsContainers.add(source.getTarget().eContainer());
                            continue;
                        }
                        elementsContainers.add(target.getOrigin().getTarget().eContainer());
                        continue;
                    }
                    if (!this.isInitialSelectionValidContainer(item, linkSource, context)) continue;
                    elementsContainers.add(item);
                }
            }
        }
        Collection<CatalogElementLink> links = ReplicableElementHandlerHelper.getInstance(context).getElementsLinks(element);
        for (CatalogElementLink linkA : links) {
            if (linkA == null || linkA.getOrigin() == null || linkA.getOrigin().getTarget() == null || linkA.getOrigin().getTarget().eContainer() == null || linkSource == null || linkSource.getOrigin() == null || linkSource.getOrigin().getTarget() == null || linkA.equals(linkSource) || !linkA.getOrigin().getTarget().eContainer().equals(linkSource.getOrigin().getTarget().eContainer())) continue;
            elementsContainers.add(linkA.getTarget().eContainer());
        }
        String scope = (String)context.get((Object)"_OS");
        IPropertyContext propertyContext = ((IPropertyHandler)OptionsHandlerHelper.getInstance((IContext)context)).getPropertyContext(context, scope);
        if (linkSource.getTarget() instanceof CatalogElement) {
            Object value;
            IProperty property;
            CatalogElement targetElement;
            Object value2;
            IProperty property2;
            CatalogElement sourceElement = ReplicableElementHandlerHelper.getInstance(context).getSource(context);
            if (sourceElement != null && sourceElement.equals(linkSource.getSource()) && (property2 = propertyContext.getProperties().getProperty("locationSource")) != null && (value2 = propertyContext.getCurrentValue(property2)) != null && value2 instanceof EObject) {
                elementsContainers.add((EObject)propertyContext.getCurrentValue(property2));
            }
            if ((targetElement = ReplicableElementHandlerHelper.getInstance(context).getTarget(context)) != null && targetElement.equals(linkSource.getSource()) && (property = propertyContext.getProperties().getProperty("locationTarget")) != null && (value = propertyContext.getCurrentValue(property)) != null && value instanceof EObject) {
                elementsContainers.add((EObject)propertyContext.getCurrentValue(property));
            }
        }
        return elementsContainers;
    }

    public IRuleAttachment getRule(EObject target, IContext context) {
        IRuleAttachment arule = null;
        IRulesHandler ruleHandler = (IRulesHandler)context.get((Object)"_R_H");
        try {
            IRule rule;
            MappingPossibility mapping;
            if (ruleHandler != null && (mapping = ruleHandler.getApplicablePossibility((Object)target)) != null && (rule = ruleHandler.getApplicablePossibility((Object)target).getCompleteRule()) != null && rule instanceof IRuleAttachment) {
                arule = (IRuleAttachment)rule;
            }
        }
        catch (MappingPossibilityResolutionException mappingPossibilityResolutionException) {
            // empty catch block
        }
        return arule;
    }

    public IStatus init(IContext context) {
        return Status.OK_STATUS;
    }

    public IStatus dispose(IContext context) {
        this.cleanLocations(context);
        return Status.OK_STATUS;
    }
}

