/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.common.re.handlers.replicable;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.polarsys.capella.common.flexibility.properties.schema.IPropertyContext;
import org.polarsys.capella.common.helpers.EObjectExt;
import org.polarsys.capella.common.helpers.EObjectLabelProviderHelper;
import org.polarsys.capella.common.queries.interpretor.QueryInterpretor;
import org.polarsys.capella.common.queries.queryContext.IQueryContext;
import org.polarsys.capella.common.queries.queryContext.QueryContext;
import org.polarsys.capella.common.re.CatalogElement;
import org.polarsys.capella.common.re.CatalogElementKind;
import org.polarsys.capella.common.re.CatalogElementLink;
import org.polarsys.capella.common.re.CatalogElementPkg;
import org.polarsys.capella.common.re.CompliancyDefinition;
import org.polarsys.capella.common.re.CompliancyDefinitionPkg;
import org.polarsys.capella.common.re.ReFactory;
import org.polarsys.capella.common.re.RePackage;
import org.polarsys.capella.common.re.RecCatalog;
import org.polarsys.capella.common.re.constants.IReConstants;
import org.polarsys.capella.common.re.handlers.replicable.IReplicableElementHandler;
import org.polarsys.capella.common.re.handlers.replicable.ReplicableElementHandlerHelper;
import org.polarsys.capella.common.re.queries.CatalogElement_AllUsedElementLinks;
import org.polarsys.capella.common.re.queries.CatalogElement_AllUsedElements;
import org.polarsys.capella.common.re.queries.CatalogElement_UsedElementLinks;
import org.polarsys.capella.common.re.queries.CatalogElement_UsedElements;
import org.polarsys.capella.core.transition.common.handlers.attachment.AttachmentHelper;
import org.polarsys.capella.core.transition.common.handlers.contextscope.ContextScopeHandlerHelper;
import org.polarsys.capella.core.transition.common.handlers.options.IPropertyHandler;
import org.polarsys.capella.core.transition.common.handlers.options.OptionsHandlerHelper;
import org.polarsys.capella.core.transition.common.handlers.traceability.ITraceabilityHandler;
import org.polarsys.kitalpha.transposer.rules.handler.rules.api.IContext;

public class ReplicableElementHandler
implements IReplicableElementHandler {
    public static final String SOURCE = "REH_SOURCE";
    public static final String TARGET = "REH_TARGET";
    public static final String INITIAL_SOURCE = "REH_INITIAL_SOURCE";
    public static final String INITIAL_TARGET = "REH_INITIAL_TARGET";
    public static final String LINKS = "LINKS";
    public static final String COMPLIANCY_BLACK_BOX_NAME = "BLACK_BOX";
    public static final String COMPLIANCY_CONSTRAINT_REUSE_NAME = "CONSTRAINT_REUSE";
    public static final String COMPLIANCY_INHERITANCY_REUSE_NAME = "INHERITANCY_REUSE";

    public CatalogElement getSource(IContext context) {
        IPropertyContext ctx = ((IPropertyHandler)OptionsHandlerHelper.getInstance((IContext)context)).getPropertyContext(context, (String)context.get((Object)"_OS"));
        return (CatalogElement)ctx.getCurrentValue(ctx.getProperties().getProperty("source"));
    }

    public CatalogElement getTarget(IContext context) {
        IPropertyContext ctx = ((IPropertyHandler)OptionsHandlerHelper.getInstance((IContext)context)).getPropertyContext(context, (String)context.get((Object)"_OS"));
        return (CatalogElement)ctx.getCurrentValue(ctx.getProperties().getProperty("target"));
    }

    public void setSource(IContext context, CatalogElement element) {
        IPropertyContext ctx = ((IPropertyHandler)OptionsHandlerHelper.getInstance((IContext)context)).getPropertyContext(context, (String)context.get((Object)"_OS"));
        ctx.setCurrentValue(ctx.getProperties().getProperty("source"), (Object)element);
    }

    public void setTarget(IContext context, CatalogElement element) {
        IPropertyContext ctx = ((IPropertyHandler)OptionsHandlerHelper.getInstance((IContext)context)).getPropertyContext(context, (String)context.get((Object)"_OS"));
        ctx.setCurrentValue(ctx.getProperties().getProperty("target"), (Object)element);
    }

    public LinkedList<CatalogElement> getListSourcesVisited(IContext context) {
        if (!context.exists((Object)"getListSourcesVisited")) {
            context.put((Object)"getListSourcesVisited", new LinkedList());
        }
        return (LinkedList)context.get((Object)"getListSourcesVisited");
    }

    public LinkedList<CatalogElement> getListSources(IContext context) {
        if (!context.exists((Object)"getListSources")) {
            context.put((Object)"getListSources", new LinkedList());
        }
        return (LinkedList)context.get((Object)"getListSources");
    }

    public CatalogElement getInitialSource(IContext context) {
        IPropertyContext ctx = ((IPropertyHandler)OptionsHandlerHelper.getInstance((IContext)context)).getPropertyContext(context, (String)context.get((Object)"_OS"));
        return (CatalogElement)ctx.getCurrentValue(ctx.getProperties().getProperty("isource"));
    }

    public CatalogElement getInitialTarget(IContext context) {
        IPropertyContext ctx = ((IPropertyHandler)OptionsHandlerHelper.getInstance((IContext)context)).getPropertyContext(context, (String)context.get((Object)"_OS"));
        return (CatalogElement)ctx.getCurrentValue(ctx.getProperties().getProperty("itarget"));
    }

    public void setInitialSource(IContext context, CatalogElement element) {
        IPropertyContext ctx = ((IPropertyHandler)OptionsHandlerHelper.getInstance((IContext)context)).getPropertyContext(context, (String)context.get((Object)"_OS"));
        ctx.setCurrentValue(ctx.getProperties().getProperty("isource"), (Object)element);
    }

    public void setInitialTarget(IContext context, CatalogElement element) {
        IPropertyContext ctx = ((IPropertyHandler)OptionsHandlerHelper.getInstance((IContext)context)).getPropertyContext(context, (String)context.get((Object)"_OS"));
        ctx.setCurrentValue(ctx.getProperties().getProperty("itarget"), (Object)element);
    }

    public Collection<CatalogElementLink> getLinks(IContext context) {
        if (!context.exists((Object)LINKS)) {
            context.put((Object)LINKS, new ArrayList());
        }
        return (Collection)context.get((Object)LINKS);
    }

    public CatalogElementPkg getRootPackage(EObject object) {
        return ReFactory.eINSTANCE.createCatalogElementPkg();
    }

    public Collection<EObject> getElements(CatalogElement object) {
        return this.getElements(object, (IQueryContext)new QueryContext());
    }

    public Collection<EObject> getElements(CatalogElement object, IQueryContext context) {
        return QueryInterpretor.executeQuery((String)CatalogElement_UsedElements.class.getSimpleName(), (Object)object, (IQueryContext)context);
    }

    public Collection<CatalogElementLink> getElementsLinks(CatalogElement object) {
        return this.getElementsLinks(object, (IQueryContext)new QueryContext());
    }

    public Collection<CatalogElementLink> getElementsLinks(CatalogElement object, IQueryContext context) {
        return QueryInterpretor.executeQuery((String)CatalogElement_UsedElementLinks.class.getSimpleName(), (Object)object, (IQueryContext)context);
    }

    public Collection<CatalogElementLink> getAllElementsLinks(CatalogElement object) {
        return this.getAllElementsLinks(object, (IQueryContext)new QueryContext());
    }

    public Collection<CatalogElementLink> getAllElementsLinks(CatalogElement object, IQueryContext context) {
        return QueryInterpretor.executeQuery((String)CatalogElement_AllUsedElementLinks.class.getSimpleName(), (Object)object, (IQueryContext)context);
    }

    public Collection<EObject> getAllElements(CatalogElement object) {
        return this.getAllElements(object, (IQueryContext)new QueryContext());
    }

    public Collection<EObject> getAllElements(CatalogElement object, IQueryContext context) {
        return QueryInterpretor.executeQuery((String)CatalogElement_AllUsedElements.class.getSimpleName(), (Object)object, (IQueryContext)context);
    }

    public boolean hasOrigin(CatalogElement element) {
        return element.getOrigin() != null;
    }

    public boolean isReplica(CatalogElement source, CatalogElement supposedReplicad) {
        return supposedReplicad.getOrigin() != null && supposedReplicad.getOrigin().equals(source);
    }

    public CatalogElement createReplicableElement() {
        CatalogElement element = ReFactory.eINSTANCE.createCatalogElement();
        element.setKind(CatalogElementKind.REC);
        return element;
    }

    public CatalogElement createReplica() {
        CatalogElement element = ReFactory.eINSTANCE.createCatalogElement();
        element.setKind(CatalogElementKind.RPL);
        return element;
    }

    public CatalogElementLink addLink(IContext context, ITraceabilityHandler handler, CatalogElement element, EObject value, EObject oppositeValue) {
        CatalogElementLink link2;
        for (CatalogElementLink link2 : ReplicableElementHandlerHelper.getInstance(context).getAllElementsLinks(element)) {
            if (value.equals(link2.getTarget())) {
                return null;
            }
            if (oppositeValue == null || !oppositeValue.equals(link2.getTarget())) continue;
            if (ContextScopeHandlerHelper.getInstance((IContext)context).contains("VIRTUAL_LINKS", (EObject)link2, context)) {
                link2.setTarget(value);
                link2.setSource(element);
                ContextScopeHandlerHelper.getInstance((IContext)context).remove("VIRTUAL_LINKS", (EObject)link2, context);
            }
            return link2;
        }
        link2 = ReFactory.eINSTANCE.createCatalogElementLink();
        link2.setSource(element);
        link2.setTarget(value);
        handler.attachTraceability((EObject)link2, value, context);
        this.getLinks(context).add(link2);
        element.getOwnedLinks().add((Object)link2);
        return link2;
    }

    public boolean isIndirectlyReferencedBy(EObject element, CatalogElement re, IContext context) {
        LinkedList<CatalogElement> elements = new LinkedList<CatalogElement>();
        LinkedList<CatalogElement> visited = new LinkedList<CatalogElement>();
        elements.addAll(this.getIndirectlyReplicableElements(context, Collections.singleton(element)));
        while (!elements.isEmpty()) {
            CatalogElement elt = (CatalogElement)elements.removeFirst();
            if (visited.contains(elt)) continue;
            visited.add(elt);
            if (elt != null && elt.equals(re)) {
                return true;
            }
            elements.addAll(this.getLinkingReplicableElements(context, Collections.singleton(elt)));
        }
        return false;
    }

    public Collection<CatalogElement> getSelectedReplicableElements(IContext context) {
        ArrayList<CatalogElement> elements = new ArrayList<CatalogElement>();
        Collection selection = (Collection)context.get((Object)"TRANSITION_SOURCES");
        for (Object item : selection) {
            if (!(item instanceof CatalogElement)) continue;
            elements.add((CatalogElement)item);
        }
        return elements;
    }

    public Collection<CatalogElement> getIndirectlySelectedReplicableElements(IContext context) {
        Collection selection = (Collection)context.get((Object)"TRANSITION_SOURCES");
        return this.getIndirectlyReplicableElements(context, selection);
    }

    public Collection<CatalogElement> getUppestReplicableElement(IContext context, Collection<?> sources) {
        ArrayList<CatalogElement> result = new ArrayList<CatalogElement>();
        for (Object item : sources) {
            if (!(item instanceof CatalogElement)) continue;
            result.add((CatalogElement)item);
        }
        result.removeAll(this.getLinkingReplicableElements(context, sources));
        return result;
    }

    public Collection<CatalogElement> getIndirectlyReplicableElementsForCommand(IContext context, Collection<?> sources) {
        ArrayList<CatalogElement> elements = new ArrayList<CatalogElement>();
        for (Object item : sources) {
            if (!(item instanceof CatalogElement)) continue;
            elements.add((CatalogElement)item);
        }
        for (Object item : sources) {
            if (item instanceof CatalogElement) continue;
            List links = EObjectExt.getReferencers((EObject)((EObject)item), (EReference)RePackage.Literals.CATALOG_ELEMENT_LINK__TARGET);
            for (EObject link : links) {
                if (!(link instanceof CatalogElementLink) || ((CatalogElementLink)link).getSource() == null) continue;
                elements.add(((CatalogElementLink)link).getSource());
            }
        }
        return elements;
    }

    public Collection<CatalogElement> getIndirectlyReplicableElements(IContext context, Collection<?> sources) {
        ArrayList<CatalogElement> elements = new ArrayList<CatalogElement>();
        if (sources == null) {
            return elements;
        }
        for (Object item : sources) {
            if (!(item instanceof CatalogElement)) continue;
            elements.add((CatalogElement)item);
        }
        for (Object item : sources) {
            if (!(item instanceof EObject)) continue;
            List links = EObjectExt.getReferencers((EObject)((EObject)item), (EReference)RePackage.Literals.CATALOG_ELEMENT_LINK__TARGET);
            for (EObject link : links) {
                if (!(link instanceof CatalogElementLink) || context != null && ContextScopeHandlerHelper.getInstance((IContext)context).contains("CREATED_LINKS", link, context) || ((CatalogElementLink)link).getSource() == null || ((CatalogElementLink)link).eContainer() == null) continue;
                elements.add(((CatalogElementLink)link).getSource());
            }
        }
        return elements;
    }

    public Collection<CatalogElement> getLinkingReplicableElements(IContext context, Collection<?> sources) {
        ArrayList<CatalogElement> elements = new ArrayList<CatalogElement>();
        for (Object item : sources) {
            if (!(item instanceof EObject)) continue;
            List links = EObjectExt.getReferencers((EObject)((EObject)item), (EReference)RePackage.Literals.CATALOG_ELEMENT_LINK__TARGET);
            for (EObject link : links) {
                if (!(link instanceof CatalogElementLink) || ContextScopeHandlerHelper.getInstance((IContext)context).contains("CREATED_LINKS", link, context) || ((CatalogElementLink)link).getSource() == null) continue;
                elements.add(((CatalogElementLink)link).getSource());
            }
        }
        return elements;
    }

    public Collection<CatalogElement> getAllDefinedReplicableElements(IContext context) {
        ArrayList<CatalogElement> elements = new ArrayList<CatalogElement>();
        Collection selection = (Collection)context.get((Object)"TRANSITION_SOURCES");
        if (!selection.isEmpty()) {
            CatalogElementPkg pkg = ReplicableElementHandlerHelper.getInstance(context).getRootPackage((EObject)selection.iterator().next());
            elements.addAll(this.getAllOwnedCatalogElements(pkg));
        }
        return elements;
    }

    public Collection<CatalogElement> getAllDefinedRecReplicableElements(IContext context) {
        ArrayList<CatalogElement> elements = new ArrayList<CatalogElement>();
        Collection selection = (Collection)context.get((Object)"TRANSITION_SOURCES");
        if (!selection.isEmpty()) {
            CatalogElementPkg pkg = ReplicableElementHandlerHelper.getInstance(context).getRootPackage((EObject)selection.iterator().next());
            for (CatalogElement element : this.getAllOwnedCatalogElements(pkg)) {
                if (element.getKind() != CatalogElementKind.REC) continue;
                elements.add(element);
            }
        }
        return elements;
    }

    public Collection<CatalogElement> getAllOwnedCatalogElements(CatalogElement element) {
        ArrayList<CatalogElement> elements = new ArrayList<CatalogElement>();
        if (element != null) {
            for (CatalogElement ownedElement : element.getOwnedElements()) {
                elements.add(ownedElement);
                elements.addAll(this.getAllOwnedCatalogElements(ownedElement));
            }
        }
        return elements;
    }

    public Collection<CatalogElement> getAllOwnedCatalogElements(CatalogElementPkg element) {
        ArrayList<CatalogElement> elements = new ArrayList<CatalogElement>();
        for (CatalogElement ownedElement : element.getOwnedElements()) {
            elements.add(ownedElement);
            elements.addAll(this.getAllOwnedCatalogElements(ownedElement));
        }
        for (CatalogElementPkg ownedElementPkg : element.getOwnedElementPkgs()) {
            elements.addAll(this.getAllOwnedCatalogElements(ownedElementPkg));
        }
        return elements;
    }

    public String getInitialReplicaName(IContext context, CatalogElementPkg pkg) {
        return "RPL" + (pkg == null ? "" : Integer.valueOf(pkg.getOwnedElements().size() + 1));
    }

    public String getInitialReplicableElementName(IContext context, CatalogElementPkg pkg) {
        return "REC" + (pkg == null ? "" : Integer.valueOf(pkg.getOwnedElements().size() + 1));
    }

    public String getString(IContext context, Collection<?> elements) {
        String result = "";
        Iterator<?> itObject = elements.iterator();
        while (itObject.hasNext()) {
            Object object = itObject.next();
            if (object instanceof EObject) {
                result = String.valueOf(result) + EObjectLabelProviderHelper.getText((EObject)((EObject)object));
            }
            if (!itObject.hasNext()) continue;
            result = String.valueOf(result) + "; ";
        }
        if (result.length() > 30) {
            result = String.valueOf(result.substring(0, 27)) + "...";
        }
        return result;
    }

    public Collection<CatalogElement> getUsedReplicableElements(CatalogElement esource) {
        LinkedList<CatalogElement> toVisit = new LinkedList<CatalogElement>();
        if (esource != null) {
            for (CatalogElementLink link : esource.getOwnedLinks()) {
                if (link == null || link.getTarget() == null || !(link.getTarget() instanceof CatalogElement)) continue;
                toVisit.addLast((CatalogElement)link.getTarget());
            }
        }
        return toVisit;
    }

    public Collection<CatalogElement> getAllUsedReplicableElements(CatalogElement source) {
        LinkedList<CatalogElement> toVisit = new LinkedList<CatalogElement>();
        LinkedList<CatalogElement> visited = new LinkedList<CatalogElement>();
        toVisit.add(source);
        while (!toVisit.isEmpty()) {
            CatalogElement visitedRE = (CatalogElement)toVisit.removeFirst();
            if (visited.contains(visitedRE)) continue;
            visited.add(visitedRE);
            if (visitedRE == null) continue;
            for (CatalogElementLink link : visitedRE.getOwnedLinks()) {
                if (link == null || link.getTarget() == null || !(link.getTarget() instanceof CatalogElement)) continue;
                toVisit.addLast((CatalogElement)link.getTarget());
            }
        }
        return visited;
    }

    public IStatus init(IContext context) {
        return Status.OK_STATUS;
    }

    public IStatus dispose(IContext context) {
        return Status.OK_STATUS;
    }

    public boolean isUnmodifiableElement(EObject value, IContext context) {
        CatalogElement source = ReplicableElementHandlerHelper.getInstance(context).getSource(context);
        CatalogElement target = ReplicableElementHandlerHelper.getInstance(context).getTarget(context);
        Collection<CatalogElement> elements = ReplicableElementHandlerHelper.getInstance(context).getIndirectlyReplicableElements(context, Collections.singletonList(value));
        elements.retainAll(ReplicableElementHandlerHelper.getInstance(context).getAllUsedReplicableElements(source));
        elements.remove(source);
        elements.remove(value);
        if (!elements.isEmpty()) {
            return true;
        }
        elements = ReplicableElementHandlerHelper.getInstance(context).getIndirectlyReplicableElements(context, Collections.singletonList(value));
        elements.retainAll(ReplicableElementHandlerHelper.getInstance(context).getAllUsedReplicableElements(target));
        elements.remove(target);
        elements.remove(value);
        return !elements.isEmpty();
    }

    public Collection<Object> getAllDefinedCatalogElementPkgs(IContext context) {
        ArrayList elements = new ArrayList();
        Collection selection = (Collection)context.get((Object)"TRANSITION_SOURCES");
        return Collections.emptyList();
    }

    public boolean isDefaultLocation(EObject location, IContext context) {
        Collection selection = (Collection)context.get((Object)"TRANSITION_SOURCES");
        CatalogElementPkg defaultLocation = ReplicableElementHandlerHelper.getInstance(context).getRootPackage((EObject)selection.iterator().next());
        return defaultLocation.equals(location) || EObjectExt.isContainedBy((EObject)location, (EObject)defaultLocation);
    }

    public void cleanVirtualLinks(IContext context) {
        Collection links = ContextScopeHandlerHelper.getInstance((IContext)context).getCollection("CREATED_LINKS", context);
        LinkedList<Object> toRemove = new LinkedList<Object>();
        for (EObject object : links) {
            if (ContextScopeHandlerHelper.getInstance((IContext)context).contains("CREATED_LINKS_TO_KEEP", object, context)) continue;
            toRemove.add(object);
        }
        CatalogElement target = ReplicableElementHandlerHelper.getInstance(context).getTarget(context);
        if (target != null) {
            for (CatalogElementLink catalogElementLink : target.getOwnedLinks()) {
                if (catalogElementLink == null || toRemove.contains(catalogElementLink)) continue;
                if (catalogElementLink.getTarget() == null) {
                    toRemove.add(catalogElementLink);
                    continue;
                }
                if (catalogElementLink.getTarget().eContainer() != null) continue;
                toRemove.add(catalogElementLink);
            }
        }
        if (!toRemove.isEmpty()) {
            for (EObject eObject : toRemove) {
                if (!(eObject instanceof CatalogElementLink)) continue;
                ((CatalogElementLink)eObject).setTarget(null);
                ((CatalogElementLink)eObject).setSource(null);
            }
            AttachmentHelper.getInstance((IContext)context).removeElements(toRemove, context);
        }
        links.clear();
        links = ContextScopeHandlerHelper.getInstance((IContext)context).getCollection("VIRTUAL_LINKS", context);
        links.removeAll(toRemove);
    }

    public Collection<CompliancyDefinition> getAllDefinedCompliancy(EObject location) {
        return Collections.emptyList();
    }

    public void createDefaultCompliancies(EObject source) {
        CatalogElementPkg pkg = this.getRootPackage(source);
        if (pkg instanceof RecCatalog) {
            CompliancyDefinitionPkg definitions = ((RecCatalog)pkg).getOwnedCompliancyDefinitionPkg();
            if (definitions == null) {
                definitions = ReFactory.eINSTANCE.createCompliancyDefinitionPkg();
                definitions.setName("Compliancy Definitions");
                ((RecCatalog)pkg).setOwnedCompliancyDefinitionPkg(definitions);
            }
            if (definitions.getOwnedDefinitions().isEmpty()) {
                CompliancyDefinition definition = ReFactory.eINSTANCE.createCompliancyDefinition();
                definition.setName(COMPLIANCY_BLACK_BOX_NAME);
                definitions.getOwnedDefinitions().add((Object)definition);
                definition = ReFactory.eINSTANCE.createCompliancyDefinition();
                definition.setName(COMPLIANCY_CONSTRAINT_REUSE_NAME);
                definitions.getOwnedDefinitions().add((Object)definition);
                definition = ReFactory.eINSTANCE.createCompliancyDefinition();
                definition.setName(COMPLIANCY_INHERITANCY_REUSE_NAME);
                definitions.getOwnedDefinitions().add((Object)definition);
            }
        }
    }

    @Override
    public Collection<CatalogElementLink> createTargetLinks(CatalogElement replicable, Collection<CatalogElementLink> setLinks, IContext context) {
        HashSet<CatalogElementLink> newLinks = new HashSet<CatalogElementLink>();
        for (CatalogElementLink link : setLinks) {
            CatalogElementLink link2 = ReFactory.eINSTANCE.createCatalogElementLink();
            link2.setTarget(link.getTarget());
            link2.setSource(replicable);
            link2.setOrigin(link);
            replicable.getOwnedLinks().add((Object)link2);
            newLinks.add(link2);
            ContextScopeHandlerHelper.getInstance((IContext)context).add("CREATED_LINKS", (EObject)link2, context);
            ContextScopeHandlerHelper.getInstance((IContext)context).add("VIRTUAL_LINKS", (EObject)link2, context);
        }
        return newLinks;
    }

    @Override
    public CatalogElementLink getOppositeLink(CatalogElementLink link, IContext context) {
        CatalogElement element = link.getSource();
        CatalogElement source = ReplicableElementHandlerHelper.getInstance(context).getSource(context);
        CatalogElement target = ReplicableElementHandlerHelper.getInstance(context).getTarget(context);
        element = element.equals(source) ? target : source;
        Collection<CatalogElementLink> usedLinks = ReplicableElementHandlerHelper.getInstance(context).getAllElementsLinks(element, (IQueryContext)new QueryContext());
        for (CatalogElementLink usedLink : usedLinks) {
            if (usedLink != null && usedLink.getOrigin() != null && usedLink.getOrigin().equals(link)) {
                return usedLink;
            }
            if (link == null || link.getOrigin() == null || !link.getOrigin().equals(usedLink)) continue;
            return usedLink;
        }
        return null;
    }

    @Override
    public CatalogElement createInitialReplica(CatalogElement source, CatalogElement target, IContext context) {
        return this.createInitialReplica(source, target, context, true);
    }

    public CatalogElement createInitialReplica(CatalogElement source, CatalogElement target, IContext context, boolean children) {
        CatalogElement element = target;
        if (element == null) {
            element = ReplicableElementHandlerHelper.getInstance(context).createReplica();
        }
        if (source != null) {
            String namea = source.getName();
            if (namea.startsWith("REC")) {
                namea = "RPL" + namea.substring(3);
            }
            element.setName(namea);
            element.setOrigin(source);
            if (IReConstants.ENABLE_SUB_INSTANCIATION()) {
                for (CatalogElementLink link : source.getOwnedLinks()) {
                    if (link == null || link.getTarget() == null || !(link.getTarget() instanceof CatalogElement)) continue;
                    CatalogElement replica = null;
                    boolean found = false;
                    for (CatalogElementLink linkReplica : element.getOwnedLinks()) {
                        if (linkReplica == null || linkReplica.getOrigin() == null || !linkReplica.getOrigin().equals(link)) continue;
                        found = true;
                        replica = (CatalogElement)linkReplica.getTarget();
                        break;
                    }
                    replica = this.createInitialReplica((CatalogElement)link.getTarget(), replica, context, IReConstants.ENABLE_SUB_INSTANCIATION());
                    if (found) continue;
                    CatalogElementLink linkCopy = ReFactory.eINSTANCE.createCatalogElementLink();
                    linkCopy.setSource(element);
                    linkCopy.setTarget((EObject)replica);
                    linkCopy.setOrigin(link);
                    element.getOwnedLinks().add((Object)linkCopy);
                    element.getOwnedElements().add((Object)replica);
                    ContextScopeHandlerHelper.getInstance((IContext)context).add("CREATED_LINKS", (EObject)linkCopy, context);
                }
            }
        }
        return element;
    }

    public void addDeletableElement(EObject element, IContext context) {
        if (!context.exists((Object)"ADDITIONAL_ELEMENTS_TO_DELETE")) {
            context.put((Object)"ADDITIONAL_ELEMENTS_TO_DELETE", new HashSet());
        }
        ((Collection)context.get((Object)"ADDITIONAL_ELEMENTS_TO_DELETE")).add(element);
    }

    public Collection<EObject> getDeletableElements(IContext context) {
        if (!context.exists((Object)"ADDITIONAL_ELEMENTS_TO_DELETE")) {
            return Collections.emptyList();
        }
        return (Collection)context.get((Object)"ADDITIONAL_ELEMENTS_TO_DELETE");
    }
}

