/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.core.data.oa.validation.operationalActivity;

import org.eclipse.core.runtime.IStatus;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.validation.EMFEventType;
import org.eclipse.emf.validation.IValidationContext;
import org.polarsys.capella.common.data.modellingcore.AbstractTrace;
import org.polarsys.capella.core.data.ctx.OperationalActorRealization;
import org.polarsys.capella.core.data.ctx.OperationalEntityRealization;
import org.polarsys.capella.core.data.oa.Entity;
import org.polarsys.capella.core.validation.rule.AbstractValidationRule;

public class EntityRealizedByActor
extends AbstractValidationRule {
    public IStatus validate(IValidationContext ctx_p) {
        EObject eObj = ctx_p.getTarget();
        EMFEventType eType = ctx_p.getEventType();
        if (eType == EMFEventType.NULL && eObj instanceof Entity) {
            Entity actor = (Entity)eObj;
            EList traces = actor.getIncomingTraces();
            if (traces.size() < 1) {
                return ctx_p.createFailureStatus(new Object[]{String.valueOf(actor.getName()) + " (" + actor.eClass().getName() + ") is not realized by any System Actor."});
            }
            for (AbstractTrace next : traces) {
                if (!(next instanceof OperationalActorRealization) && !(next instanceof OperationalEntityRealization)) continue;
                return ctx_p.createSuccessStatus();
            }
            return ctx_p.createFailureStatus(new Object[]{String.valueOf(actor.getName()) + " (" + actor.eClass().getName() + ") is not realized by any System Actor."});
        }
        return ctx_p.createSuccessStatus();
    }
}

