/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.kitalpha.ad.metadata.helpers;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.edit.domain.IEditingDomainProvider;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.emf.transaction.util.TransactionUtil;
import org.osgi.framework.Version;
import org.polarsys.kitalpha.ad.metadata.commands.CreateMetadataResourceCommand;
import org.polarsys.kitalpha.ad.metadata.commands.MetadataCommand;
import org.polarsys.kitalpha.ad.metadata.helpers.MetadataHelper;
import org.polarsys.kitalpha.ad.metadata.metadata.Metadata;
import org.polarsys.kitalpha.ad.metadata.metadata.MetadataFactory;
import org.polarsys.kitalpha.ad.metadata.metadata.ViewpointReference;
import org.polarsys.kitalpha.resourcereuse.model.Resource;

public class ViewpointMetadata {
    public static final String STORAGE_EXTENSION = "afm";
    private final ResourceSet context;

    public ViewpointMetadata(ResourceSet context) {
        this.context = context;
    }

    public Map<String, Version> getViewpointUsages() {
        return this.getViewpointReferences();
    }

    public List<ViewpointReference> getAllViewpointReferences() {
        ArrayList<ViewpointReference> result = new ArrayList<ViewpointReference>();
        Metadata metadata = this.getMetadataStorage();
        for (Metadata meta : this.collectAdditionalMetadata(new ArrayList<Metadata>(), metadata)) {
            result.addAll((Collection<ViewpointReference>)meta.getViewpointReferences());
        }
        return result;
    }

    private List<Metadata> collectAdditionalMetadata(List<Metadata> collector, Metadata metadata) {
        if (metadata != null) {
            LinkedList<Metadata> toVisit = new LinkedList<Metadata>();
            toVisit.add(metadata);
            while (!toVisit.isEmpty()) {
                Metadata poll = (Metadata)toVisit.poll();
                if (poll == null) {
                    return collector;
                }
                if (collector.contains(poll)) {
                    throw new IllegalStateException("A cycle has been detected");
                }
                collector.add(poll);
                toVisit.addAll((Collection<Metadata>)poll.getAdditionalMetadata());
            }
        }
        return collector;
    }

    public Map<String, Version> getViewpointReferences() {
        HashMap<String, Version> id2version = new HashMap<String, Version>();
        if (this.context.getResources().isEmpty()) {
            return id2version;
        }
        Metadata metadataStorage = this.getMetadataStorage();
        if (metadataStorage == null) {
            return id2version;
        }
        for (ViewpointReference usedViewpoint : metadataStorage.getViewpointReferences()) {
            id2version.put(usedViewpoint.getVpId(), usedViewpoint.getVersion());
        }
        return id2version;
    }

    public Version getVersion(Resource vpResource) {
        Metadata metadata = this.getMetadataStorage();
        if (metadata == null) {
            throw new IllegalStateException("cannot find metadata resource");
        }
        for (Metadata meta : this.collectAdditionalMetadata(new ArrayList<Metadata>(), metadata)) {
            for (ViewpointReference uv : new ArrayList(meta.getViewpointReferences())) {
                if (!vpResource.getId().equals(uv.getVpId())) continue;
                return uv.getVersion();
            }
        }
        return null;
    }

    public void updateVersion(Resource vpResource, Version version) {
        Metadata metadata = this.getMetadataStorage(true);
        for (ViewpointReference uv : new ArrayList(metadata.getViewpointReferences())) {
            if (!vpResource.getId().equals(uv.getVpId())) continue;
            uv.setVersion(version);
            return;
        }
        this.setUsage(vpResource, version, true);
    }

    public void setUsage(Resource vpResource, Version version, boolean usage) {
        if (usage) {
            this.reference(vpResource, version);
        } else {
            this.unReference(vpResource);
        }
    }

    public void reference(Resource vpResource, Version version) {
        ViewpointReference uv2;
        Metadata metadata = this.getMetadataStorage(true);
        for (ViewpointReference uv2 : new ArrayList(metadata.getViewpointReferences())) {
            if (!vpResource.getId().equals(uv2.getVpId())) continue;
            uv2.setVersion(version);
            return;
        }
        uv2 = MetadataFactory.eINSTANCE.createViewpointReference();
        uv2.setId(EcoreUtil.generateUUID());
        uv2.setInactive(false);
        uv2.setVpId(vpResource.getId());
        uv2.setVersion(version);
        metadata.getViewpointReferences().add((Object)uv2);
    }

    public void unReference(Resource vpResource) {
        Metadata metadata = this.getMetadataStorage(true);
        for (ViewpointReference uv : new ArrayList(metadata.getViewpointReferences())) {
            if (!vpResource.getId().equals(uv.getVpId())) continue;
            metadata.getViewpointReferences().remove((Object)uv);
        }
    }

    private void executeCommandInTransaction(MetadataCommand command) {
        TransactionalEditingDomain editingDomain = TransactionUtil.getEditingDomain((ResourceSet)this.context);
        if (editingDomain == null && this.context instanceof IEditingDomainProvider) {
            editingDomain = ((IEditingDomainProvider)this.context).getEditingDomain();
        }
        if (editingDomain == null) {
            command.execute();
        } else {
            editingDomain.getCommandStack().execute((Command)command);
        }
    }

    public void setFilter(String id, boolean filter) {
        this.setActivationSate(id, !filter);
    }

    public void setActivationSate(String id, boolean active) {
        Metadata metadata = this.getMetadataStorage(true);
        for (ViewpointReference uv : new ArrayList(metadata.getViewpointReferences())) {
            if (!id.equals(uv.getVpId())) continue;
            uv.setInactive(!active);
        }
    }

    public boolean isInUse(String id) {
        return this.isReferenced(id);
    }

    public boolean isReferenced(String id) {
        Metadata metadata = this.getMetadataStorage();
        for (Metadata meta : this.collectAdditionalMetadata(new ArrayList<Metadata>(), metadata)) {
            for (ViewpointReference uv : meta.getViewpointReferences()) {
                if (!id.equals(uv.getVpId())) continue;
                return true;
            }
        }
        return false;
    }

    public boolean isFiltered(String id) {
        return this.isInactive(id);
    }

    public boolean isInactive(String id) {
        Metadata metadata = this.getMetadataStorage();
        for (Metadata meta : this.collectAdditionalMetadata(new ArrayList<Metadata>(), metadata)) {
            for (ViewpointReference uv : meta.getViewpointReferences()) {
                if (!id.equals(uv.getVpId())) continue;
                return uv.isInactive();
            }
        }
        return false;
    }

    public org.eclipse.emf.ecore.resource.Resource initMetadataStorage(URI location) {
        CreateMetadataResourceCommand command = new CreateMetadataResourceCommand(this.context, location);
        this.executeCommandInTransaction(command);
        return command.getMetadataResource();
    }

    public org.eclipse.emf.ecore.resource.Resource initMetadataStorage() {
        if (this.hasMetadata()) {
            return this.getMetadataStorage().eResource();
        }
        return this.initMetadataStorage(this.getExpectedMetadataStorageURI());
    }

    public URI getExpectedMetadataStorageURI() {
        URI uri = ((org.eclipse.emf.ecore.resource.Resource)this.context.getResources().get(0)).getURI();
        return MetadataHelper.getExpectedMetadataStorageURI(uri);
    }

    public boolean hasMetadata() {
        return this.getMetadataStorage() != null;
    }

    protected Metadata getMetadataStorage() {
        return this.getMetadataStorage(false);
    }

    protected Metadata getMetadataStorage(boolean create) {
        org.eclipse.emf.ecore.resource.Resource resource = this.getResource(STORAGE_EXTENSION);
        if (create && resource == null) {
            resource = this.initMetadataStorage();
        }
        if (resource == null) {
            return null;
        }
        if (resource.getContents().isEmpty()) {
            return null;
        }
        Metadata metadata = (Metadata)resource.getContents().get(0);
        return metadata;
    }

    private org.eclipse.emf.ecore.resource.Resource getResource(String extension) {
        if (this.context.getResources().isEmpty()) {
            return null;
        }
        for (org.eclipse.emf.ecore.resource.Resource res : this.context.getResources()) {
            if (!res.getURI().toString().endsWith(extension)) continue;
            return res;
        }
        URI uri = this.getExpectedMetadataStorageURI();
        try {
            return this.context.getResource(uri, true);
        }
        catch (Exception e) {
            org.eclipse.emf.ecore.resource.Resource resource = this.context.getResource(uri, false);
            if (resource != null && resource.getContents().isEmpty()) {
                resource.unload();
                this.context.getResources().remove((Object)resource);
            }
            return null;
        }
    }
}

