/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.core.data.pa.validation.physicalComponent;

import java.util.ArrayList;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.validation.EMFEventType;
import org.eclipse.emf.validation.IValidationContext;
import org.polarsys.capella.common.data.modellingcore.ModelElement;
import org.polarsys.capella.core.data.cs.BlockArchitecture;
import org.polarsys.capella.core.data.cs.Component;
import org.polarsys.capella.core.data.cs.Interface;
import org.polarsys.capella.core.data.la.LogicalArchitecture;
import org.polarsys.capella.core.data.pa.PhysicalComponent;
import org.polarsys.capella.core.model.helpers.CapellaElementExt;
import org.polarsys.capella.core.model.helpers.InterfaceExt;
import org.polarsys.capella.core.model.helpers.InterfacePkgExt;
import org.polarsys.capella.core.model.preferences.CapellaModelPreferencesPlugin;
import org.polarsys.capella.core.validation.rule.AbstractValidationRule;

public class MDCHK_PhysicalComponent_InterfaceUseAndImpl_1
extends AbstractValidationRule {
    public IStatus validate(IValidationContext ctx_p) {
        EObject eObj = ctx_p.getTarget();
        EMFEventType eType = ctx_p.getEventType();
        if (eType == EMFEventType.NULL && eObj instanceof PhysicalComponent) {
            PhysicalComponent physicalComponent = (PhysicalComponent)eObj;
            if (!CapellaModelPreferencesPlugin.getDefault().isInterfaceProjectionHandle()) {
                EList realizedComponent = new ArrayList(1);
                realizedComponent = physicalComponent.getRealizedLogicalComponents();
                if (!realizedComponent.isEmpty()) {
                    boolean failureStatus = false;
                    ArrayList allInterface = new ArrayList(1);
                    allInterface.addAll(physicalComponent.getUsedInterfaces());
                    allInterface.addAll(physicalComponent.getImplementedInterfaces());
                    allInterface.addAll(physicalComponent.getProvidedInterfaces());
                    allInterface.addAll(physicalComponent.getRequiredInterfaces());
                    ArrayList<Interface> inValidInterfaces = new ArrayList<Interface>(1);
                    for (Interface myInterface : allInterface) {
                        BlockArchitecture rootBlockArchitecture = InterfacePkgExt.getRootBlockArchitecture((ModelElement)myInterface);
                        if (rootBlockArchitecture == null || !(rootBlockArchitecture instanceof LogicalArchitecture)) continue;
                        ArrayList components = new ArrayList(1);
                        components.addAll(InterfaceExt.getUserLogicalComponents((Interface)myInterface));
                        components.addAll(InterfaceExt.getImplementerLogicalComponents((Interface)myInterface));
                        components.addAll(InterfaceExt.getProviderComponent((Interface)myInterface));
                        components.addAll(InterfaceExt.getRequireComponent((Interface)myInterface));
                        if (!components.isEmpty()) {
                            boolean flag = false;
                            for (Component component : components) {
                                if (!realizedComponent.contains(component)) continue;
                                flag = true;
                            }
                            if (flag) continue;
                            failureStatus = true;
                            inValidInterfaces.add(myInterface);
                            continue;
                        }
                        failureStatus = true;
                        inValidInterfaces.add(myInterface);
                    }
                    if (failureStatus) {
                        String inValidInterfacesName = CapellaElementExt.getElementNamesSeperatedByComma(inValidInterfaces);
                        return this.createFailureStatus(ctx_p, new Object[]{physicalComponent.getName(), inValidInterfacesName});
                    }
                }
            }
        }
        return ctx_p.createSuccessStatus();
    }
}

