/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.core.data.helpers.ctx.services;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.emf.common.util.EList;
import org.polarsys.capella.core.data.ctx.Actor;
import org.polarsys.capella.core.data.ctx.ActorMissionInvolvement;
import org.polarsys.capella.core.data.ctx.Capability;
import org.polarsys.capella.core.data.ctx.CapabilityExploitation;
import org.polarsys.capella.core.data.ctx.Mission;

public class MissionExt {
    public static List<Capability> getExploitedCapabilities(Mission mission) {
        ArrayList<Capability> exploitedCapabilities = new ArrayList<Capability>();
        EList exploitationSet = mission.getOwnedCapabilityExploitations();
        for (CapabilityExploitation exploit : exploitationSet) {
            exploitedCapabilities.add(exploit.getCapability());
        }
        return exploitedCapabilities;
    }

    public static List<Actor> getInvolvedActors(Mission mission) {
        ArrayList<Actor> involvedActors = new ArrayList<Actor>();
        EList contributionSet = mission.getInvolvedActors();
        for (ActorMissionInvolvement involvement : contributionSet) {
            involvedActors.add(involvement.getActor());
        }
        return involvedActors;
    }

    public static void removeInvolvedActors(Mission mission, List<Actor> actors) {
        ArrayList<ActorMissionInvolvement> removedLinks = new ArrayList<ActorMissionInvolvement>();
        for (Object involvement : mission.getInvolvedActors()) {
            ActorMissionInvolvement actorInvolvement = (ActorMissionInvolvement)involvement;
            if (!actors.contains(actorInvolvement.getActor())) continue;
            removedLinks.add(actorInvolvement);
        }
        for (ActorMissionInvolvement actorMissionInvolvement : removedLinks) {
            actorMissionInvolvement.destroy();
        }
    }

    public static void removeExploitedCapabilities(Mission mission, List<Capability> useCases) {
        ArrayList<CapabilityExploitation> removedLinks = new ArrayList<CapabilityExploitation>();
        for (Object capabilityExp : mission.getOwnedCapabilityExploitations()) {
            CapabilityExploitation capabilitExploitation = (CapabilityExploitation)capabilityExp;
            if (!useCases.contains(capabilitExploitation.getCapability())) continue;
            removedLinks.add(capabilitExploitation);
        }
        for (CapabilityExploitation capabilityExploitation : removedLinks) {
            capabilityExploitation.destroy();
        }
    }
}

