/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.core.data.helpers.information.delegates;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.polarsys.capella.core.data.capellacore.Classifier;
import org.polarsys.capella.core.data.capellacore.Feature;
import org.polarsys.capella.core.data.capellacore.TypedElement;
import org.polarsys.capella.core.data.helpers.capellacore.delegates.ClassifierHelper;
import org.polarsys.capella.core.data.information.InformationPackage;
import org.polarsys.capella.core.data.information.Partition;
import org.polarsys.capella.core.data.information.PartitionableElement;

public class PartitionableElementHelper {
    private static PartitionableElementHelper instance;

    private PartitionableElementHelper() {
    }

    public static PartitionableElementHelper getInstance() {
        if (instance == null) {
            instance = new PartitionableElementHelper();
        }
        return instance;
    }

    public Object doSwitch(PartitionableElement element, EStructuralFeature feature) {
        Object ret = null;
        if (feature.equals(InformationPackage.Literals.PARTITIONABLE_ELEMENT__REPRESENTING_PARTITIONS)) {
            ret = this.getRepresentingPartitions(element);
        } else if (feature.equals(InformationPackage.Literals.PARTITIONABLE_ELEMENT__OWNED_PARTITIONS)) {
            ret = this.getOwnedPartitions(element);
        }
        if (ret == null) {
            ret = ClassifierHelper.getInstance().doSwitch((Classifier)element, feature);
        }
        return ret;
    }

    protected List<Partition> getRepresentingPartitions(PartitionableElement element) {
        EList typedElements = element.getTypedElements();
        ArrayList<Partition> ret = new ArrayList<Partition>();
        for (TypedElement typedElement : typedElements) {
            if (!(typedElement instanceof Partition)) continue;
            ret.add((Partition)typedElement);
        }
        return ret;
    }

    protected List<Partition> getOwnedPartitions(PartitionableElement element) {
        EList features = element.getOwnedFeatures();
        ArrayList<Partition> ret = new ArrayList<Partition>();
        for (Feature feature : features) {
            if (!(feature instanceof Partition)) continue;
            ret.add((Partition)feature);
        }
        return ret;
    }
}

