/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.core.data.helpers.la.delegates;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.polarsys.capella.core.data.capellacore.Type;
import org.polarsys.capella.core.data.cs.Component;
import org.polarsys.capella.core.data.cs.ComponentAllocation;
import org.polarsys.capella.core.data.cs.SystemComponent;
import org.polarsys.capella.core.data.ctx.System;
import org.polarsys.capella.core.data.fa.AbstractFunction;
import org.polarsys.capella.core.data.helpers.cs.delegates.SystemComponentHelper;
import org.polarsys.capella.core.data.information.Partition;
import org.polarsys.capella.core.data.la.LaPackage;
import org.polarsys.capella.core.data.la.LogicalComponent;
import org.polarsys.capella.core.data.la.LogicalFunction;
import org.polarsys.capella.core.data.la.SystemRealization;
import org.polarsys.capella.core.data.pa.PhysicalComponent;

public class LogicalComponentHelper {
    private static LogicalComponentHelper instance;

    private LogicalComponentHelper() {
    }

    public static LogicalComponentHelper getInstance() {
        if (instance == null) {
            instance = new LogicalComponentHelper();
        }
        return instance;
    }

    public Object doSwitch(LogicalComponent element, EStructuralFeature feature) {
        List<LogicalFunction> ret = null;
        if (feature.equals(LaPackage.Literals.LOGICAL_COMPONENT__SUB_LOGICAL_COMPONENTS)) {
            ret = this.getSubLogicalComponents(element);
        } else if (feature.equals(LaPackage.Literals.LOGICAL_COMPONENT__SYSTEM_REALIZATIONS)) {
            ret = this.getSystemRealizations(element);
        } else if (feature.equals(LaPackage.Literals.LOGICAL_COMPONENT__ALLOCATED_LOGICAL_FUNCTIONS)) {
            ret = this.getAllocatedLogicalFunctions(element);
        } else if (feature.equals(LaPackage.Literals.LOGICAL_COMPONENT__REALIZING_PHYSICAL_COMPONENTS)) {
            ret = this.getRealizingPhysicalComponents(element);
        } else if (feature.equals(LaPackage.Literals.LOGICAL_COMPONENT__REALIZED_SYSTEMS)) {
            ret = this.getRealizedSystems(element);
        }
        if (ret == null) {
            ret = SystemComponentHelper.getInstance().doSwitch((SystemComponent)element, feature);
        }
        return ret;
    }

    protected List<SystemRealization> getSystemRealizations(LogicalComponent element) {
        ArrayList<SystemRealization> ret = new ArrayList<SystemRealization>();
        for (ComponentAllocation componentAllocation : element.getProvisionedComponentAllocations()) {
            if (!(componentAllocation instanceof SystemRealization)) continue;
            ret.add((SystemRealization)componentAllocation);
        }
        return ret;
    }

    protected List<LogicalComponent> getSubLogicalComponents(LogicalComponent element) {
        ArrayList<LogicalComponent> ret = new ArrayList<LogicalComponent>();
        for (Partition thePartition : element.getOwnedPartitions()) {
            Type representedElement = thePartition.getType();
            if (!(representedElement instanceof LogicalComponent)) continue;
            ret.add((LogicalComponent)representedElement);
        }
        return ret;
    }

    protected List<LogicalFunction> getAllocatedLogicalFunctions(LogicalComponent element) {
        ArrayList<LogicalFunction> ret = new ArrayList<LogicalFunction>();
        for (AbstractFunction function : element.getAllocatedFunctions()) {
            if (!(function instanceof LogicalFunction)) continue;
            ret.add((LogicalFunction)function);
        }
        return ret;
    }

    protected List<PhysicalComponent> getRealizingPhysicalComponents(LogicalComponent element) {
        ArrayList<PhysicalComponent> ret = new ArrayList<PhysicalComponent>();
        for (Component cpnt : element.getAllocatingComponents()) {
            if (!(cpnt instanceof PhysicalComponent)) continue;
            ret.add((PhysicalComponent)cpnt);
        }
        return ret;
    }

    protected List<System> getRealizedSystems(LogicalComponent element) {
        ArrayList<System> ret = new ArrayList<System>();
        for (Component cpnt : element.getAllocatedComponents()) {
            if (!(cpnt instanceof System)) continue;
            ret.add((System)cpnt);
        }
        return ret;
    }
}

