/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.core.model.handler.command;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.common.command.AbstractCommand;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.edit.domain.AdapterFactoryEditingDomain;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.polarsys.capella.common.ef.ExecutionManager;
import org.polarsys.capella.common.ef.command.AbstractReadWriteCommand;
import org.polarsys.capella.common.ef.command.ICommand;
import org.polarsys.capella.common.helpers.operations.LongRunningListenersRegistry;
import org.polarsys.capella.common.mdsofa.common.helper.ExtensionPointHelper;
import org.polarsys.capella.core.model.handler.ModelHandlerPlugin;
import org.polarsys.capella.core.model.handler.command.AbstractCapellaDeleteHook;
import org.polarsys.capella.core.model.handler.command.BasicRepresentationDeleteCommand;
import org.polarsys.capella.core.model.handler.command.CapellaResourceHelper;
import org.polarsys.capella.core.model.handler.command.DeleteStructureCommand;
import org.polarsys.capella.core.model.handler.command.IDeleteHelper;
import org.polarsys.capella.core.model.handler.command.Messages;
import org.polarsys.capella.core.model.handler.command.PreDeleteHandler;
import org.polarsys.capella.core.model.handler.command.PreDeleteStructureCommand;
import org.polarsys.capella.core.model.handler.helpers.RepresentationHelper;

public class BasicCapellaDeleteCommand
extends AbstractCommand {
    private IDeleteHelper deleteHelper = IDeleteHelper.DEFAULT;
    public static final String ID = "Delete";
    private static ArrayList<AbstractCapellaDeleteHook> deleteCommandHooks;
    private Command realCommand;
    private Collection<?> selection;
    private Collection<?> expandedSelection;
    private Set<Object> allElementsToDelete;
    private Set<EObject> _controlledExpandedSelectionContents;
    private boolean ensureTransaction;
    private boolean confirmDelete;
    private ExecutionManager executionManager;
    protected EditingDomain editingDomain;
    private boolean sendLongRunningEvents;

    public BasicCapellaDeleteCommand(ExecutionManager executionManager, Collection<?> selection) {
        this(executionManager, selection, true);
    }

    public BasicCapellaDeleteCommand(ExecutionManager executionManager, Collection<?> selection, boolean ensureTransaction) {
        this(executionManager, selection, ensureTransaction, false, true);
        this.confirmDelete = this.isConfirmationRequired();
    }

    public BasicCapellaDeleteCommand(ExecutionManager executionManager, Collection<?> selection, boolean ensureTransaction, boolean confirmDelete, boolean longOperationEvents) {
        this.executionManager = executionManager;
        this.editingDomain = executionManager != null ? executionManager.getEditingDomain() : null;
        this.ensureTransaction = ensureTransaction;
        this.confirmDelete = confirmDelete;
        this.sendLongRunningEvents = longOperationEvents;
        this.selection = new ArrayList(selection);
    }

    public void execute() {
        Set<? extends EObject> allControlledElementsToDelete = this.getAllControlledElementsToDelete();
        if (allControlledElementsToDelete.size() > 0) {
            this.showAbortDialogForControlledElementsToDelete(allControlledElementsToDelete);
            return;
        }
        if (this.confirmDelete && !this.confirmDeletion()) {
            return;
        }
        if (this.ensureTransaction) {
            this.executionManager.execute((ICommand)new AbstractReadWriteCommand(){

                public void commandRolledBack() {
                    if (BasicCapellaDeleteCommand.this.sendLongRunningEvents) {
                        LongRunningListenersRegistry.getInstance().operationAborted(BasicCapellaDeleteCommand.class);
                    }
                }

                public Collection<?> getAffectedObjects() {
                    if (BasicCapellaDeleteCommand.this.realCommand != null) {
                        return BasicCapellaDeleteCommand.this.realCommand.getAffectedObjects();
                    }
                    return super.getAffectedObjects();
                }

                public String getName() {
                    return Messages.CapellaDeleteCommand_Label;
                }

                public void run() {
                    BasicCapellaDeleteCommand.this.doExecute();
                }
            });
        } else {
            try {
                this.doExecute();
            }
            catch (Exception re) {
                ModelHandlerPlugin.getDefault().getLog().log((IStatus)new Status(2, ModelHandlerPlugin.PLUGIN_ID, re.getMessage(), (Throwable)re));
            }
        }
    }

    protected void showAbortDialogForControlledElementsToDelete(Set<? extends EObject> controlledElementsToDelete) {
    }

    protected boolean confirmDeletion() {
        return true;
    }

    protected Command getDeleteRepresentationCommand(TransactionalEditingDomain editingDomain) {
        return new BasicRepresentationDeleteCommand(editingDomain, RepresentationHelper.getAllRepresentationsTargetedBy(this.getExpandedSelection()), (IProgressMonitor)new NullProgressMonitor());
    }

    protected void doExecute() {
        if (this.sendLongRunningEvents) {
            LongRunningListenersRegistry.getInstance().operationStarting(BasicCapellaDeleteCommand.class);
        }
        for (AbstractCapellaDeleteHook hook : this.getDeleteCommandHooks()) {
            if (hook.preDelete(this.getAllElementsToDelete()).isOK()) continue;
            if (this.sendLongRunningEvents) {
                LongRunningListenersRegistry.getInstance().operationAborted(BasicCapellaDeleteCommand.class);
            }
            return;
        }
        try {
            this.realCommand = new DeleteStructureCommand(this.editingDomain, this.getExpandedSelection()){

                @Override
                protected void doPrepare() {
                    this.append(BasicCapellaDeleteCommand.this.getDeleteRepresentationCommand((TransactionalEditingDomain)this.getEditingDomain()));
                    super.doPrepare();
                }
            };
            if (this.realCommand.canExecute()) {
                this.realCommand.execute();
            }
        }
        finally {
            if (this.sendLongRunningEvents) {
                LongRunningListenersRegistry.getInstance().operationEnded(BasicCapellaDeleteCommand.class);
            }
        }
    }

    public boolean canUndo() {
        if (this.realCommand != null) {
            return this.realCommand.canUndo();
        }
        return false;
    }

    protected boolean isConfirmationRequired() {
        return false;
    }

    public Collection<?> getAffectedObjects() {
        if (this.realCommand != null) {
            return this.realCommand.getAffectedObjects();
        }
        return super.getAffectedObjects();
    }

    protected boolean prepare() {
        return true;
    }

    public void redo() {
        if (this.realCommand != null) {
            this.realCommand.redo();
        }
    }

    public void undo() {
        if (this.realCommand != null) {
            this.realCommand.undo();
        }
    }

    private List<AbstractCapellaDeleteHook> getDeleteCommandHooks() {
        if (deleteCommandHooks == null) {
            IConfigurationElement[] configurationElements;
            deleteCommandHooks = new ArrayList();
            IConfigurationElement[] iConfigurationElementArray = configurationElements = ExtensionPointHelper.getConfigurationElements((String)"org.polarsys.capella.core.platform.sirius.ui.actions", (String)"deleteCommandDelegation");
            int n = configurationElements.length;
            int n2 = 0;
            while (n2 < n) {
                IConfigurationElement elem = iConfigurationElementArray[n2];
                deleteCommandHooks.add((AbstractCapellaDeleteHook)ExtensionPointHelper.createInstance((IConfigurationElement)elem, (String)"class"));
                ++n2;
            }
        }
        return deleteCommandHooks;
    }

    public Collection<?> getExpandedSelection() {
        if (this.expandedSelection == null) {
            this.expandedSelection = Collections.unmodifiableCollection(this.deleteHelper.getExpandedSelection(this.selection));
        }
        return this.expandedSelection;
    }

    public IDeleteHelper getDeleteHelper() {
        return this.deleteHelper;
    }

    public void setDeleteHelper(IDeleteHelper helper) {
        this.deleteHelper = helper;
    }

    public Set<? extends EObject> getAllControlledElementsToDelete() {
        if (this._controlledExpandedSelectionContents == null) {
            HashSet<EObject> result = new HashSet<EObject>();
            for (Object deletedElement : this.getAllElementsToDelete()) {
                if (!AdapterFactoryEditingDomain.isControlled(deletedElement)) continue;
                result.add((EObject)deletedElement);
            }
            this._controlledExpandedSelectionContents = Collections.unmodifiableSet(result);
        }
        return this._controlledExpandedSelectionContents;
    }

    public Set<?> getAllElementsToDelete() {
        if (this.allElementsToDelete == null) {
            HashSet<EObject> result = new HashSet<EObject>();
            PreDeleteHandler handler = new PreDeleteHandler();
            PreDeleteStructureCommand preDeletion = new PreDeleteStructureCommand(this.editingDomain, this.getExpandedSelection(), handler);
            if (preDeletion.canExecute()) {
                preDeletion.execute();
            }
            block6: for (Notification notification : handler.notifications) {
                Object notifier = notification.getNotifier();
                if (!(notifier instanceof EObject)) continue;
                Object oldValue = notification.getOldValue();
                int notificationType = notification.getEventType();
                switch (notificationType) {
                    case 1: {
                        if (notification.getNewValue() != null) continue block6;
                    }
                    case 4: {
                        if (!(oldValue instanceof EObject)) break;
                        boolean handleNotification = false;
                        try {
                            EReference feature = (EReference)EReference.class.cast(notification.getFeature());
                            handleNotification = feature != null ? feature.isContainment() : false;
                        }
                        catch (ClassCastException cce) {
                            handleNotification = true;
                        }
                        if (!handleNotification) break;
                        EObject deletedObject = (EObject)oldValue;
                        result.add(deletedObject);
                        if (!CapellaResourceHelper.isSemanticElement(deletedObject)) break;
                        TreeIterator allChildrenOfDeletedObject = deletedObject.eAllContents();
                        while (allChildrenOfDeletedObject.hasNext()) {
                            EObject child = (EObject)allChildrenOfDeletedObject.next();
                            result.add(child);
                        }
                        continue block6;
                    }
                }
            }
            handler.dispose();
            this.allElementsToDelete = Collections.unmodifiableSet(result);
        }
        return this.allElementsToDelete;
    }

    protected void fillStructure(EObject parent, EObject removedElement, Map<EObject, Set<EObject>> parentsToChildren) {
        if (parent == null || removedElement == null || parentsToChildren == null) {
            return;
        }
        Set<EObject> children = parentsToChildren.get(parent);
        if (children == null) {
            children = new HashSet<EObject>(1);
            parentsToChildren.put(parent, children);
        }
        children.add(removedElement);
        for (EObject removed : removedElement.eContents()) {
            this.fillStructure(removedElement, removed, parentsToChildren);
        }
    }
}

