/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.core.model.handler.command;

import java.util.Collection;
import java.util.HashSet;
import org.apache.log4j.Logger;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.transaction.RecordingCommand;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.osgi.util.NLS;
import org.eclipse.sirius.business.api.dialect.DialectManager;
import org.eclipse.sirius.business.api.session.Session;
import org.eclipse.sirius.business.api.session.SessionManager;
import org.eclipse.sirius.viewpoint.DRepresentation;
import org.eclipse.sirius.viewpoint.DRepresentationDescriptor;
import org.eclipse.sirius.viewpoint.DSemanticDecorator;
import org.polarsys.capella.common.tools.report.EmbeddedMessage;
import org.polarsys.capella.common.tools.report.config.registry.ReportManagerRegistry;
import org.polarsys.capella.core.model.handler.command.Messages;
import org.polarsys.capella.core.model.handler.helpers.RepresentationHelper;

public class BasicRepresentationDeleteCommand
extends RecordingCommand {
    private static final Logger logger = ReportManagerRegistry.getInstance().subscribe("User Interface");
    private Collection<DRepresentation> representations;
    private IProgressMonitor monitor;

    public BasicRepresentationDeleteCommand(TransactionalEditingDomain domain, Collection<DRepresentation> representations, IProgressMonitor monitor) {
        super(domain, Messages.DeleteRepresentationCommand_DeleteRepresentationCommandLabel);
        this.representations = representations;
        this.monitor = monitor;
    }

    protected void doExecute() {
        if (this.representations == null || this.representations.size() == 0) {
            return;
        }
        try {
            this.monitor.beginTask(this.description, this.representations.size());
            for (DRepresentation representation : this.representations) {
                DSemanticDecorator semanticDecorator = (DSemanticDecorator)representation;
                if (representation.getName() != null) {
                    this.monitor.setTaskName(NLS.bind((String)Messages.DeleteRepresentationCommand_DeleteRepresentationCommandText, (Object)representation.getName()));
                }
                Session session = null;
                EObject targetElement = semanticDecorator.getTarget();
                if (targetElement != null) {
                    session = SessionManager.INSTANCE.getSession(targetElement);
                }
                if (session == null) {
                    session = this.getSession(semanticDecorator.eResource());
                }
                if (session != null) {
                    this.closeActiveRepresentationEditor(representation, session);
                    DRepresentationDescriptor descriptor = RepresentationHelper.getRepresentationDescriptor(session, representation);
                    if (descriptor != null && DialectManager.INSTANCE.deleteRepresentation(descriptor, session)) {
                        SessionManager.INSTANCE.notifyRepresentationDeleted(session);
                    }
                } else {
                    StringBuilder loggerMessage = new StringBuilder("DeleteRepresentationAction.DeleteRepresentationCommand.doExecute(..) _ ");
                    loggerMessage.append("unable to find a session for ").append(semanticDecorator.toString());
                    logger.error((Object)new EmbeddedMessage(loggerMessage.toString(), "User Interface"));
                }
                this.monitor.worked(1);
            }
        }
        finally {
            this.monitor.done();
        }
    }

    protected void closeActiveRepresentationEditor(DRepresentation representation, Session session) {
    }

    private Session getSession(Resource airdResource) {
        Session result = null;
        for (Session session : SessionManager.INSTANCE.getSessions()) {
            HashSet<Resource> allAnalysisResources = new HashSet<Resource>(session.getReferencedSessionResources());
            allAnalysisResources.add(session.getSessionResource());
            if (!allAnalysisResources.contains(airdResource)) continue;
            result = session;
            break;
        }
        return result;
    }
}

