/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.core.model.handler.helpers;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import org.apache.log4j.Logger;
import org.eclipse.core.resources.IFile;
import org.eclipse.emf.ecore.xmi.impl.XMLHandler;
import org.polarsys.capella.common.mdsofa.common.helper.StringHelper;
import org.polarsys.capella.common.tools.report.config.registry.ReportManagerRegistry;

public class CapellaFeatureHelper {
    private static final Logger __logger = ReportManagerRegistry.getInstance().subscribe("Model Management");
    private static final int BUFFER_SIZE = 76;

    public static String getDetectedVersion(IFile modelFile_p) {
        String detectedVersion = null;
        try {
            InputStream contents = modelFile_p.getContents(false);
            if (!contents.markSupported()) {
                contents = new BufferedInputStream(contents);
            }
            byte[] buffer = CapellaFeatureHelper.readBuffer(contents);
            contents.close();
            String encoding = XMLHandler.getXMLEncoding((byte[])buffer);
            String contentAsString = new String(buffer, encoding);
            detectedVersion = StringHelper.substring((String)"Capella_Version_", (String)"-->", (String)contentAsString, (boolean)false);
            if (detectedVersion == null) {
                detectedVersion = StringHelper.substring((String)"MelodyAdvance_Version_", (String)"-->", (String)contentAsString, (boolean)false);
            }
        }
        catch (Exception exception_p) {
            StringBuilder loggerMessage = new StringBuilder("CapellaFeatureHelper.getDetectedVersion(..) _ ");
            __logger.warn((Object)loggerMessage.toString(), (Throwable)exception_p);
        }
        return detectedVersion;
    }

    private static byte[] readBuffer(InputStream inputStream_p) throws IOException {
        int bytesRead;
        if (inputStream_p.available() == 0) {
            return new byte[0];
        }
        byte[] buffer = new byte[76];
        inputStream_p.mark(76);
        int totalBytesRead = bytesRead = inputStream_p.read(buffer, 0, 76);
        while (bytesRead != -1 && totalBytesRead < 76) {
            bytesRead = inputStream_p.read(buffer, totalBytesRead, 76 - totalBytesRead);
            if (bytesRead == -1) continue;
            totalBytesRead += bytesRead;
        }
        if (totalBytesRead < 0) {
            buffer = new byte[]{};
        } else if (totalBytesRead < 76) {
            byte[] smallerBuffer = new byte[totalBytesRead];
            System.arraycopy(buffer, 0, smallerBuffer, 0, totalBytesRead);
            buffer = smallerBuffer;
        }
        inputStream_p.reset();
        return buffer;
    }
}

