/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.core.model.handler.helpers;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.polarsys.capella.common.libraries.LibrariesFactory;
import org.polarsys.capella.common.libraries.ModelInformation;
import org.polarsys.capella.core.data.capellacore.CapellacoreFactory;
import org.polarsys.capella.core.data.capellacore.EnumerationPropertyLiteral;
import org.polarsys.capella.core.data.capellacore.EnumerationPropertyType;
import org.polarsys.capella.core.data.capellacore.KeyValue;
import org.polarsys.capella.core.data.capellamodeller.Project;
import org.polarsys.kitalpha.emde.model.ElementExtension;

public class CapellaProjectHelper {
    public static final String PROGRESS_STATUS_KEYWORD = "ProgressStatus";
    private static final String PROJECT_APPROACH_KEY = "projectApproach";

    public static void setProjectWithApproach(Project capellaProject_p, ProjectApproach approach_p) {
        for (KeyValue keyValue : capellaProject_p.getKeyValuePairs()) {
            if (!PROJECT_APPROACH_KEY.equals(keyValue.getKey())) continue;
            keyValue.setValue(approach_p.name());
            return;
        }
        KeyValue natureKeyValue = CapellacoreFactory.eINSTANCE.createKeyValue();
        natureKeyValue.setKey(PROJECT_APPROACH_KEY);
        natureKeyValue.setValue(approach_p.name());
        capellaProject_p.getKeyValuePairs().add((Object)natureKeyValue);
    }

    private static TriStateBoolean hasGivenApproach(ProjectApproach approach_p, Project capellaProject_p) {
        TriStateBoolean result = TriStateBoolean.False;
        if (capellaProject_p == null) {
            return TriStateBoolean.Undefined;
        }
        for (KeyValue keyValue : capellaProject_p.getKeyValuePairs()) {
            if (!PROJECT_APPROACH_KEY.equals(keyValue.getKey()) || !approach_p.name().equals(keyValue.getValue())) continue;
            result = TriStateBoolean.True;
            break;
        }
        return result;
    }

    public static TriStateBoolean isSingletonComponentsDriven(EObject capellaElement_p) {
        return CapellaProjectHelper.hasGivenApproach(ProjectApproach.SingletonComponents, CapellaProjectHelper.getProject(capellaElement_p));
    }

    public static TriStateBoolean isReusableComponentsDriven(EObject capellaElement_p) {
        return CapellaProjectHelper.hasGivenApproach(ProjectApproach.ReusableComponents, CapellaProjectHelper.getProject(capellaElement_p));
    }

    public static void removeOldProjectApproachContent(Project capellaProject) {
        EList keyValuePairs = capellaProject.getKeyValuePairs();
        if (!keyValuePairs.isEmpty()) {
            Iterator keyValues = keyValuePairs.iterator();
            while (keyValues.hasNext()) {
                KeyValue projectApproachKeyValue = (KeyValue)keyValues.next();
                if (!PROJECT_APPROACH_KEY.equals(projectApproachKeyValue.getKey())) continue;
                String value = projectApproachKeyValue.getValue();
                if (ProjectApproach.ReusableComponents.name().equals(value) || ProjectApproach.SingletonComponents.name().equals(value)) break;
                keyValues.remove();
                break;
            }
        }
    }

    public static void addProjectProgressStatus(Project project_p) {
        EnumerationPropertyType type = CapellacoreFactory.eINSTANCE.createEnumerationPropertyType(PROGRESS_STATUS_KEYWORD);
        type.getOwnedLiterals().add((Object)CapellacoreFactory.eINSTANCE.createEnumerationPropertyLiteral("DRAFT"));
        type.getOwnedLiterals().add((Object)CapellacoreFactory.eINSTANCE.createEnumerationPropertyLiteral("TO_BE_REVIEWED"));
        type.getOwnedLiterals().add((Object)CapellacoreFactory.eINSTANCE.createEnumerationPropertyLiteral("TO_BE_DISCUSSED"));
        type.getOwnedLiterals().add((Object)CapellacoreFactory.eINSTANCE.createEnumerationPropertyLiteral("REWORK_NECESSARY"));
        type.getOwnedLiterals().add((Object)CapellacoreFactory.eINSTANCE.createEnumerationPropertyLiteral("UNDER_REWORK"));
        type.getOwnedLiterals().add((Object)CapellacoreFactory.eINSTANCE.createEnumerationPropertyLiteral("REVIEWED_OK"));
        project_p.getOwnedEnumerationPropertyTypes().add((Object)type);
    }

    public static EnumerationPropertyType getEnumerationPropertyType(EObject eObject_p, String key_p) {
        Project project;
        if (eObject_p != null && (project = CapellaProjectHelper.getProject(eObject_p)) != null) {
            for (EnumerationPropertyType current : project.getOwnedEnumerationPropertyTypes()) {
                if (!current.getName().equals(key_p)) continue;
                return current;
            }
        }
        return null;
    }

    public static List<EnumerationPropertyLiteral> getEnumerationPropertyLiterals(EObject eObject_p, String key_p) {
        Project project;
        ArrayList<EnumerationPropertyLiteral> result = new ArrayList<EnumerationPropertyLiteral>();
        if (eObject_p != null && (project = CapellaProjectHelper.getProject(eObject_p)) != null) {
            for (EnumerationPropertyType current : project.getOwnedEnumerationPropertyTypes()) {
                if (!current.getName().equals(key_p)) continue;
                result.addAll((Collection<EnumerationPropertyLiteral>)current.getOwnedLiterals());
            }
        }
        return result;
    }

    public static Project getProject(EObject modelElement_p) {
        EObject parent = modelElement_p;
        while (!(parent instanceof Project) && parent != null) {
            parent = parent.eContainer();
        }
        return parent != null ? (Project)parent : null;
    }

    public static void addModelInformation(Project project_p) {
        CapellaProjectHelper.getModelInformation(project_p, true);
    }

    public static ModelInformation getModelInformation(Project project_p, boolean create_p) {
        ModelInformation result = null;
        if (project_p != null) {
            for (ElementExtension extension : project_p.getOwnedExtensions()) {
                if (!(extension instanceof ModelInformation)) continue;
                result = (ModelInformation)extension;
                break;
            }
            if (result == null && create_p) {
                result = LibrariesFactory.eINSTANCE.createModelInformation();
                project_p.getOwnedExtensions().add((Object)result);
            }
        }
        return result;
    }

    public static enum ProjectApproach {
        SingletonComponents,
        ReusableComponents;

    }

    public static enum TriStateBoolean {
        True,
        False,
        Undefined;

    }
}

