/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.core.model.handler.helpers;

import com.google.common.collect.Iterables;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.sirius.business.api.dialect.DialectManager;
import org.eclipse.sirius.business.api.query.RepresentationDescriptionQuery;
import org.eclipse.sirius.business.api.session.Session;
import org.eclipse.sirius.business.api.session.SessionManager;
import org.eclipse.sirius.business.api.session.resource.AirdResource;
import org.eclipse.sirius.viewpoint.DAnalysis;
import org.eclipse.sirius.viewpoint.DRepresentation;
import org.eclipse.sirius.viewpoint.DRepresentationDescriptor;
import org.eclipse.sirius.viewpoint.DSemanticDecorator;
import org.eclipse.sirius.viewpoint.ViewpointPackage;
import org.eclipse.sirius.viewpoint.description.DAnnotation;
import org.eclipse.sirius.viewpoint.description.DescriptionFactory;
import org.eclipse.sirius.viewpoint.description.RepresentationDescription;
import org.eclipse.sirius.viewpoint.description.Viewpoint;
import org.polarsys.capella.common.data.modellingcore.ModellingcorePackage;
import org.polarsys.capella.common.helpers.EcoreUtil2;
import org.polarsys.capella.common.utils.RunnableWithBooleanResult;
import org.polarsys.capella.core.data.capellacore.CapellacorePackage;
import org.polarsys.capella.core.data.cs.AbstractActor;
import org.polarsys.capella.core.data.interaction.InteractionPackage;
import org.polarsys.capella.core.model.handler.command.CapellaResourceHelper;
import org.polarsys.capella.core.model.handler.helpers.CrossReferencerHelper;

public class RepresentationHelper {
    public static List<DRepresentation> getRepresentations(Collection<?> selection) {
        return RepresentationHelper.getRepresentations(selection, false);
    }

    public static List<DRepresentation> getRepresentations(Collection<?> selection, boolean mustBeDecorator) {
        ArrayList<DRepresentation> representations = new ArrayList<DRepresentation>();
        for (Object selectedObject : selection) {
            if (selectedObject instanceof DRepresentation) {
                RepresentationHelper.addRepresentation(mustBeDecorator, representations, (DRepresentation)selectedObject);
            }
            if (!(selectedObject instanceof DRepresentationDescriptor)) continue;
            RepresentationHelper.addRepresentation(mustBeDecorator, representations, ((DRepresentationDescriptor)selectedObject).getRepresentation());
        }
        return representations;
    }

    private static void addRepresentation(boolean mustBeDecorator, List<DRepresentation> representations, DRepresentation selectedObject) {
        if (mustBeDecorator) {
            if (selectedObject instanceof DSemanticDecorator) {
                representations.add(selectedObject);
            }
        } else {
            representations.add(selectedObject);
        }
    }

    public static Collection<DRepresentation> getAllRepresentationsTargetedBy(Collection<?> semanticElements) {
        HashSet<DRepresentation> representations = new HashSet<DRepresentation>();
        Iterable semanticEObjects = Iterables.filter(semanticElements, EObject.class);
        for (EObject semanticEObject : semanticEObjects) {
            Session session = SessionManager.INSTANCE.getSession(semanticEObject);
            if (session == null) continue;
            representations.addAll(DialectManager.INSTANCE.getRepresentations(semanticEObject, session));
            TreeIterator allChildrenOfCurrentElement = semanticEObject.eAllContents();
            while (allChildrenOfCurrentElement.hasNext()) {
                EObject child = (EObject)allChildrenOfCurrentElement.next();
                representations.addAll(DialectManager.INSTANCE.getRepresentations(child, session));
            }
        }
        return representations;
    }

    public static Collection<DRepresentationDescriptor> getAllRepresentationDescriptorsTargetedBy(Collection<?> semanticElements) {
        HashSet<DRepresentationDescriptor> representations = new HashSet<DRepresentationDescriptor>();
        Iterable semanticEObjects = Iterables.filter(semanticElements, EObject.class);
        for (EObject semanticEObject : semanticEObjects) {
            Session session = SessionManager.INSTANCE.getSession(semanticEObject);
            if (session == null) continue;
            representations.addAll(DialectManager.INSTANCE.getRepresentationDescriptors(semanticEObject, session));
            TreeIterator allChildrenOfCurrentElement = semanticEObject.eAllContents();
            while (allChildrenOfCurrentElement.hasNext()) {
                EObject child = (EObject)allChildrenOfCurrentElement.next();
                representations.addAll(DialectManager.INSTANCE.getRepresentationDescriptors(child, session));
            }
        }
        return representations;
    }

    private static void getRelatedRepresentations(EObject semanticElement, Set<DRepresentation> representations) {
        Session session = SessionManager.INSTANCE.getSession(semanticElement);
        ArrayList<EObject> semanticElementsToCheck = new ArrayList<EObject>();
        semanticElementsToCheck.add(semanticElement);
        if (semanticElement instanceof AbstractActor) {
            semanticElementsToCheck.addAll((Collection<EObject>)((AbstractActor)semanticElement).getAllocatedFunctions());
        }
        for (EObject semanticElementToCheck : semanticElementsToCheck) {
            for (EStructuralFeature.Setting setting : session.getSemanticCrossReferencer().getInverseReferences(semanticElementToCheck)) {
                if (ViewpointPackage.Literals.DSEMANTIC_DECORATOR__TARGET.equals(setting.getEStructuralFeature())) {
                    DSemanticDecorator decorator = (DSemanticDecorator)setting.getEObject();
                    DRepresentation diagram = null;
                    diagram = decorator instanceof DRepresentation ? (DRepresentation)decorator : (DRepresentation)EcoreUtil2.getFirstContainer((EObject)decorator, (EClass)ViewpointPackage.Literals.DREPRESENTATION);
                    if (diagram == null) continue;
                    representations.add(diagram);
                    continue;
                }
                if (!ModellingcorePackage.Literals.ABSTRACT_TYPED_ELEMENT__ABSTRACT_TYPE.equals(setting.getEStructuralFeature()) && !InteractionPackage.Literals.EVENT_RECEIPT_OPERATION__OPERATION.equals(setting.getEStructuralFeature()) && !InteractionPackage.Literals.ABSTRACT_END__EVENT.equals(setting.getEStructuralFeature()) && !InteractionPackage.Literals.SEQUENCE_MESSAGE__RECEIVING_END.equals(setting.getEStructuralFeature()) && !InteractionPackage.Literals.EVENT_SENT_OPERATION__OPERATION.equals(setting.getEStructuralFeature()) && !InteractionPackage.Literals.SEQUENCE_MESSAGE__SENDING_END.equals(setting.getEStructuralFeature()) && !InteractionPackage.Literals.INSTANCE_ROLE__REPRESENTED_INSTANCE.equals(setting.getEStructuralFeature()) && !InteractionPackage.Literals.STATE_FRAGMENT__RELATED_ABSTRACT_STATE.equals(setting.getEStructuralFeature()) && !InteractionPackage.Literals.STATE_FRAGMENT__RELATED_ABSTRACT_FUNCTION.equals(setting.getEStructuralFeature()) && !CapellacorePackage.Literals.INVOLVEMENT__INVOLVED.equals(setting.getEStructuralFeature())) continue;
                RepresentationHelper.getRelatedRepresentations(setting.getEObject(), representations);
            }
        }
    }

    public static Collection<DRepresentation> getAllRepresentationsWhereSemanticElementIsDisplayed(EObject semanticElement, RunnableWithBooleanResult filteringCondition) {
        Session session = SessionManager.INSTANCE.getSession(semanticElement);
        if (session == null) {
            return Collections.emptySet();
        }
        HashSet<DRepresentation> unfilteredRepresentations = new HashSet<DRepresentation>();
        RepresentationHelper.getRelatedRepresentations(semanticElement, unfilteredRepresentations);
        HashSet<DRepresentation> filteredRepresentations = new HashSet<DRepresentation>();
        Collection selectedViewpoints = session.getSelectedViewpoints(false);
        for (DRepresentation representation : unfilteredRepresentations) {
            RepresentationDescription representationDescription = DialectManager.INSTANCE.getDescription(representation);
            Viewpoint parentViewpoint = new RepresentationDescriptionQuery(representationDescription).getParentViewpoint();
            if (!selectedViewpoints.contains(parentViewpoint)) continue;
            if (filteringCondition == null) {
                filteredRepresentations.add(representation);
                continue;
            }
            filteringCondition.setObject((EObject)representationDescription);
            filteringCondition.run();
            if (!filteringCondition.getResult().booleanValue()) continue;
            filteredRepresentations.add(representation);
        }
        return filteredRepresentations;
    }

    public static Collection<Resource> collectDependentResources(EObject semanticRoot) {
        HashSet<Resource> resources = new HashSet<Resource>();
        for (EObject referencingElement : CrossReferencerHelper.getReferencingElements(semanticRoot)) {
            resources.add(referencingElement.eResource());
        }
        for (DRepresentation representation : RepresentationHelper.getAllRepresentationsWhereSemanticElementIsDisplayed(semanticRoot, null)) {
            resources.add(representation.eResource());
        }
        Resource semanticRootResource = semanticRoot.eResource();
        TreeIterator semanticRootEAllContents = semanticRoot.eAllContents();
        while (semanticRootEAllContents.hasNext()) {
            EObject child = (EObject)semanticRootEAllContents.next();
            Resource childResource = EcoreUtil2.getResourceContainer((EObject)child).eResource();
            if (!semanticRootResource.equals(childResource)) continue;
            for (EObject referencingElement : CrossReferencerHelper.getReferencingElements(child)) {
                resources.add(referencingElement.eResource());
            }
            for (DRepresentation representation : RepresentationHelper.getAllRepresentationsWhereSemanticElementIsDisplayed(child, null)) {
                resources.add(representation.eResource());
            }
        }
        return resources;
    }

    public static DAnnotation getAnnotation(String source, DRepresentation representation) {
        for (DAnnotation annotation : representation.getEAnnotations()) {
            if (!annotation.getSource().equals(source)) continue;
            return annotation;
        }
        return null;
    }

    public static DAnnotation createAnnotation(String source, DRepresentation representation) {
        DAnnotation annotation = DescriptionFactory.eINSTANCE.createDAnnotation();
        annotation.setSource(source);
        representation.getEAnnotations().add((Object)annotation);
        return annotation;
    }

    public static void removeAnnotation(String source, DRepresentation representation) {
        DAnnotation annotation = RepresentationHelper.getAnnotation(source, representation);
        if (annotation != null) {
            representation.getEAnnotations().remove((Object)annotation);
        }
    }

    public static Collection<Resource> getSemanticResources(DRepresentation representation) {
        EObject root;
        if (representation != null && representation instanceof DSemanticDecorator && (root = ((DSemanticDecorator)representation).getTarget()) != null) {
            HashSet<Resource> resources = new HashSet<Resource>();
            Session session = SessionManager.INSTANCE.getSession(root);
            if (session != null) {
                Set referencedSessionResources;
                HashSet sessionResources = new HashSet();
                Collection sessionSemanticResources = session.getSemanticResources();
                if (sessionSemanticResources != null) {
                    sessionResources.addAll(sessionSemanticResources);
                }
                if ((referencedSessionResources = session.getReferencedSessionResources()) != null) {
                    sessionResources.addAll(referencedSessionResources);
                }
                for (Resource resource : sessionResources) {
                    if (resource instanceof AirdResource) {
                        AirdResource airdResource = (AirdResource)resource;
                        if (airdResource.getContents() == null) continue;
                        for (EObject rootAird : airdResource.getContents()) {
                            DAnalysis analysis;
                            if (!(rootAird instanceof DAnalysis) || (analysis = (DAnalysis)rootAird).getModels() == null) continue;
                            for (EObject model : analysis.getModels()) {
                                Resource modelResource;
                                if (model == null || model.eIsProxy() || (modelResource = model.eResource()) == null) continue;
                                resources.add(modelResource);
                            }
                        }
                        continue;
                    }
                    if (!CapellaResourceHelper.isCapellaResource(resource)) continue;
                    resources.add(resource);
                }
                return resources;
            }
            return Collections.singletonList(root.eResource());
        }
        return Collections.EMPTY_LIST;
    }

    public static DRepresentationDescriptor getRepresentationDescriptor(Session session, DRepresentation representation) {
        if (representation != null && session != null) {
            RepresentationDescription description = DialectManager.INSTANCE.getDescription(representation);
            for (DRepresentationDescriptor descriptor : DialectManager.INSTANCE.getRepresentationDescriptors(description, session)) {
                if (!representation.equals(descriptor.getRepresentation())) continue;
                return descriptor;
            }
        }
        return null;
    }

    public static DRepresentationDescriptor getRepresentationDescriptor(DRepresentation representation) {
        if (representation instanceof DSemanticDecorator) {
            EObject target = ((DSemanticDecorator)representation).getTarget();
            Session session = SessionManager.INSTANCE.getSession(target);
            return RepresentationHelper.getRepresentationDescriptor(session, representation);
        }
        return null;
    }

    public static Collection<DRepresentationDescriptor> getRepresentationDescriptors(Collection<DRepresentation> representations) {
        HashSet<DRepresentationDescriptor> result = new HashSet<DRepresentationDescriptor>();
        for (DRepresentation representation : representations) {
            DRepresentationDescriptor descriptor = RepresentationHelper.getRepresentationDescriptor(representation);
            if (descriptor == null) continue;
            result.add(descriptor);
        }
        return result;
    }
}

