/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.core.platform.sirius.ui.actions;

import java.util.List;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.polarsys.capella.common.data.modellingcore.TraceableElement;
import org.polarsys.capella.core.data.cs.Component;
import org.polarsys.capella.core.data.cs.CsFactory;
import org.polarsys.capella.core.data.cs.DeployableElement;
import org.polarsys.capella.core.data.cs.DeploymentTarget;
import org.polarsys.capella.core.data.cs.ExchangeItemAllocation;
import org.polarsys.capella.core.data.cs.Interface;
import org.polarsys.capella.core.data.cs.Part;
import org.polarsys.capella.core.data.cs.PhysicalLink;
import org.polarsys.capella.core.data.fa.AbstractFunction;
import org.polarsys.capella.core.data.fa.ComponentExchange;
import org.polarsys.capella.core.data.fa.ComponentExchangeAllocation;
import org.polarsys.capella.core.data.fa.ComponentExchangeFunctionalExchangeAllocation;
import org.polarsys.capella.core.data.fa.ComponentFunctionalAllocation;
import org.polarsys.capella.core.data.fa.FaFactory;
import org.polarsys.capella.core.data.fa.FunctionalExchange;
import org.polarsys.capella.core.data.information.ExchangeItem;
import org.polarsys.capella.core.data.oa.ActivityAllocation;
import org.polarsys.capella.core.data.oa.OaFactory;
import org.polarsys.capella.core.data.oa.Role;
import org.polarsys.capella.core.data.pa.deployment.DeploymentFactory;
import org.polarsys.capella.core.data.pa.deployment.PartDeploymentLink;
import org.polarsys.capella.core.model.helpers.ComponentExchangeExt;
import org.polarsys.capella.core.model.helpers.PhysicalComponentExt;
import org.polarsys.capella.core.model.preferences.CapellaModelPreferencesPlugin;

public class AllocationManagementAction {
    public static AllocationManagementAction getInstance() {
        return new AllocationManagementAction();
    }

    public void allocatingFunctionsToComponent(List<EObject> targetElements, EObject sourceElement) {
        block2: {
            block3: {
                if (sourceElement == null) break block2;
                if (!(sourceElement instanceof Component)) break block3;
                Component comp = (Component)sourceElement;
                for (EObject modelElement : targetElements) {
                    AbstractFunction function;
                    if (!(modelElement instanceof AbstractFunction) || !(function = (AbstractFunction)modelElement).getAllocationBlocks().isEmpty()) continue;
                    ComponentFunctionalAllocation alloction = FaFactory.eINSTANCE.createComponentFunctionalAllocation();
                    comp.getOwnedFunctionalAllocation().add((Object)alloction);
                    alloction.setSourceElement((TraceableElement)comp);
                    alloction.setTargetElement((TraceableElement)function);
                }
                break block2;
            }
            if (!(sourceElement instanceof Role)) break block2;
            Role role = (Role)sourceElement;
            for (EObject modelElement : targetElements) {
                AbstractFunction function;
                if (!(modelElement instanceof AbstractFunction) || !(function = (AbstractFunction)modelElement).getAllocationBlocks().isEmpty()) continue;
                ActivityAllocation newAllocation = OaFactory.eINSTANCE.createActivityAllocation();
                role.getOwnedActivityAllocations().add((Object)newAllocation);
                newAllocation.setSourceElement((TraceableElement)role);
                newAllocation.setTargetElement((TraceableElement)function);
            }
        }
    }

    public void allocatingExchangeItemsToInterfaces(List<EObject> targetElements, List<EObject> sourceElements) {
        if (!sourceElements.isEmpty() && !targetElements.isEmpty()) {
            for (EObject source : sourceElements) {
                if (!(source instanceof Interface)) continue;
                Interface sourceElement = (Interface)source;
                for (EObject target : targetElements) {
                    if (!(target instanceof ExchangeItem)) continue;
                    ExchangeItem targetElement = (ExchangeItem)target;
                    EList allocations = sourceElement.getOwnedExchangeItemAllocations();
                    ExchangeItemAllocation newAllocation = CsFactory.eINSTANCE.createExchangeItemAllocation();
                    allocations.add((Object)newAllocation);
                    newAllocation.setAllocatedItem(targetElement);
                }
            }
        }
    }

    public void allocatingPCPartsToPCPart(List<EObject> targetElements, EObject sourceElement) {
        if (sourceElement != null && sourceElement instanceof Part) {
            Part sourcePart = (Part)sourceElement;
            for (EObject modelElement : targetElements) {
                Part targetPart;
                if (!(modelElement instanceof Part) || !(targetPart = (Part)modelElement).getDeployingLinks().isEmpty() || !PhysicalComponentExt.isDeploymentPossible((Part)sourcePart, (Part)targetPart)) continue;
                PartDeploymentLink deployment = DeploymentFactory.eINSTANCE.createPartDeploymentLink();
                sourcePart.getOwnedDeploymentLinks().add((Object)deployment);
                deployment.setDeployedElement((DeployableElement)targetPart);
                deployment.setLocation((DeploymentTarget)sourcePart);
            }
        }
    }

    public void allocatingFEsToComponentExchanges(List<EObject> targetElements, EObject sourceElement) {
        if (sourceElement != null && sourceElement instanceof ComponentExchange) {
            ComponentExchange compExc = (ComponentExchange)sourceElement;
            for (EObject object : targetElements) {
                if (!(object instanceof FunctionalExchange)) continue;
                FunctionalExchange functExc = (FunctionalExchange)object;
                ComponentExchangeFunctionalExchangeAllocation allocation = FaFactory.eINSTANCE.createComponentExchangeFunctionalExchangeAllocation();
                compExc.getOwnedComponentExchangeFunctionalExchangeAllocations().add((Object)allocation);
                allocation.setSourceElement((TraceableElement)compExc);
                allocation.setTargetElement((TraceableElement)functExc);
                if (!CapellaModelPreferencesPlugin.getDefault().isSynchronizationOfComponentPortToFunctionPortAllowed()) continue;
                ComponentExchangeExt.synchronizePortAllocations((ComponentExchange)compExc, (FunctionalExchange)functExc);
            }
        }
    }

    public void allocatingCEsToPhysicalLinks(List<EObject> targetElements, EObject sourceElement) {
        if (sourceElement != null && sourceElement instanceof PhysicalLink) {
            PhysicalLink physicalLink = (PhysicalLink)sourceElement;
            for (EObject object : targetElements) {
                if (!(object instanceof ComponentExchange)) continue;
                ComponentExchangeAllocation allocation = FaFactory.eINSTANCE.createComponentExchangeAllocation();
                physicalLink.getOwnedComponentExchangeAllocations().add((Object)allocation);
                allocation.setSourceElement((TraceableElement)physicalLink);
                allocation.setTargetElement((TraceableElement)((ComponentExchange)object));
            }
        }
    }
}

