/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.core.platform.sirius.ui.actions;

import java.util.Collection;
import java.util.List;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.command.UnexecutableCommand;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emf.edit.ui.EMFEditUIPlugin;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.polarsys.capella.common.helpers.TransactionHelper;
import org.polarsys.capella.common.model.copypaste.SharedCutPasteClipboard;
import org.polarsys.capella.core.model.helpers.move.MoveHelper;
import org.polarsys.capella.core.platform.sirius.ui.commands.CapellaPasteCommand;
import org.polarsys.capella.core.ui.toolkit.AbstractCommandActionHandler;

public class CapellaPasteAction
extends AbstractCommandActionHandler {
    public CapellaPasteAction() {
        super(EMFEditUIPlugin.INSTANCE.getString("_UI_Paste_menu_item"));
    }

    public Command createCommand(Collection<Object> selection) {
        if (1 == selection.size()) {
            return new CapellaPasteCommand((EditingDomain)TransactionHelper.getEditingDomain((Collection)this.filterSelection(selection)), this.getStructuredSelection().iterator().next(), null, -1);
        }
        return UnexecutableCommand.INSTANCE;
    }

    public boolean updateSelection(IStructuredSelection selection) {
        Object obj;
        if (!selection.isEmpty() && (obj = selection.iterator().next()) instanceof EObject) {
            Collection clipboard = null;
            SharedCutPasteClipboard cutClipboard = SharedCutPasteClipboard.getCutClipboard();
            if (cutClipboard != null && cutClipboard.hasCut()) {
                clipboard = cutClipboard.getClipboard();
            } else {
                TransactionalEditingDomain domain = TransactionHelper.getEditingDomain((EObject)((EObject)obj));
                if (domain != null) {
                    clipboard = domain.getClipboard();
                }
            }
            if (clipboard != null && !clipboard.isEmpty() && !CapellaPasteAction.checkSemanticRules((List)clipboard, (EObject)obj)) {
                return false;
            }
        }
        return super.updateSelection(selection);
    }

    @Deprecated
    public static boolean checkSemanticRules(List<EObject> selectedElements, EObject targetElement) {
        return MoveHelper.getInstance().checkSemanticRules(selectedElements, targetElement).isOK();
    }
}

