/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.core.platform.sirius.ui.commands;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Set;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.ui.PlatformUI;
import org.polarsys.capella.common.ef.ExecutionManager;
import org.polarsys.capella.core.model.handler.command.BasicCapellaDeleteCommand;
import org.polarsys.capella.core.model.handler.helpers.RepresentationHelper;
import org.polarsys.capella.core.model.preferences.IDeletePreferences;
import org.polarsys.capella.core.platform.sirius.ui.commands.DeleteRepresentationCommand;
import org.polarsys.capella.core.platform.sirius.ui.commands.Messages;
import org.polarsys.capella.core.ui.toolkit.dialogs.ConfirmDeleteCapellaElementDialog;
import org.polarsys.capella.core.ui.toolkit.dialogs.ImpactAnalysisDialog;

public class CapellaDeleteCommand
extends BasicCapellaDeleteCommand {
    public CapellaDeleteCommand(ExecutionManager executionManager, Collection<?> selection) {
        this(executionManager, selection, true);
    }

    public CapellaDeleteCommand(EditingDomain editingDomain, Collection<?> selection, boolean confirmDelete) {
        this(null, selection, false, confirmDelete, true);
        this.editingDomain = editingDomain;
    }

    public CapellaDeleteCommand(ExecutionManager executionManager, Collection<?> selection, boolean ensureTransaction) {
        this(executionManager, selection, ensureTransaction, IDeletePreferences.INSTANCE.isConfirmationRequired(), true);
    }

    public CapellaDeleteCommand(ExecutionManager executionManager, Collection<?> selection, boolean ensureTransaction, boolean confirmDelete, boolean longOperationEvents) {
        super(executionManager, selection, ensureTransaction, confirmDelete, longOperationEvents);
    }

    protected Command getDeleteRepresentationCommand(TransactionalEditingDomain editingDomain) {
        return new DeleteRepresentationCommand(editingDomain, RepresentationHelper.getAllRepresentationsTargetedBy((Collection)this.getExpandedSelection()));
    }

    protected boolean isConfirmationRequired() {
        return IDeletePreferences.INSTANCE.isConfirmationRequired();
    }

    protected void showAbortDialogForControlledElementsToDelete(final Set<? extends EObject> controlledElementsToDelete) {
        PlatformUI.getWorkbench().getDisplay().syncExec(new Runnable(){

            @Override
            public void run() {
                ImpactAnalysisDialog dialog = new ImpactAnalysisDialog(new ArrayList(controlledElementsToDelete), Messages.CapellaDeleteCommand_Label, Messages.CapellaDeleteCommand_ControlledElementsError_Message, 1, new String[]{org.polarsys.capella.common.ui.toolkit.dialogs.Messages.AbstractViewerDialog_OK_Title}, 3, false);
                dialog.open();
            }
        });
    }

    protected boolean confirmDeletion() {
        final int[] dialogResult = new int[1];
        PlatformUI.getWorkbench().getDisplay().syncExec(new Runnable(){

            @Override
            public void run() {
                ConfirmDeleteCapellaElementDialog confirmDeletionDialog = new ConfirmDeleteCapellaElementDialog(new ArrayList(CapellaDeleteCommand.this.getAllElementsToDelete()), true, CapellaDeleteCommand.this.getExpandedSelection().toArray());
                dialogResult[0] = confirmDeletionDialog.open();
            }
        });
        return dialogResult[0] == 0;
    }

    public static boolean confirmDeletion(ExecutionManager manager, Collection<?> selection) {
        DryRun dr = new DryRun(manager, selection);
        dr.execute();
        return dr.proceed();
    }

    static class DryRun
    extends CapellaDeleteCommand {
        boolean proceed = false;

        public DryRun(ExecutionManager executionManager, Collection<?> selection) {
            super(executionManager, selection);
        }

        public boolean proceed() {
            return this.proceed;
        }

        public void doExecute() {
            this.proceed = true;
        }
    }
}

