/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.kitalpha.richtext.widget.tools.ext.types;

import java.util.Iterator;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.edit.domain.AdapterFactoryEditingDomain;
import org.eclipse.emf.edit.ui.provider.AdapterFactoryContentProvider;
import org.eclipse.emf.edit.ui.provider.AdapterFactoryLabelProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.sirius.business.api.query.DViewQuery;
import org.eclipse.sirius.business.api.session.Session;
import org.eclipse.sirius.business.api.session.SessionManager;
import org.eclipse.sirius.business.api.session.danalysis.DAnalysisSession;
import org.eclipse.sirius.business.api.session.resource.AirdResource;
import org.eclipse.sirius.viewpoint.DAnalysis;
import org.eclipse.sirius.viewpoint.DRepresentation;
import org.eclipse.sirius.viewpoint.DRepresentationDescriptor;
import org.eclipse.sirius.viewpoint.DView;
import org.eclipse.sirius.viewpoint.description.Viewpoint;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Display;
import org.polarsys.kitalpha.richtext.widget.tools.dialogs.FilteredElementTreeSelectionDialog;
import org.polarsys.kitalpha.richtext.widget.tools.ext.types.ModelElementLinkHandler;
import org.polarsys.kitalpha.richtext.widget.tools.intf.LinkHandler;
import org.polarsys.kitalpha.richtext.widget.tools.messages.Messages;
import org.polarsys.kitalpha.richtext.widget.tools.utils.MDERichTextToolsHelper;
import org.polarsys.kitalpha.richtext.widget.tools.utils.Tuple;

public class DiagramElementLinkHandler
extends ModelElementLinkHandler
implements LinkHandler {
    @Override
    public Tuple<String, String> getLink(String linkType, String basePath, Object object) {
        EObject eObject;
        AdapterFactoryEditingDomain editingDomain;
        Tuple<String, String> path = null;
        if (object instanceof EObject && (editingDomain = MDERichTextToolsHelper.getAdapterFactory((EObject)(eObject = (EObject)object))) != null) {
            Iterator analysisResources;
            Session session;
            AdapterFactoryLabelProvider labelProvider = new AdapterFactoryLabelProvider(editingDomain.getAdapterFactory()){

                public Image getImage(Object object) {
                    Viewpoint vp;
                    if (object instanceof DView && (vp = ((DView)object).getViewpoint()) != null) {
                        return super.getImage((Object)vp);
                    }
                    return super.getImage(object);
                }

                public String getText(Object object) {
                    Viewpoint vp;
                    if (object instanceof DView && (vp = ((DView)object).getViewpoint()) != null) {
                        return super.getText((Object)vp);
                    }
                    return super.getText(object);
                }
            };
            AdapterFactoryContentProvider contentProvider = MDERichTextToolsHelper.getContentProvider((EObject)eObject);
            FilteredElementTreeSelectionDialog dialog = new FilteredElementTreeSelectionDialog(Display.getCurrent().getActiveShell(), (ILabelProvider)labelProvider, (ITreeContentProvider)contentProvider);
            dialog.setTitle(Messages.RichTextWidget_Dialog_Title_Diagram_Element_Selection);
            dialog.setMessage(Messages.RichTextWidget_Dialog_Title_Selection_Diagram_Element);
            dialog.addFilter(new ViewerFilter(){

                public boolean select(Viewer viewer, Object parentElement, Object element) {
                    return element instanceof Resource && this.containsDRepresentation((Resource)element) || this.select(element);
                }

                private boolean select(Object element) {
                    return element instanceof DAnalysis || element instanceof DView && !new DViewQuery((DView)element).getLoadedRepresentations().isEmpty() || element instanceof DRepresentationDescriptor;
                }

                private boolean containsDRepresentation(Resource resource) {
                    TreeIterator it = resource.getAllContents();
                    while (it.hasNext()) {
                        EObject obj = (EObject)it.next();
                        if (!this.select(obj)) continue;
                        return true;
                    }
                    return false;
                }
            });
            Resource diagramResource = null;
            Resource res = eObject.eResource();
            if (res instanceof AirdResource) {
                diagramResource = res;
            } else if (res != null && (session = SessionManager.INSTANCE.getSession(res)) != null && (analysisResources = ((DAnalysisSession)session).getAllSessionResources().iterator()).hasNext()) {
                diagramResource = (Resource)analysisResources.next();
            }
            if (diagramResource != null) {
                Object result;
                dialog.setInput((Object)diagramResource.getResourceSet());
                if (dialog.open() == 0 && (result = dialog.getFirstResult()) instanceof DRepresentationDescriptor) {
                    DRepresentation representation = ((DRepresentationDescriptor)result).getRepresentation();
                    URI uri = EcoreUtil.getURI((EObject)representation);
                    path = this.getTuple(uri.toString(), representation);
                }
            }
        }
        return path;
    }
}

