/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.kitalpha.transposer.transformation.emf.activities;

import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.ecore.ENamedElement;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.polarsys.kitalpha.cadence.core.api.IActivity;
import org.polarsys.kitalpha.cadence.core.api.parameter.ActivityParameters;
import org.polarsys.kitalpha.cadence.core.api.parameter.DeclaredParameter;
import org.polarsys.kitalpha.cadence.core.api.parameter.ParameterError;
import org.polarsys.kitalpha.transposer.TransposerCorePlugin;
import org.polarsys.kitalpha.transposer.api.ITransposerWorkflow;
import org.polarsys.kitalpha.transposer.rules.handler.rules.api.IContext;
import org.polarsys.kitalpha.transposer.transformation.context.GenericTransformationContext;
import org.polarsys.kitalpha.transposer.transformation.emf.util.EcoreIdentifierUtil;
import org.polarsys.kitalpha.transposer.transformation.trace.Trace;
import org.polarsys.kitalpha.transposer.transformation.trace.TraceHelper;

public class SoftTraceCleaner
implements IActivity,
ITransposerWorkflow {
    public static final String ID = "org.polarsys.kitalpha.transposer.transformation.emf.trace.clean.soft";
    private TraceHelper _traceHelper = null;
    private Set<?> _transformableElements = null;
    private Collection<EObject> _cleanedElements = new HashSet<EObject>();

    public Collection<DeclaredParameter> getParameters() {
        return null;
    }

    public IStatus run(ActivityParameters activityParams_p) {
        Object set;
        IContext context = (IContext)activityParams_p.getParameter("TransposerContext").getValue();
        this._transformableElements = (Set)activityParams_p.getParameter("TransposerTransposableObjects").getValue();
        if (context == null) {
            return new Status(4, "org.polarsys.kitalpha.transposer.transformation.emf", "Context in not initialized in the Transposer Workflow");
        }
        if (context instanceof GenericTransformationContext) {
            this._traceHelper = ((GenericTransformationContext)context).getTraceHelper();
        }
        ResourceSet rs = null;
        if (context.get((Object)"TransposerResourceSet") != null && (set = context.get((Object)"TransposerResourceSet")) instanceof ResourceSet) {
            rs = (ResourceSet)set;
        }
        if (this._traceHelper != null && this._transformableElements != null) {
            for (Trace trace : this._traceHelper.getTraces()) {
                if (!(trace.getTarget() instanceof EObject) || this._cleanedElements.contains(trace.getTarget()) || trace.getSource() != null && this._transformableElements.contains(trace.getSource())) continue;
                EObject toRemove = (EObject)trace.getTarget();
                this.removeCompletely(toRemove);
                this._cleanedElements.add(toRemove);
            }
        }
        if (this._cleanedElements.size() != 0) {
            this.logInfoCleanMessage();
        }
        return Status.OK_STATUS;
    }

    private void logInfoCleanMessage() {
        StringBuilder message = new StringBuilder();
        message.append(" WARNING \n");
        message.append("--- TraceCleaner cleaned elements ---\n");
        for (EObject obj : this._cleanedElements) {
            message.append(" . " + EcoreIdentifierUtil.getIdentifier((ENamedElement)obj.eClass()) + " : " + obj + "\n");
        }
        TransposerCorePlugin.getDefault().logInfo("org.polarsys.kitalpha.transposer.transformation.emf", message.toString(), null);
    }

    public Map<String, ParameterError<?>> validateParameters(ActivityParameters valuedParameters_p) {
        return null;
    }

    protected void removeCompletely(EObject eObject_p) {
        EcoreUtil.delete((EObject)eObject_p);
    }
}

