/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.core.transfo.operationalcapability;

import java.util.Iterator;
import org.eclipse.emf.ecore.EObject;
import org.polarsys.capella.core.data.capellacommon.AbstractCapabilityPkg;
import org.polarsys.capella.core.data.capellacommon.CapellacommonPackage;
import org.polarsys.capella.core.data.capellacore.CapellaElement;
import org.polarsys.capella.core.data.cs.BlockArchitecture;
import org.polarsys.capella.core.data.ctx.SystemAnalysis;
import org.polarsys.capella.core.data.interaction.AbstractCapability;
import org.polarsys.capella.core.data.la.LogicalArchitecture;
import org.polarsys.capella.core.data.oa.OperationalAnalysis;
import org.polarsys.capella.core.model.helpers.BlockArchitectureExt;
import org.polarsys.capella.core.model.utils.CapellaLayerCheckingExt;
import org.polarsys.capella.core.projection.common.AbstractTransform;
import org.polarsys.capella.core.projection.common.LayersCreation;
import org.polarsys.capella.core.tiger.ITransfo;
import org.polarsys.capella.core.tiger.ITransfoRuleBase;
import org.polarsys.capella.core.tiger.impl.Transfo;
import org.polarsys.capella.core.tiger.impl.TransfoRule;

public abstract class TransformOperationalCapability
extends AbstractTransform {
    public void setContext(EObject context_p) {
        if (context_p instanceof AbstractCapabilityPkg || context_p instanceof AbstractCapability) {
            this._context.add(context_p);
        } else if (context_p instanceof BlockArchitecture) {
            this._context.add(((BlockArchitecture)context_p).getOwnedAbstractCapabilityPkg());
        }
    }

    protected ITransfo createTransfo(ITransfoRuleBase ruleBase_p, String context_p) {
        Iterator iterator = ruleBase_p.iterator();
        Transfo transfo = new Transfo(CapellacommonPackage.Literals.TRANSFO_LINK, context_p);
        while (iterator.hasNext()) {
            transfo.addRule((TransfoRule)iterator.next());
        }
        transfo.put((Object)"transfoSource", (Object)this._context);
        return transfo;
    }

    protected boolean retainContextElement(EObject contextElement_p, ITransfo transfo_p) {
        if (contextElement_p instanceof CapellaElement) {
            LogicalArchitecture la;
            CapellaElement contextElement = (CapellaElement)contextElement_p;
            if (CapellaLayerCheckingExt.isAOrInOperationalAnalysisLayer((CapellaElement)contextElement)) {
                OperationalAnalysis ctx = (OperationalAnalysis)BlockArchitectureExt.getRootBlockArchitecture((EObject)contextElement);
                if (ctx != null) {
                    for (BlockArchitecture logicalArchitecture : LayersCreation.getOrCreateSaLayers((OperationalAnalysis)ctx)) {
                        transfo_p.put((Object)"transfoSource", (Object)contextElement_p);
                        transfo_p.put((Object)"transfoTargetContainer", (Object)logicalArchitecture);
                    }
                    return true;
                }
            } else if (CapellaLayerCheckingExt.isAOrInContextLayer((CapellaElement)contextElement)) {
                SystemAnalysis ctx = (SystemAnalysis)BlockArchitectureExt.getRootBlockArchitecture((EObject)contextElement);
                if (ctx != null) {
                    for (BlockArchitecture logicalArchitecture : LayersCreation.getOrCreateLaLayers((SystemAnalysis)ctx)) {
                        transfo_p.put((Object)"transfoSource", (Object)contextElement_p);
                        transfo_p.put((Object)"transfoTargetContainer", (Object)logicalArchitecture);
                    }
                    return true;
                }
            } else if (CapellaLayerCheckingExt.isAOrInLogicalLayer((CapellaElement)contextElement) && (la = (LogicalArchitecture)BlockArchitectureExt.getRootBlockArchitecture((EObject)contextElement)) != null) {
                for (BlockArchitecture physicalArchitecture : LayersCreation.getOrCreatePaLayers((LogicalArchitecture)la)) {
                    transfo_p.put((Object)"transfoSource", (Object)contextElement_p);
                    transfo_p.put((Object)"transfoTargetContainer", (Object)physicalArchitecture);
                }
                return true;
            }
        }
        return false;
    }
}

