/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.kitalpha.ad.viewpoint.dsl.generation.helper.pde;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.pde.core.IBaseModel;
import org.eclipse.pde.core.build.IBuild;
import org.eclipse.pde.core.build.IBuildEntry;
import org.eclipse.pde.core.build.IBuildModel;
import org.eclipse.pde.internal.core.ibundle.IBundle;
import org.eclipse.pde.internal.core.ibundle.IBundlePluginModelBase;
import org.eclipse.pde.internal.core.text.build.BuildModelFactory;
import org.eclipse.pde.internal.ui.util.ModelModification;
import org.eclipse.pde.internal.ui.util.PDEModelUtility;
import org.eclipse.ui.actions.WorkspaceModifyOperation;
import org.polarsys.kitalpha.ad.viewpoint.dsl.generation.helper.pde.RequiredExecutionEnvironment;

public class PDEUtility {
    private static final Object bundleLock = new Object();
    private static final NullProgressMonitor Null_Progress_Monitor = new NullProgressMonitor();

    public static void updatePluginXml(final IProject project, final String content) throws InvocationTargetException, InterruptedException {
        WorkspaceModifyOperation operation = new WorkspaceModifyOperation(){

            protected void execute(IProgressMonitor monitor) throws CoreException, InvocationTargetException, InterruptedException {
                ByteArrayInputStream outputContent = new ByteArrayInputStream(content.getBytes());
                try {
                    IFile file = project.getFile("plugin.xml");
                    if (file.exists()) {
                        file.setContents((InputStream)outputContent, true, false, null);
                    } else {
                        file.create((InputStream)outputContent, true, null);
                    }
                }
                catch (CoreException e) {
                    e.printStackTrace();
                }
            }
        };
        operation.run((IProgressMonitor)Null_Progress_Monitor);
        try {
            project.refreshLocal(2, (IProgressMonitor)Null_Progress_Monitor);
        }
        catch (CoreException e) {
            e.printStackTrace();
        }
    }

    public static void updateBuild_BinInclude(IProject project, String entry, boolean isFolder, IProgressMonitor monitor) {
        ArrayList<String> entries = new ArrayList<String>();
        entries.add(entry);
        if (isFolder) {
            PDEUtility.updateBuild_BinInclude(project, entries, null, monitor);
        } else {
            PDEUtility.updateBuild_BinInclude(project, null, entries, monitor);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void updateBuild_BinInclude(IProject project, final List<String> folders, final List<String> files, IProgressMonitor monitor) {
        if (project == null) {
            return;
        }
        Object object = bundleLock;
        synchronized (object) {
            IFile build = project.getFile("build.properties");
            if (!build.exists()) {
                try {
                    build.create((InputStream)new ByteArrayInputStream("".getBytes()), true, monitor);
                }
                catch (CoreException e) {
                    e.printStackTrace();
                }
            }
            PDEModelUtility.modifyModel((ModelModification)new ModelModification(build){

                protected void modifyModel(IBaseModel model, IProgressMonitor innerMonitor) throws CoreException {
                    if (!(model instanceof IBuildModel)) {
                        return;
                    }
                    IBuildModel buildModel = (IBuildModel)model;
                    IBuild build = buildModel.getBuild();
                    IBuildEntry binInclude = build.getEntry("bin.includes");
                    if (binInclude == null) {
                        binInclude = new BuildModelFactory(buildModel).createEntry("bin.includes");
                        build.add(binInclude);
                    }
                    if (folders != null) {
                        for (String folder : folders) {
                            if (binInclude.contains(folder = String.valueOf(folder) + "/")) continue;
                            binInclude.addToken(folder);
                        }
                    }
                    if (files != null) {
                        for (String file : files) {
                            if (binInclude.contains(file)) continue;
                            binInclude.addToken(file);
                        }
                    }
                }
            }, (IProgressMonitor)monitor);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void setActivator(IProject project, final String activatorClassFQN, IProgressMonitor monitor) {
        if (project == null) {
            return;
        }
        Object object = bundleLock;
        synchronized (object) {
            IFile manifest = project.getFile("META-INF/MANIFEST.MF");
            PDEModelUtility.modifyModel((ModelModification)new ModelModification(manifest){

                protected void modifyModel(IBaseModel model, IProgressMonitor innerMonitor) throws CoreException {
                    if (!(model instanceof IBundlePluginModelBase)) {
                        return;
                    }
                    IBundlePluginModelBase bundleModel = (IBundlePluginModelBase)model;
                    IBundle bundle = bundleModel.getBundleModel().getBundle();
                    if (activatorClassFQN == null || activatorClassFQN.trim().length() <= 0) {
                        throw new RuntimeException("Activator Java Class can't be null or empty");
                    }
                    bundle.setHeader("Bundle-Activator", activatorClassFQN);
                }
            }, (IProgressMonitor)monitor);
        }
    }

    public static void updateRequiredBundles(IProject project, List<String> requiredBundlesToAdd, IProgressMonitor monitor) {
        PDEUtility.updateManifestModel(project, requiredBundlesToAdd, null, false, monitor);
    }

    public static void updateRequiredBundles(IProject project, String requiredBundleToAdd, IProgressMonitor monitor) {
        ArrayList<String> requiredBundlesToAdd = new ArrayList<String>();
        requiredBundlesToAdd.add(requiredBundleToAdd);
        PDEUtility.updateManifestModel(project, requiredBundlesToAdd, null, false, monitor);
    }

    public static void removeRequiredBundles(IProject project, List<String> requiredBundlesToRemove, IProgressMonitor monitor) {
        PDEUtility.updateManifestModel2(project, requiredBundlesToRemove, false, monitor);
    }

    public static void removeRequiredBundles(IProject project, String requiredBundleToRemove, IProgressMonitor monitor) {
        ArrayList<String> requiredBundlesToRemove = new ArrayList<String>();
        requiredBundlesToRemove.add(requiredBundleToRemove);
        PDEUtility.updateManifestModel2(project, requiredBundlesToRemove, false, monitor);
    }

    public static void updateRequiredExecutionEnv(IProject project, RequiredExecutionEnvironment executionEnv, IProgressMonitor monitor) {
        PDEUtility.updateManifestModel(project, null, executionEnv, false, monitor);
    }

    public static void updateExportNoInternalPackage(IProject project, IProgressMonitor monitor) {
        PDEUtility.updateManifestModel(project, null, null, true, monitor);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void updateManifestModel(final IProject project, final List<String> requiredBundlesToAdd, final RequiredExecutionEnvironment requiredExecutionEnvironment, final boolean exportNoInternalPackages, IProgressMonitor monitor) {
        if (project == null) {
            return;
        }
        Object object = bundleLock;
        synchronized (object) {
            IFile manifest = project.getFile("META-INF/MANIFEST.MF");
            PDEModelUtility.modifyModel((ModelModification)new ModelModification(manifest){

                protected void modifyModel(IBaseModel model, IProgressMonitor innerMonitor) throws CoreException {
                    if (!(model instanceof IBundlePluginModelBase)) {
                        return;
                    }
                    IBundlePluginModelBase bundleModel = (IBundlePluginModelBase)model;
                    IBundle bundle = bundleModel.getBundleModel().getBundle();
                    if (requiredBundlesToAdd != null && requiredBundlesToAdd.size() > 0) {
                        String available_requiredBundles = bundle.getHeader("Require-Bundle");
                        String newRequiredBundles = PDEUtility.mergeRequiredBundles(available_requiredBundles, requiredBundlesToAdd);
                        bundle.setHeader("Require-Bundle", newRequiredBundles);
                    }
                    if (requiredExecutionEnvironment != null) {
                        bundle.setHeader("Bundle-RequiredExecutionEnvironment", requiredExecutionEnvironment.toString());
                    }
                    if (exportNoInternalPackages) {
                        List allJavaPackages = PDEUtility.getJavaPackages(project, exportNoInternalPackages);
                        String exportedPackage = bundle.getHeader("Export-Package");
                        String newPackageExportList_s = PDEUtility.mergeExportPackage(exportedPackage, allJavaPackages);
                        bundle.setHeader("Export-Package", newPackageExportList_s);
                        bundle.setHeader("Bundle-ManifestVersion", "2");
                    }
                }
            }, (IProgressMonitor)monitor);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void updateManifestModel2(IProject project, final List<String> requiredBundlesToRemove, final boolean exportedPackagesToRemove, IProgressMonitor monitor) {
        if (project == null) {
            return;
        }
        Object object = bundleLock;
        synchronized (object) {
            IFile manifest = project.getFile("META-INF/MANIFEST.MF");
            PDEModelUtility.modifyModel((ModelModification)new ModelModification(manifest){

                protected void modifyModel(IBaseModel model, IProgressMonitor innerMonitor) throws CoreException {
                    String available_requiredBundles;
                    String newRequiredBundles;
                    if (!(model instanceof IBundlePluginModelBase)) {
                        return;
                    }
                    IBundlePluginModelBase bundleModel = (IBundlePluginModelBase)model;
                    IBundle bundle = bundleModel.getBundleModel().getBundle();
                    if (requiredBundlesToRemove != null && requiredBundlesToRemove.size() > 0 && (newRequiredBundles = PDEUtility.mergeRequiredBundles2(available_requiredBundles = bundle.getHeader("Require-Bundle"), requiredBundlesToRemove)) != null) {
                        bundle.setHeader("Require-Bundle", newRequiredBundles);
                    }
                }
            }, (IProgressMonitor)monitor);
        }
    }

    private static String mergeRequiredBundles2(String available_requiredBundles, List<String> requiredBundlesToRemove) {
        boolean updateBundles = false;
        ArrayList<Object> available_dependecies = new ArrayList<Object>();
        if (available_requiredBundles != null && available_requiredBundles.trim().length() > 0) {
            if (available_requiredBundles.indexOf(",") != -1) {
                String[] list = available_requiredBundles.split(",");
                String[] stringArray = list;
                int n = list.length;
                int n2 = 0;
                while (n2 < n) {
                    String current = stringArray[n2];
                    available_dependecies.add(current);
                    ++n2;
                }
            } else {
                available_dependecies.add(available_requiredBundles);
            }
            for (String bundleToAdd : requiredBundlesToRemove) {
                boolean removeBundle = false;
                for (String string : available_dependecies) {
                    String plugName = string;
                    if (plugName.indexOf(";") != -1) {
                        plugName = plugName.subSequence(0, string.indexOf(";")).toString();
                    }
                    if (!plugName.equals(bundleToAdd)) continue;
                    removeBundle = true;
                    break;
                }
                if (!removeBundle) continue;
                available_dependecies.remove(bundleToAdd);
                updateBundles = true;
            }
        } else {
            return null;
        }
        if (available_dependecies.size() > 0 && updateBundles) {
            String newRequiredBundles = "";
            if (available_dependecies.size() == 1) {
                newRequiredBundles = (String)available_dependecies.get(0);
            } else {
                newRequiredBundles = String.valueOf((String)available_dependecies.get(0)) + ",";
                int i = 1;
                while (i < available_dependecies.size() - 1) {
                    newRequiredBundles = String.valueOf(newRequiredBundles) + "\n " + (String)available_dependecies.get(i) + ",";
                    ++i;
                }
                newRequiredBundles = String.valueOf(newRequiredBundles) + "\n " + (String)available_dependecies.get(available_dependecies.size() - 1);
            }
            return newRequiredBundles;
        }
        return available_requiredBundles;
    }

    private static String mergeRequiredBundles(String available_requiredBundles, List<String> requiredBundlesToAdd) {
        boolean updateBundles = false;
        ArrayList<Object> available_dependecies = new ArrayList<Object>();
        if (available_requiredBundles != null && available_requiredBundles.trim().length() > 0) {
            if (available_requiredBundles.indexOf(",") != -1) {
                String[] list = available_requiredBundles.split(",");
                String[] stringArray = list;
                int n = list.length;
                int n2 = 0;
                while (n2 < n) {
                    String current = stringArray[n2];
                    available_dependecies.add(current);
                    ++n2;
                }
            } else {
                available_dependecies.add(available_requiredBundles);
            }
            for (String bundleToAdd : requiredBundlesToAdd) {
                boolean addBundle = true;
                for (String string : available_dependecies) {
                    String plugName = string;
                    if (plugName.indexOf(";") != -1) {
                        plugName = plugName.subSequence(0, string.indexOf(";")).toString();
                    }
                    if (!plugName.equals(bundleToAdd)) continue;
                    addBundle = false;
                    break;
                }
                if (!addBundle) continue;
                available_dependecies.add(bundleToAdd);
                updateBundles = true;
            }
        } else {
            available_dependecies.addAll(requiredBundlesToAdd);
            updateBundles = true;
        }
        if (available_dependecies.size() > 0 && updateBundles) {
            String newRequiredBundles = "";
            if (available_dependecies.size() == 1) {
                newRequiredBundles = (String)available_dependecies.get(0);
            } else {
                newRequiredBundles = String.valueOf((String)available_dependecies.get(0)) + ",";
                int i = 1;
                while (i < available_dependecies.size() - 1) {
                    newRequiredBundles = String.valueOf(newRequiredBundles) + "\n " + (String)available_dependecies.get(i) + ",";
                    ++i;
                }
                newRequiredBundles = String.valueOf(newRequiredBundles) + "\n " + (String)available_dependecies.get(available_dependecies.size() - 1);
            }
            return newRequiredBundles;
        }
        return available_requiredBundles;
    }

    private static List<String> getJavaPackages(IProject project, boolean withInternal) throws JavaModelException {
        IJavaProject javaProject = JavaCore.create((IProject)project);
        IPackageFragment[] fragments = javaProject.getPackageFragments();
        ArrayList<String> packageNameToExport = new ArrayList<String>();
        IPackageFragment[] iPackageFragmentArray = fragments;
        int n = fragments.length;
        int n2 = 0;
        while (n2 < n) {
            IPackageFragment iPackageFragment = iPackageFragmentArray[n2];
            ICompilationUnit[] compilationUnits = iPackageFragment.getCompilationUnits();
            if (!iPackageFragment.isDefaultPackage() && compilationUnits.length > 0 && (withInternal || !iPackageFragment.getElementName().endsWith(".internal") && !iPackageFragment.getElementName().contains(".internal."))) {
                packageNameToExport.add(iPackageFragment.getElementName());
            }
            ++n2;
        }
        return packageNameToExport;
    }

    private static String mergeExportPackage(String exportedJavaPackage, List<String> newPackagesToExport) throws JavaModelException {
        if (newPackagesToExport != null && newPackagesToExport.size() > 0) {
            ArrayList<Object> exportPackages_new_l = new ArrayList<Object>();
            if (exportedJavaPackage != null && exportedJavaPackage.trim().length() > 0) {
                String[] exportPackages_existing_t;
                String[] stringArray = exportPackages_existing_t = exportedJavaPackage.split(",");
                int n = exportPackages_existing_t.length;
                int n2 = 0;
                while (n2 < n) {
                    String iExportPackage = stringArray[n2];
                    exportPackages_new_l.add(iExportPackage);
                    ++n2;
                }
            }
            for (String iExportPackage : newPackagesToExport) {
                if (exportPackages_new_l.contains(iExportPackage)) continue;
                exportPackages_new_l.add(iExportPackage);
            }
            if (exportPackages_new_l.size() > 0) {
                String exportPackages_new_s = " " + (String)exportPackages_new_l.get(0);
                if (exportPackages_new_l.size() > 1) {
                    int i = 1;
                    while (i < exportPackages_new_l.size()) {
                        exportPackages_new_s = String.valueOf(exportPackages_new_s) + ", \n";
                        exportPackages_new_s = String.valueOf(exportPackages_new_s) + " " + (String)exportPackages_new_l.get(i);
                        ++i;
                    }
                }
                return exportPackages_new_s;
            }
        }
        return exportedJavaPackage;
    }

    public static void updateClassPath(IProject project) {
        try {
            IJavaProject javaProject = JavaCore.create((IProject)project);
            javaProject.setRawClasspath(javaProject.readRawClasspath(), javaProject.readOutputLocation(), (IProgressMonitor)Null_Progress_Monitor);
            project.refreshLocal(2, (IProgressMonitor)Null_Progress_Monitor);
        }
        catch (CoreException e) {
            e.printStackTrace();
        }
    }
}

