/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.kitalpha.ad.viewpoint.dsl.generation.helper.task;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.egf.core.producer.InvocationException;
import org.eclipse.egf.ftask.producer.context.ITaskProductionContext;
import org.eclipse.pde.core.plugin.IPluginModelBase;
import org.eclipse.pde.core.plugin.PluginRegistry;
import org.eclipse.pde.internal.core.ClasspathComputer;
import org.eclipse.pde.internal.ui.util.ModelModification;
import org.eclipse.pde.internal.ui.util.PDEModelUtility;
import org.polarsys.kitalpha.ad.viewpoint.dsl.generation.helper.pde.operation.BundleModelModification;
import org.polarsys.kitalpha.ad.viewpoint.dsl.generation.helper.task.AbstractProjectUpdateTask;

public class UpdateProjectExecutionEnvironmentTask
extends AbstractProjectUpdateTask {
    private static final Object bundleLock = new Object();
    protected static final String PORJECT_EE_CONTRACT = "project.ee";

    @Override
    public void updateProject(IProject project, ITaskProductionContext productionContext, IProgressMonitor monitor) throws InvocationException {
        String ee = (String)productionContext.getInputValue((Object)PORJECT_EE_CONTRACT, String.class);
        ee = this.preparateEE(ee);
        Assert.isNotNull((Object)ee, (String)"Execution Environment contract should have a value");
        this.updatePluginVersion(project, ee, monitor);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updatePluginVersion(IProject project, String ee, IProgressMonitor monitor) throws InvocationException {
        Object object = bundleLock;
        synchronized (object) {
            IFile manifest = project.getFile("META-INF/MANIFEST.MF");
            if (manifest == null || !manifest.exists()) {
                throw new IllegalArgumentException("The Manifest file doesn't exists");
            }
            BundleModelModification operation = new BundleModelModification(manifest, "Bundle-RequiredExecutionEnvironment", ee);
            PDEModelUtility.modifyModel((ModelModification)operation, (IProgressMonitor)monitor);
            try {
                project.refreshLocal(2, monitor);
                this.updateClasspathSettings(project, monitor);
            }
            catch (CoreException e) {
                throw new InvocationException((Throwable)e);
            }
        }
    }

    private void updateClasspathSettings(IProject project, IProgressMonitor monitor) {
        IPluginModelBase model = PluginRegistry.findModel((IProject)project);
        if (model != null) {
            try {
                ClasspathComputer.setClasspath((IProject)project, (IPluginModelBase)model);
                if (ResourcesPlugin.getWorkspace().isAutoBuilding()) {
                    project.build(6, monitor);
                }
            }
            catch (CoreException coreException) {
                // empty catch block
            }
        }
    }

    private String preparateEE(String ee) {
        StringBuffer buffer = new StringBuffer();
        if (ee.contains(",")) {
            String[] eeTable = ee.split(",");
            int i = 0;
            while (i < eeTable.length) {
                String id = eeTable[i].trim();
                if (buffer.length() > 0) {
                    buffer.append(",");
                    buffer.append(System.getProperty("line.separator"));
                    buffer.append(" ");
                }
                buffer.append(id);
                ++i;
            }
        } else {
            buffer.append(ee);
        }
        return buffer.toString();
    }
}

