/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.core.platform.eclipse.capella.ui.trace.views;

import org.eclipse.emf.ecore.EObject;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.polarsys.capella.common.data.modellingcore.AbstractNamedElement;
import org.polarsys.capella.common.data.modellingcore.ModelElement;
import org.polarsys.capella.common.data.modellingcore.TraceableElement;
import org.polarsys.capella.common.ef.command.AbstractReadWriteCommand;
import org.polarsys.capella.common.ef.command.ICommand;
import org.polarsys.capella.common.helpers.TransactionHelper;
import org.polarsys.capella.common.ui.toolkit.editors.Editor;
import org.polarsys.capella.core.data.capellacommon.GenericTrace;
import org.polarsys.capella.core.data.capellacore.CapellaElement;
import org.polarsys.capella.core.data.capellacore.Trace;
import org.polarsys.capella.core.data.capellamodeller.SystemEngineering;
import org.polarsys.capella.core.data.requirement.RequirementsTrace;
import org.polarsys.capella.core.model.helpers.query.CapellaQueries;
import org.polarsys.capella.core.platform.eclipse.capella.ui.trace.messages.Messages;
import org.polarsys.capella.core.platform.eclipse.capella.ui.trace.messages.TraceUtil;
import org.polarsys.capella.core.platform.eclipse.capella.ui.trace.views.components.TraceTreeViewer;
import org.polarsys.capella.core.platform.eclipse.capella.ui.trace.views.providers.TracePageContentProvider;
import org.polarsys.capella.core.platform.eclipse.capella.ui.trace.views.providers.TraceStore;
import org.polarsys.capella.core.ui.resources.CapellaUIResourcesPlugin;
import org.polarsys.capella.core.ui.toolkit.dialogs.CapellaWizardDialog;

public class ViewEditPage
extends WizardPage {
    private TraceableElement _currentElt;
    private TraceTreeViewer _leftTraceViewer;
    private TraceTreeViewer _rightTraceViewer;
    private Text _statusBarText;
    private Menu _editMenu;
    private SelectionListener _menuListener = new SelectionAdapter(){

        public void widgetSelected(SelectionEvent e_p) {
            MenuItem item = (MenuItem)e_p.widget;
            if (item.getText().equals(Messages.getString("ViewEditPage.edit_menu.text"))) {
                final Trace currentTrace = (Trace)item.getData();
                Editor traceEditor = new Editor(new TracePageContentProvider(), new TraceStore((CapellaElement)currentTrace)){

                    public Image getDefaultPageImage() {
                        Image image = null;
                        if (this.getStore() != null) {
                            ImageDescriptor pngImageDescriptor = CapellaUIResourcesPlugin.getDefault().getPNGImage(currentTrace.eClass());
                            image = pngImageDescriptor != null ? pngImageDescriptor.createImage() : super.getDefaultPageImage();
                        }
                        return image;
                    }

                    public boolean performFinish() {
                        TransactionHelper.getExecutionManager((EObject)currentTrace).execute((ICommand)new AbstractReadWriteCommand(){

                            public void run() {
                                page.store();
                            }
                        });
                        return true;
                    }
                };
                CapellaWizardDialog dlg = new CapellaWizardDialog(ViewEditPage.this.getShell(), (IWizard)traceEditor);
                dlg.open();
            } else if (item.getText().equals(Messages.getString("ViewEditPage.show_in_explorer_menu.text"))) {
                CapellaElement currentSelection = (CapellaElement)item.getData();
                if (PlatformUI.isWorkbenchRunning()) {
                    TraceUtil.findAndSelectElement(currentSelection);
                }
            }
        }
    };

    public ViewEditPage(String pageName_p, TraceableElement currentElt_p) {
        super(pageName_p);
        this._currentElt = currentElt_p;
        this.setTitle(Messages.getString("ViewEditPage.title"));
        this.setCapellaImageDescriptor(currentElt_p);
    }

    public void setCapellaImageDescriptor(TraceableElement currentElt_p) {
        ImageDescriptor pngImageDescriptor = CapellaUIResourcesPlugin.getDefault().getPNGImage(currentElt_p.eClass());
        this.setImageDescriptor(pngImageDescriptor);
    }

    protected Composite createInternalComposite(Composite parent_p) {
        Composite composite = new Composite(parent_p, 0);
        composite.setLayout((Layout)new GridLayout(1, true));
        GridData gridData = new GridData(4, 4, true, true);
        composite.setLayoutData((Object)gridData);
        return composite;
    }

    public void createControl(Composite parent_p) {
        Composite composite = this.createInternalComposite(parent_p);
        Label currentNamedEltValueLabel = new Label(composite, 18440);
        if (this._currentElt instanceof AbstractNamedElement) {
            String name = ((AbstractNamedElement)this._currentElt).getName();
            currentNamedEltValueLabel.setText(name == null ? "" : name);
            this.setTitle(String.valueOf(Messages.getString("ViewEditPage.title")) + ((AbstractNamedElement)this._currentElt).getName());
            currentNamedEltValueLabel.setVisible(false);
        }
        Label imageExplanation = new Label(composite, 0x1000000);
        GridData gdData = new GridData();
        gdData.horizontalAlignment = 4;
        gdData.verticalAlignment = 0;
        gdData.grabExcessHorizontalSpace = true;
        gdData.grabExcessVerticalSpace = false;
        gdData.horizontalSpan = 2;
        imageExplanation.setLayoutData((Object)gdData);
        imageExplanation.setImage(AbstractUIPlugin.imageDescriptorFromPlugin((String)"org.polarsys.capella.core.platform.eclipse.ui.trace", (String)"icons/transparent_traceability.png").createImage());
        Composite traceTreeComposite = new Composite(composite, 4);
        traceTreeComposite.setLayout((Layout)new FillLayout());
        GridData data = new GridData(4, 4, true, true);
        traceTreeComposite.setLayoutData((Object)data);
        this._leftTraceViewer = new TraceTreeViewer(this._currentElt, TraceTreeViewer.TraceType.SOURCE_ELEMENT);
        this._leftTraceViewer.getControl(traceTreeComposite);
        this._leftTraceViewer.setWizardPage(this);
        this._rightTraceViewer = new TraceTreeViewer(this._currentElt, TraceTreeViewer.TraceType.TARGET_ELEMENT);
        this._rightTraceViewer.getControl(traceTreeComposite);
        this._rightTraceViewer.setWizardPage(this);
        this._editMenu = new Menu((Control)traceTreeComposite.getShell());
        MenuItem editMenuItem = new MenuItem(this._editMenu, 8);
        editMenuItem.setText(Messages.getString("ViewEditPage.edit_menu.text"));
        editMenuItem.addSelectionListener(this._menuListener);
        MenuItem showInExplorerItem = new MenuItem(this._editMenu, 8);
        showInExplorerItem.setText(Messages.getString("ViewEditPage.show_in_explorer_menu.text"));
        showInExplorerItem.addSelectionListener(this._menuListener);
        showInExplorerItem.setImage(CapellaUIResourcesPlugin.getDefault().getImage("full/obj16/capella_explorer.png"));
        this.createStatusTextField(composite);
        this._leftTraceViewer.addListener(new TraceTreeListener(this._rightTraceViewer));
        this._leftTraceViewer.addListener(new LabelListener(currentNamedEltValueLabel));
        this._rightTraceViewer.addListener(new TraceTreeListener(this._leftTraceViewer));
        this._rightTraceViewer.addListener(new LabelListener(currentNamedEltValueLabel));
        this.setControl((Control)composite);
    }

    private void createStatusTextField(Composite parent_p) {
        this._statusBarText = new Text(parent_p, 2056);
        this._statusBarText.setEditable(false);
        GridData gdData = new GridData();
        gdData.horizontalAlignment = 4;
        gdData.grabExcessHorizontalSpace = true;
        gdData.grabExcessVerticalSpace = false;
        gdData.horizontalSpan = 2;
        this._statusBarText.setLayoutData((Object)gdData);
    }

    public String getElementPath(Object object_p) {
        if (object_p instanceof TraceableElement) {
            TraceableElement element = (TraceableElement)object_p;
            SystemEngineering systemEngineering = CapellaQueries.getInstance().getRootQueries().getSystemEngineering((ModelElement)element);
            return this.getPath(systemEngineering, element);
        }
        return "";
    }

    public String getPath(SystemEngineering sysEng_p, TraceableElement target_p) {
        String name = target_p instanceof AbstractNamedElement ? ((AbstractNamedElement)target_p).getName() : "";
        StringBuffer path = new StringBuffer(name == null ? "" : name);
        EObject container = target_p.eContainer();
        if (container instanceof TraceableElement) {
            TraceableElement parent = (TraceableElement)container;
            if (parent != sysEng_p) {
                path.insert(path.indexOf(path.toString()), String.valueOf(this.getPath(sysEng_p, parent)) + "::");
            } else {
                String parentName = parent instanceof AbstractNamedElement ? ((AbstractNamedElement)parent).getName() : "";
                path.insert(path.indexOf(path.toString()), String.valueOf(parentName) + "::");
            }
        }
        return path.toString();
    }

    private void updateStatusBar(Object element_p) {
        if (element_p == null) {
            this._statusBarText.setText("");
            return;
        }
        this._statusBarText.setText(this.getElementPath(element_p));
    }

    protected class LabelListener
    implements IDoubleClickListener {
        Label _namedEltLabel;

        public LabelListener(Label namedEltLabel_p) {
            this._namedEltLabel = namedEltLabel_p;
        }

        public void doubleClick(DoubleClickEvent event_p) {
            Object elem;
            ISelection selection = event_p.getSelection();
            if (selection instanceof IStructuredSelection && ((IStructuredSelection)selection).size() == 1 && (elem = ((IStructuredSelection)selection).getFirstElement()) instanceof TraceableElement) {
                String name = elem instanceof AbstractNamedElement ? ((AbstractNamedElement)elem).getName() : "";
                this._namedEltLabel.setText(name == null ? "" : name);
                ViewEditPage.this.setTitle(String.valueOf(Messages.getString("ViewEditPage.title")) + (name == null ? "" : name));
                ViewEditPage.this.setCapellaImageDescriptor((TraceableElement)elem);
            }
        }
    }

    protected class TraceTreeListener
    extends MouseAdapter
    implements IDoubleClickListener,
    ISelectionChangedListener {
        TraceTreeViewer _traceTreeViewer;

        public TraceTreeListener(TraceTreeViewer traceTreeViewer_p) {
            this._traceTreeViewer = traceTreeViewer_p;
            this._traceTreeViewer._treeViewer.addSelectionChangedListener((ISelectionChangedListener)this);
            this._traceTreeViewer._treeViewer.getTree().addMouseListener((MouseListener)this);
        }

        public void doubleClick(DoubleClickEvent event_p) {
            Object elem;
            ISelection selection = event_p.getSelection();
            if (selection instanceof IStructuredSelection && ((IStructuredSelection)selection).size() == 1 && (elem = ((IStructuredSelection)selection).getFirstElement()) instanceof TraceableElement) {
                this._traceTreeViewer.updateComponent((TraceableElement)elem);
            }
        }

        public void selectionChanged(SelectionChangedEvent event_p) {
            ISelection selection = event_p.getSelection();
            if (selection instanceof IStructuredSelection && ((IStructuredSelection)selection).size() == 1) {
                Object elem = ((IStructuredSelection)selection).getFirstElement();
                ViewEditPage.this.updateStatusBar(elem);
            }
        }

        public void mouseUp(MouseEvent e_p) {
            ISelection selection;
            if (e_p.button == 3 && (selection = this._traceTreeViewer._treeViewer.getSelection()) instanceof IStructuredSelection && ((IStructuredSelection)selection).size() == 1) {
                Object elem = ((IStructuredSelection)selection).getFirstElement();
                Point point = new Point(e_p.x, e_p.y);
                point = Display.getCurrent().map(this._traceTreeViewer._treeViewer.getControl(), null, point);
                ViewEditPage.this._editMenu.setLocation(point);
                MenuItem editItem = ViewEditPage.this._editMenu.getItem(0);
                editItem.setEnabled(false);
                MenuItem showItem = ViewEditPage.this._editMenu.getItem(1);
                showItem.setEnabled(false);
                if (elem instanceof GenericTrace || elem instanceof RequirementsTrace) {
                    editItem.setData(elem);
                    editItem.setEnabled(true);
                }
                if (elem instanceof TraceableElement) {
                    showItem.setData(elem);
                    showItem.setEnabled(true);
                }
                ViewEditPage.this._editMenu.setVisible(true);
            }
        }
    }
}

