/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.core.model.helpers;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.polarsys.capella.common.data.modellingcore.AbstractType;
import org.polarsys.capella.common.data.modellingcore.ModelElement;
import org.polarsys.capella.common.helpers.EcoreUtil2;
import org.polarsys.capella.core.data.capellacore.CapellaElement;
import org.polarsys.capella.core.data.capellacore.Classifier;
import org.polarsys.capella.core.data.capellamodeller.SystemEngineering;
import org.polarsys.capella.core.data.cs.BlockArchitecture;
import org.polarsys.capella.core.data.cs.Component;
import org.polarsys.capella.core.data.cs.Interface;
import org.polarsys.capella.core.data.ctx.System;
import org.polarsys.capella.core.data.ctx.SystemAnalysis;
import org.polarsys.capella.core.data.information.Partition;
import org.polarsys.capella.core.data.interaction.Scenario;
import org.polarsys.capella.core.data.la.CapabilityRealization;
import org.polarsys.capella.core.data.la.LaPackage;
import org.polarsys.capella.core.data.la.LogicalArchitecture;
import org.polarsys.capella.core.data.la.LogicalArchitecturePkg;
import org.polarsys.capella.core.data.la.LogicalComponent;
import org.polarsys.capella.core.data.la.LogicalComponentPkg;
import org.polarsys.capella.core.data.pa.PhysicalArchitecture;
import org.polarsys.capella.core.data.pa.PhysicalComponent;
import org.polarsys.capella.core.model.helpers.CapellaElementExt;
import org.polarsys.capella.core.model.helpers.ComponentExt;
import org.polarsys.capella.core.model.helpers.InterfacePkgExt;
import org.polarsys.capella.core.model.helpers.LogicalArchitectureExt;
import org.polarsys.capella.core.model.helpers.LogicalComponentPkgExt;
import org.polarsys.capella.core.model.helpers.SystemEngineeringExt;

public class LogicalComponentExt {
    public static List<CapellaElement> getAllInterfacesInLogicalComponent(LogicalComponent logicalComponent1) {
        ArrayList<CapellaElement> list = new ArrayList<CapellaElement>();
        if (logicalComponent1 != null) {
            list.addAll(InterfacePkgExt.getAllInterfacesFiltered(logicalComponent1.getOwnedInterfacePkg(), null, false));
            for (LogicalComponent lc : logicalComponent1.getSubLogicalComponents()) {
                list.addAll(LogicalComponentExt.getAllInterfacesInLogicalComponent(lc));
            }
            for (LogicalComponentPkg lcPkg : logicalComponent1.getOwnedLogicalComponentPkgs()) {
                list.addAll(LogicalComponentPkgExt.getAllInterfacesInLogicalComponentPkg(lcPkg));
            }
            for (LogicalArchitecture logArch : logicalComponent1.getOwnedLogicalArchitectures()) {
                list.addAll(LogicalArchitectureExt.getAllInterfacesInLogicalArchitecture(logArch));
            }
        }
        return list;
    }

    public static List<LogicalArchitecture> getAllLogicalArchitectures(LogicalComponent logicalComponent1) {
        ArrayList<LogicalArchitecture> list = new ArrayList<LogicalArchitecture>();
        if (logicalComponent1 != null) {
            list.addAll((Collection<LogicalArchitecture>)logicalComponent1.getOwnedLogicalArchitectures());
            for (LogicalComponentPkg lcPkg : logicalComponent1.getOwnedLogicalComponentPkgs()) {
                list.addAll(LogicalComponentPkgExt.getAllLogicalArchitectures(lcPkg));
            }
            for (LogicalComponent lc : logicalComponent1.getSubLogicalComponents()) {
                list.addAll(LogicalComponentExt.getAllLogicalArchitectures(lc));
            }
        }
        return list;
    }

    public static List<CapabilityRealization> getCapabilityRealizationUseCaseFromLCParentHierarchy(LogicalComponent component) {
        SystemAnalysis ca;
        ArrayList<CapabilityRealization> list = new ArrayList<CapabilityRealization>();
        Component parentComponent = LogicalComponentExt.getParentContainer(component);
        BlockArchitecture arch = ComponentExt.getRootBlockArchitecture((ModelElement)component);
        if (arch != null) {
            list.addAll(CapellaElementExt.getAllCapabilityRealizationInvolvedWith((CapellaElement)arch));
        }
        if (parentComponent instanceof LogicalComponent) {
            LogicalComponent parentLC = (LogicalComponent)parentComponent;
            list.addAll(CapellaElementExt.getAllCapabilityRealizationsFromAbstractCapabilityPkg(parentLC.getOwnedAbstractCapabilityPkg()));
            list.addAll(LogicalComponentExt.getCapabilityRealizationUseCaseFromLCParentHierarchy(parentLC));
        } else if (parentComponent instanceof System && (ca = (SystemAnalysis)((System)parentComponent).eContainer()) != null && !ca.equals(arch)) {
            list.addAll(CapellaElementExt.getAllCapabilityRealizationsFromAbstractCapabilityPkg(ca.getOwnedAbstractCapabilityPkg()));
        }
        return list;
    }

    public static List<LogicalComponent> getDecompositionLogicalComponentInvolved(LogicalComponent lc) {
        ArrayList<LogicalComponent> decompLcInvolved = new ArrayList<LogicalComponent>();
        for (Partition partition : lc.getOwnedPartitions()) {
            AbstractType currentLc = partition.getAbstractType();
            if (!(currentLc instanceof LogicalComponent) || decompLcInvolved.contains(currentLc)) continue;
            decompLcInvolved.add((LogicalComponent)currentLc);
        }
        return decompLcInvolved;
    }

    public static PhysicalComponent getImplementor(LogicalComponent component, PhysicalArchitecture physicalArchitecture) {
        PhysicalComponent implementorPC = null;
        for (PhysicalComponent pc : LogicalComponentExt.getImplementors(component)) {
            if (!EcoreUtil2.isContainedBy((EObject)pc, (EObject)physicalArchitecture)) continue;
            implementorPC = pc;
        }
        return implementorPC;
    }

    public static List<PhysicalComponent> getImplementors(LogicalComponent component) {
        ArrayList<PhysicalComponent> implementorsList = new ArrayList<PhysicalComponent>();
        EList eImplementors = component.getAllocatingComponents();
        for (Object object : eImplementors) {
            PhysicalComponent implementorPC = (PhysicalComponent)object;
            if (implementorPC == null) continue;
            implementorsList.add(implementorPC);
        }
        return implementorsList;
    }

    public static List<Interface> getInterfacesFromLCParentHierarchy(LogicalComponent component) {
        SystemAnalysis ca;
        Component parentComponent;
        ArrayList<Interface> list = new ArrayList<Interface>();
        BlockArchitecture arch = ComponentExt.getRootBlockArchitecture((ModelElement)component);
        if (arch != null) {
            list.addAll(InterfacePkgExt.getAllInterfaces(arch.getOwnedInterfacePkg()));
            list.addAll(InterfacePkgExt.getOwnedInterfacesFromBlockArchitectureParent(arch));
        }
        if ((parentComponent = LogicalComponentExt.getParentContainer(component)) != null && parentComponent instanceof LogicalComponent) {
            LogicalComponent parentLC = (LogicalComponent)parentComponent;
            list.addAll(InterfacePkgExt.getAllInterfaces(parentLC.getOwnedInterfacePkg()));
            list.addAll(LogicalComponentExt.getInterfacesFromLCParentHierarchy(parentLC));
        } else if (parentComponent instanceof System && (ca = (SystemAnalysis)((System)parentComponent).eContainer()) != null && !ca.equals(arch)) {
            list.addAll(InterfacePkgExt.getAllInterfaces(ca.getOwnedInterfacePkg()));
        }
        return list;
    }

    public static List<CapellaElement> getInterfacesFromLogicalComponent(LogicalComponent logicalComponent, LogicalComponent currentLC, boolean usedFlag) {
        ArrayList<CapellaElement> list = new ArrayList<CapellaElement>();
        if (logicalComponent != null) {
            int currentLCLevel;
            int lcLevel = LogicalComponentExt.getRecursiveLogicalComponentLevel(logicalComponent);
            if (lcLevel == (currentLCLevel = LogicalComponentExt.getRecursiveLogicalComponentLevel(currentLC))) {
                if (!logicalComponent.equals(currentLC)) {
                    if (usedFlag) {
                        list.addAll(ComponentExt.getUsedInterfacesFiltered((Component)logicalComponent, (Component)(currentLC != null ? currentLC : logicalComponent)));
                    } else {
                        list.addAll(ComponentExt.getImplementedInterfacesFiltered((Component)logicalComponent, (Component)(currentLC != null ? currentLC : logicalComponent)));
                    }
                }
                list.addAll(InterfacePkgExt.getAllInterfacesFiltered(logicalComponent.getOwnedInterfacePkg(), (Component)currentLC, usedFlag));
            }
            for (LogicalComponentPkg logicalComponentPkg : logicalComponent.getOwnedLogicalComponentPkgs()) {
                list.addAll(LogicalComponentPkgExt.getAllInterfacesInLogicalComponentPkg(logicalComponentPkg, currentLC, usedFlag));
            }
            for (LogicalComponent lc : logicalComponent.getSubLogicalComponents()) {
                list.addAll(LogicalComponentExt.getInterfacesFromLogicalComponent(lc, currentLC, usedFlag));
            }
            for (LogicalArchitecture logArch : logicalComponent.getOwnedLogicalArchitectures()) {
                list.addAll(LogicalArchitectureExt.getAllInterfacesInLogicalArchitecture(logArch, currentLC, usedFlag));
            }
        }
        return list;
    }

    public static List<CapellaElement> getInterfacesFromSameLevelLogicalComponent(LogicalComponent logicalComponent, LogicalComponent currentLC) {
        int currentLCLevel;
        int lcLevel;
        ArrayList<CapellaElement> list = new ArrayList<CapellaElement>();
        if (logicalComponent != null && (lcLevel = LogicalComponentExt.getRecursiveLogicalComponentLevel(logicalComponent)) == (currentLCLevel = LogicalComponentExt.getRecursiveLogicalComponentLevel(currentLC)) && !logicalComponent.equals(currentLC)) {
            list.addAll((Collection<CapellaElement>)logicalComponent.getUsedInterfaces());
            list.addAll((Collection<CapellaElement>)logicalComponent.getImplementedInterfaces());
            List<Interface> innerInterfaces = InterfacePkgExt.getAllInterfacesFiltered(logicalComponent.getOwnedInterfacePkg(), null, true);
            list.removeAll(innerInterfaces);
        }
        return list;
    }

    public static List<CapellaElement> getInterfacesFromSameLevelLogicalComponent(LogicalComponent logicalComponent, LogicalComponent currentLC, boolean usedFlag) {
        int currentLCLevel;
        int lcLevel;
        ArrayList<CapellaElement> list = new ArrayList<CapellaElement>();
        if (logicalComponent != null && (lcLevel = LogicalComponentExt.getRecursiveLogicalComponentLevel(logicalComponent)) == (currentLCLevel = LogicalComponentExt.getRecursiveLogicalComponentLevel(currentLC))) {
            if (!logicalComponent.equals(currentLC)) {
                if (usedFlag) {
                    list.addAll(ComponentExt.getUsedInterfacesFiltered((Component)logicalComponent, (Component)(currentLC != null ? currentLC : logicalComponent)));
                } else {
                    list.addAll(ComponentExt.getImplementedInterfacesFiltered((Component)logicalComponent, (Component)(currentLC != null ? currentLC : logicalComponent)));
                }
            }
            list.addAll(InterfacePkgExt.getAllInterfacesFiltered(logicalComponent.getOwnedInterfacePkg(), (Component)currentLC, usedFlag));
        }
        return list;
    }

    public static LogicalComponent getLogicalComponentContainerFromScenario(Scenario scenario) {
        LogicalComponent containerLc = null;
        containerLc = (LogicalComponent)EcoreUtil2.getFirstContainer((EObject)scenario, (EClass)LaPackage.Literals.LOGICAL_COMPONENT);
        if (containerLc == null) {
            LogicalArchitecture la = (LogicalArchitecture)EcoreUtil2.getFirstContainer((EObject)scenario, (EClass)LaPackage.Literals.LOGICAL_ARCHITECTURE);
            containerLc = SystemEngineeringExt.getRootLogicalComponent(la);
        }
        return containerLc;
    }

    private static LogicalComponent getParentComponent(LogicalComponent component) {
        LogicalComponent parentComponent = null;
        for (Partition partition : component.getRepresentingPartitions()) {
            Classifier ownerClassifier = (Classifier)partition.eContainer();
            if (!(ownerClassifier instanceof LogicalComponent)) continue;
            parentComponent = (LogicalComponent)ownerClassifier;
        }
        return parentComponent;
    }

    public static Component getParentContainer(LogicalComponent component) {
        return LogicalComponentExt.getRecursiveParentContainer(component);
    }

    private static int getRecursiveLogicalComponentLevel(LogicalComponent component) {
        int level = 0;
        LogicalComponent parentComponent = null;
        LogicalComponent currentComponent = component;
        while (LogicalComponentExt.getParentComponent(currentComponent) != null) {
            currentComponent = parentComponent = LogicalComponentExt.getParentComponent(currentComponent);
            ++level;
        }
        return level;
    }

    private static Component getRecursiveParentContainer(LogicalArchitecture component) {
        System cpnt = null;
        EObject container = component.eContainer();
        if (container instanceof SystemEngineering) {
            cpnt = SystemEngineeringExt.getSystem((SystemEngineering)container);
        } else if (container instanceof LogicalComponent) {
            cpnt = (LogicalComponent)container;
        } else if (container instanceof LogicalArchitecturePkg) {
            cpnt = LogicalComponentExt.getRecursiveParentContainer((LogicalArchitecturePkg)container);
        }
        return cpnt;
    }

    private static Component getRecursiveParentContainer(LogicalArchitecturePkg component) {
        System cpnt = null;
        EObject container = component.eContainer();
        if (container instanceof SystemEngineering) {
            cpnt = SystemEngineeringExt.getSystem((SystemEngineering)container);
        }
        return cpnt;
    }

    private static Component getRecursiveParentContainer(LogicalComponent component) {
        Component cpnt = null;
        EObject container = component.eContainer();
        if (container instanceof LogicalArchitecture) {
            cpnt = LogicalComponentExt.getRecursiveParentContainer((LogicalArchitecture)container);
        } else if (container instanceof LogicalComponentPkg) {
            cpnt = LogicalComponentExt.getRecursiveParentContainer((LogicalComponentPkg)container);
        } else if (container instanceof LogicalComponent) {
            cpnt = (LogicalComponent)container;
        }
        return cpnt;
    }

    private static Component getRecursiveParentContainer(LogicalComponentPkg componentPkg) {
        Component cpnt = null;
        EObject container = componentPkg.eContainer();
        if (container instanceof LogicalArchitecture) {
            cpnt = LogicalComponentExt.getRecursiveParentContainer((LogicalArchitecture)container);
        } else if (container instanceof LogicalComponentPkg) {
            cpnt = LogicalComponentExt.getRecursiveParentContainer((LogicalComponentPkg)container);
        } else if (container instanceof LogicalComponent) {
            cpnt = (LogicalComponent)container;
        }
        return cpnt;
    }

    public static LogicalComponent getRootLogicalComponentFromCurrentLC(EObject elt) {
        if (elt == null || ComponentExt.isComponentRoot(elt)) {
            return (LogicalComponent)elt;
        }
        return LogicalComponentExt.getRootLogicalComponentFromCurrentLC(elt.eContainer());
    }

    public static List<LogicalComponent> getSameLevelComponents(LogicalComponent currentElement) {
        ArrayList<LogicalComponent> list = new ArrayList<LogicalComponent>(1);
        if (currentElement != null) {
            for (LogicalComponent alc : currentElement.getSubLogicalComponents()) {
                list.add(alc);
            }
            for (LogicalComponentPkg lcPkg : currentElement.getOwnedLogicalComponentPkgs()) {
                for (LogicalComponent alc : LogicalComponentPkgExt.getAllLCsFromLCPkg(lcPkg)) {
                    list.add(alc);
                }
            }
        }
        return list;
    }

    public static List<LogicalComponent> getAllSubComponents(LogicalComponent component) {
        ArrayList<LogicalComponent> result = new ArrayList<LogicalComponent>();
        for (LogicalComponent lc : component.getSubLogicalComponents()) {
            result.addAll(LogicalComponentExt.getAllSubComponents(lc));
        }
        result.add(component);
        return result;
    }
}

