/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.core.model.helpers;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.polarsys.capella.common.helpers.EObjectExt;
import org.polarsys.capella.common.helpers.query.MDEQueries;
import org.polarsys.capella.core.data.capellacore.CapellaElement;
import org.polarsys.capella.core.data.capellamodeller.SystemEngineering;
import org.polarsys.capella.core.data.cs.BlockArchitecture;
import org.polarsys.capella.core.data.cs.Component;
import org.polarsys.capella.core.data.cs.CsPackage;
import org.polarsys.capella.core.data.cs.PhysicalLink;
import org.polarsys.capella.core.data.cs.SystemComponent;
import org.polarsys.capella.core.data.fa.AbstractFunction;
import org.polarsys.capella.core.data.fa.FunctionPkg;
import org.polarsys.capella.core.data.pa.PhysicalArchitecture;
import org.polarsys.capella.core.data.pa.PhysicalArchitecturePkg;
import org.polarsys.capella.core.data.pa.PhysicalComponent;
import org.polarsys.capella.core.data.pa.PhysicalFunctionPkg;
import org.polarsys.capella.core.model.helpers.CapellaElementExt;
import org.polarsys.capella.core.model.helpers.InterfacePkgExt;
import org.polarsys.capella.core.model.helpers.SystemComponentExt;
import org.polarsys.capella.core.model.helpers.SystemEngineeringExt;

public class PhysicalArchitectureExt {
    public static List<CapellaElement> getAllInterfaces(BlockArchitecture blockArchitecture, PhysicalComponent currentPC, boolean usedFlag) {
        ArrayList<CapellaElement> list = new ArrayList<CapellaElement>();
        if (blockArchitecture != null) {
            list.addAll(InterfacePkgExt.getAllInterfacesFiltered(blockArchitecture.getOwnedInterfacePkg(), (Component)currentPC, usedFlag));
        }
        return list;
    }

    public static List<PhysicalLink> getAllPhysicalLinks(PhysicalArchitecture architecture) {
        ArrayList<PhysicalLink> instList = new ArrayList<PhysicalLink>();
        for (EObject obj : EObjectExt.getAll((EObject)architecture, (EClass)CsPackage.Literals.PHYSICAL_LINK)) {
            instList.add((PhysicalLink)obj);
        }
        return instList;
    }

    public static List<PhysicalComponent> getAllPhysicalComponents(PhysicalArchitecture currentElement) {
        Set pcSet = MDEQueries.getInstance().getAllQueries().getAll((EObject)currentElement, PhysicalComponent.class);
        ArrayList<PhysicalComponent> pcList = new ArrayList<PhysicalComponent>();
        for (EObject obj : pcSet) {
            pcList.add((PhysicalComponent)obj);
        }
        return pcList;
    }

    @Deprecated
    public static List<CapellaElement> getOwnedInterfacesFromPhysicalLayerFiltered(SystemEngineering systemEngineering, PhysicalComponent currentPC, boolean usedFlag) {
        PhysicalArchitecture physicalArchitecture2;
        ArrayList<CapellaElement> list = new ArrayList<CapellaElement>(1);
        PhysicalArchitecturePkg physicalArchitecturePkg = SystemEngineeringExt.getOwnedPhysicalArchitecturePkg(systemEngineering);
        if (physicalArchitecturePkg != null) {
            for (PhysicalArchitecture physicalArchitecture2 : physicalArchitecturePkg.getOwnedPhysicalArchitectures()) {
                if (physicalArchitecture2 == null) continue;
                list.addAll(PhysicalArchitectureExt.getAllInterfaces((BlockArchitecture)physicalArchitecture2, currentPC, usedFlag));
            }
        }
        if ((physicalArchitecture2 = SystemEngineeringExt.getOwnedPhysicalArchitecture(systemEngineering)) != null) {
            list.addAll(PhysicalArchitectureExt.getAllInterfaces((BlockArchitecture)physicalArchitecture2, currentPC, usedFlag));
        }
        return list;
    }

    public static List<CapellaElement> getCapabilityRealizationUseCasesFromPhysicalLayerFiltered(SystemEngineering systemEngineering, PhysicalComponent currentPC, boolean isFilterRequired) {
        PhysicalArchitecture physicalArch2;
        ArrayList<CapellaElement> list = new ArrayList<CapellaElement>(1);
        PhysicalArchitecturePkg physicalArchPkg = SystemEngineeringExt.getOwnedPhysicalArchitecturePkg(systemEngineering);
        if (physicalArchPkg != null) {
            for (PhysicalArchitecture physicalArch2 : physicalArchPkg.getOwnedPhysicalArchitectures()) {
                if (physicalArch2 == null) continue;
                if (isFilterRequired) {
                    list.addAll(SystemComponentExt.getCapabilityRealizationUseCasesFiltered((SystemComponent)currentPC, (CapellaElement)physicalArch2));
                    continue;
                }
                list.addAll(CapellaElementExt.getAllCapabilityRealizationInvolvedWith((CapellaElement)physicalArch2));
            }
        }
        if ((physicalArch2 = SystemEngineeringExt.getOwnedPhysicalArchitecture(systemEngineering)) != null) {
            if (isFilterRequired) {
                list.addAll(SystemComponentExt.getCapabilityRealizationUseCasesFiltered((SystemComponent)currentPC, (CapellaElement)physicalArch2));
            } else {
                list.addAll(CapellaElementExt.getAllCapabilityRealizationInvolvedWith((CapellaElement)physicalArch2));
            }
        }
        return list;
    }

    public static SystemEngineering getParentSystemEngineering(PhysicalArchitecture currentPhysicalArchitecture) {
        if (currentPhysicalArchitecture != null) {
            EObject container = currentPhysicalArchitecture.eContainer();
            if (container instanceof PhysicalArchitecturePkg) {
                container = ((PhysicalArchitecturePkg)container).eContainer();
            }
            if (container instanceof SystemEngineering) {
                return (SystemEngineering)container;
            }
        }
        return null;
    }

    public static List<AbstractFunction> getAllFunctions(BlockArchitecture arch) {
        FunctionPkg functionPkg;
        List<AbstractFunction> list = new ArrayList<AbstractFunction>(1);
        if (arch != null && (functionPkg = arch.getOwnedFunctionPkg()) != null && functionPkg instanceof PhysicalFunctionPkg) {
            list = PhysicalArchitectureExt.getAllFunctionsFromFunctionPkg((PhysicalFunctionPkg)functionPkg);
        }
        return list;
    }

    public static List<AbstractFunction> getAllAbstractFunctions(BlockArchitecture arch) {
        FunctionPkg functionPkg;
        List<AbstractFunction> list = new ArrayList<AbstractFunction>(1);
        if (arch != null && (functionPkg = arch.getOwnedFunctionPkg()) != null && functionPkg instanceof PhysicalFunctionPkg) {
            list = PhysicalArchitectureExt.getAllFunctionsFromAbstractFunctionPkg((PhysicalFunctionPkg)functionPkg);
        }
        return list;
    }

    public static List<AbstractFunction> getAllFunctionsFromFunctionPkg(PhysicalFunctionPkg sysFunPkg) {
        ArrayList<AbstractFunction> list = new ArrayList<AbstractFunction>(1);
        if (sysFunPkg != null) {
            EList ownedFunctions = sysFunPkg.getOwnedPhysicalFunctions();
            list.addAll((Collection<AbstractFunction>)ownedFunctions);
            for (AbstractFunction function : ownedFunctions) {
                list.addAll(PhysicalArchitectureExt.getAllFunctionsFromFunction(function));
            }
            for (PhysicalFunctionPkg ownedFunctionPkg : sysFunPkg.getOwnedPhysicalFunctionPkgs()) {
                list.addAll(PhysicalArchitectureExt.getAllFunctionsFromFunctionPkg(ownedFunctionPkg));
            }
        }
        return list;
    }

    public static List<AbstractFunction> getAllFunctionsFromAbstractFunctionPkg(PhysicalFunctionPkg sysFunPkg) {
        ArrayList<AbstractFunction> list = new ArrayList<AbstractFunction>(1);
        if (sysFunPkg != null) {
            EList ownedFunctions = sysFunPkg.getOwnedPhysicalFunctions();
            list.addAll((Collection<AbstractFunction>)ownedFunctions);
            for (AbstractFunction function : ownedFunctions) {
                list.addAll(PhysicalArchitectureExt.getAllFunctionsFromAbstracrtFunction(function));
            }
            for (PhysicalFunctionPkg ownedFunctionPkg : sysFunPkg.getOwnedPhysicalFunctionPkgs()) {
                list.addAll(PhysicalArchitectureExt.getAllFunctionsFromAbstractFunctionPkg(ownedFunctionPkg));
            }
        }
        return list;
    }

    public static List<AbstractFunction> getAllFunctionsFromFunction(AbstractFunction fun) {
        ArrayList<AbstractFunction> list = new ArrayList<AbstractFunction>(1);
        if (fun != null) {
            EList ownedSystemFunctions = fun.getOwnedFunctions();
            for (AbstractFunction abstractFunction : ownedSystemFunctions) {
                list.add(abstractFunction);
            }
            for (AbstractFunction function : ownedSystemFunctions) {
                list.addAll(PhysicalArchitectureExt.getAllFunctionsFromFunction(function));
            }
        }
        return list;
    }

    public static List<AbstractFunction> getAllFunctionsFromAbstracrtFunction(AbstractFunction fun) {
        ArrayList<AbstractFunction> list = new ArrayList<AbstractFunction>(1);
        if (fun != null) {
            EList ownedSystemFunctions = fun.getOwnedFunctions();
            for (AbstractFunction abstractFunction : ownedSystemFunctions) {
                list.add(abstractFunction);
            }
            for (AbstractFunction function : ownedSystemFunctions) {
                list.addAll(PhysicalArchitectureExt.getAllFunctionsFromAbstracrtFunction(function));
            }
        }
        return list;
    }
}

