/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.core.model.helpers;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.polarsys.capella.common.data.modellingcore.AbstractTrace;
import org.polarsys.capella.common.data.modellingcore.AbstractType;
import org.polarsys.capella.common.data.modellingcore.AbstractTypedElement;
import org.polarsys.capella.common.data.modellingcore.InformationsExchanger;
import org.polarsys.capella.common.data.modellingcore.ModelElement;
import org.polarsys.capella.common.data.modellingcore.TraceableElement;
import org.polarsys.capella.common.helpers.EcoreUtil2;
import org.polarsys.capella.core.data.capellacore.CapellaElement;
import org.polarsys.capella.core.data.capellacore.Feature;
import org.polarsys.capella.core.data.capellacore.ModellingArchitecture;
import org.polarsys.capella.core.data.cs.AbstractDeploymentLink;
import org.polarsys.capella.core.data.cs.AbstractPhysicalLinkEnd;
import org.polarsys.capella.core.data.cs.Component;
import org.polarsys.capella.core.data.cs.DeployableElement;
import org.polarsys.capella.core.data.cs.DeploymentTarget;
import org.polarsys.capella.core.data.cs.Part;
import org.polarsys.capella.core.data.cs.PhysicalLink;
import org.polarsys.capella.core.data.cs.PhysicalLinkEnd;
import org.polarsys.capella.core.data.cs.PhysicalPort;
import org.polarsys.capella.core.data.fa.AbstractFunctionalBlock;
import org.polarsys.capella.core.data.fa.ComponentExchange;
import org.polarsys.capella.core.data.fa.ComponentExchangeAllocator;
import org.polarsys.capella.core.data.fa.ComponentPort;
import org.polarsys.capella.core.data.fa.ComponentPortAllocation;
import org.polarsys.capella.core.data.fa.FaFactory;
import org.polarsys.capella.core.data.fa.FaPackage;
import org.polarsys.capella.core.data.information.Port;
import org.polarsys.capella.core.data.pa.PaPackage;
import org.polarsys.capella.core.model.helpers.BlockArchitectureExt;
import org.polarsys.capella.core.model.helpers.CapellaElementExt;
import org.polarsys.capella.core.model.helpers.ComponentExchangeExt;
import org.polarsys.capella.core.model.helpers.ComponentExt;
import org.polarsys.capella.core.model.helpers.PartExt;

public class PhysicalLinkExt
extends org.polarsys.capella.core.data.helpers.cs.services.PhysicalLinkExt {
    public static boolean attachTo(PhysicalLink link, Component container) {
        if (container != null && !container.equals(link.eContainer())) {
            container.getOwnedPhysicalLinks().add((Object)link);
            return true;
        }
        return false;
    }

    public static boolean attachToDefaultContainer(PhysicalLink link) {
        return PhysicalLinkExt.attachTo(link, PhysicalLinkExt.getDefaultContainer(link));
    }

    public static Component getDefaultContainer(CapellaElement sourcePart, CapellaElement targetPart) {
        EObject container = ComponentExt.getFirstCommonComponentAncestor((EObject)sourcePart, (EObject)targetPart);
        if (container != null && !(container instanceof Component)) {
            container = EcoreUtil2.getFirstContainer((EObject)container, (EClass)PaPackage.Literals.PHYSICAL_COMPONENT);
        }
        if (container == null || !(container instanceof Component)) {
            container = BlockArchitectureExt.getFirstComponent((ModellingArchitecture)ComponentExt.getRootBlockArchitecture((ModelElement)sourcePart));
        }
        return (Component)container;
    }

    public static Component getDefaultContainer(PhysicalLink link) {
        Component source = org.polarsys.capella.core.data.helpers.cs.services.PhysicalLinkExt.getSourceComponent((PhysicalLink)link);
        Collection parts = org.polarsys.capella.core.data.helpers.cs.services.PhysicalLinkExt.getSourceParts((PhysicalLink)link);
        if (!parts.isEmpty()) {
            source = (CapellaElement)parts.iterator().next();
        }
        Component target = org.polarsys.capella.core.data.helpers.cs.services.PhysicalLinkExt.getTargetComponent((PhysicalLink)link);
        parts = org.polarsys.capella.core.data.helpers.cs.services.PhysicalLinkExt.getTargetParts((PhysicalLink)link);
        if (!parts.isEmpty()) {
            target = (CapellaElement)parts.iterator().next();
        }
        return PhysicalLinkExt.getDefaultContainer((CapellaElement)source, (CapellaElement)target);
    }

    public static AbstractFunctionalBlock getDefaultContainerForCategory(CapellaElement sourcePart, CapellaElement targetPart) {
        EObject container = ComponentExt.getFirstCommonComponentAncestor((EObject)sourcePart, (EObject)targetPart);
        if (container != null && !(container instanceof AbstractFunctionalBlock)) {
            container = EcoreUtil2.getFirstContainer((EObject)container, (EClass)FaPackage.Literals.ABSTRACT_FUNCTIONAL_BLOCK);
        }
        if (container == null || !(container instanceof AbstractFunctionalBlock)) {
            container = BlockArchitectureExt.getFirstComponent((ModellingArchitecture)ComponentExt.getRootBlockArchitecture((ModelElement)sourcePart));
        }
        return (AbstractFunctionalBlock)container;
    }

    public static AbstractFunctionalBlock getDefaultContainerForCategory(PhysicalLink link) {
        Component source = org.polarsys.capella.core.data.helpers.cs.services.PhysicalLinkExt.getSourceComponent((PhysicalLink)link);
        Collection parts = org.polarsys.capella.core.data.helpers.cs.services.PhysicalLinkExt.getSourceParts((PhysicalLink)link);
        if (!parts.isEmpty()) {
            source = (CapellaElement)parts.iterator().next();
        }
        Component target = org.polarsys.capella.core.data.helpers.cs.services.PhysicalLinkExt.getTargetComponent((PhysicalLink)link);
        parts = org.polarsys.capella.core.data.helpers.cs.services.PhysicalLinkExt.getTargetParts((PhysicalLink)link);
        if (!parts.isEmpty()) {
            target = (CapellaElement)parts.iterator().next();
        }
        return PhysicalLinkExt.getDefaultContainerForCategory((CapellaElement)source, (CapellaElement)target);
    }

    public static boolean isDelegation(PhysicalLink link) {
        Collection<Part> firstPartAncestors;
        Collection sourceParts = org.polarsys.capella.core.data.helpers.cs.services.PhysicalLinkExt.getSourceParts((PhysicalLink)link);
        Collection targetParts = org.polarsys.capella.core.data.helpers.cs.services.PhysicalLinkExt.getTargetParts((PhysicalLink)link);
        boolean flag = false;
        for (Part part : targetParts) {
            firstPartAncestors = PartExt.getFirstPartAncestors(part);
            for (Part part2 : firstPartAncestors) {
                if (!sourceParts.contains(part2)) continue;
                return true;
            }
        }
        if (!flag) {
            for (Part part : sourceParts) {
                firstPartAncestors = PartExt.getFirstPartAncestors(part);
                for (Part part2 : firstPartAncestors) {
                    if (!targetParts.contains(part2)) continue;
                    return true;
                }
            }
        }
        return false;
    }

    public static void synchronizeAllocations(PhysicalLink pLink, ComponentExchange cExchange) {
        Port ceSource = ComponentExchangeExt.getSourcePort(cExchange);
        Port ceTarget = ComponentExchangeExt.getTargetPort(cExchange);
        if (ceSource instanceof ComponentPort && ceTarget instanceof ComponentPort) {
            PhysicalLinkExt.synchronizeAllocations(pLink, (ComponentPort)ceSource, (ComponentPort)ceTarget);
        }
    }

    private static void synchronizeAllocations(PhysicalLink pLink, ComponentPort ceSource, ComponentPort ceTarget) {
        PhysicalLinkExt.synchronizeAllocations(PhysicalLinkExt.getPhysicalPortFrom(pLink, (InformationsExchanger)ceSource), ceSource);
        PhysicalLinkExt.synchronizeAllocations(PhysicalLinkExt.getPhysicalPortFrom(pLink, (InformationsExchanger)ceTarget), ceTarget);
    }

    protected static void synchronizeAllocations(PhysicalPort pPort, ComponentPort cPort) {
        if (pPort == null || cPort == null) {
            return;
        }
        ComponentPortAllocation exchange = PhysicalLinkExt.getComponentPortAllocation(pPort, cPort);
        if (exchange == null) {
            PhysicalLinkExt.createComponentPortAllocation(pPort, cPort);
        }
    }

    public static List<ModelElement> evaluateImpactsOfUnsynchronizeAllocations(PhysicalLink pLink, ComponentExchange cExchange, boolean forceCleaning) {
        ArrayList<ModelElement> result = new ArrayList<ModelElement>();
        Port ceSource = ComponentExchangeExt.getSourcePort(cExchange);
        Port ceTarget = ComponentExchangeExt.getTargetPort(cExchange);
        if (ceSource instanceof ComponentPort && ceTarget instanceof ComponentPort) {
            result.addAll(PhysicalLinkExt.unsynchronizeAllocations(pLink, (ComponentPort)ceSource, (ComponentPort)ceTarget, forceCleaning));
        }
        return result;
    }

    private static List<ModelElement> unsynchronizeAllocations(PhysicalLink pLink, ComponentPort ceSource, ComponentPort ceTarget, boolean forceCleaning) {
        ArrayList<ModelElement> result = new ArrayList<ModelElement>();
        if (forceCleaning || PhysicalLinkExt.getExchangesFrom((ComponentExchangeAllocator)pLink, (InformationsExchanger)ceSource).isEmpty()) {
            result.addAll(PhysicalLinkExt.unsynchronizeAllocations(PhysicalLinkExt.getPhysicalPortFrom(pLink, (InformationsExchanger)ceSource), ceSource));
        }
        if (forceCleaning || PhysicalLinkExt.getExchangesFrom((ComponentExchangeAllocator)pLink, (InformationsExchanger)ceTarget).isEmpty()) {
            result.addAll(PhysicalLinkExt.unsynchronizeAllocations(PhysicalLinkExt.getPhysicalPortFrom(pLink, (InformationsExchanger)ceTarget), ceTarget));
        }
        return result;
    }

    protected static List<ModelElement> unsynchronizeAllocations(PhysicalPort pPort, ComponentPort cPort) {
        ComponentPortAllocation allocation;
        ArrayList<ModelElement> result = new ArrayList<ModelElement>();
        if (pPort != null && cPort != null && (allocation = PhysicalLinkExt.getComponentPortAllocation(pPort, cPort)) != null) {
            result.add((ModelElement)allocation);
        }
        return result;
    }

    private static ComponentPortAllocation getComponentPortAllocation(PhysicalPort pPort, ComponentPort cPort) {
        for (AbstractTrace trace : pPort.getOutgoingTraces()) {
            if (!(trace instanceof ComponentPortAllocation) || !cPort.equals(trace.getTargetElement())) continue;
            return (ComponentPortAllocation)trace;
        }
        return null;
    }

    protected static List<ComponentExchange> getExchangesFrom(ComponentExchangeAllocator cpntAllocator, InformationsExchanger cPort) {
        ArrayList<ComponentExchange> result = new ArrayList<ComponentExchange>();
        if (cPort != null) {
            for (ComponentExchange exchange : cpntAllocator.getAllocatedComponentExchanges()) {
                InformationsExchanger ceSource = exchange.getSource();
                InformationsExchanger ceTarget = exchange.getTarget();
                if (!cPort.equals(ceSource) && !cPort.equals(ceTarget)) continue;
                result.add(exchange);
            }
        }
        return result;
    }

    protected static PhysicalPort getPhysicalPortFrom(PhysicalLink pLink, InformationsExchanger cPort) {
        EObject cPortOwner = cPort.eContainer();
        if (cPortOwner instanceof AbstractType) {
            for (AbstractTypedElement elt : ((AbstractType)cPortOwner).getAbstractTypedElements()) {
                if (!(elt instanceof DeployableElement)) continue;
                for (AbstractDeploymentLink lnk : ((DeployableElement)elt).getDeployingLinks()) {
                    AbstractType type;
                    DeploymentTarget tgt = lnk.getLocation();
                    if (!(tgt instanceof AbstractTypedElement) || !((type = ((AbstractTypedElement)tgt).getAbstractType()) instanceof Component)) continue;
                    for (Feature feature : ((Component)type).getOwnedFeatures()) {
                        if (!(feature instanceof PhysicalPort)) continue;
                        for (AbstractPhysicalLinkEnd linkEnd : pLink.getLinkEnds()) {
                            PhysicalPort pp;
                            if (linkEnd instanceof PhysicalPort && linkEnd.equals(feature)) {
                                return (PhysicalPort)feature;
                            }
                            if (!(linkEnd instanceof PhysicalLinkEnd) || !feature.equals(pp = ((PhysicalLinkEnd)linkEnd).getPort())) continue;
                            return (PhysicalPort)feature;
                        }
                    }
                }
            }
        }
        return null;
    }

    private static void createComponentPortAllocation(PhysicalPort pPort, ComponentPort cPort) {
        ComponentPortAllocation allocation = FaFactory.eINSTANCE.createComponentPortAllocation();
        allocation.setSourceElement((TraceableElement)pPort);
        allocation.setTargetElement((TraceableElement)cPort);
        pPort.getOwnedComponentPortAllocations().add((Object)allocation);
        CapellaElementExt.creationService((EObject)allocation);
    }
}

