/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.core.model.helpers.listeners;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.polarsys.capella.common.data.modellingcore.AbstractNamedElement;
import org.polarsys.capella.common.data.modellingcore.ModellingcorePackage;
import org.polarsys.capella.common.ef.command.AbstractReadWriteCommand;
import org.polarsys.capella.common.ef.command.ICommand;
import org.polarsys.capella.common.helpers.EObjectExt;
import org.polarsys.capella.core.data.cs.ExchangeItemAllocation;
import org.polarsys.capella.core.data.helpers.information.services.ExchangeItemExt;
import org.polarsys.capella.core.data.information.AbstractEventOperation;
import org.polarsys.capella.core.data.information.ExchangeItem;
import org.polarsys.capella.core.data.interaction.Event;
import org.polarsys.capella.core.data.interaction.EventReceiptOperation;
import org.polarsys.capella.core.data.interaction.EventSentOperation;
import org.polarsys.capella.core.data.interaction.InteractionPackage;
import org.polarsys.capella.core.data.interaction.SequenceMessage;
import org.polarsys.capella.core.model.helpers.listeners.CapellaModelDataListener;

public class CapellaModelDataListenerForSequenceMessages
extends CapellaModelDataListener {
    protected Collection<SequenceMessage> getAssociatedSequenceMessages(Collection<? extends AbstractEventOperation> operations) {
        HashSet<SequenceMessage> sequenceMessages = new HashSet<SequenceMessage>();
        for (AbstractEventOperation abstractEventOperation : operations) {
            sequenceMessages.addAll((Collection<SequenceMessage>)abstractEventOperation.getInvokingSequenceMessages());
        }
        return sequenceMessages;
    }

    protected List<EObject> getSequenceMessages(Event event) {
        ArrayList<EObject> result = new ArrayList<EObject>();
        List abstractEnds = EObjectExt.getReferencers((EObject)event, (EClass)InteractionPackage.Literals.ABSTRACT_END, (EReference)InteractionPackage.Literals.ABSTRACT_END__EVENT);
        for (EObject abstractEnd : abstractEnds) {
            result.addAll(EObjectExt.getReferencers((EObject)abstractEnd, (EClass)InteractionPackage.Literals.SEQUENCE_MESSAGE, (EReference)InteractionPackage.Literals.SEQUENCE_MESSAGE__SENDING_END));
            result.addAll(EObjectExt.getReferencers((EObject)abstractEnd, (EClass)InteractionPackage.Literals.SEQUENCE_MESSAGE, (EReference)InteractionPackage.Literals.SEQUENCE_MESSAGE__RECEIVING_END));
        }
        return result;
    }

    public void notifyChanged(Notification notification) {
        if (this.filterNotification(notification)) {
            return;
        }
        if (notification.getEventType() != 1) {
            return;
        }
        Object notifier = notification.getNotifier();
        EStructuralFeature feature = (EStructuralFeature)notification.getFeature();
        if (notifier instanceof EventSentOperation && InteractionPackage.Literals.EVENT_SENT_OPERATION__OPERATION.equals(feature) || notifier instanceof EventReceiptOperation && InteractionPackage.Literals.EVENT_RECEIPT_OPERATION__OPERATION.equals(feature)) {
            Object value = notification.getNewValue();
            String name = "";
            if (value instanceof ExchangeItemAllocation) {
                ExchangeItem exchangeItem = ((ExchangeItemAllocation)value).getAllocatedItem();
                if (exchangeItem != null) {
                    name = exchangeItem.getName();
                }
            } else if (value instanceof AbstractEventOperation) {
                name = ((AbstractEventOperation)value).getName();
            }
            List<EObject> sequenceMessages = this.getSequenceMessages((Event)notifier);
            this.renameElements(sequenceMessages, name);
        } else if (ModellingcorePackage.Literals.ABSTRACT_NAMED_ELEMENT__NAME.equals(feature)) {
            String value = notification.getNewStringValue();
            if (notifier instanceof ExchangeItem || notifier instanceof AbstractEventOperation) {
                Collection<Object> operations = Collections.emptyList();
                if (notifier instanceof ExchangeItem) {
                    operations = ExchangeItemExt.getRelatedExchangeItemAllocations((ExchangeItem)((ExchangeItem)notifier));
                } else if (notifier instanceof AbstractEventOperation && !(notifier instanceof ExchangeItemAllocation)) {
                    operations = Collections.singletonList((AbstractEventOperation)notifier);
                }
                Collection<SequenceMessage> sequenceMessages = this.getAssociatedSequenceMessages(operations);
                this.renameElements(sequenceMessages, value);
            } else if (notifier instanceof SequenceMessage) {
                AbstractEventOperation op = ((SequenceMessage)notifier).getInvokedOperation();
                AbstractEventOperation elementToRename = null;
                if (op instanceof ExchangeItemAllocation) {
                    ExchangeItem exchangeItem = ((ExchangeItemAllocation)op).getAllocatedItem();
                    if (exchangeItem != null) {
                        elementToRename = exchangeItem;
                    }
                } else {
                    elementToRename = op;
                }
                this.renameElements(Collections.singletonList(elementToRename), value);
            }
        }
    }

    protected void renameElements(final Collection<? extends EObject> elementsToRename, final String newName) {
        boolean renameNeeded = false;
        for (EObject eObject : elementsToRename) {
            AbstractNamedElement namedElementToRename;
            if (!(eObject instanceof AbstractNamedElement) || StringUtils.equals((String)(namedElementToRename = (AbstractNamedElement)eObject).getName(), (String)newName)) continue;
            renameNeeded = true;
            break;
        }
        if (!renameNeeded) {
            return;
        }
        this.executeCommand(elementsToRename, (ICommand)new AbstractReadWriteCommand(){

            public void run() {
                for (EObject elementToRename : elementsToRename) {
                    AbstractNamedElement namedElementToRename;
                    if (!(elementToRename instanceof AbstractNamedElement) || StringUtils.equals((String)(namedElementToRename = (AbstractNamedElement)elementToRename).getName(), (String)newName)) continue;
                    namedElementToRename.setName(newName);
                }
            }
        });
    }
}

