/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.core.model.helpers.move;

import com.google.common.base.Predicate;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.Collections2;
import com.google.common.collect.Iterators;
import com.google.common.collect.Multimap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.ListenerList;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.command.CompoundCommand;
import org.eclipse.emf.common.util.BasicDiagnostic;
import org.eclipse.emf.common.util.Diagnostic;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.util.EContentsEList;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.edit.command.AddCommand;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emf.transaction.RecordingCommand;
import org.eclipse.emf.transaction.ResourceSetListener;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.emf.transaction.util.TransactionUtil;
import org.eclipse.osgi.util.NLS;
import org.polarsys.capella.common.helpers.EObjectLabelProviderHelper;
import org.polarsys.capella.core.model.helpers.move.Messages;
import org.polarsys.capella.core.model.helpers.move.StageListener;
import org.polarsys.capella.core.model.helpers.move.StageResourceSetListener;

public class Stage {
    static final String SOURCE = "capella.move.stage";
    final List<EObject> delegate = new ArrayList<EObject>();
    private TransactionalEditingDomain domain;
    private ResourceSetListener listener;
    private final ListenerList<StageListener> stageListeners;
    private final int CODE_BACKREF = 0;
    Map<EObject, EObject> plannedParents = new HashMap<EObject, EObject>();
    Multimap<EObject, EStructuralFeature.Setting> backrefs = ArrayListMultimap.create();
    private final Multimap<EObject, Diagnostic> diagnostics = ArrayListMultimap.create();

    public Stage(TransactionalEditingDomain domain) {
        this.domain = domain;
        this.stageListeners = new ListenerList();
        this.listener = new StageResourceSetListener(this);
        domain.addResourceSetListener(this.listener);
    }

    public void addStageListener(StageListener l) {
        this.stageListeners.add((Object)l);
    }

    public void removeStageListener(StageListener l) {
        this.stageListeners.remove((Object)l);
    }

    public void setParent(EObject staged, EObject newParent) {
        EObject oldParent = null;
        oldParent = newParent == null ? this.plannedParents.remove(staged) : this.plannedParents.put(staged, newParent);
        this.notifyNewParent(staged, oldParent, newParent);
    }

    public EditingDomain getEditingDomain() {
        return this.domain;
    }

    public Collection<EObject> getElementsWithoutNewParent() {
        return Collections2.filter(this.getElements(), (Predicate)new Predicate<EObject>(){

            public boolean apply(EObject input) {
                return !Stage.this.plannedParents.containsKey(input);
            }
        });
    }

    public Collection<EObject> getElements() {
        return Collections.unmodifiableCollection(this.delegate);
    }

    public Collection<Diagnostic> getDiagnostics(EObject elem) {
        return this.diagnostics.get((Object)elem);
    }

    public void addAll(Collection<EObject> elements) {
        for (EObject e : elements) {
            this.addInternal(e);
        }
        this.notifyAdd(elements);
    }

    public void add(EObject element) {
        this.addInternal(element);
        this.notifyAdd(Collections.singleton(element));
    }

    private void notifyAdd(Collection<EObject> elements) {
        for (StageListener s : this.stageListeners) {
            s.elementsAdded(elements);
        }
    }

    private void notifyRemoved(Collection<? extends EObject> elements) {
        for (StageListener s : this.stageListeners) {
            s.elementsRemoved(elements);
        }
    }

    private void notifyNewParent(EObject staged, EObject oldParent, EObject newParent) {
        for (StageListener s : this.stageListeners) {
            s.parentChanged(staged, oldParent, newParent);
        }
    }

    private void addInternal(EObject e) {
        TransactionalEditingDomain eDomain = TransactionUtil.getEditingDomain((EObject)e);
        if (eDomain == null) {
            throw new IllegalArgumentException(Messages.Stage_element_has_no_editing_domain);
        }
        if (this.domain != eDomain) {
            throw new IllegalArgumentException(Messages.Stage_different_editing_domains_not_allowed);
        }
        if (EcoreUtil.isAncestor(this.delegate, (EObject)e)) {
            return;
        }
        Iterator<EObject> it = this.delegate.iterator();
        while (it.hasNext()) {
            EObject staged = it.next();
            if (!EcoreUtil.isAncestor((EObject)e, (EObject)staged)) continue;
            it.remove();
        }
        this.delegate.add(e);
        this.refreshBackRefs();
    }

    private void refreshBackRefs() {
        for (EObject e : this.delegate) {
            this.refreshBackRefs(e);
        }
    }

    private void refreshBackRefs(EObject staged) {
        this.diagnostics.removeAll((Object)staged);
        this.backrefs.removeAll((Object)staged);
        TreeIterator it = EcoreUtil.getAllContents((EObject)staged, (boolean)true);
        while (it.hasNext()) {
            EObject next = (EObject)it.next();
            this.diagnostics.removeAll((Object)next);
            this.backrefs.removeAll((Object)next);
        }
        this.addBackrefs(staged);
        it = EcoreUtil.getAllContents((EObject)staged, (boolean)true);
        while (it.hasNext()) {
            this.addBackrefs((EObject)it.next());
        }
    }

    private void addBackrefs(EObject e) {
        EContentsEList.FeatureIterator it = (EContentsEList.FeatureIterator)e.eCrossReferences().iterator();
        while (it.hasNext()) {
            EObject referenced = (EObject)it.next();
            EStructuralFeature feature = it.feature();
            if (feature.isDerived() || Iterators.contains((Iterator)EcoreUtil.getAllContents(this.delegate), (Object)referenced) || this.delegate.contains(referenced) || EcoreUtil.getRootContainer((EObject)referenced) != EcoreUtil.getRootContainer((EObject)e)) continue;
            this.backrefs.put((Object)referenced, (Object)((InternalEObject)e).eSetting(it.feature()));
            this.diagnostics.put((Object)e, (Object)new BasicDiagnostic(4, SOURCE, 0, Messages.Stage_diagnostic_backref, new Object[]{e, referenced, it.feature()}));
        }
    }

    public void refresh() {
        ArrayList<EObject> keep = new ArrayList<EObject>();
        for (EObject e : this.delegate) {
            if (TransactionUtil.getEditingDomain((EObject)e) != this.domain) {
                this.plannedParents.remove(e);
                continue;
            }
            if (e.eContainer() == this.plannedParents.get(e)) {
                this.plannedParents.remove(e);
                continue;
            }
            EObject plannedParent = this.plannedParents.get(e);
            if (plannedParent != null && TransactionUtil.getEditingDomain((EObject)plannedParent) != this.domain) {
                this.plannedParents.remove(e);
            }
            keep.add(e);
        }
        this.delegate.clear();
        this.diagnostics.clear();
        this.backrefs.clear();
        for (EObject e : keep) {
            this.addInternal(e);
        }
        for (StageListener l : this.stageListeners) {
            l.stageChanged(this);
        }
    }

    public boolean hasBackreferences() {
        return this.backrefs.size() > 0;
    }

    public boolean hasBackreferences(EObject staged) {
        for (EStructuralFeature.Setting setting : this.backrefs.values()) {
            if (setting.getEObject() != staged) continue;
            return true;
        }
        return false;
    }

    public EObject getNewParent(EObject staged) {
        return this.plannedParents.get(staged);
    }

    public Multimap<EStructuralFeature, EObject> getBackreferences(EObject staged) {
        ArrayListMultimap result = ArrayListMultimap.create();
        for (Map.Entry entry : this.backrefs.entries()) {
            if (((EStructuralFeature.Setting)entry.getValue()).getEObject() != staged) continue;
            result.put((Object)((EStructuralFeature.Setting)entry.getValue()).getEStructuralFeature(), (Object)((EObject)entry.getKey()));
        }
        return result;
    }

    public IStatus execute() {
        Status result = null;
        if (!this.backrefs.isEmpty()) {
            result = new Status(4, "org.polarsys.capella.core.model.helpers", Messages.Stage_incomplete_with_backrefs);
        } else if (!this.plannedParents.keySet().containsAll(this.getElements())) {
            result = new Status(4, "org.polarsys.capella.core.model.helpers", Messages.Stage_incomplete_with_orphan);
        } else {
            RecordingCommand rc = new RecordingCommand(this.domain, Messages.Stage_formtitle){
                IStatus resultStatus;
                {
                    this.resultStatus = Status.OK_STATUS;
                }

                protected void doExecute() {
                    CompoundCommand c = new CompoundCommand();
                    for (EObject staged : Stage.this.getElements()) {
                        if (c.appendAndExecute(AddCommand.create((EditingDomain)Stage.this.domain, (Object)Stage.this.getNewParent(staged), null, Collections.singleton(staged)))) continue;
                        this.resultStatus = new Status(4, "org.polarsys.capella.core.model.helpers", NLS.bind((String)"Cannot move {0} to {1}", (Object)EObjectLabelProviderHelper.getText((EObject)staged), (Object)EObjectLabelProviderHelper.getText((EObject)Stage.this.getNewParent(staged))));
                        throw new OperationCanceledException();
                    }
                }

                public Collection<?> getResult() {
                    return Collections.singleton(this.resultStatus);
                }
            };
            this.domain.getCommandStack().execute((Command)rc);
            result = (IStatus)rc.getResult().iterator().next();
        }
        return result;
    }

    public boolean canExecute() {
        return this.getElements().size() > 0 && this.getElementsWithoutNewParent().isEmpty() && !this.hasBackreferences();
    }

    public void dispose() {
        if (this.domain != null) {
            this.domain.removeResourceSetListener(this.listener);
        }
    }

    public void remove(EObject e) {
        this.removeAll(Collections.singletonList(e));
    }

    public void removeAll(Collection<? extends EObject> elements) {
        for (EObject eObject : elements) {
            this.plannedParents.remove(eObject);
        }
        if (this.delegate.removeAll(elements)) {
            Iterator iterator = this.backrefs.entries().iterator();
            while (iterator.hasNext()) {
                Map.Entry next = (Map.Entry)iterator.next();
                if (!EcoreUtil.isAncestor(elements, (EObject)((EStructuralFeature.Setting)next.getValue()).getEObject())) continue;
                iterator.remove();
            }
            this.refreshBackRefs();
            this.notifyRemoved(elements);
        }
    }
}

