/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.core.refinement.processor.actorprojection;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.ecore.EObject;
import org.polarsys.capella.common.data.modellingcore.ModelElement;
import org.polarsys.capella.core.data.capellacore.CapellaElement;
import org.polarsys.capella.core.data.capellacore.NamedElement;
import org.polarsys.capella.core.data.capellacore.Type;
import org.polarsys.capella.core.data.cs.AbstractActor;
import org.polarsys.capella.core.data.cs.ComponentArchitecture;
import org.polarsys.capella.core.data.ctx.SystemAnalysis;
import org.polarsys.capella.core.data.information.AbstractInstance;
import org.polarsys.capella.core.data.interaction.AbstractEnd;
import org.polarsys.capella.core.data.interaction.InstanceRole;
import org.polarsys.capella.core.data.interaction.InteractionFragment;
import org.polarsys.capella.core.data.interaction.Scenario;
import org.polarsys.capella.core.data.la.LogicalArchitecture;
import org.polarsys.capella.core.data.la.LogicalComponent;
import org.polarsys.capella.core.data.pa.PhysicalArchitecture;
import org.polarsys.capella.core.model.utils.CapellaLayerCheckingExt;
import org.polarsys.capella.core.projection.actors.ctx2la.TransformActorsCtx2La;
import org.polarsys.capella.core.projection.actors.la2pa.TransformActorsLa2Pa;
import org.polarsys.capella.core.refinement.scenarios.core.exceptions.ProcessorException;
import org.polarsys.capella.core.refinement.scenarios.core.plugs.IProcessor;

public class ActorProjectionProcessor
implements IProcessor {
    private ModelElement context = null;
    private NamedElement target = null;

    public void execute(IProgressMonitor progressMonitor) throws ProcessorException {
        if ((CapellaLayerCheckingExt.isInContextLayer((CapellaElement)((CapellaElement)this.context)) || this.context instanceof SystemAnalysis) && CapellaLayerCheckingExt.isInLogicalLayer((CapellaElement)this.target) || this.target instanceof LogicalArchitecture || (CapellaLayerCheckingExt.isInLogicalLayer((CapellaElement)((CapellaElement)this.context)) || this.context instanceof LogicalArchitecture) && CapellaLayerCheckingExt.isInPhysicalLayer((CapellaElement)this.target) || this.target instanceof PhysicalArchitecture) {
            Scenario scenario = (Scenario)this.context;
            ArrayList<AbstractActor> listActor = new ArrayList<AbstractActor>();
            for (InteractionFragment interactionFragment : scenario.getOwnedInteractionFragments()) {
                Type cpnt;
                AbstractInstance cpntInst;
                AbstractEnd abstractEnd;
                InstanceRole instRole;
                if (!(interactionFragment instanceof AbstractEnd) || (instRole = (abstractEnd = (AbstractEnd)interactionFragment).getCovered()) == null || (cpntInst = instRole.getRepresentedInstance()) == null || !((cpnt = cpntInst.getType()) instanceof AbstractActor) || listActor.contains(cpnt)) continue;
                listActor.add((AbstractActor)cpnt);
            }
            this.performActorProjection(listActor);
        }
    }

    private void performActorProjection(List<AbstractActor> listActor) {
        block3: {
            block2: {
                if (!(this.target instanceof LogicalArchitecture)) break block2;
                for (AbstractActor actor : listActor) {
                    TransformActorsCtx2La transfActor = new TransformActorsCtx2La();
                    transfActor.setContext((EObject)actor);
                    transfActor.execute();
                }
                break block3;
            }
            if (!(this.target instanceof PhysicalArchitecture)) break block3;
            for (AbstractActor actor : listActor) {
                TransformActorsLa2Pa transfActor = new TransformActorsLa2Pa();
                transfActor.setContext((EObject)actor);
                transfActor.execute();
            }
        }
    }

    public Object getResult() {
        return null;
    }

    public void setContext(ModelElement context) {
        this.context = context;
    }

    public void setContext(List<ModelElement> context) {
        if (context != null && context.size() > 0) {
            this.setContext(context.get(0));
        }
    }

    public void setTarget(NamedElement target) {
        if (target instanceof ComponentArchitecture || target instanceof LogicalComponent) {
            this.target = target;
        }
    }

    public Object getName() {
        return "actor and interface projection";
    }
}

