/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.core.ui.fastlinker;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.sirius.diagram.ui.edit.api.part.IAbstractDiagramNodeEditPart;
import org.eclipse.sirius.diagram.ui.edit.api.part.IDiagramEdgeEditPart;
import org.eclipse.sirius.diagram.ui.edit.api.part.IDiagramElementEditPart;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.handlers.HandlerUtil;
import org.polarsys.capella.core.ui.fastlinker.FastLinkerActivator;

public class SendToFastLinkerCommandHandler
extends AbstractHandler {
    public Object execute(ExecutionEvent event) throws ExecutionException {
        ISelection selection = this.getCurrentSelection(event.getApplicationContext());
        Collection<EObject> selectedModelElement = this.getSelectedModelElement(selection);
        if (selectedModelElement == null) {
            return null;
        }
        FastLinkerActivator.getDefault().getFastLinkerManager().putElementInFastLinker(selectedModelElement);
        return null;
    }

    public ISelection getCurrentSelection(Object evaluationContext) {
        IWorkbenchPart activePart = (IWorkbenchPart)HandlerUtil.getVariable((Object)evaluationContext, (String)"activePart");
        if (activePart == null) {
            return StructuredSelection.EMPTY;
        }
        if (activePart.getSite().getSelectionProvider() == null) {
            return StructuredSelection.EMPTY;
        }
        return activePart.getSite().getSelectionProvider().getSelection();
    }

    public Collection<EObject> getSelectedModelElement(ISelection selection) {
        if (!(selection instanceof IStructuredSelection)) {
            return null;
        }
        ArrayList<EObject> ret = new ArrayList<EObject>();
        List selectedElements = ((IStructuredSelection)selection).toList();
        for (Object selectedElement : selectedElements) {
            if (selectedElement instanceof IAbstractDiagramNodeEditPart || selectedElement instanceof IDiagramEdgeEditPart) {
                IDiagramElementEditPart diagramElement = (IDiagramElementEditPart)selectedElement;
                ret.add(diagramElement.resolveTargetSemanticElement());
                continue;
            }
            if (!(selectedElement instanceof EObject)) continue;
            ret.add((EObject)selectedElement);
        }
        if (selectedElements.isEmpty()) {
            return null;
        }
        return ret;
    }

    public void setEnabled(Object evaluationContext) {
        ISelection selection = this.getCurrentSelection(evaluationContext);
        Collection<EObject> selectedElement = this.getSelectedModelElement(selection);
        if (selectedElement == null || selectedElement.isEmpty()) {
            this.setBaseEnabled(false);
            return;
        }
        boolean isAccepted = FastLinkerActivator.getDefault().getFastLinkerManager().acceptElementInFastLinker(selectedElement);
        this.setBaseEnabled(isAccepted);
    }
}

