/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.core.data.information.datatype.validation;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.validation.IValidationContext;
import org.polarsys.capella.common.data.modellingcore.AbstractType;
import org.polarsys.capella.core.data.information.datatype.DataType;
import org.polarsys.capella.core.data.information.datatype.NumericType;
import org.polarsys.capella.core.data.information.datatype.NumericTypeKind;
import org.polarsys.capella.core.data.information.datavalue.DataValue;
import org.polarsys.capella.core.data.information.datavalue.LiteralNumericValue;
import org.polarsys.capella.core.data.information.datavalue.LiteralStringValue;
import org.polarsys.capella.core.model.helpers.CapellaElementExt;
import org.polarsys.capella.core.validation.rule.AbstractValidationRule;

public class DataValuePattern
extends AbstractValidationRule {
    public IStatus validate(IValidationContext ctx) {
        EObject eObj = ctx.getTarget();
        if (eObj instanceof LiteralNumericValue || eObj instanceof LiteralStringValue) {
            DataValue dataValue = (DataValue)eObj;
            String value = this.getTargetValue(dataValue);
            if (value == null || value.trim().equalsIgnoreCase("")) {
                return ctx.createFailureStatus(new Object[]{"value is not set for \"" + CapellaElementExt.getCapellaExplorerLabel((EObject)dataValue) + "\"" + " (" + dataValue.eClass().getName() + ")"});
            }
            AbstractType dataValueType = dataValue.getAbstractType();
            String pattern = null;
            if (dataValueType != null && dataValueType instanceof DataType) {
                DataType dataType = (DataType)dataValueType;
                pattern = dataType.getPattern();
                if (!this.checkDataValueFunctionOfDataType(pattern, value, dataType)) {
                    if (pattern == null || pattern.trim().equals("")) {
                        if (dataType instanceof NumericType) {
                            NumericTypeKind kind = ((NumericType)dataType).getKind();
                            if (kind.equals((Object)NumericTypeKind.INTEGER)) {
                                pattern = "INTEGER [+-]?[1-9][0-9]*|0";
                            } else if (kind.equals((Object)NumericTypeKind.FLOAT)) {
                                pattern = "FLOAT (+|-)?([0-9]*[.][0-9]+|[0-9]+[.][0-9]*)(e|E)(+|-)[0-9]+";
                            }
                        } else {
                            pattern = "null";
                        }
                    }
                    return ctx.createFailureStatus(new Object[]{String.valueOf(value) + " value of " + "\"" + CapellaElementExt.getCapellaExplorerLabel((EObject)dataValue) + "\"" + " (" + dataValue.eClass().getName() + ")" + " does not match the patten " + pattern.toString()});
                }
            } else if ((dataValue instanceof LiteralNumericValue || dataValue instanceof LiteralStringValue) && !this.parseInteger(value)) {
                pattern = "INTEGER [+-]?[1-9][0-9]*|0";
                return ctx.createFailureStatus(new Object[]{String.valueOf(value) + " value of " + "\"" + CapellaElementExt.getCapellaExplorerLabel((EObject)dataValue) + "\"" + " (" + dataValue.eClass().getName() + ")" + " does not match the default patten " + pattern.toString()});
            }
        }
        return ctx.createSuccessStatus();
    }

    private boolean checkDataValueFunctionOfDataType(String pattern, String value, DataType dataType) {
        if (pattern != null && !pattern.trim().equals("") && pattern.length() > 1) {
            return this.tryToMatchWithPattern(value, pattern);
        }
        if (dataType != null && dataType instanceof NumericType) {
            return this.tryToMatchWithKind(value, dataType);
        }
        return false;
    }

    private boolean tryToMatchWithKind(String value, DataType dataType) {
        NumericTypeKind kind = ((NumericType)dataType).getKind();
        switch (kind) {
            case FLOAT: {
                try {
                    Float.parseFloat(value);
                    break;
                }
                catch (NumberFormatException e) {
                    return false;
                }
            }
            case INTEGER: {
                return this.parseInteger(value);
            }
        }
        return true;
    }

    private boolean parseInteger(String value) {
        try {
            Integer.parseInt(value);
        }
        catch (NumberFormatException e) {
            return false;
        }
        return true;
    }

    private boolean tryToMatchWithPattern(String value, String pattern) {
        try {
            Pattern p = Pattern.compile(pattern);
            Matcher m = p.matcher(value);
            return m.matches();
        }
        catch (Exception e) {
            return false;
        }
    }

    private String getTargetValue(DataValue datavalue) {
        if (datavalue instanceof LiteralNumericValue) {
            return ((LiteralNumericValue)datavalue).getValue();
        }
        if (datavalue instanceof LiteralStringValue) {
            return ((LiteralStringValue)datavalue).getValue();
        }
        return null;
    }
}

