/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.core.platform.sirius.clipboard.commands;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.emf.common.util.BasicEList;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.common.util.UniqueEList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.ecore.xmi.XMLResource;
import org.eclipse.gmf.runtime.emf.clipboard.core.ClipboardUtil;
import org.eclipse.gmf.runtime.notation.Edge;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.sirius.business.api.session.Session;
import org.eclipse.sirius.business.api.session.SessionManager;
import org.eclipse.sirius.diagram.DDiagram;
import org.eclipse.sirius.diagram.DDiagramElement;
import org.eclipse.sirius.diagram.DEdge;
import org.eclipse.sirius.diagram.DNode;
import org.eclipse.sirius.diagram.business.internal.metamodel.helper.MappingHelper;
import org.eclipse.sirius.viewpoint.DRepresentationElement;
import org.eclipse.sirius.viewpoint.DSemanticDecorator;
import org.eclipse.sirius.viewpoint.Style;
import org.polarsys.capella.core.data.cs.Part;
import org.polarsys.capella.core.platform.sirius.clipboard.Messages;
import org.polarsys.capella.core.platform.sirius.clipboard.commands.AbstractResultCommand;
import org.polarsys.capella.core.platform.sirius.clipboard.commands.SetStyleSwitch;
import org.polarsys.capella.core.platform.sirius.clipboard.util.BusinessHelper;
import org.polarsys.capella.core.platform.sirius.clipboard.util.CapellaDiagramClipboard;
import org.polarsys.capella.core.platform.sirius.clipboard.util.DiagramBusinessHelper;
import org.polarsys.capella.core.platform.sirius.clipboard.util.GmfUtil;
import org.polarsys.capella.core.platform.sirius.clipboard.util.LayerUtil;
import org.polarsys.capella.core.platform.sirius.clipboard.util.MiscUtil;
import org.polarsys.capella.core.platform.sirius.clipboard.util.NamingUtil;
import org.polarsys.capella.core.platform.sirius.clipboard.util.SiriusUtil;
import org.polarsys.capella.core.platform.sirius.clipboard.util.StorageLocation;

public class CapellaDiagramPasteCommand
extends AbstractResultCommand {
    private List<View> targets;
    private String suffix;
    private Map<DRepresentationElement, DRepresentationElement> pastedSiriusElementsMapping;
    private boolean isStandbyUsage;
    private boolean isRestoreStyles;

    public CapellaDiagramPasteCommand(List<? extends View> targets) {
        this(targets, false);
    }

    public CapellaDiagramPasteCommand(List<? extends View> targets, boolean restoreStyles) {
        assert (targets != null);
        this.isRestoreStyles = restoreStyles;
        this.targets = new ArrayList<View>(targets);
        this.suffix = null;
        this.pastedSiriusElementsMapping = new HashMap<DRepresentationElement, DRepresentationElement>();
        this.isStandbyUsage = this.checkStandbyUsage();
    }

    public Map<DRepresentationElement, DRepresentationElement> getPastedSiriusElementsOrigins() {
        return Collections.unmodifiableMap(this.pastedSiriusElementsMapping);
    }

    public void run() {
        EObject semanticSource = this.getSemanticSource();
        EObject semanticTarget = this.getSemanticTarget();
        if (semanticSource == null || semanticTarget == null) {
            return;
        }
        List<EObject> semanticOrigins = this.getSemanticRootsForCopy(CapellaDiagramClipboard.getInstance().getSiriusElements(), semanticTarget);
        List<EObject> semanticCopies = this.pasteCapellaElements(semanticOrigins, semanticSource, semanticTarget);
        if (semanticCopies == null) {
            return;
        }
        UniqueEList<EObject> rawAllSiriusOrigins = MiscUtil.getContentSet(CapellaDiagramClipboard.getInstance().getSiriusElements());
        List<DSemanticDecorator> allSiriusOrigins = MiscUtil.filter(rawAllSiriusOrigins, DSemanticDecorator.class);
        for (View target : this.targets) {
            EcoreUtil.resolveAll((EObject)target);
        }
        DSemanticDecorator siriusTarget = LayerUtil.getSiriusElement(this.getGmfTarget());
        CapellaDiagramClipboard clipboard = CapellaDiagramClipboard.getInstance();
        if (clipboard.isEmpty() || SiriusUtil.layoutIsConstrained((EObject)siriusTarget)) {
            this.setResults(Collections.emptyList());
            return;
        }
        String data = clipboard.getSiriusData();
        Collection<EObject> pastedSiriusElements = this.pasteSiriusElements(data, (EObject)siriusTarget);
        List<EObject> result = this.reconcileSiriusAndSemanticLayers(pastedSiriusElements, allSiriusOrigins, semanticOrigins, semanticCopies);
        for (EObject eObj : result) {
            this.resolveIncoherences(eObj);
        }
        this.setResults(result);
    }

    private void resolveIncoherences(EObject eObj) {
        if (eObj instanceof DNode) {
            DNode aNode = (DNode)eObj;
            ArrayList<DEdge> incomingEdgesToRemove = new ArrayList<DEdge>();
            for (DEdge anEdge : aNode.getIncomingEdges()) {
                if (anEdge.getTargetNode() == aNode) continue;
                incomingEdgesToRemove.add(anEdge);
            }
            for (DEdge toRemove : incomingEdgesToRemove) {
                aNode.getIncomingEdges().remove((Object)toRemove);
            }
            ArrayList<DEdge> outgoingEdgesToRemove = new ArrayList<DEdge>();
            for (DEdge anEdge : aNode.getOutgoingEdges()) {
                if (anEdge.getSourceNode() == aNode) continue;
                outgoingEdgesToRemove.add(anEdge);
            }
            for (DEdge toRemove : outgoingEdgesToRemove) {
                aNode.getOutgoingEdges().remove((Object)toRemove);
            }
        }
        for (EObject child : eObj.eContents()) {
            this.resolveIncoherences(child);
        }
    }

    protected boolean checkStandbyUsage() {
        HashSet<DSemanticDecorator> copySelection = new HashSet<DSemanticDecorator>(CapellaDiagramClipboard.getInstance().getSiriusElements());
        HashSet<DSemanticDecorator> pasteSelection = new HashSet<DSemanticDecorator>(LayerUtil.toSirius(this.targets));
        return copySelection.equals(pasteSelection);
    }

    public View getGmfTarget() {
        View result = this.targets.get(0);
        if (this.isStandbyUsage && result.eContainer() instanceof View && !(result.eContainer() instanceof Edge)) {
            result = (View)result.eContainer();
        }
        return result;
    }

    protected EObject getSemanticSource() {
        List<View> gmfOrigins = CapellaDiagramClipboard.getInstance().getGmfElements();
        List<View> gmfRoots = MiscUtil.getRoots(gmfOrigins);
        List<EObject> semanticGmfRoots = LayerUtil.toSemanticLevel(gmfRoots);
        EObject result = MiscUtil.getCommonAncestor(semanticGmfRoots, false);
        if (result == null) {
            View gmfSource = GmfUtil.getCommonViewAncestor(gmfOrigins);
            result = LayerUtil.toSemanticLevel(gmfSource);
        }
        return result;
    }

    protected EObject getSemanticTarget() {
        return DiagramBusinessHelper.getInstance().getRepresentedStorage(this.getGmfTarget());
    }

    protected List<EObject> reconcileSiriusAndSemanticLayers(Iterable<? extends EObject> siriusElements, Iterable<? extends EObject> siriusOrigins, List<EObject> semanticOrigins, List<EObject> semanticCopies) {
        LinkedList<EObject> result = new LinkedList<EObject>();
        ArrayList<EObject> toDelete = new ArrayList<EObject>();
        for (EObject eObject : siriusElements) {
            this.reconcileSiriusElement(eObject, semanticOrigins, semanticCopies, siriusOrigins, result, toDelete);
            TreeIterator it = eObject.eAllContents();
            while (it.hasNext()) {
                this.reconcileSiriusElement((EObject)it.next(), semanticOrigins, semanticCopies, siriusOrigins, result, toDelete);
            }
        }
        for (EObject eObject : toDelete) {
            EcoreUtil.remove((EObject)eObject);
        }
        return result;
    }

    protected void reconcileSiriusElement(EObject siriusElement, List<EObject> semanticOrigins, List<EObject> semanticCopies, Iterable<? extends EObject> allSiriusOrigins, List<EObject> result, Collection<EObject> toDelete) {
        if (siriusElement instanceof DRepresentationElement) {
            DRepresentationElement representation = (DRepresentationElement)siriusElement;
            EObject currentTarget = representation.getTarget();
            EObject newTarget = MiscUtil.getCorrespondingInStructure(semanticOrigins, currentTarget, semanticCopies);
            if (newTarget != null) {
                DRepresentationElement origin = this.getCounterpart(representation, allSiriusOrigins);
                representation.setTarget(newTarget);
                if (origin.getTarget() != null) {
                    representation.getSemanticElements().remove((Object)origin.getTarget());
                }
                representation.getSemanticElements().add((Object)newTarget);
                String name = NamingUtil.getName(newTarget);
                if (name != null) {
                    representation.setName(name);
                }
                result.add((EObject)representation);
                this.pastedSiriusElementsMapping.put(representation, origin);
            } else {
                toDelete.add((EObject)representation);
            }
        }
    }

    protected DRepresentationElement getCounterpart(DRepresentationElement element, Iterable<? extends EObject> candidates) {
        for (EObject eObject : candidates) {
            if (!(eObject instanceof DRepresentationElement) || !this.areSimilarSiriusElements(element, (DRepresentationElement)eObject)) continue;
            return (DRepresentationElement)eObject;
        }
        return null;
    }

    protected boolean areSimilarSiriusElements(DRepresentationElement element1, DRepresentationElement element2) {
        return element1.getTarget() == element2.getTarget() && element1.getMapping() == element2.getMapping();
    }

    protected Collection<EObject> pasteSiriusElements(String data, EObject target) {
        if (!(target.eResource() instanceof XMLResource)) {
            throw new RuntimeException(Messages.CapellaDiagramPasteAction_Unsupported);
        }
        Collection result = ClipboardUtil.pasteElementsFromString((String)data, (EObject)target, null, null);
        if (result != null && !result.isEmpty()) {
            DDiagram siriusDiagram;
            if (!(target instanceof DDiagram) && (siriusDiagram = SiriusUtil.getDiagram(target)) != null) {
                for (EObject pasted : result) {
                    if (!(pasted instanceof DEdge) || pasted.eContainer() == siriusDiagram) continue;
                    siriusDiagram.getOwnedDiagramElements().add((Object)((DEdge)pasted));
                }
            }
            if (this.isRestoreStyles) {
                for (EObject pasted : result) {
                    if (!(pasted instanceof DDiagramElement)) continue;
                    DDiagramElement element = (DDiagramElement)pasted;
                    Session session = SessionManager.INSTANCE.getSession(element.getTarget());
                    MappingHelper mappingHelper = new MappingHelper(session.getInterpreter());
                    Style bestStyle = mappingHelper.getBestStyle(element.getDiagramElementMapping(), element.getTarget(), pasted, pasted.eContainer(), element.getParentDiagram());
                    new SetStyleSwitch(bestStyle).doSwitch(pasted);
                }
            }
        }
        return result;
    }

    protected List<EObject> pasteCapellaElements(List<EObject> origins, EObject source, EObject target) {
        List<EObject> result = null;
        List<StorageLocation> locations = this.getInstantiationLocationsForAddition(origins, source, target);
        if (locations != null) {
            assert (origins.size() == locations.size());
            this.suffix = this.getCommonSuffix(origins, locations);
            List<EObject> copies = this.copyAll(origins, this.suffix);
            List<EObject> orderedOrigins = this.sortBySibling(origins);
            for (EObject orderedOrigin : orderedOrigins) {
                int index = origins.indexOf(orderedOrigin);
                locations.get(index).applyOn(copies.get(index));
            }
            this.duplicateExternalReferences(origins, copies);
            result = copies;
            this.filterOutUnrelevantSemanticElements(copies);
            DSemanticDecorator siriusContext = null;
            View view = this.getGmfTarget();
            if (view.getElement() instanceof DSemanticDecorator) {
                siriusContext = (DSemanticDecorator)view.getElement();
            }
            for (EObject copy : copies) {
                BusinessHelper.getInstance().addImplicitElements(copy, target, siriusContext);
            }
        }
        return result;
    }

    protected <T extends EObject> List<T> copyAll(Collection<? extends T> elts, final String suffix) {
        EcoreUtil.Copier copier = new EcoreUtil.Copier(){

            public EObject copy(EObject eObject) {
                EObject copy = super.copy(eObject);
                MiscUtil.setNewId(copy);
                NamingUtil.suffixName(copy, suffix);
                return copy;
            }

            protected void copyReference(EReference ref, EObject eObject, EObject copyEObject) {
                super.copyReference(ref, eObject, copyEObject);
                if (!ref.isContainment() && MiscUtil.supportsAddition(ref) && !BusinessHelper.getInstance().updateWithDuplicatedValues(ref)) {
                    EList refValues = (EList)copyEObject.eGet((EStructuralFeature)ref);
                    refValues.retainAll(this.values());
                }
            }
        };
        Collection result = copier.copyAll(elts);
        copier.copyReferences();
        return new BasicEList<T>(result){

            protected boolean useEquals() {
                return false;
            }
        };
    }

    protected List<EObject> sortBySibling(Collection<EObject> elements) {
        ArrayList<EObject> result = new ArrayList<EObject>(elements.size());
        HashMap<StorageLocation, ArrayList<EObject>> siblings = new HashMap<StorageLocation, ArrayList<EObject>>();
        for (EObject element : elements) {
            StorageLocation location = new StorageLocation(element.eContainer(), element.eContainmentFeature());
            ArrayList<EObject> localSiblings = (ArrayList<EObject>)siblings.get(location);
            if (localSiblings == null) {
                localSiblings = new ArrayList<EObject>();
                siblings.put(location, localSiblings);
            }
            localSiblings.add(element);
        }
        Collection partialLists = siblings.values();
        Comparator<EObject> siblingsComparator = new Comparator<EObject>(){

            @Override
            public int compare(EObject o1, EObject o2) {
                return this.getContainmentIndex(o1) - this.getContainmentIndex(o2);
            }

            private int getContainmentIndex(EObject element) {
                EReference containment;
                int index = 0;
                if (element != null && (containment = element.eContainmentFeature()) != null && containment.isMany()) {
                    List peers = (List)element.eContainer().eGet((EStructuralFeature)containment);
                    index = peers.indexOf(element);
                }
                return index;
            }
        };
        for (List partialList : partialLists) {
            Collections.sort(partialList, siblingsComparator);
        }
        for (List partialList : partialLists) {
            result.addAll(partialList);
        }
        return result;
    }

    protected void filterOutUnrelevantSemanticElements(List<EObject> copies) {
        ArrayList<EObject> toDelete = new ArrayList<EObject>();
        for (EObject copy : copies) {
            TreeIterator it = copy.eAllContents();
            while (it.hasNext()) {
                EObject current = (EObject)it.next();
                if (BusinessHelper.getInstance().isMeaningfulWithin(current, copies)) continue;
                it.prune();
                toDelete.add(current);
            }
        }
        for (EObject deletionTarget : toDelete) {
            MiscUtil.deleteRec(deletionTarget);
        }
    }

    protected void duplicateExternalReferences(List<EObject> origins, List<EObject> copies) {
        assert (origins.size() == copies.size());
        for (EObject origin : origins) {
            this.duplicateExternalIncomingReferences(origins, copies, origin);
            TreeIterator it = origin.eAllContents();
            while (it.hasNext()) {
                EObject child = (EObject)it.next();
                this.duplicateExternalIncomingReferences(origins, copies, child);
            }
        }
    }

    protected void duplicateExternalIncomingReferences(List<EObject> origins, List<EObject> copies, EObject origin) {
        assert (origins.size() == copies.size());
        EObject copy = MiscUtil.getCorrespondingInStructure(origins, origin, copies);
        if (copy == null) {
            return;
        }
        List<EStructuralFeature.Setting> settings = MiscUtil.getExternalSettingsForAddition(origin, origins);
        for (EStructuralFeature.Setting setting : settings) {
            List opposites = (List)setting.getEObject().eGet(setting.getEStructuralFeature());
            opposites.add(copy);
        }
    }

    protected String getCommonSuffix(List<EObject> origins, List<StorageLocation> locations) {
        ArrayList<List<EObject>> childrenList = new ArrayList<List<EObject>>(origins.size());
        ArrayList<String> names = new ArrayList<String>(origins.size());
        int i = 0;
        while (i < origins.size()) {
            names.add(NamingUtil.getName(origins.get(i)));
            childrenList.add(this.getElementsAtLocation(locations.get(i)));
            ++i;
        }
        String result = NamingUtil.getSuffixForUniqueNames(childrenList, names);
        return result;
    }

    protected List<EObject> getSemanticRootsForCopy(Collection<? extends EObject> selectedSiriusElements, EObject semanticTarget) {
        List<EObject> result = new ArrayList();
        for (EObject eObject : selectedSiriusElements) {
            if (!(eObject instanceof DSemanticDecorator)) continue;
            EObject semanticElement = ((DSemanticDecorator)eObject).getTarget();
            result.add(semanticElement);
        }
        result = MiscUtil.getRoots(result);
        Set<EObject> set = BusinessHelper.getInstance().getImplicitElements(result, (Object)semanticTarget);
        result.addAll(set);
        result = MiscUtil.getRoots(result);
        return result;
    }

    protected List<StorageLocation> getInstantiationLocationsForAddition(List<EObject> elements, EObject source, EObject target) {
        ArrayList<StorageLocation> result = new ArrayList<StorageLocation>();
        for (EObject element : elements) {
            StorageLocation location = this.getInstantiationLocation(element, source, target);
            if (location.supportsAddition()) {
                result.add(location);
                continue;
            }
            return null;
        }
        return result;
    }

    protected List<EObject> getElementsAtLocation(StorageLocation location) {
        assert (location != null);
        assert (location.getContainer() != null && location.getContainment() != null);
        List result = null;
        if (location.getContainment().isMany()) {
            result = (List)location.getContainer().eGet((EStructuralFeature)location.getContainment());
        }
        return result;
    }

    protected StorageLocation getInstantiationLocation(EObject element, EObject source, EObject target) {
        StorageLocation result = null;
        EReference containment = null;
        EObject container = null;
        if (element != null) {
            containment = element.eContainmentFeature();
            container = !this.isStandbyUsage && element.eContainer() == source && target.eClass().getEAllContainments().contains((Object)containment) && !this.elementIsPart(element) ? target : element.eContainer();
        }
        if (container != null && containment != null) {
            StorageLocation location = new StorageLocation(container, containment);
            if (BusinessHelper.getInstance().isMeaningfulStorageFor(location, element)) {
                result = location;
            }
        }
        return result;
    }

    private boolean elementIsPart(EObject element) {
        return element instanceof Part;
    }

    public String getName() {
        return Messages.PasteCommand_Name;
    }
}

