/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.core.platform.sirius.clipboard.util;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.sirius.viewpoint.DSemanticDecorator;
import org.polarsys.capella.common.data.activity.ActivityNode;
import org.polarsys.capella.common.data.modellingcore.AbstractTrace;
import org.polarsys.capella.common.data.modellingcore.AbstractType;
import org.polarsys.capella.common.data.modellingcore.InformationsExchanger;
import org.polarsys.capella.common.data.modellingcore.ModelElement;
import org.polarsys.capella.common.data.modellingcore.TraceableElement;
import org.polarsys.capella.core.data.capellacore.CapellacorePackage;
import org.polarsys.capella.core.data.capellacore.EnumerationPropertyValue;
import org.polarsys.capella.core.data.cs.AbstractActor;
import org.polarsys.capella.core.data.cs.AbstractDeploymentLink;
import org.polarsys.capella.core.data.cs.AbstractPhysicalLinkEnd;
import org.polarsys.capella.core.data.cs.BlockArchitecture;
import org.polarsys.capella.core.data.cs.Component;
import org.polarsys.capella.core.data.cs.CsFactory;
import org.polarsys.capella.core.data.cs.CsPackage;
import org.polarsys.capella.core.data.cs.DeployableElement;
import org.polarsys.capella.core.data.cs.DeploymentTarget;
import org.polarsys.capella.core.data.cs.Part;
import org.polarsys.capella.core.data.cs.PhysicalLink;
import org.polarsys.capella.core.data.cs.PhysicalLinkEnd;
import org.polarsys.capella.core.data.cs.SystemComponent;
import org.polarsys.capella.core.data.ctx.Actor;
import org.polarsys.capella.core.data.ctx.SystemAnalysis;
import org.polarsys.capella.core.data.ctx.SystemFunction;
import org.polarsys.capella.core.data.epbs.ConfigurationItem;
import org.polarsys.capella.core.data.epbs.EPBSArchitecture;
import org.polarsys.capella.core.data.fa.AbstractFunction;
import org.polarsys.capella.core.data.fa.ComponentExchange;
import org.polarsys.capella.core.data.fa.ComponentExchangeEnd;
import org.polarsys.capella.core.data.fa.ComponentFunctionalAllocation;
import org.polarsys.capella.core.data.fa.FaFactory;
import org.polarsys.capella.core.data.fa.FaPackage;
import org.polarsys.capella.core.data.fa.FunctionPkg;
import org.polarsys.capella.core.data.fa.FunctionalExchange;
import org.polarsys.capella.core.data.information.Association;
import org.polarsys.capella.core.data.information.Class;
import org.polarsys.capella.core.data.information.InformationPackage;
import org.polarsys.capella.core.data.information.Property;
import org.polarsys.capella.core.data.information.datatype.Enumeration;
import org.polarsys.capella.core.data.information.datavalue.DatavalueFactory;
import org.polarsys.capella.core.data.information.datavalue.EnumerationLiteral;
import org.polarsys.capella.core.data.information.datavalue.LiteralNumericValue;
import org.polarsys.capella.core.data.information.datavalue.NumericValue;
import org.polarsys.capella.core.data.interaction.AbstractEnd;
import org.polarsys.capella.core.data.interaction.Execution;
import org.polarsys.capella.core.data.interaction.InstanceRole;
import org.polarsys.capella.core.data.interaction.SequenceMessage;
import org.polarsys.capella.core.data.la.LogicalActor;
import org.polarsys.capella.core.data.la.LogicalArchitecture;
import org.polarsys.capella.core.data.la.LogicalComponent;
import org.polarsys.capella.core.data.la.LogicalFunction;
import org.polarsys.capella.core.data.oa.Entity;
import org.polarsys.capella.core.data.oa.OperationalActivity;
import org.polarsys.capella.core.data.oa.OperationalAnalysis;
import org.polarsys.capella.core.data.pa.PhysicalActor;
import org.polarsys.capella.core.data.pa.PhysicalArchitecture;
import org.polarsys.capella.core.data.pa.PhysicalComponent;
import org.polarsys.capella.core.data.pa.PhysicalComponentNature;
import org.polarsys.capella.core.data.pa.PhysicalFunction;
import org.polarsys.capella.core.data.pa.deployment.DeploymentFactory;
import org.polarsys.capella.core.data.pa.deployment.PartDeploymentLink;
import org.polarsys.capella.core.model.handler.helpers.CapellaProjectHelper;
import org.polarsys.capella.core.model.preferences.CapellaModelPreferencesPlugin;
import org.polarsys.capella.core.platform.sirius.clipboard.util.MiscUtil;
import org.polarsys.capella.core.platform.sirius.clipboard.util.StorageLocation;

public class BusinessHelper {
    private static final BusinessHelper INSTANCE = new BusinessHelper();
    private static final Collection<EReference> NON_UPDATING_FEATURES = Arrays.asList(InformationPackage.eINSTANCE.getPort_ProvidedInterfaces(), InformationPackage.eINSTANCE.getPort_RequiredInterfaces(), CapellacorePackage.eINSTANCE.getAbstractPropertyValue_ValuedElements(), CapellacorePackage.eINSTANCE.getPropertyValueGroup_ValuedElements(), CapellacorePackage.eINSTANCE.getCapellaElement_AppliedPropertyValues(), CapellacorePackage.eINSTANCE.getCapellaElement_AppliedPropertyValueGroups());

    public static BusinessHelper getInstance() {
        return INSTANCE;
    }

    private BusinessHelper() {
    }

    public Collection<EObject> addImplicitElements(EObject element, Object context, DSemanticDecorator graphicalContext) {
        HashSet<EObject> result = new HashSet<EObject>();
        EObject container = element.eContainer();
        EObject graphicalTarget = null;
        if (graphicalContext != null) {
            graphicalTarget = graphicalContext.getTarget();
        }
        if (container instanceof Component && element instanceof Component) {
            Component ownerC = (Component)container;
            Component eltC = (Component)element;
            if (eltC.getAbstractTypedElements().isEmpty()) {
                Part addition = this.createPartFor((AbstractType)eltC);
                ownerC.getOwnedFeatures().add((Object)addition);
                result.add((EObject)addition);
                if (graphicalTarget instanceof Part && container instanceof PhysicalComponent && container.eContainer() instanceof PhysicalComponent && element instanceof PhysicalComponent && ((PhysicalComponent)container).getNature() == PhysicalComponentNature.NODE && ((PhysicalComponent)element).getNature() == PhysicalComponentNature.BEHAVIOR) {
                    this.deployPhysicalPartOn(addition, (Part)graphicalTarget);
                }
            }
        } else if (element instanceof Part && graphicalTarget instanceof Part && ((Part)element).getAbstractType() instanceof PhysicalComponent && ((Part)graphicalTarget).getAbstractType() instanceof PhysicalComponent && ((PhysicalComponent)((Part)element).getAbstractType()).getNature() == PhysicalComponentNature.BEHAVIOR && ((PhysicalComponent)((Part)graphicalTarget).getAbstractType()).getNature() == PhysicalComponentNature.NODE) {
            boolean isAllocated;
            EList deployingParts = ((Part)element).getDeployingParts();
            boolean bl = isAllocated = deployingParts.size() > 0;
            if (!isAllocated) {
                this.deployPhysicalPartOn((Part)element, (Part)graphicalTarget);
            }
        } else if (element instanceof AbstractFunction && (context instanceof Component || graphicalTarget instanceof Part)) {
            boolean mustCreate;
            AbstractFunction function = (AbstractFunction)element;
            Component component = null;
            if (context instanceof Component) {
                component = (Component)context;
            } else {
                Part part = (Part)graphicalTarget;
                if (part.getAbstractType() instanceof Component) {
                    component = (Component)part.getAbstractType();
                }
            }
            boolean bl = mustCreate = component != null;
            if (mustCreate) {
                BlockArchitecture functionArchi = this.getBlockArchitecture((EObject)function);
                BlockArchitecture componentArchi = this.getBlockArchitecture((EObject)component);
                if (functionArchi != null && componentArchi != null) {
                    boolean bl2 = mustCreate = functionArchi.eClass() == componentArchi.eClass();
                }
            }
            if (mustCreate && component instanceof PhysicalComponent) {
                PhysicalComponent pc = (PhysicalComponent)component;
                boolean bl3 = mustCreate = pc.getNature() != PhysicalComponentNature.NODE;
            }
            if (mustCreate) {
                boolean isAllocated;
                for (ComponentFunctionalAllocation existingAlloc : function.getComponentFunctionalAllocations()) {
                    if (existingAlloc.getBlock() != component) continue;
                    mustCreate = false;
                    break;
                }
                EList allocationBlocks = function.getAllocationBlocks();
                boolean bl4 = isAllocated = allocationBlocks.size() > 0;
                if (mustCreate && !isAllocated) {
                    ComponentFunctionalAllocation allocation = FaFactory.eINSTANCE.createComponentFunctionalAllocation();
                    MiscUtil.setNewId((EObject)allocation);
                    allocation.setSourceElement((TraceableElement)component);
                    allocation.setTargetElement((TraceableElement)function);
                    component.getOwnedFunctionalAllocation().add((Object)allocation);
                    result.add((EObject)allocation);
                }
            }
        } else if (element instanceof EnumerationLiteral && context instanceof Enumeration) {
            ((EnumerationLiteral)element).setAbstractType((AbstractType)context);
        }
        return result;
    }

    private void deployPhysicalPartOn(Part element, Part location) {
        PartDeploymentLink link = DeploymentFactory.eINSTANCE.createPartDeploymentLink();
        MiscUtil.setNewId((EObject)link);
        link.setLocation((DeploymentTarget)location);
        link.setDeployedElement((DeployableElement)element);
        location.getOwnedDeploymentLinks().add((Object)link);
    }

    private Part createPartFor(AbstractType type) {
        Part result = CsFactory.eINSTANCE.createPart();
        MiscUtil.setNewId((EObject)result);
        result.setName(type.getName());
        LiteralNumericValue minCard = DatavalueFactory.eINSTANCE.createLiteralNumericValue("minCard");
        minCard.setValue("1");
        result.setOwnedMinCard((NumericValue)minCard);
        LiteralNumericValue maxCard = DatavalueFactory.eINSTANCE.createLiteralNumericValue("maxCard");
        maxCard.setValue("1");
        result.setOwnedMaxCard((NumericValue)maxCard);
        result.setAbstractType(type);
        return result;
    }

    public Set<EObject> getImplicitElements(EObject element, Object context) {
        HashSet<EObject> result = new HashSet<EObject>();
        if (element instanceof Part && !this.isMultipartAllowed(element)) {
            result.add((EObject)((Part)element).getAbstractType());
        } else if (element instanceof Component && !this.isMultipartAllowed(element)) {
            EList typedElements = ((Component)element).getAbstractTypedElements();
            if (typedElements.size() == 1 && typedElements.get(0) instanceof Part) {
                result.add((EObject)typedElements.get(0));
            }
        } else if (element instanceof Association) {
            result.addAll((Collection<EObject>)((Association)element).getNavigableMembers());
        } else if (element instanceof SequenceMessage) {
            SequenceMessage msg = (SequenceMessage)element;
            result.add((EObject)msg.getSendingEnd());
            result.add((EObject)msg.getSendingEnd().getEvent());
            result.add((EObject)msg.getReceivingEnd());
            result.add((EObject)msg.getReceivingEnd().getEvent());
        } else if (element instanceof Execution) {
            Execution msg = (Execution)element;
            result.add((EObject)msg.getStart());
            if (msg.getStart() instanceof AbstractEnd) {
                result.add((EObject)((AbstractEnd)msg.getStart()).getEvent());
            }
            result.add((EObject)msg.getFinish());
            if (msg.getFinish() instanceof AbstractEnd) {
                result.add((EObject)((AbstractEnd)msg.getFinish()).getEvent());
            }
        } else if (element instanceof InstanceRole) {
            result.add((EObject)((InstanceRole)element).getRepresentedInstance());
        }
        return result;
    }

    public final Set<EObject> getImplicitElements(Collection<? extends EObject> elements, Object context) {
        HashSet<EObject> result = new HashSet<EObject>();
        for (EObject eObject : elements) {
            result.addAll(this.getImplicitElements(eObject, context));
        }
        return result;
    }

    private boolean hasFixedCardinality(EReference reference) {
        return CsPackage.eINSTANCE.getPhysicalLink_LinkEnds() == reference || InformationPackage.eINSTANCE.getAssociation_NavigableMembers() == reference;
    }

    public boolean isMeaningfulWithin(EObject element, Collection<? extends EObject> contexts) {
        Property property;
        AbstractType propertyType;
        if (element instanceof EnumerationPropertyValue) {
            return false;
        }
        ArrayList<Object> mustBeIncluded = new ArrayList<Object>();
        if (element instanceof AbstractTrace) {
            AbstractTrace abstractTrace = (AbstractTrace)element;
            mustBeIncluded.add(abstractTrace.getSourceElement());
            mustBeIncluded.add(abstractTrace.getTargetElement());
        } else if (element instanceof FunctionalExchange) {
            FunctionalExchange functionalExchange = (FunctionalExchange)element;
            mustBeIncluded.add(functionalExchange.getSource());
            mustBeIncluded.add(functionalExchange.getTarget());
        } else if (element instanceof ComponentExchange) {
            ComponentExchange componentExchange = (ComponentExchange)element;
            InformationsExchanger source = componentExchange.getSource();
            if (source instanceof ComponentExchangeEnd) {
                mustBeIncluded.add(((ComponentExchangeEnd)source).getPart());
                mustBeIncluded.add(((ComponentExchangeEnd)source).getPort());
            } else {
                mustBeIncluded.add(source);
            }
            Iterator target = componentExchange.getTarget();
            if (target instanceof ComponentExchangeEnd) {
                mustBeIncluded.add(((ComponentExchangeEnd)target).getPart());
                mustBeIncluded.add(((ComponentExchangeEnd)target).getPort());
            } else {
                mustBeIncluded.add(target);
            }
        } else if (element instanceof PhysicalLink) {
            PhysicalLink physicalLink = (PhysicalLink)element;
            for (AbstractPhysicalLinkEnd end : physicalLink.getLinkEnds()) {
                if (end instanceof PhysicalLinkEnd) {
                    mustBeIncluded.add(((PhysicalLinkEnd)end).getPart());
                    mustBeIncluded.add(((PhysicalLinkEnd)end).getPort());
                    continue;
                }
                mustBeIncluded.add(end);
            }
        } else if (element instanceof AbstractDeploymentLink && !this.isMultipleDeploymentAllowed(element)) {
            AbstractDeploymentLink abstractDeploymentLink = (AbstractDeploymentLink)element;
            DeployableElement deployed = abstractDeploymentLink.getDeployedElement();
            mustBeIncluded.add(deployed);
        } else if (element instanceof Property && (propertyType = (property = (Property)element).getAbstractType()) instanceof Class) {
            Class propertyClass = (Class)propertyType;
            EObject propertyContainer = property.eContainer();
            if (!propertyClass.isIsPrimitive() && contexts.contains(propertyContainer) && propertyContainer instanceof Class) {
                boolean found = false;
                Iterator<? extends EObject> it = contexts.iterator();
                while (!found && it.hasNext()) {
                    Association association;
                    EObject context = it.next();
                    if (!(context instanceof Association) || !(association = (Association)context).getNavigableMembers().contains((Object)property)) continue;
                    found = true;
                }
                if (!found) {
                    return false;
                }
            }
        }
        for (EObject eObject : mustBeIncluded) {
            if (eObject != null && EcoreUtil.isAncestor(contexts, (EObject)eObject)) continue;
            return false;
        }
        return true;
    }

    public boolean isMeaningfulStorageFor(StorageLocation loc, EObject toStore) {
        boolean result = true;
        EObject container = loc.getContainer();
        if (toStore instanceof AbstractFunction) {
            boolean bl = result = container instanceof FunctionPkg || container instanceof AbstractFunction;
            if (result) {
                BlockArchitecture archi = this.getBlockArchitecture(container);
                if (toStore instanceof SystemFunction) {
                    result = archi instanceof SystemAnalysis;
                } else if (toStore instanceof LogicalFunction) {
                    result = archi instanceof LogicalArchitecture;
                } else if (toStore instanceof PhysicalFunction) {
                    result = archi instanceof PhysicalArchitecture;
                } else if (toStore instanceof OperationalActivity) {
                    result = archi instanceof OperationalAnalysis;
                }
            }
        } else if (toStore instanceof FunctionalExchange) {
            EObject pinOwner;
            FunctionalExchange exchange = (FunctionalExchange)toStore;
            ActivityNode pin = exchange.getSource();
            if (pin == null) {
                pin = exchange.getTarget();
            }
            if (pin != null && (pinOwner = pin.eContainer()) != null) {
                result = container.eClass().isSuperTypeOf(pinOwner.eClass());
            }
        } else if (toStore instanceof Part && ((Part)toStore).getAbstractType() instanceof Component && (container instanceof Part || container instanceof Component)) {
            Component toStoreType = (Component)((Part)toStore).getAbstractType();
            Component containerType = container instanceof Component ? (Component)container : (Component)((Part)container).getAbstractType();
            result = this.componentsMatchForStorage(containerType, toStoreType);
        }
        return result;
    }

    private boolean componentsMatchForStorage(Component container, Component toStore) {
        BlockArchitecture architecture = this.getBlockArchitecture((EObject)container);
        if (architecture instanceof LogicalArchitecture) {
            return toStore instanceof LogicalComponent || toStore instanceof LogicalActor;
        }
        if (architecture instanceof PhysicalArchitecture) {
            return toStore instanceof PhysicalComponent || toStore instanceof PhysicalActor;
        }
        if (architecture instanceof SystemAnalysis) {
            return toStore instanceof SystemComponent || toStore instanceof Actor;
        }
        if (architecture instanceof OperationalAnalysis) {
            return toStore instanceof Entity;
        }
        if (architecture instanceof EPBSArchitecture) {
            return toStore instanceof ConfigurationItem;
        }
        return false;
    }

    private BlockArchitecture getBlockArchitecture(EObject element) {
        if (element == null) {
            return null;
        }
        if (element instanceof BlockArchitecture) {
            return (BlockArchitecture)element;
        }
        return this.getBlockArchitecture(element.eContainer());
    }

    private boolean isMultipartAllowed(EObject element) {
        return CapellaProjectHelper.TriStateBoolean.True.equals((Object)CapellaProjectHelper.isReusableComponentsDriven((EObject)((ModelElement)element)));
    }

    private boolean isMultipleDeploymentAllowed(EObject element) {
        return CapellaModelPreferencesPlugin.getDefault().isMultipleDeploymentAllowed();
    }

    public boolean storageCanBeDerived(EObject element) {
        return element instanceof FunctionalExchange || element instanceof ComponentExchange || element instanceof PhysicalLink || element instanceof Part && ((Part)element).getType() instanceof AbstractActor;
    }

    public StorageLocation deriveStorage(EObject element, List<? extends StorageLocation> locations, List<? extends EObject> peers) {
        PhysicalLink exchange;
        EList ends;
        assert (locations.size() == peers.size());
        StorageLocation result = null;
        ModelElement container = null;
        EReference containment = null;
        if (element instanceof FunctionalExchange) {
            FunctionalExchange exchange2 = (FunctionalExchange)element;
            container = this.deriveLinkStorage((EObject)exchange2.getSource(), (EObject)exchange2.getTarget(), locations, peers);
            if (container instanceof AbstractFunction) {
                containment = FaPackage.eINSTANCE.getAbstractFunction_OwnedFunctionalExchanges();
            }
        } else if (element instanceof ComponentExchange) {
            ComponentExchange exchange3 = (ComponentExchange)element;
            container = this.deriveLinkStorage((EObject)exchange3.getSource(), (EObject)exchange3.getTarget(), locations, peers);
            if (container instanceof Component) {
                containment = FaPackage.eINSTANCE.getAbstractFunctionalBlock_OwnedComponentExchanges();
            }
        } else if (element instanceof PhysicalLink && 2 == (ends = (exchange = (PhysicalLink)element).getLinkEnds()).size() && (container = this.deriveLinkStorage((EObject)ends.get(0), (EObject)ends.get(1), locations, peers)) instanceof Component) {
            containment = CsPackage.eINSTANCE.getComponent_OwnedPhysicalLinks();
        }
        if (container != null && containment != null) {
            result = new StorageLocation((EObject)container, containment);
        }
        return result;
    }

    private ModelElement deriveLinkStorage(EObject source, EObject target, List<? extends StorageLocation> locations, List<? extends EObject> peers) {
        ModelElement result = null;
        EObject sourceElement = this.getLinkDerivationReferenceElement(source);
        EObject targetElement = this.getLinkDerivationReferenceElement(target);
        try {
            int sourceIndex = peers.indexOf(sourceElement);
            int targetIndex = peers.indexOf(targetElement);
            StorageLocation sourceLoc = locations.get(sourceIndex);
            StorageLocation targetLoc = locations.get(targetIndex);
            EObject ancestor = MiscUtil.getCommonAncestor(sourceLoc.getContainer(), targetLoc.getContainer());
            if (ancestor instanceof ModelElement) {
                result = (ModelElement)ancestor;
            }
        }
        catch (RuntimeException runtimeException) {
            // empty catch block
        }
        return result;
    }

    private EObject getLinkDerivationReferenceElement(EObject element) {
        ComponentExchangeEnd end;
        Object result = element instanceof ComponentExchangeEnd ? ((end = (ComponentExchangeEnd)element).getPart() != null ? end.getPart() : end.getPort()) : (element instanceof PhysicalLinkEnd ? ((end = (PhysicalLinkEnd)element).getPart() != null ? end.getPart() : end.getPort()) : element);
        return result.eContainer();
    }

    public boolean updateWithDuplicatedValues(EReference reference) {
        return !this.hasFixedCardinality(reference) && !NON_UPDATING_FEATURES.contains(reference);
    }
}

