/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.core.platform.sirius.clipboard.util;

import java.util.HashSet;
import java.util.List;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.ecore.EObject;
import org.polarsys.capella.common.data.modellingcore.AbstractNamedElement;

public final class NamingUtil {
    private static final String DEFAULT_SUFFIX_START = "_";

    private NamingUtil() {
    }

    public static String getName(EObject elt) {
        String result = null;
        if (elt instanceof AbstractNamedElement) {
            result = ((AbstractNamedElement)elt).getName();
        }
        return result;
    }

    public static boolean suffixName(EObject elt, String suffix) {
        AbstractNamedElement namedElement;
        String name;
        boolean result = false;
        if (suffix != null && elt instanceof AbstractNamedElement && (name = (namedElement = (AbstractNamedElement)elt).getName()) != null && name.length() > 0) {
            String newName = NamingUtil.buildString(name, suffix);
            try {
                namedElement.setName(newName);
                result = true;
            }
            catch (RuntimeException runtimeException) {
                // empty catch block
            }
        }
        return result;
    }

    public static void suffixNameDeep(EObject elt, String suffix) {
        NamingUtil.suffixName(elt, suffix);
        TreeIterator it = elt.eAllContents();
        while (it.hasNext()) {
            NamingUtil.suffixName((EObject)it.next(), suffix);
        }
    }

    public static void suffixNamesDeep(Iterable<? extends EObject> elts, String suffix) {
        for (EObject eObject : elts) {
            NamingUtil.suffixNameDeep(eObject, suffix);
        }
    }

    public static String getSuffixForUniqueName(Iterable<? extends EObject> peers, String baseName) {
        assert (peers != null);
        int index = NamingUtil.getIndexForUniqueNameSuffix(peers, baseName);
        String suffixProposal = NamingUtil.getSuffixFromNumber(index);
        return suffixProposal;
    }

    public static String getSuffixForUniqueNames(List<? extends Iterable<? extends EObject>> peersList, List<String> baseNames) {
        assert (peersList != null && baseNames != null);
        assert (peersList.size() == baseNames.size());
        int index = 1;
        int i = 0;
        while (i < baseNames.size()) {
            String currentName = baseNames.get(i);
            if (currentName != null) {
                int indexProposal = NamingUtil.getIndexForUniqueNameSuffix(peersList.get(i), currentName);
                index = Math.max(index, indexProposal);
            }
            ++i;
        }
        String suffixProposal = NamingUtil.getSuffixFromNumber(index);
        return suffixProposal;
    }

    private static int getIndexForUniqueNameSuffix(Iterable<? extends EObject> peers, String baseName) {
        String string;
        assert (peers != null);
        String bn = baseName == null ? "" : baseName;
        HashSet<String> names = new HashSet<String>();
        for (EObject eObject : peers) {
            String current = NamingUtil.getName(eObject);
            if (current == null) continue;
            names.add(current);
        }
        int i = 0;
        while (names.contains(string = NamingUtil.applySuffixNumberOn(bn, ++i)) && i < Integer.MAX_VALUE) {
        }
        return i;
    }

    private static String applySuffixNumberOn(String base, int number) {
        return NamingUtil.buildString(base, NamingUtil.getSuffixFromNumber(number));
    }

    private static String getSuffixFromNumber(int number) {
        return NamingUtil.buildString(DEFAULT_SUFFIX_START, number);
    }

    public static String buildString(Object ... objects) {
        StringBuilder builder = new StringBuilder();
        Object[] objectArray = objects;
        int n = objects.length;
        int n2 = 0;
        while (n2 < n) {
            Object object = objectArray[n2];
            builder.append(object == null ? "" : object.toString());
            ++n2;
        }
        return builder.toString();
    }
}

