/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.core.sirius.analysis;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.apache.log4j.Logger;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.osgi.util.NLS;
import org.eclipse.sirius.diagram.AbstractDNode;
import org.eclipse.sirius.diagram.DDiagram;
import org.eclipse.sirius.diagram.DDiagramElement;
import org.eclipse.sirius.diagram.DEdge;
import org.eclipse.sirius.diagram.DNodeContainer;
import org.eclipse.sirius.diagram.EdgeTarget;
import org.eclipse.sirius.diagram.description.DiagramElementMapping;
import org.eclipse.sirius.diagram.description.EdgeMapping;
import org.eclipse.sirius.diagram.description.NodeMapping;
import org.eclipse.sirius.viewpoint.DSemanticDecorator;
import org.polarsys.capella.common.data.activity.ActivityNode;
import org.polarsys.capella.common.data.modellingcore.AbstractTrace;
import org.polarsys.capella.common.data.modellingcore.IState;
import org.polarsys.capella.common.data.modellingcore.InformationsExchanger;
import org.polarsys.capella.common.data.modellingcore.ModelElement;
import org.polarsys.capella.common.data.modellingcore.ModellingcorePackage;
import org.polarsys.capella.common.data.modellingcore.TraceableElement;
import org.polarsys.capella.common.helpers.EObjectLabelProviderHelper;
import org.polarsys.capella.common.tools.report.EmbeddedMessage;
import org.polarsys.capella.common.tools.report.config.registry.ReportManagerRegistry;
import org.polarsys.capella.core.data.capellacommon.AbstractCapabilityPkg;
import org.polarsys.capella.core.data.capellacommon.State;
import org.polarsys.capella.core.data.capellacore.CapellaElement;
import org.polarsys.capella.core.data.capellacore.NamedElement;
import org.polarsys.capella.core.data.cs.AbstractActor;
import org.polarsys.capella.core.data.cs.BlockArchitecture;
import org.polarsys.capella.core.data.cs.Component;
import org.polarsys.capella.core.data.cs.CsFactory;
import org.polarsys.capella.core.data.cs.CsPackage;
import org.polarsys.capella.core.data.cs.Part;
import org.polarsys.capella.core.data.cs.PhysicalLink;
import org.polarsys.capella.core.data.cs.PhysicalLinkCategory;
import org.polarsys.capella.core.data.cs.PhysicalLinkEnd;
import org.polarsys.capella.core.data.cs.PhysicalPath;
import org.polarsys.capella.core.data.cs.PhysicalPort;
import org.polarsys.capella.core.data.fa.AbstractFunction;
import org.polarsys.capella.core.data.fa.ComponentExchange;
import org.polarsys.capella.core.data.fa.ComponentExchangeCategory;
import org.polarsys.capella.core.data.fa.ComponentExchangeEnd;
import org.polarsys.capella.core.data.fa.ComponentPort;
import org.polarsys.capella.core.data.fa.ComponentPortAllocation;
import org.polarsys.capella.core.data.fa.ComponentPortAllocationEnd;
import org.polarsys.capella.core.data.fa.ComponentPortKind;
import org.polarsys.capella.core.data.fa.ExchangeCategory;
import org.polarsys.capella.core.data.fa.FaFactory;
import org.polarsys.capella.core.data.fa.FunctionPkg;
import org.polarsys.capella.core.data.fa.FunctionPort;
import org.polarsys.capella.core.data.fa.FunctionalChain;
import org.polarsys.capella.core.data.fa.FunctionalExchange;
import org.polarsys.capella.core.data.fa.OrientationPortKind;
import org.polarsys.capella.core.data.helpers.fa.services.FunctionExt;
import org.polarsys.capella.core.data.helpers.fa.services.FunctionPkgExt;
import org.polarsys.capella.core.data.information.Partition;
import org.polarsys.capella.core.data.information.PartitionableElement;
import org.polarsys.capella.core.data.information.Port;
import org.polarsys.capella.core.data.interaction.Scenario;
import org.polarsys.capella.core.data.oa.ActivityAllocation;
import org.polarsys.capella.core.data.oa.CommunicationMean;
import org.polarsys.capella.core.data.oa.Entity;
import org.polarsys.capella.core.data.oa.OperationalActivity;
import org.polarsys.capella.core.data.oa.Role;
import org.polarsys.capella.core.data.pa.AbstractPhysicalComponent;
import org.polarsys.capella.core.data.pa.PhysicalComponentNature;
import org.polarsys.capella.core.diagram.helpers.ContextualDiagramHelper;
import org.polarsys.capella.core.model.helpers.AbstractCapabilityPkgExt;
import org.polarsys.capella.core.model.helpers.BlockArchitectureExt;
import org.polarsys.capella.core.model.helpers.ComponentExchangeExt;
import org.polarsys.capella.core.model.helpers.ComponentExt;
import org.polarsys.capella.core.model.helpers.ComponentPortAllocationExt;
import org.polarsys.capella.core.model.helpers.FunctionalExchangeExt;
import org.polarsys.capella.core.model.helpers.PhysicalLinkExt;
import org.polarsys.capella.core.model.helpers.PortExt;
import org.polarsys.capella.core.model.helpers.ScenarioExt;
import org.polarsys.capella.core.sirius.analysis.CapellaServices;
import org.polarsys.capella.core.sirius.analysis.CsServices;
import org.polarsys.capella.core.sirius.analysis.DDiagramContents;
import org.polarsys.capella.core.sirius.analysis.DFServices;
import org.polarsys.capella.core.sirius.analysis.DiagramServices;
import org.polarsys.capella.core.sirius.analysis.FaServices;
import org.polarsys.capella.core.sirius.analysis.FunctionalChainServices;
import org.polarsys.capella.core.sirius.analysis.Messages;
import org.polarsys.capella.core.sirius.analysis.PhysicalServices;
import org.polarsys.capella.core.sirius.analysis.StateMachineServices;
import org.polarsys.capella.core.sirius.analysis.constants.MappingConstantsHelper;
import org.polarsys.capella.core.sirius.analysis.showhide.AbstractShowHide;
import org.polarsys.capella.core.sirius.analysis.showhide.ShowHideABComponent;
import org.polarsys.capella.core.sirius.analysis.showhide.ShowHideABComponentCategory;
import org.polarsys.capella.core.sirius.analysis.showhide.ShowHideABComponentExchange;
import org.polarsys.capella.core.sirius.analysis.showhide.ShowHideABPhysicalCategory;
import org.polarsys.capella.core.sirius.analysis.showhide.ShowHideABPhysicalLink;
import org.polarsys.capella.core.sirius.analysis.showhide.ShowHideABRole;
import org.polarsys.capella.core.sirius.analysis.showhide.ShowHideFunction;
import org.polarsys.capella.core.sirius.analysis.showhide.ShowHideFunctionalExchange;
import org.polarsys.capella.core.sirius.analysis.tool.HashMapSet;

public class ABServices {
    private static ABServices service = null;

    public static ABServices getService() {
        if (service == null) {
            service = new ABServices();
        }
        return service;
    }

    public boolean isValidDndABFunctionPort(EObject element, DSemanticDecorator newContainer) {
        return DFServices.getService().isValidDndDFFunctionPort(element, newContainer);
    }

    public boolean isValidABComponentPort(EObject context, DSemanticDecorator containerView) {
        return containerView != null && !(containerView instanceof DDiagram);
    }

    public boolean isValidABCreationPortAllocation(EObject context, DSemanticDecorator sourceView) {
        if (sourceView == null) {
            return false;
        }
        EObject source = sourceView.getTarget();
        return source instanceof ComponentPort || source instanceof PhysicalPort;
    }

    public boolean isValidABCreationPortAllocation(EObject context, DSemanticDecorator sourceView, DSemanticDecorator targetView) {
        if (sourceView == null || targetView == null) {
            return false;
        }
        EObject source = sourceView.getTarget();
        EObject target = targetView.getTarget();
        if (!(source instanceof PhysicalPort) && !(source instanceof ComponentPort) || !(target instanceof FunctionPort)) {
            return false;
        }
        return EcoreUtil.isAncestor((EObject)sourceView.eContainer(), (EObject)targetView);
    }

    public boolean isValidABCreationComponentPortAllocation(EObject context, DSemanticDecorator sourceView) {
        if (sourceView == null) {
            return false;
        }
        EObject source = sourceView.getTarget();
        return source instanceof PhysicalPort;
    }

    public boolean isValidABCreationComponentPortAllocation(EObject context, DSemanticDecorator sourceView, DSemanticDecorator targetView) {
        if (sourceView == null || targetView == null) {
            return false;
        }
        EObject source = sourceView.getTarget();
        EObject target = targetView.getTarget();
        if (!(source instanceof PhysicalPort) || !(target instanceof ComponentPort)) {
            return false;
        }
        EObject parentTarget = targetView.eContainer();
        EObject parentSource = sourceView.eContainer();
        if (parentTarget == null || parentSource == null) {
            return false;
        }
        return parentSource.equals(parentTarget.eContainer());
    }

    public EObject dndABComponent(NamedElement pcMoved, NamedElement oldContainer, NamedElement newContainer) {
        NamedElement newOwner = newContainer;
        if (newOwner instanceof Part) {
            newOwner = CsServices.getService().getComponentType((Part)newContainer);
        }
        if (newOwner instanceof Component) {
            Component newComponent = (Component)newOwner;
            Component component = null;
            if (pcMoved instanceof Part) {
                newComponent.getOwnedFeatures().add((Object)((Part)pcMoved));
                component = (Component)((Part)pcMoved).getType();
            } else if (pcMoved instanceof Component) {
                for (Part part : ComponentExt.getRepresentingParts((Component)((Component)pcMoved))) {
                    if (newComponent.equals(part.eContainer())) continue;
                    newComponent.getOwnedFeatures().add((Object)part);
                }
                component = (Component)pcMoved;
            } else {
                return pcMoved;
            }
            if (!CsPackage.Literals.PART__OWNED_ABSTRACT_TYPE.equals(component.eContainingFeature())) {
                FaServices.getFaServices().moveComponent(component, newComponent);
            }
            List<PartitionableElement> listChild = CapellaServices.getService().getAllDescendants((PartitionableElement)component);
            listChild.add((PartitionableElement)component);
            for (PartitionableElement child : listChild) {
                if (!(child instanceof Component)) continue;
                Component componentChild = (Component)child;
                for (ComponentPort port : ComponentExt.getOwnedComponentPort((Component)componentChild)) {
                    FaServices.getFaServices().moveComponentExchanges(port);
                }
            }
            for (Port port : ComponentExt.getOwnedComponentPort((Component)component)) {
                FaServices.getFaServices().removeUselessPortRealizations(port, false, true, false, false);
            }
            FaServices.getFaServices().removeUselessExchanges((NamedElement)component);
        }
        return pcMoved;
    }

    public EObject dndABDComponent(NamedElement pcMoved, NamedElement oldContainer, NamedElement newContainer) {
        return this.dndABComponent(pcMoved, oldContainer, newContainer);
    }

    public EObject reconnectABComponentExchangeSource(EObject componentExchange, DSemanticDecorator edge, DSemanticDecorator oldNode, DSemanticDecorator newNode) {
        if (edge instanceof DEdge && componentExchange instanceof ComponentExchange) {
            this.reconnectABComponentExchange((ComponentExchange)componentExchange, ModellingcorePackage.Literals.ABSTRACT_INFORMATION_FLOW__SOURCE, (DEdge)edge, oldNode, newNode);
        }
        return componentExchange;
    }

    public EObject reconnectABComponentExchangeTarget(EObject componentExchange, DSemanticDecorator edge, DSemanticDecorator oldNode, DSemanticDecorator newNode) {
        if (edge instanceof DEdge && componentExchange instanceof ComponentExchange) {
            this.reconnectABComponentExchange((ComponentExchange)componentExchange, ModellingcorePackage.Literals.ABSTRACT_INFORMATION_FLOW__TARGET, (DEdge)edge, oldNode, newNode);
        }
        return componentExchange;
    }

    public void reconnectABComponentExchange(ComponentExchange componentExchange, EReference bound, DEdge edge, DSemanticDecorator oldNode, DSemanticDecorator newNode) {
        InformationsExchanger relatedPart = CsServices.getService().getRelatedPart(newNode);
        if (!(componentExchange instanceof CommunicationMean) && CsServices.getService().isMultipartMode((ModelElement)componentExchange) && newNode.getTarget() instanceof Port && relatedPart instanceof Part) {
            ComponentExchangeEnd end = null;
            Object boundValue = componentExchange.eGet((EStructuralFeature)bound);
            if (boundValue instanceof ComponentExchangeEnd) {
                end = (ComponentExchangeEnd)boundValue;
            }
            if (end == null) {
                end = FaFactory.eINSTANCE.createComponentExchangeEnd();
                componentExchange.getOwnedComponentExchangeEnds().add((Object)end);
            }
            end.setPart((Partition)((Part)relatedPart));
            end.setPort((Port)newNode.getTarget());
            componentExchange.eSet((EStructuralFeature)bound, (Object)end);
        } else {
            Object boundValue = componentExchange.eGet((EStructuralFeature)bound);
            if (boundValue instanceof ComponentExchangeEnd) {
                CapellaServices.getService().removeElement((CapellaElement)((ComponentExchangeEnd)boundValue));
            }
            componentExchange.eSet((EStructuralFeature)bound, (Object)newNode.getTarget());
        }
        ComponentExchangeExt.attachToDefaultContainer((ComponentExchange)componentExchange);
    }

    public boolean isValidABReconnectComponentExchangeSource(ComponentExchange exchange, EObject source, EObject target) {
        if (exchange instanceof CommunicationMean) {
            return source instanceof Component && target instanceof Component;
        }
        if (!CsServices.getService().isMultipartMode((ModelElement)exchange) && target instanceof Part) {
            return false;
        }
        if (source instanceof ComponentPort && target instanceof ComponentPort) {
            return PortExt.haveSameOrientation((ComponentPort)((ComponentPort)source), (ComponentPort)((ComponentPort)target));
        }
        return !(source instanceof ComponentPort) || !(target instanceof PhysicalPort);
    }

    public boolean isValidABReconnectComponentExchangeTarget(ComponentExchange exchange, EObject source, EObject target) {
        return this.isValidABReconnectComponentExchangeSource(exchange, source, target);
    }

    public EObject reconnectABPhysicalLinkSource(EObject physicalLink, DSemanticDecorator edge, DSemanticDecorator oldNode, DSemanticDecorator newNode) {
        if (edge instanceof DEdge && physicalLink instanceof PhysicalLink) {
            this.reconnectABPhysicalLink((PhysicalLink)physicalLink, (DEdge)edge, oldNode, newNode);
        }
        return physicalLink;
    }

    public EObject reconnectABPhysicalLinkTarget(EObject physicalLink, DSemanticDecorator edge, DSemanticDecorator oldNode, DSemanticDecorator newNode) {
        if (edge instanceof DEdge && physicalLink instanceof PhysicalLink) {
            this.reconnectABPhysicalLink((PhysicalLink)physicalLink, (DEdge)edge, oldNode, newNode);
        }
        return physicalLink;
    }

    public void reconnectABPhysicalLink(PhysicalLink physicalLink, DEdge edge, DSemanticDecorator oldNode, DSemanticDecorator newNode) {
        EObject oldTarget = oldNode.getTarget();
        EObject newTarget = newNode.getTarget();
        PhysicalPort oldPort = null;
        PhysicalPort newPort = null;
        if (oldTarget instanceof PhysicalPort) {
            oldPort = (PhysicalPort)oldTarget;
        }
        if (newTarget instanceof PhysicalPort) {
            newPort = (PhysicalPort)newTarget;
        }
        if (CsServices.getService().isMultipartMode((ModelElement)physicalLink) || physicalLink.getOwnedPhysicalLinkEnds().size() > 0) {
            InformationsExchanger relatedPart = CsServices.getService().getRelatedPart(newNode);
            PhysicalLinkEnd end = null;
            for (PhysicalLinkEnd end1 : physicalLink.getOwnedPhysicalLinkEnds()) {
                if ((oldPort != null || end1.getPort() != null) && (oldPort == null || !oldPort.equals(end1.getPort()))) continue;
                end = end1;
                break;
            }
            if (end == null) {
                end = CsFactory.eINSTANCE.createPhysicalLinkEnd();
                physicalLink.getOwnedPhysicalLinkEnds().add((Object)end);
                physicalLink.getLinkEnds().add((Object)end);
            }
            end.setPart((Part)relatedPart);
            end.setPort((PhysicalPort)newNode.getTarget());
        } else {
            int index = physicalLink.getLinkEnds().indexOf((Object)oldPort);
            physicalLink.getLinkEnds().add(index, (Object)newPort);
            physicalLink.getLinkEnds().remove((Object)oldPort);
        }
        PhysicalLinkExt.attachToDefaultContainer((PhysicalLink)physicalLink);
    }

    public boolean isValidABReconnectPhysicalLinkSource(PhysicalLink exchange, EObject source, EObject target) {
        if (!CsServices.getService().isMultipartMode((ModelElement)exchange) && target instanceof Part) {
            return false;
        }
        if (source instanceof ComponentPort && target instanceof ComponentPort) {
            return true;
        }
        return !(source instanceof PhysicalPort) || !(target instanceof ComponentPort);
    }

    public boolean isValidABReconnectPhysicalLinkTarget(PhysicalLink exchange, EObject source, EObject target) {
        return this.isValidABReconnectPhysicalLinkSource(exchange, source, target);
    }

    public boolean isValidDndComponent(Part source, Component target) {
        for (Part part : ComponentExt.getRepresentingParts((Component)target)) {
            Collection parts = ComponentExt.getPartAncestors((Part)part);
            if (!parts.contains(source)) continue;
            return false;
        }
        return !target.equals(source.getAbstractType());
    }

    public boolean isValidDndComponent(Part source, Part target) {
        Collection parts = ComponentExt.getPartAncestors((Part)target);
        if (parts.contains(source)) {
            return false;
        }
        return !target.getAbstractType().equals(source.getAbstractType());
    }

    public boolean isValidDndComponent(Component source, Component target) {
        Collection parts = ComponentExt.getComponentAncestors((Component)target);
        if (parts.contains(source)) {
            return false;
        }
        return !target.equals(source);
    }

    public boolean isValidDndABComponent(Part semanticObjectToDrop, EObject targetContainerView) {
        EObject context = CsServices.getService().getABTarget((DSemanticDecorator)targetContainerView);
        if (context instanceof BlockArchitecture) {
            return false;
        }
        if (context instanceof Component) {
            return this.isValidDndComponent(semanticObjectToDrop, (Component)context);
        }
        if (context instanceof Part) {
            return this.isValidDndComponent(semanticObjectToDrop, (Part)context);
        }
        return false;
    }

    public boolean isValidDndABDComponent(Component semanticObjectToDrop, EObject targetContainerView) {
        EObject target = ((DSemanticDecorator)targetContainerView).getTarget();
        if (target instanceof Component) {
            return this.isValidDndComponent(semanticObjectToDrop, (Component)target);
        }
        return false;
    }

    public boolean isValidDnDPhysicalPort(EObject context, DSemanticDecorator container) {
        return PhysicalServices.getService().isValidPhysicalPort(context, container.getTarget());
    }

    public EObject createABFunctionalExchange(EObject context, AbstractDNode sourceView, AbstractDNode targetView) {
        DDiagram diagram = CapellaServices.getService().getDiagramContainer((EObject)sourceView);
        ActivityNode sourceTarget = FaServices.getFaServices().getRelatedActivityNode((DSemanticDecorator)sourceView);
        ActivityNode targetTarget = FaServices.getFaServices().getRelatedActivityNode((DSemanticDecorator)targetView);
        FunctionalExchange exchange = FunctionalExchangeExt.createFunctionalExchange((ActivityNode)sourceTarget, (ActivityNode)targetTarget);
        FaServices.getFaServices().createViewFunctionalExchange(exchange, sourceView, targetView, diagram);
        CsServices.getService().setInterpreterVariable(context, "result", (EObject)exchange);
        return exchange;
    }

    public Collection<EObject> getABInsertStateModesScope(DSemanticDecorator containerView) {
        HashSet availableStates = new HashSet();
        HashSet<EObject> result = new HashSet<EObject>();
        DDiagram diagram = CapellaServices.getService().getDiagramContainer((EObject)containerView);
        DDiagramContents content = new DDiagramContents(diagram);
        EObject target = ((DSemanticDecorator)diagram).getTarget();
        if (target != null) {
            BlockArchitecture architecture = BlockArchitectureExt.getRootBlockArchitecture((EObject)target);
            for (AbstractFunction function : FunctionPkgExt.getAllAbstractFunctions((FunctionPkg)BlockArchitectureExt.getFunctionPkg((BlockArchitecture)architecture))) {
                availableStates.addAll(function.getAvailableInStates());
            }
            for (State state : availableStates) {
                boolean addElement = false;
                for (EObject function : this.getABInsertStateModesRelatedElements(state, architecture)) {
                    if (!(function instanceof AbstractFunction) || content.containsView(function, (DiagramElementMapping)FaServices.getFaServices().getMappingABAbstractFunction((AbstractFunction)function, diagram))) continue;
                    addElement = true;
                    break;
                }
                if (!addElement) continue;
                result.add((EObject)state);
            }
        }
        return result;
    }

    public void showABStateModes(DSemanticDecorator containerView, Collection<EObject> elements) {
        HashSet<EObject> functionsToShow = new HashSet<EObject>();
        DDiagram diagram = CapellaServices.getService().getDiagramContainer((EObject)containerView);
        DDiagramContents content = new DDiagramContents(diagram);
        EObject target = ((DSemanticDecorator)diagram).getTarget();
        if (target != null) {
            BlockArchitecture sourceArchitecture = BlockArchitectureExt.getRootBlockArchitecture((EObject)target);
            for (EObject object : elements) {
                if (!(object instanceof State)) continue;
                State mode = (State)object;
                functionsToShow.addAll(this.getABInsertStateModesRelatedElements(mode, sourceArchitecture));
            }
            this.showABAbstractFunction(functionsToShow, content);
        }
    }

    public Collection<EObject> getABInsertStateModesRelatedElements(State mode, BlockArchitecture sourceArchitecture) {
        HashSet<EObject> functionsToShow = new HashSet<EObject>();
        for (EObject element : StateMachineServices.getService().getAllFunctionsActiveInStates((EObject)sourceArchitecture, (IState)mode)) {
            BlockArchitecture targetArchitecture = BlockArchitectureExt.getRootBlockArchitecture((EObject)element);
            if (!sourceArchitecture.equals(targetArchitecture)) continue;
            functionsToShow.add(element);
        }
        return functionsToShow;
    }

    public boolean isValidABInsertStateModes(DSemanticDecorator containerView) {
        return containerView instanceof DDiagram;
    }

    public Collection<EObject> getABInsertScenariosScope(DSemanticDecorator containerView) {
        HashSet<EObject> result = new HashSet<EObject>();
        DDiagram diagram = CapellaServices.getService().getDiagramContainer((EObject)containerView);
        DDiagramContents content = new DDiagramContents(diagram);
        EObject target = ((DSemanticDecorator)diagram).getTarget();
        if (target != null) {
            BlockArchitecture sourceArchitecture = BlockArchitectureExt.getRootBlockArchitecture((EObject)target);
            AbstractCapabilityPkg pkg = BlockArchitectureExt.getAbstractCapabilityPkg((BlockArchitecture)sourceArchitecture);
            for (Scenario scenario : AbstractCapabilityPkgExt.getAllScenarios((AbstractCapabilityPkg)pkg)) {
                boolean addElement = false;
                for (EObject element : ContextualDiagramHelper.getService().getInsertScenariosRelatedElements(scenario, sourceArchitecture)) {
                    if (element instanceof AbstractFunction) {
                        if (content.containsView(element, content.getMapping(MappingConstantsHelper.getMappingABAbstractFunction(diagram)))) continue;
                        addElement = true;
                        break;
                    }
                    if (element instanceof FunctionalExchange) {
                        if (content.containsView(element, content.getMapping(MappingConstantsHelper.getMappingABFunctionalExchange(diagram)))) continue;
                        addElement = true;
                        break;
                    }
                    if (element instanceof Part) {
                        if (content.containsView(element, content.getMapping(MappingConstantsHelper.getMappingABComponent(element, diagram)))) continue;
                        addElement = true;
                        break;
                    }
                    if (element instanceof Role) {
                        if (content.containsView(element, content.getMapping(MappingConstantsHelper.getMappingABRole(diagram)))) continue;
                        addElement = true;
                        break;
                    }
                    if (element instanceof Entity) {
                        if (content.containsView(element, content.getMapping(MappingConstantsHelper.getMappingABComponent(element, diagram)))) continue;
                        addElement = true;
                        break;
                    }
                    if (!(element instanceof ComponentExchange) || content.containsView(element, content.getMapping(MappingConstantsHelper.getMappingABConnection(diagram)))) continue;
                    addElement = true;
                    break;
                }
                if (!addElement) continue;
                if (ScenarioExt.isFunctionalScenario((Scenario)scenario)) {
                    result.add((EObject)scenario);
                    continue;
                }
                if (ScenarioExt.isDataFlowFunctionalScenario((Scenario)scenario)) {
                    result.add((EObject)scenario);
                    continue;
                }
                if (ScenarioExt.isDataFlowBehaviouralScenario((Scenario)scenario)) {
                    result.add((EObject)scenario);
                    continue;
                }
                if (!ScenarioExt.isInterfaceScenario((Scenario)scenario)) continue;
                result.add((EObject)scenario);
            }
        }
        return result;
    }

    public void showABScenarios(DSemanticDecorator containerView, Collection<EObject> elements) {
        HashSet<EObject> partToShow = new HashSet<EObject>();
        HashSet<EObject> roleToShow = new HashSet<EObject>();
        HashSet<EObject> functionsToShow = new HashSet<EObject>();
        LinkedList<Object> unallocatedFunctions = new LinkedList<Object>();
        LinkedList<Object> unallocatedRoles = new LinkedList<Object>();
        HashSet<EObject> exchangesToShow = new HashSet<EObject>();
        HashSet<EObject> componentExchangesToShow = new HashSet<EObject>();
        DDiagram diagram = CapellaServices.getService().getDiagramContainer((EObject)containerView);
        DDiagramContents content = new DDiagramContents(diagram);
        EObject target = ((DSemanticDecorator)diagram).getTarget();
        if (target != null) {
            BlockArchitecture sourceArchitecture = BlockArchitectureExt.getRootBlockArchitecture((EObject)target);
            for (EObject object : elements) {
                Logger logger;
                if (!(object instanceof Scenario)) continue;
                Scenario scenario = (Scenario)object;
                for (EObject related : ContextualDiagramHelper.getService().getInsertScenariosRelatedElements(scenario, sourceArchitecture)) {
                    if (related instanceof AbstractFunction) {
                        boolean isAllocated;
                        functionsToShow.add(related);
                        boolean bl = isAllocated = !((AbstractFunction)related).getAllocationBlocks().isEmpty();
                        if (related instanceof OperationalActivity) {
                            OperationalActivity oActivity = (OperationalActivity)related;
                            if (isAllocated) continue;
                            if (!oActivity.getActivityAllocations().isEmpty()) {
                                boolean isRoleAllocated = false;
                                for (ActivityAllocation allocation : oActivity.getActivityAllocations()) {
                                    Role role = allocation.getRole();
                                    if (role == null || isRoleAllocated || !role.getRoleAllocations().isEmpty()) continue;
                                    unallocatedRoles.add(role);
                                }
                                continue;
                            }
                            unallocatedFunctions.add(related);
                            continue;
                        }
                        if (isAllocated) continue;
                        unallocatedFunctions.add(related);
                        continue;
                    }
                    if (related instanceof FunctionalExchange) {
                        exchangesToShow.add(related);
                        continue;
                    }
                    if (related instanceof Part) {
                        partToShow.add(related);
                        continue;
                    }
                    if (related instanceof Role) {
                        roleToShow.add(related);
                        if (!((Role)related).getRoleAllocations().isEmpty()) continue;
                        unallocatedRoles.add(related);
                        continue;
                    }
                    if (related instanceof Entity) {
                        partToShow.add(related);
                        continue;
                    }
                    if (!(related instanceof ComponentExchange)) continue;
                    componentExchangesToShow.add(related);
                }
                if (unallocatedFunctions.size() > 0) {
                    unallocatedFunctions.addFirst(scenario);
                    logger = ReportManagerRegistry.getInstance().subscribe("Model Management");
                    logger.info((Object)new EmbeddedMessage(NLS.bind((String)Messages.ABServices_UnallocatedFunctions, (Object)EObjectLabelProviderHelper.getText((EObject)scenario)), "Model Management", unallocatedFunctions));
                }
                if (unallocatedRoles.size() <= 0) continue;
                unallocatedRoles.addFirst(scenario);
                logger = ReportManagerRegistry.getInstance().subscribe("Model Management");
                logger.info((Object)new EmbeddedMessage(NLS.bind((String)Messages.ABServices_UnallocatedRoles, (Object)EObjectLabelProviderHelper.getText((EObject)scenario)), "Model Management", unallocatedRoles));
            }
            this.showABComponent(partToShow, content);
            this.showABRole(roleToShow, content);
            this.showABAbstractFunction(functionsToShow, content);
            this.showABFunctionalExchange(exchangesToShow, content);
            this.showABComponentExchange(componentExchangesToShow, content);
        }
    }

    public EObject showABRole(Collection<EObject> elements, DDiagramContents content) {
        ShowHideABRole shService = new ShowHideABRole(content);
        for (EObject element : elements) {
            AbstractShowHide.DiagramContext context = shService.new AbstractShowHide.DiagramContext();
            shService.show(element, context);
        }
        return content.getDDiagram();
    }

    public boolean isValidABInsertScenarios(DSemanticDecorator containerView) {
        return containerView instanceof DDiagram;
    }

    public EObject showABAbstractFunction(Collection<EObject> elements, DDiagramContents content) {
        ShowHideFunction shService = new ShowHideFunction(content);
        for (EObject element : elements) {
            AbstractShowHide.DiagramContext context = shService.new AbstractShowHide.DiagramContext();
            shService.show(element, context);
        }
        return content.getDDiagram();
    }

    public EObject showABComponentExchange(Collection<EObject> elements, DDiagramContents content) {
        ShowHideABComponentExchange shService = new ShowHideABComponentExchange(content);
        for (EObject element : elements) {
            AbstractShowHide.DiagramContext context = shService.new AbstractShowHide.DiagramContext();
            shService.show(element, context);
        }
        return content.getDDiagram();
    }

    public EObject showABPhysicalLink(Collection<EObject> elements, DDiagramContents content) {
        ShowHideABPhysicalLink shService = new ShowHideABPhysicalLink(content);
        for (EObject element : elements) {
            AbstractShowHide.DiagramContext context = shService.new AbstractShowHide.DiagramContext();
            shService.show(element, context);
        }
        return content.getDDiagram();
    }

    public EObject showABComponentExchange(Collection<EObject> elements, DDiagramContents content, DSemanticDecorator currentElementView) {
        ShowHideABComponentExchange shService = new ShowHideABComponentExchange(content);
        for (EObject element : elements) {
            AbstractShowHide.DiagramContext context = shService.new AbstractShowHide.DiagramContext();
            if (currentElementView instanceof DDiagramElement) {
                context.setVariable("spv", Collections.singletonList(currentElementView));
            }
            shService.show(element, context);
        }
        return content.getDDiagram();
    }

    public EObject showABFunctionalExchange(Collection<EObject> elements, DDiagramContents content) {
        ShowHideFunctionalExchange shService = new ShowHideFunctionalExchange(content);
        for (EObject element : elements) {
            AbstractShowHide.DiagramContext context = shService.new AbstractShowHide.DiagramContext();
            shService.show(element, context);
        }
        return content.getDDiagram();
    }

    public EObject showABComponent(Collection<EObject> components, DDiagramContents content) {
        if (components == null || components.isEmpty()) {
            return content.getDDiagram();
        }
        ShowHideABComponent shService = new ShowHideABComponent(content);
        for (EObject component : components) {
            AbstractShowHide.DiagramContext context = shService.new AbstractShowHide.DiagramContext();
            shService.show(component, context);
        }
        return content.getDDiagram();
    }

    public boolean isValidABComponentCategoryPort(EObject context, DSemanticDecorator containerView) {
        return true;
    }

    public boolean isValidABPhysicalCategoryPort(EObject context, DSemanticDecorator containerView) {
        return true;
    }

    public boolean isValidABPhysicalCategoryEdge(PhysicalLinkCategory category, DSemanticDecorator source, DSemanticDecorator target) {
        if (category == null || source == null || target == null) {
            return false;
        }
        InformationsExchanger sourcePart = CsServices.getService().getRelatedPart(source);
        InformationsExchanger targetPart = CsServices.getService().getRelatedPart(target);
        DSemanticDecorator sourcePartView = CsServices.getService().getRelatedPartView(source);
        DSemanticDecorator targetPartView = CsServices.getService().getRelatedPartView(target);
        AbstractDNode sourceView = (AbstractDNode)sourcePartView;
        AbstractDNode targetView = (AbstractDNode)targetPartView;
        AbstractDNode sourceCategoryPort = null;
        AbstractDNode targetCategoryPort = null;
        EObject sourceTarget = source.getTarget();
        EObject targetTarget = target.getTarget();
        if (sourceTarget instanceof Port && targetTarget instanceof PhysicalLinkCategory || targetTarget instanceof Port && sourceTarget instanceof PhysicalLinkCategory) {
            for (AbstractDNode node : sourceView.getOwnedBorderedNodes()) {
                if (!category.equals(node.getTarget())) continue;
                sourceCategoryPort = node;
                break;
            }
            for (AbstractDNode node : targetView.getOwnedBorderedNodes()) {
                if (!category.equals(node.getTarget())) continue;
                targetCategoryPort = node;
                break;
            }
            boolean hasEdge = false;
            if (sourceCategoryPort != null && targetCategoryPort != null) {
                for (DEdge edge : ((EdgeTarget)sourceCategoryPort).getIncomingEdges()) {
                    if (!category.equals(edge.getTarget()) || (edge.getSourceNode() != sourceCategoryPort || edge.getTargetNode() != targetCategoryPort) && (edge.getSourceNode() != targetCategoryPort || edge.getTargetNode() != sourceCategoryPort)) continue;
                    hasEdge = true;
                    break;
                }
                for (DEdge edge : ((EdgeTarget)sourceCategoryPort).getOutgoingEdges()) {
                    if (!category.equals(edge.getTarget()) || (edge.getSourceNode() != sourceCategoryPort || edge.getTargetNode() != targetCategoryPort) && (edge.getSourceNode() != targetCategoryPort || edge.getTargetNode() != sourceCategoryPort)) continue;
                    hasEdge = true;
                    break;
                }
            }
            if (hasEdge) {
                return false;
            }
            Port delegationTargetPort = null;
            InformationsExchanger delegationSourcePart = null;
            if (sourceTarget instanceof Port) {
                delegationTargetPort = (Port)sourceTarget;
                delegationSourcePart = targetPart;
            }
            if (targetTarget instanceof Port) {
                delegationTargetPort = (Port)targetTarget;
                delegationSourcePart = sourcePart;
            }
            boolean isValid = false;
            if (delegationTargetPort != null && delegationSourcePart != null) {
                Collection delegations;
                if (delegationTargetPort instanceof PhysicalPort) {
                    delegations = PortExt.getDelegationPhysicalLinks((PhysicalPort)((PhysicalPort)delegationTargetPort));
                    for (PhysicalLink delegation : delegations) {
                        if (delegationTargetPort.equals(org.polarsys.capella.core.data.helpers.cs.services.PhysicalLinkExt.getTargetPort((PhysicalLink)delegation))) {
                            if (!org.polarsys.capella.core.data.helpers.cs.services.PhysicalLinkExt.getSourceParts((PhysicalLink)delegation).contains(delegationSourcePart)) continue;
                            isValid = true;
                        } else {
                            if (!delegationTargetPort.equals(org.polarsys.capella.core.data.helpers.cs.services.PhysicalLinkExt.getSourcePort((PhysicalLink)delegation)) || !org.polarsys.capella.core.data.helpers.cs.services.PhysicalLinkExt.getTargetParts((PhysicalLink)delegation).contains(delegationSourcePart)) continue;
                            isValid = true;
                        }
                        break;
                    }
                } else if (delegationTargetPort instanceof ComponentPort) {
                    delegations = PortExt.getIncomingComponentPortAllocations((ComponentPort)((ComponentPort)delegationTargetPort));
                    for (PhysicalLink delegation : delegations) {
                        if (delegationTargetPort.equals(ComponentPortAllocationExt.getTargetPort((ComponentPortAllocation)delegation))) {
                            if (!ComponentPortAllocationExt.getSourceParts((ComponentPortAllocation)delegation).contains(delegationSourcePart)) continue;
                            isValid = true;
                        } else {
                            if (!delegationTargetPort.equals(ComponentPortAllocationExt.getSourcePort((ComponentPortAllocation)delegation)) || !ComponentPortAllocationExt.getTargetParts((ComponentPortAllocation)delegation).contains(delegationSourcePart)) continue;
                            isValid = true;
                        }
                        break;
                    }
                }
                if (!isValid) {
                    return false;
                }
                isValid = false;
                for (PhysicalLink exchange : this.getRelatedPhysicalLinks((EObject)delegationSourcePart)) {
                    if (PhysicalLinkExt.isDelegation((PhysicalLink)exchange) || !exchange.getCategories().contains((Object)category)) continue;
                    isValid = true;
                    break;
                }
                if (!isValid) {
                    return false;
                }
            }
            if (sourcePartView.eContainer() != targetPartView && targetPartView.eContainer() != sourcePartView) {
                isValid = false;
            }
            return isValid;
        }
        for (PhysicalLink exchange : this.getRelatedPhysicalLinks((EObject)sourcePart)) {
            if (!exchange.getCategories().contains((Object)category)) continue;
            Collection sourceParts = org.polarsys.capella.core.data.helpers.cs.services.PhysicalLinkExt.getSourceParts((PhysicalLink)exchange);
            Collection targetParts = org.polarsys.capella.core.data.helpers.cs.services.PhysicalLinkExt.getTargetParts((PhysicalLink)exchange);
            if (!(sourceParts.contains(sourcePart) && targetParts.contains(targetPart) ? CsServices.getService().isValidLinkEdge(CsServices.getService().getPhysicalLinkWrapper(exchange), sourcePartView, targetPartView, false) : sourceParts.contains(targetPart) && targetParts.contains(sourcePart) && CsServices.getService().isValidLinkEdge(CsServices.getService().getPhysicalLinkWrapper(exchange), targetPartView, sourcePartView, false))) continue;
            return true;
        }
        return this.getRelatedPhysicalLinks((EObject)sourcePart).size() == 0;
    }

    public boolean isValidABFunctionalExchangeEdge(EObject context, DSemanticDecorator sourceView, DSemanticDecorator targetView) {
        return context instanceof FunctionalExchange && sourceView != targetView;
    }

    public boolean isValidCreationABNodePC(DSemanticDecorator containerView) {
        if (containerView == null) {
            return false;
        }
        EObject container = containerView.getTarget();
        if (container == null) {
            return false;
        }
        EObject type = CsServices.getService().getComponentType(containerView);
        if (type == null || !(type instanceof AbstractPhysicalComponent)) {
            return false;
        }
        AbstractPhysicalComponent pcType = (AbstractPhysicalComponent)type;
        if (PhysicalComponentNature.BEHAVIOR.equals((Object)pcType.getNature())) {
            return false;
        }
        if (pcType instanceof AbstractActor) {
            return false;
        }
        return !(containerView instanceof DDiagram) || !(CsServices.getService().getABTarget(containerView) instanceof BlockArchitecture);
    }

    public boolean isValidCreationABReuseNodePC(DSemanticDecorator containerView) {
        return this.isValidCreationABNodePC(containerView);
    }

    public boolean isValidCreationABBehaviorPC(DSemanticDecorator containerView) {
        if (containerView == null) {
            return false;
        }
        EObject container = containerView.getTarget();
        if (container == null) {
            return false;
        }
        EObject type = CsServices.getService().getComponentType(containerView);
        if (type == null || !(type instanceof AbstractPhysicalComponent)) {
            return false;
        }
        AbstractPhysicalComponent pcType = (AbstractPhysicalComponent)type;
        if (PhysicalComponentNature.NODE.equals((Object)pcType.getNature())) {
            return false;
        }
        if (pcType instanceof AbstractActor) {
            return false;
        }
        return !(containerView instanceof DDiagram) || !(CsServices.getService().getABTarget(containerView) instanceof BlockArchitecture);
    }

    public boolean isValidCreationABReuseBehaviorPC(DSemanticDecorator containerView) {
        return this.isValidCreationABBehaviorPC(containerView);
    }

    public boolean isValidCreationABDeployNodePC(DSemanticDecorator containerView) {
        if (!(containerView instanceof DNodeContainer)) {
            return false;
        }
        EObject type = CsServices.getService().getComponentType(containerView);
        if (type == null || !(type instanceof AbstractPhysicalComponent)) {
            return false;
        }
        AbstractPhysicalComponent pcType = (AbstractPhysicalComponent)type;
        return PhysicalComponentNature.NODE.equals((Object)pcType.getNature());
    }

    public boolean isValidCreationABDeployBehaviorPC(DSemanticDecorator containerView) {
        if (!(containerView instanceof DNodeContainer)) {
            return false;
        }
        EObject type = CsServices.getService().getComponentType(containerView);
        return type != null && type instanceof AbstractPhysicalComponent;
    }

    public boolean isValidABFunctionalChainInternalLinkEdge(FunctionalChain chain, DSemanticDecorator source, DSemanticDecorator target) {
        return FunctionalChainServices.getFunctionalChainServices().isValidInternalLinkEdge(chain, (EdgeTarget)source, (EdgeTarget)target);
    }

    public boolean isValidABPhysicalPathInternalLinkEdge(PhysicalPath path, DSemanticDecorator source, DSemanticDecorator target) {
        if (source instanceof EdgeTarget) {
            HashSet<DEdge> edges = new HashSet<DEdge>();
            EdgeTarget src = (EdgeTarget)source;
            edges.addAll(DiagramServices.getDiagramServices().getIncomingEdges(src));
            edges.addAll(DiagramServices.getDiagramServices().getOutgoingEdges(src));
            int nbEdges = 0;
            for (DEdge edge : edges) {
                if (edge == null || !edge.getTarget().equals(path)) continue;
                if (edge.getSourceNode().equals(target)) {
                    ++nbEdges;
                }
                if (!edge.getTargetNode().equals(target)) continue;
                ++nbEdges;
            }
            return nbEdges <= 1;
        }
        return true;
    }

    public boolean isValidFunctionalExchangeCategoryEdge(ExchangeCategory category, DSemanticDecorator source, DSemanticDecorator target) {
        if (category == null || source == null || target == null) {
            return false;
        }
        DSemanticDecorator sourcePartView = CsServices.getService().getRelatedFunctionView(source);
        DSemanticDecorator targetPartView = CsServices.getService().getRelatedFunctionView(target);
        AbstractFunction sourceTarget = (AbstractFunction)sourcePartView.getTarget();
        AbstractFunction targetTarget = (AbstractFunction)targetPartView.getTarget();
        return this.isSourceTargetCategoryFunction(sourceTarget, targetTarget, category);
    }

    public boolean isSourceTargetCategoryFunction(AbstractFunction source, AbstractFunction target, ExchangeCategory category) {
        ArrayList cSource = new ArrayList(category.getExchanges());
        ArrayList allSourceExchanges = new ArrayList();
        for (AbstractFunction currentFunction : FunctionExt.getAllAbstractFunctions((AbstractFunction)source)) {
            allSourceExchanges.addAll(FunctionExt.getOutGoingExchange((AbstractFunction)currentFunction));
            allSourceExchanges.addAll(FunctionExt.getOutGoingExchange((AbstractFunction)currentFunction));
        }
        ArrayList allTargetExchanges = new ArrayList();
        for (AbstractFunction currentFunction : FunctionExt.getAllAbstractFunctions((AbstractFunction)target)) {
            allTargetExchanges.addAll(FunctionExt.getIncomingExchange((AbstractFunction)currentFunction));
            allTargetExchanges.addAll(FunctionExt.getIncomingExchange((AbstractFunction)currentFunction));
        }
        allSourceExchanges.retainAll(allTargetExchanges);
        cSource.retainAll(allSourceExchanges);
        return !cSource.isEmpty();
    }

    public boolean isSourceCategoryFunction(AbstractFunction source, ExchangeCategory category) {
        ArrayList cSource = new ArrayList(category.getExchanges());
        ArrayList allSourceExchanges = new ArrayList();
        for (AbstractFunction currentFunction : FunctionExt.getAllAbstractFunctions((AbstractFunction)source)) {
            allSourceExchanges.addAll(FunctionExt.getOutGoingExchange((AbstractFunction)currentFunction));
            allSourceExchanges.addAll(FunctionExt.getOutGoingExchange((AbstractFunction)currentFunction));
        }
        cSource.retainAll(allSourceExchanges);
        return !cSource.isEmpty();
    }

    public boolean isTargetCategoryFunction(AbstractFunction target, ExchangeCategory category) {
        ArrayList cSource = new ArrayList(category.getExchanges());
        ArrayList allSourceExchanges = new ArrayList();
        for (AbstractFunction currentFunction : FunctionExt.getAllAbstractFunctions((AbstractFunction)target)) {
            allSourceExchanges.addAll(FunctionExt.getIncomingExchange((AbstractFunction)currentFunction));
            allSourceExchanges.addAll(FunctionExt.getIncomingExchange((AbstractFunction)currentFunction));
        }
        cSource.retainAll(allSourceExchanges);
        return !cSource.isEmpty();
    }

    public boolean isValidABComponentCategoryEdge(ComponentExchangeCategory category, DSemanticDecorator source, DSemanticDecorator target) {
        if (category == null || source == null || target == null) {
            return false;
        }
        InformationsExchanger sourcePart = CsServices.getService().getRelatedPart(source);
        InformationsExchanger targetPart = CsServices.getService().getRelatedPart(target);
        DSemanticDecorator sourcePartView = CsServices.getService().getRelatedPartView(source);
        DSemanticDecorator targetPartView = CsServices.getService().getRelatedPartView(target);
        AbstractDNode sourceView = (AbstractDNode)sourcePartView;
        AbstractDNode targetView = (AbstractDNode)targetPartView;
        AbstractDNode sourceCategoryPort = null;
        AbstractDNode targetCategoryPort = null;
        EObject sourceTarget = source.getTarget();
        EObject targetTarget = target.getTarget();
        if (sourceTarget instanceof ComponentPort && targetTarget instanceof ComponentExchangeCategory || targetTarget instanceof ComponentPort && sourceTarget instanceof ComponentExchangeCategory) {
            for (AbstractDNode node : sourceView.getOwnedBorderedNodes()) {
                if (!category.equals(node.getTarget())) continue;
                sourceCategoryPort = node;
                break;
            }
            for (AbstractDNode node : targetView.getOwnedBorderedNodes()) {
                if (!category.equals(node.getTarget())) continue;
                targetCategoryPort = node;
                break;
            }
            boolean hasEdge = false;
            if (sourceCategoryPort != null && targetCategoryPort != null) {
                for (DEdge edge : ((EdgeTarget)sourceCategoryPort).getIncomingEdges()) {
                    if (!category.equals(edge.getTarget()) || (edge.getSourceNode() != sourceCategoryPort || edge.getTargetNode() != targetCategoryPort) && (edge.getSourceNode() != targetCategoryPort || edge.getTargetNode() != sourceCategoryPort)) continue;
                    hasEdge = true;
                    break;
                }
                for (DEdge edge : ((EdgeTarget)sourceCategoryPort).getOutgoingEdges()) {
                    if (!category.equals(edge.getTarget()) || (edge.getSourceNode() != sourceCategoryPort || edge.getTargetNode() != targetCategoryPort) && (edge.getSourceNode() != targetCategoryPort || edge.getTargetNode() != sourceCategoryPort)) continue;
                    hasEdge = true;
                    break;
                }
            }
            if (hasEdge) {
                return false;
            }
            ComponentPort delegationTargetPort = null;
            InformationsExchanger delegationSourcePart = null;
            if (sourceTarget instanceof ComponentPort) {
                delegationTargetPort = (ComponentPort)sourceTarget;
                delegationSourcePart = targetPart;
            }
            if (targetTarget instanceof ComponentPort) {
                delegationTargetPort = (ComponentPort)targetTarget;
                delegationSourcePart = sourcePart;
            }
            boolean isValid = false;
            if (delegationTargetPort != null && delegationSourcePart != null) {
                List delegations = PortExt.getDelegationComponentExchanges((ComponentPort)delegationTargetPort);
                for (ComponentExchange delegation : delegations) {
                    if (delegationTargetPort.equals(ComponentExchangeExt.getTargetPort((ComponentExchange)delegation))) {
                        if (!ComponentExchangeExt.getSourcePartsAndEntities((ComponentExchange)delegation).contains(delegationSourcePart)) continue;
                        isValid = true;
                        break;
                    }
                    if (!delegationTargetPort.equals(ComponentExchangeExt.getSourcePort((ComponentExchange)delegation)) || !ComponentExchangeExt.getTargetPartsAndEntities((ComponentExchange)delegation).contains(delegationSourcePart)) continue;
                    isValid = true;
                    break;
                }
                if (!isValid) {
                    return false;
                }
                isValid = false;
                for (ComponentExchange exchange : this.getRelatedComponentExchanges((EObject)delegationSourcePart)) {
                    if (ComponentExchangeExt.isDelegation((ComponentExchange)exchange) || !exchange.getCategories().contains((Object)category)) continue;
                    isValid = true;
                    break;
                }
                if (!isValid) {
                    return false;
                }
            }
            if (sourcePartView.eContainer() != targetPartView && targetPartView.eContainer() != sourcePartView) {
                isValid = false;
            }
            return isValid;
        }
        for (ComponentExchange exchange : this.getRelatedComponentExchanges((EObject)sourcePart)) {
            if (!exchange.getCategories().contains((Object)category)) continue;
            Collection sourceParts = ComponentExchangeExt.getSourcePartsAndEntities((ComponentExchange)exchange);
            Collection targetParts = ComponentExchangeExt.getTargetPartsAndEntities((ComponentExchange)exchange);
            if (!(sourceParts.contains(sourcePart) && targetParts.contains(targetPart) ? CsServices.getService().isValidLinkEdge(CsServices.getService().getComponentExchangeWrapper(exchange), sourcePartView, targetPartView, false) : sourceParts.contains(targetPart) && targetParts.contains(sourcePart) && CsServices.getService().isValidLinkEdge(CsServices.getService().getComponentExchangeWrapper(exchange), targetPartView, sourcePartView, false))) continue;
            return true;
        }
        return this.getRelatedComponentExchanges((EObject)sourcePart).size() == 0;
    }

    public boolean isValidShowHideABPhysicalCategory(EObject context, EObject containerView) {
        return this.isValidShowHideABComponentCategory(context, containerView);
    }

    public boolean isValidShowHideABComponentCategory(EObject context, EObject containerView) {
        EObject target;
        return containerView instanceof AbstractDNode && (target = ((AbstractDNode)containerView).getTarget()) != null && (target instanceof Part || target instanceof Entity);
    }

    public boolean isValidSwitchABPhysicalCategory(EObject context, EObject containerView) {
        return this.isValidSwitchABComponentCategory(context, containerView);
    }

    public boolean isValidSwitchABComponentCategory(EObject context, EObject containerView) {
        return containerView instanceof DDiagram;
    }

    public EObject showABPhysicalCategories(DSemanticDecorator context, HashMapSet<EObject, EObject> scope, HashMapSet<EObject, EObject> initialSelection, HashMapSet<EObject, EObject> selectedElements) {
        Iterator<Object> iterator;
        PhysicalLinkCategory category;
        DDiagram currentDiagram = CapellaServices.getService().getDiagramContainer((EObject)context);
        DDiagramContents content = new DDiagramContents(currentDiagram);
        EObject source = context.getTarget();
        ShowHideABPhysicalCategory shService = new ShowHideABPhysicalCategory(content);
        AbstractShowHide.DiagramContext ctx = shService.new AbstractShowHide.DiagramContext();
        if (context instanceof DDiagramElement) {
            ctx.setVariable("spv", Collections.singletonList(context));
        }
        for (EObject key : scope.keySet()) {
            category = (PhysicalLinkCategory)key;
            iterator = scope.get(key).iterator();
            while (iterator.hasNext()) {
                EObject value = (EObject)iterator.next();
                if (selectedElements.containsKey(key) && selectedElements.get(key).contains(value) || !initialSelection.containsKey(key) || !initialSelection.get(key).contains(value)) continue;
                this.showABPhysicalCategory(shService, ctx, (PhysicalLinkCategory)key, source, value, false);
                for (PhysicalLink exchange : this.getRelatedPhysicalLinks(source)) {
                    if (!exchange.getCategories().contains((Object)key)) continue;
                    this.displayABPhysicalCategoryPortDelegation(ctx, category, exchange, (PhysicalPort)org.polarsys.capella.core.data.helpers.cs.services.PhysicalLinkExt.getSourcePort((PhysicalLink)exchange), false, shService);
                    this.displayABPhysicalCategoryPortDelegation(ctx, category, exchange, (PhysicalPort)org.polarsys.capella.core.data.helpers.cs.services.PhysicalLinkExt.getTargetPort((PhysicalLink)exchange), false, shService);
                }
            }
        }
        for (EObject key : selectedElements.keySet()) {
            category = (PhysicalLinkCategory)key;
            iterator = selectedElements.get(key).iterator();
            while (iterator.hasNext()) {
                EObject target = (EObject)iterator.next();
                this.showABPhysicalCategory(shService, ctx, (PhysicalLinkCategory)key, source, target, true);
            }
            for (PhysicalLink exchange : this.getRelatedPhysicalLinks(source)) {
                if (!exchange.getCategories().contains((Object)key)) continue;
                this.displayABPhysicalCategoryPortDelegation(ctx, category, exchange, (PhysicalPort)org.polarsys.capella.core.data.helpers.cs.services.PhysicalLinkExt.getSourcePort((PhysicalLink)exchange), true, shService);
                this.displayABPhysicalCategoryPortDelegation(ctx, category, exchange, (PhysicalPort)org.polarsys.capella.core.data.helpers.cs.services.PhysicalLinkExt.getTargetPort((PhysicalLink)exchange), true, shService);
            }
        }
        content.commitDeferredActions();
        return context;
    }

    public EObject showABComponentCategories(DSemanticDecorator context, HashMapSet<EObject, EObject> scope, HashMapSet<EObject, EObject> initialSelection, HashMapSet<EObject, EObject> selectedElements) {
        Iterator<Object> iterator;
        ComponentExchangeCategory category;
        DDiagram currentDiagram = CapellaServices.getService().getDiagramContainer((EObject)context);
        DDiagramContents content = new DDiagramContents(currentDiagram);
        EObject source = context.getTarget();
        ShowHideABComponentCategory shService = new ShowHideABComponentCategory(content);
        AbstractShowHide.DiagramContext ctx = shService.new AbstractShowHide.DiagramContext();
        if (context instanceof DDiagramElement) {
            ctx.setVariable("spv", Collections.singletonList(context));
        }
        for (EObject key : scope.keySet()) {
            category = (ComponentExchangeCategory)key;
            iterator = scope.get(key).iterator();
            while (iterator.hasNext()) {
                EObject value = (EObject)iterator.next();
                if (selectedElements.containsKey(key) && selectedElements.get(key).contains(value) || !initialSelection.containsKey(key) || !initialSelection.get(key).contains(value)) continue;
                this.showABComponentCategory(shService, ctx, (ComponentExchangeCategory)key, source, value, false);
                for (ComponentExchange exchange : this.getRelatedComponentExchanges(source)) {
                    if (!exchange.getCategories().contains((Object)key)) continue;
                    this.displayABComponentCategoryPortDelegation(ctx, category, exchange, (ComponentPort)ComponentExchangeExt.getSourcePort((ComponentExchange)exchange), false, shService);
                    this.displayABComponentCategoryPortDelegation(ctx, category, exchange, (ComponentPort)ComponentExchangeExt.getTargetPort((ComponentExchange)exchange), false, shService);
                }
            }
        }
        for (EObject key : selectedElements.keySet()) {
            category = (ComponentExchangeCategory)key;
            iterator = selectedElements.get(key).iterator();
            while (iterator.hasNext()) {
                EObject target = (EObject)iterator.next();
                this.showABComponentCategory(shService, ctx, (ComponentExchangeCategory)key, source, target, true);
            }
            for (ComponentExchange exchange : this.getRelatedComponentExchanges(source)) {
                if (!exchange.getCategories().contains((Object)key)) continue;
                this.displayABComponentCategoryPortDelegation(ctx, category, exchange, (ComponentPort)ComponentExchangeExt.getSourcePort((ComponentExchange)exchange), true, shService);
                this.displayABComponentCategoryPortDelegation(ctx, category, exchange, (ComponentPort)ComponentExchangeExt.getTargetPort((ComponentExchange)exchange), true, shService);
            }
        }
        content.commitDeferredActions();
        return context;
    }

    public EObject switchABPhysicalCategories(DSemanticDecorator context, Collection<EObject> scope, Collection<EObject> initialSelection, Collection<EObject> selectedElements) {
        DDiagram currentDiagram = CapellaServices.getService().getDiagramContainer((EObject)context);
        DDiagramContents content = new DDiagramContents(currentDiagram);
        return this.switchABPhysicalCategories(content, context, selectedElements, true);
    }

    public EObject switchABPhysicalCategories(DDiagramContents content, DSemanticDecorator context, Collection<EObject> selectedElements, boolean showHiddenPhysicalLinks) {
        HashMapSet scopeSource;
        EObject source;
        EObject sourceViewTarget;
        ABServices.getService().updateABPhysicalCategories(content);
        DDiagram currentDiagram = content.getDDiagram();
        ArrayList<DDiagramElement> sourceViews = new ArrayList<DDiagramElement>();
        if (context instanceof DDiagramElement) {
            sourceViews.add((DDiagramElement)context);
        }
        if (sourceViews.isEmpty()) {
            DiagramElementMapping mapping = content.getMapping(MappingConstantsHelper.getMappingABComponent(CsPackage.Literals.ABSTRACT_ACTOR, currentDiagram));
            for (DDiagramElement element : content.getDiagramElements(mapping)) {
                sourceViews.add(element);
            }
            mapping = content.getMapping(MappingConstantsHelper.getMappingABComponent(CsPackage.Literals.COMPONENT, currentDiagram));
            for (DDiagramElement element : content.getDiagramElements(mapping)) {
                sourceViews.add(element);
            }
            if (currentDiagram.getDescription().getName().equalsIgnoreCase("Physical Architecture Blank")) {
                mapping = content.getMapping(MappingConstantsHelper.getMappingABDeployedElement(currentDiagram));
                for (DDiagramElement element : content.getDiagramElements(mapping)) {
                    sourceViews.add(element);
                }
            }
        }
        ShowHideABPhysicalCategory categories = new ShowHideABPhysicalCategory(content);
        AbstractShowHide.DiagramContext ctx = categories.new AbstractShowHide.DiagramContext();
        if (context instanceof DDiagramElement) {
            ctx.setVariable("spv", Collections.singletonList(context));
        }
        HashMap<EObject, Collection<PhysicalLink>> relatedPhysicalLinksMap = new HashMap<EObject, Collection<PhysicalLink>>();
        HashMap<DDiagramElement, HashMapSet<EObject, EObject>> abShowHidePhysicalCategoriesScopeMap = new HashMap<DDiagramElement, HashMapSet<EObject, EObject>>();
        for (DDiagramElement sourceView : sourceViews) {
            sourceViewTarget = sourceView.getTarget();
            if (sourceViewTarget == null) continue;
            source = sourceViewTarget;
            Collection<PhysicalLink> relatedPhysicalLinks = this.getRelatedPhysicalLinks(source);
            relatedPhysicalLinksMap.put(source, relatedPhysicalLinks);
            abShowHidePhysicalCategoriesScopeMap.put(sourceView, this.getABShowHidePhysicalCategoriesScope((DSemanticDecorator)sourceView, relatedPhysicalLinks));
        }
        for (DDiagramElement sourceView : sourceViews) {
            sourceViewTarget = sourceView.getTarget();
            if (sourceViewTarget == null) continue;
            source = sourceViewTarget;
            scopeSource = (HashMapSet)abShowHidePhysicalCategoriesScopeMap.get(sourceView);
            for (EObject key : scopeSource.keySet()) {
                EObject target;
                Iterator iterator;
                if (selectedElements.contains(key)) {
                    iterator = scopeSource.get(key).iterator();
                    while (iterator.hasNext()) {
                        target = (EObject)iterator.next();
                        this.showABPhysicalCategory(categories, ctx, (PhysicalLinkCategory)key, source, target, true);
                    }
                    continue;
                }
                iterator = scopeSource.get(key).iterator();
                while (iterator.hasNext()) {
                    target = (EObject)iterator.next();
                    this.showABPhysicalCategory(categories, ctx, (PhysicalLinkCategory)key, source, target, false);
                }
            }
        }
        for (DDiagramElement sourceView : sourceViews) {
            sourceViewTarget = sourceView.getTarget();
            if (sourceViewTarget == null) continue;
            source = sourceViewTarget;
            scopeSource = (HashMapSet)abShowHidePhysicalCategoriesScopeMap.get(sourceView);
            for (EObject key : scopeSource.keySet()) {
                PhysicalLinkCategory category = (PhysicalLinkCategory)key;
                if (selectedElements.contains(key)) {
                    for (PhysicalLink exchange : (Collection)relatedPhysicalLinksMap.get(source)) {
                        if (!exchange.getCategories().contains((Object)key)) continue;
                        this.displayABPhysicalCategoryPortDelegation(ctx, category, exchange, (PhysicalPort)org.polarsys.capella.core.data.helpers.cs.services.PhysicalLinkExt.getSourcePort((PhysicalLink)exchange), true, categories);
                        this.displayABPhysicalCategoryPortDelegation(ctx, category, exchange, (PhysicalPort)org.polarsys.capella.core.data.helpers.cs.services.PhysicalLinkExt.getTargetPort((PhysicalLink)exchange), true, categories);
                        categories.hide((EObject)exchange, ctx);
                    }
                    continue;
                }
                if (!showHiddenPhysicalLinks) continue;
                for (PhysicalLink exchange : (Collection)relatedPhysicalLinksMap.get(source)) {
                    if (!exchange.getCategories().contains((Object)key)) continue;
                    this.displayABPhysicalCategoryPortDelegation(ctx, category, exchange, (PhysicalPort)org.polarsys.capella.core.data.helpers.cs.services.PhysicalLinkExt.getSourcePort((PhysicalLink)exchange), false, categories);
                    this.displayABPhysicalCategoryPortDelegation(ctx, category, exchange, (PhysicalPort)org.polarsys.capella.core.data.helpers.cs.services.PhysicalLinkExt.getTargetPort((PhysicalLink)exchange), false, categories);
                    categories.show((EObject)exchange, ctx);
                }
            }
        }
        ABServices.getService().updateABPhysicalCategories(content);
        content.commitDeferredActions();
        return context;
    }

    public EObject switchABComponentCategories(DSemanticDecorator context, Collection<EObject> scope, Collection<EObject> initialSelection, Collection<EObject> selectedElements) {
        DDiagram currentDiagram = CapellaServices.getService().getDiagramContainer((EObject)context);
        DDiagramContents content = new DDiagramContents(currentDiagram);
        return this.switchABComponentCategories(content, context, selectedElements, true);
    }

    @Deprecated
    public EObject switchABComponentCategories(DDiagramContents content, DSemanticDecorator context, Collection<EObject> selectedElements) {
        return this.switchABComponentCategories(content, context, selectedElements, true);
    }

    public EObject switchABComponentCategories(DDiagramContents content, DSemanticDecorator context, Collection<EObject> selectedElements, boolean showHiddenExchanges) {
        HashMapSet scopeSource;
        EObject source;
        EObject sourceViewTarget;
        ABServices.getService().updateABComponentCategories(content);
        DDiagram currentDiagram = content.getDDiagram();
        HashSet<DDiagramElement> sourceViews = new HashSet<DDiagramElement>();
        if (context instanceof DDiagramElement) {
            sourceViews.add((DDiagramElement)context);
        }
        if (sourceViews.isEmpty()) {
            DiagramElementMapping mapping = content.getMapping(MappingConstantsHelper.getMappingABComponent(CsPackage.Literals.ABSTRACT_ACTOR, currentDiagram));
            for (DDiagramElement element : content.getDiagramElements(mapping)) {
                sourceViews.add(element);
            }
            mapping = content.getMapping(MappingConstantsHelper.getMappingABComponent(CsPackage.Literals.COMPONENT, currentDiagram));
            for (DDiagramElement element : content.getDiagramElements(mapping)) {
                sourceViews.add(element);
            }
            if (currentDiagram.getDescription().getName().equalsIgnoreCase("Physical Architecture Blank")) {
                mapping = content.getMapping(MappingConstantsHelper.getMappingABDeployedElement(currentDiagram));
                for (DDiagramElement element : content.getDiagramElements(mapping)) {
                    sourceViews.add(element);
                }
            }
        }
        ShowHideABComponentCategory categories = new ShowHideABComponentCategory(content);
        AbstractShowHide.DiagramContext ctx = categories.new AbstractShowHide.DiagramContext();
        if (context instanceof DDiagramElement) {
            ctx.setVariable("spv", Collections.singletonList(context));
        }
        HashMap<EObject, Collection<ComponentExchange>> relatedComponentExchangesMap = new HashMap<EObject, Collection<ComponentExchange>>();
        HashMap<DDiagramElement, HashMapSet<EObject, EObject>> abShowHideComponentCategoriesScopeMap = new HashMap<DDiagramElement, HashMapSet<EObject, EObject>>();
        for (DDiagramElement sourceView : sourceViews) {
            sourceViewTarget = sourceView.getTarget();
            if (sourceViewTarget == null) continue;
            source = sourceViewTarget;
            Collection<ComponentExchange> relatedComponentExchanges = this.getRelatedComponentExchanges(source);
            relatedComponentExchangesMap.put(source, this.getRelatedComponentExchanges(source));
            abShowHideComponentCategoriesScopeMap.put(sourceView, this.getABShowHideComponentCategoriesScope((DSemanticDecorator)sourceView, relatedComponentExchanges));
        }
        for (DDiagramElement sourceView : sourceViews) {
            sourceViewTarget = sourceView.getTarget();
            if (sourceViewTarget == null) continue;
            source = sourceViewTarget;
            scopeSource = (HashMapSet)abShowHideComponentCategoriesScopeMap.get(sourceView);
            for (EObject key : scopeSource.keySet()) {
                EObject target;
                Iterator iterator;
                if (selectedElements.contains(key)) {
                    iterator = scopeSource.get(key).iterator();
                    while (iterator.hasNext()) {
                        target = (EObject)iterator.next();
                        this.showABComponentCategory(categories, ctx, (ComponentExchangeCategory)key, source, target, true);
                    }
                    continue;
                }
                iterator = scopeSource.get(key).iterator();
                while (iterator.hasNext()) {
                    target = (EObject)iterator.next();
                    this.showABComponentCategory(categories, ctx, (ComponentExchangeCategory)key, source, target, false);
                }
            }
        }
        for (DDiagramElement sourceView : sourceViews) {
            sourceViewTarget = sourceView.getTarget();
            if (sourceViewTarget == null) continue;
            source = sourceViewTarget;
            scopeSource = (HashMapSet)abShowHideComponentCategoriesScopeMap.get(sourceView);
            for (EObject key : scopeSource.keySet()) {
                ComponentExchangeCategory category = (ComponentExchangeCategory)key;
                if (selectedElements.contains(key)) {
                    for (ComponentExchange exchange : (Collection)relatedComponentExchangesMap.get(source)) {
                        if (!exchange.getCategories().contains((Object)key)) continue;
                        this.displayABComponentCategoryPortDelegation(ctx, category, exchange, (ComponentPort)ComponentExchangeExt.getSourcePort((ComponentExchange)exchange), true, categories);
                        this.displayABComponentCategoryPortDelegation(ctx, category, exchange, (ComponentPort)ComponentExchangeExt.getTargetPort((ComponentExchange)exchange), true, categories);
                        categories.hide((EObject)exchange, ctx);
                    }
                    continue;
                }
                if (!showHiddenExchanges) continue;
                for (ComponentExchange exchange : (Collection)relatedComponentExchangesMap.get(source)) {
                    if (!exchange.getCategories().contains((Object)key)) continue;
                    this.displayABComponentCategoryPortDelegation(ctx, category, exchange, (ComponentPort)ComponentExchangeExt.getSourcePort((ComponentExchange)exchange), false, categories);
                    this.displayABComponentCategoryPortDelegation(ctx, category, exchange, (ComponentPort)ComponentExchangeExt.getTargetPort((ComponentExchange)exchange), false, categories);
                    categories.show((EObject)exchange, ctx);
                }
            }
        }
        ABServices.getService().updateABComponentCategories(content);
        content.commitDeferredActions();
        return context;
    }

    private void showABPhysicalCategory(AbstractShowHide categories, AbstractShowHide.DiagramContext context, PhysicalLinkCategory key, EObject source, EObject target, boolean b) {
        context.setVariable("sourceParts", Collections.singletonList(source));
        context.setVariable("targetParts", Collections.singletonList(target));
        boolean isSourceAndTargetNoPort = false;
        boolean isSourceAndTargetPort = false;
        for (PhysicalLink exchanges : this.getRelatedPhysicalLinks(source, target, key)) {
            Port sourcePort = org.polarsys.capella.core.data.helpers.cs.services.PhysicalLinkExt.getSourcePort((PhysicalLink)exchanges);
            Port targetPort = org.polarsys.capella.core.data.helpers.cs.services.PhysicalLinkExt.getTargetPort((PhysicalLink)exchanges);
            if (sourcePort == null && targetPort == null) {
                isSourceAndTargetNoPort = true;
            }
            if (sourcePort == null || targetPort == null) continue;
            isSourceAndTargetPort = true;
        }
        if (isSourceAndTargetNoPort) {
            context.setVariable("npo", Boolean.TRUE);
            context.setVariable("npo", Boolean.TRUE);
            if (b) {
                categories.show((EObject)key, context);
            } else {
                categories.hide((EObject)key, context);
            }
        }
        if (isSourceAndTargetPort) {
            context.setVariable("npo", Boolean.FALSE);
            context.setVariable("npo", Boolean.FALSE);
            if (b) {
                categories.show((EObject)key, context);
            } else {
                categories.hide((EObject)key, context);
            }
        }
    }

    private void showABComponentCategory(AbstractShowHide categories, AbstractShowHide.DiagramContext context, ComponentExchangeCategory key, EObject source, EObject target, boolean b) {
        context.setVariable("sourceParts", Collections.singletonList(source));
        context.setVariable("targetParts", Collections.singletonList(target));
        boolean isSourceAndTargetNoPort = false;
        boolean isSourceAndTargetPort = false;
        for (ComponentExchange exchanges : this.getRelatedComponentExchanges(source, target, key)) {
            Port sourcePort = ComponentExchangeExt.getSourcePort((ComponentExchange)exchanges);
            Port targetPort = ComponentExchangeExt.getTargetPort((ComponentExchange)exchanges);
            if (sourcePort == null && targetPort == null) {
                isSourceAndTargetNoPort = true;
            }
            if (sourcePort == null || targetPort == null) continue;
            isSourceAndTargetPort = true;
        }
        if (isSourceAndTargetNoPort) {
            context.setVariable("npo", Boolean.TRUE);
            context.setVariable("npo", Boolean.TRUE);
            if (b) {
                categories.show((EObject)key, context);
            } else {
                categories.hide((EObject)key, context);
            }
        }
        if (isSourceAndTargetPort) {
            context.setVariable("npo", Boolean.FALSE);
            context.setVariable("npo", Boolean.FALSE);
            if (b) {
                categories.show((EObject)key, context);
            } else {
                categories.hide((EObject)key, context);
            }
        }
    }

    protected void displayABPhysicalCategoryPortDelegation(AbstractShowHide.DiagramContext context, PhysicalLinkCategory category, PhysicalLink exchange, PhysicalPort sourcePort, boolean b, AbstractShowHide service) {
        if (sourcePort == null) {
            return;
        }
        for (EObject element : this.getPhysicalLinkDelegationsForCategory(sourcePort, category)) {
            PhysicalLink delegation;
            if (element instanceof PhysicalLink) {
                delegation = (PhysicalLink)element;
                if (org.polarsys.capella.core.data.helpers.cs.services.PhysicalLinkExt.getSourcePort((PhysicalLink)delegation).equals(sourcePort)) {
                    context.setVariable("tpo", Collections.singletonList(org.polarsys.capella.core.data.helpers.cs.services.PhysicalLinkExt.getTargetPort((PhysicalLink)delegation)));
                }
                if (org.polarsys.capella.core.data.helpers.cs.services.PhysicalLinkExt.getTargetPort((PhysicalLink)delegation).equals(sourcePort)) {
                    context.setVariable("spo", Collections.singletonList(org.polarsys.capella.core.data.helpers.cs.services.PhysicalLinkExt.getSourcePort((PhysicalLink)delegation)));
                }
                context.setVariable("sourceParts", org.polarsys.capella.core.data.helpers.cs.services.PhysicalLinkExt.getSourceParts((PhysicalLink)delegation));
                context.setVariable("targetParts", org.polarsys.capella.core.data.helpers.cs.services.PhysicalLinkExt.getTargetParts((PhysicalLink)delegation));
                if (b) {
                    service.show((EObject)category, context);
                    context.unsetVariable("spo");
                    context.unsetVariable("tpo");
                    service.hide((EObject)delegation, context);
                    continue;
                }
                service.hide((EObject)category, context);
                context.unsetVariable("spo");
                context.unsetVariable("tpo");
                service.show((EObject)delegation, context);
                continue;
            }
            if (!(element instanceof ComponentPortAllocation)) continue;
            delegation = (ComponentPortAllocation)element;
            if (ComponentPortAllocationExt.getSourcePort((ComponentPortAllocation)delegation).equals(sourcePort)) {
                context.setVariable("tpo", Collections.singletonList(ComponentPortAllocationExt.getTargetPort((ComponentPortAllocation)delegation)));
            }
            if (ComponentPortAllocationExt.getTargetPort((ComponentPortAllocation)delegation).equals(sourcePort)) {
                context.setVariable("spo", Collections.singletonList(ComponentPortAllocationExt.getSourcePort((ComponentPortAllocation)delegation)));
            }
            context.setVariable("sourceParts", ComponentPortAllocationExt.getSourceParts((ComponentPortAllocation)delegation));
            context.setVariable("targetParts", ComponentPortAllocationExt.getTargetParts((ComponentPortAllocation)delegation));
            if (b) {
                service.show((EObject)category, context);
                context.unsetVariable("spo");
                context.unsetVariable("tpo");
                service.hide((EObject)delegation, context);
                continue;
            }
            service.hide((EObject)category, context);
            context.unsetVariable("spo");
            context.unsetVariable("tpo");
            service.show((EObject)delegation, context);
        }
    }

    protected void displayABComponentCategoryPortDelegation(AbstractShowHide.DiagramContext context, ComponentExchangeCategory category, ComponentExchange exchange, ComponentPort sourcePort, boolean b, AbstractShowHide service) {
        if (sourcePort == null) {
            return;
        }
        for (ComponentExchange delegation : this.getComponentExchangeDelegationsForCategory(sourcePort, category)) {
            if (ComponentExchangeExt.getSourcePort((ComponentExchange)delegation).equals(sourcePort)) {
                context.setVariable("tpo", Collections.singletonList(ComponentExchangeExt.getTargetPort((ComponentExchange)delegation)));
            }
            if (ComponentExchangeExt.getTargetPort((ComponentExchange)delegation).equals(sourcePort)) {
                context.setVariable("spo", Collections.singletonList(ComponentExchangeExt.getSourcePort((ComponentExchange)delegation)));
            }
            context.setVariable("sourceParts", ComponentExchangeExt.getSourcePartsAndEntities((ComponentExchange)delegation));
            context.setVariable("targetParts", ComponentExchangeExt.getTargetPartsAndEntities((ComponentExchange)delegation));
            if (b) {
                service.show((EObject)category, context);
                context.unsetVariable("spo");
                context.unsetVariable("tpo");
                service.hide((EObject)delegation, context);
                continue;
            }
            service.hide((EObject)category, context);
            context.unsetVariable("spo");
            context.unsetVariable("tpo");
            service.show((EObject)delegation, context);
        }
    }

    protected Collection<EObject> getPhysicalLinkDelegationsForCategory(PhysicalPort port, PhysicalLinkCategory category) {
        ArrayList<EObject> result = new ArrayList<EObject>();
        if (port != null) {
            for (PhysicalLink exchange : PortExt.getDelegatedPhysicalLinks((PhysicalPort)port)) {
                if (exchange.getCategories().contains((Object)category)) continue;
                result.add((EObject)exchange);
            }
            for (ComponentPortAllocation allocation : port.getOwnedComponentPortAllocations()) {
                result.add((EObject)allocation);
            }
        }
        return result;
    }

    protected Collection<ComponentExchange> getComponentExchangeDelegationsForCategory(ComponentPort port, ComponentExchangeCategory category) {
        ArrayList<ComponentExchange> result = new ArrayList<ComponentExchange>();
        if (port != null) {
            for (ComponentExchange exchange : PortExt.getDelegatedComponentExchanges((ComponentPort)port)) {
                if (exchange.getCategories().contains((Object)category)) continue;
                result.add(exchange);
            }
        }
        return result;
    }

    public Collection<PhysicalLink> getRelatedPhysicalLinks(EObject source, EObject target, PhysicalLinkCategory category) {
        ArrayList<PhysicalLink> result = new ArrayList<PhysicalLink>();
        for (PhysicalLink element : this.getRelatedPhysicalLinks(source)) {
            if (!element.getCategories().contains((Object)category)) continue;
            Collection sourceParts = org.polarsys.capella.core.data.helpers.cs.services.PhysicalLinkExt.getSourceParts((PhysicalLink)element);
            Collection targetParts = org.polarsys.capella.core.data.helpers.cs.services.PhysicalLinkExt.getTargetParts((PhysicalLink)element);
            if (sourceParts.contains(source) && targetParts.contains(target)) {
                result.add(element);
                continue;
            }
            if (!sourceParts.contains(target) || !targetParts.contains(source)) continue;
            result.add(element);
        }
        return result;
    }

    public Collection<PhysicalLink> getRelatedPhysicalLinks(EObject part) {
        if (part instanceof Part) {
            return org.polarsys.capella.core.data.helpers.cs.services.PhysicalLinkExt.getAllRelatedPhysicalLinks((Part)((Part)part));
        }
        return Collections.emptyList();
    }

    public Collection<ComponentExchange> getRelatedComponentExchanges(EObject sourcePart, EObject targetPart, ComponentExchangeCategory category) {
        ArrayList<ComponentExchange> result = new ArrayList<ComponentExchange>();
        for (ComponentExchange element : this.getRelatedComponentExchanges(sourcePart)) {
            if (!element.getCategories().contains((Object)category)) continue;
            Collection sourceParts = ComponentExchangeExt.getSourcePartsAndEntities((ComponentExchange)element);
            Collection targetParts = ComponentExchangeExt.getTargetPartsAndEntities((ComponentExchange)element);
            if (sourceParts.contains(sourcePart) && targetParts.contains(targetPart)) {
                result.add(element);
                continue;
            }
            if (!sourceParts.contains(targetPart) || !targetParts.contains(sourcePart)) continue;
            result.add(element);
        }
        return result;
    }

    public Collection<ComponentExchange> getRelatedComponentExchanges(EObject element) {
        if (element instanceof Part) {
            return ComponentExt.getAllRelatedComponentExchange((Part)((Part)element), (boolean)true);
        }
        if (element instanceof Component) {
            return ComponentExt.getAllRelatedComponentExchange((Component)((Component)element));
        }
        return Collections.emptyList();
    }

    public Collection<PhysicalLink> getRelatedPhysicalLink(EObject element) {
        if (element instanceof Part) {
            return org.polarsys.capella.core.data.helpers.cs.services.PhysicalLinkExt.getAllRelatedPhysicalLinks((Part)((Part)element));
        }
        if (element instanceof Component) {
            return org.polarsys.capella.core.data.helpers.cs.services.PhysicalLinkExt.getAllRelatedPhysicalLinks((Component)((Component)element));
        }
        return Collections.emptyList();
    }

    public HashMapSet<EObject, EObject> getABShowHidePhysicalCategoriesScope(DSemanticDecorator context, Collection<PhysicalLink> relatedPhysicalLinks) {
        HashMapSet<EObject, EObject> result = new HashMapSet<EObject, EObject>();
        InformationsExchanger relatedPart = CsServices.getService().getRelatedPart(context);
        if (relatedPart != null) {
            for (PhysicalLink exchange : relatedPhysicalLinks) {
                for (PhysicalLinkCategory value : exchange.getCategories()) {
                    Collection sourceParts = org.polarsys.capella.core.data.helpers.cs.services.PhysicalLinkExt.getSourceParts((PhysicalLink)exchange);
                    Collection targetParts = org.polarsys.capella.core.data.helpers.cs.services.PhysicalLinkExt.getTargetParts((PhysicalLink)exchange);
                    if (sourceParts.contains(relatedPart)) {
                        for (EObject related : targetParts) {
                            result.put((EObject)value, related);
                        }
                        continue;
                    }
                    if (!targetParts.contains(relatedPart)) continue;
                    for (EObject related : sourceParts) {
                        result.put((EObject)value, related);
                    }
                }
            }
        }
        return result;
    }

    public HashMapSet<EObject, EObject> getABShowHidePhysicalCategoriesScope(DSemanticDecorator context) {
        InformationsExchanger relatedPart = CsServices.getService().getRelatedPart(context);
        if (relatedPart != null) {
            Collection<PhysicalLink> relatedPhysicalLinks = this.getRelatedPhysicalLinks((EObject)relatedPart);
            return this.getABShowHidePhysicalCategoriesScope(context, relatedPhysicalLinks);
        }
        return new HashMapSet<EObject, EObject>();
    }

    public HashMapSet<EObject, EObject> getABShowHideComponentCategoriesScope(DSemanticDecorator context, Collection<ComponentExchange> relatedComponentExchanges) {
        HashMapSet<EObject, EObject> result = new HashMapSet<EObject, EObject>();
        InformationsExchanger relatedPart = CsServices.getService().getRelatedPart(context);
        if (relatedPart != null) {
            for (ComponentExchange exchange : relatedComponentExchanges) {
                for (ComponentExchangeCategory value : exchange.getCategories()) {
                    Collection sourceParts = ComponentExchangeExt.getSourcePartsAndEntities((ComponentExchange)exchange);
                    Collection targetParts = ComponentExchangeExt.getTargetPartsAndEntities((ComponentExchange)exchange);
                    if (sourceParts.contains(relatedPart)) {
                        for (EObject related : targetParts) {
                            result.put((EObject)value, related);
                        }
                        continue;
                    }
                    if (!targetParts.contains(relatedPart)) continue;
                    for (EObject related : sourceParts) {
                        result.put((EObject)value, related);
                    }
                }
            }
        }
        return result;
    }

    @Deprecated
    public HashMapSet<EObject, EObject> getABShowHideComponentCategoriesScope(DSemanticDecorator context) {
        InformationsExchanger relatedPart = CsServices.getService().getRelatedPart(context);
        if (relatedPart != null) {
            Collection<ComponentExchange> relatedComponentExchanges = this.getRelatedComponentExchanges((EObject)relatedPart);
            return this.getABShowHideComponentCategoriesScope(context, relatedComponentExchanges);
        }
        return new HashMapSet<EObject, EObject>();
    }

    public HashMapSet<EObject, EObject> getABShowHidePhysicalCategoriesInitialSelection(DSemanticDecorator context) {
        HashMapSet<EObject, EObject> scope = this.getABShowHidePhysicalCategoriesScope(context);
        HashMapSet<EObject, EObject> result = new HashMapSet<EObject, EObject>();
        DDiagram diagram = CapellaServices.getService().getDiagramContainer((EObject)context);
        DDiagramContents ctx = new DDiagramContents(diagram);
        DiagramElementMapping edgeMapping = ctx.getMapping(MappingConstantsHelper.getMappingABPhysicalCategory(ctx.getDDiagram()));
        DSemanticDecorator sourcePartView = CsServices.getService().getRelatedPartView(context);
        for (EObject key : scope.keySet()) {
            Iterator iterator = scope.get(key).iterator();
            while (iterator.hasNext()) {
                EObject targetPart = (EObject)iterator.next();
                for (DDiagramElement elementView : ctx.getDiagramElements(key, edgeMapping)) {
                    if (!(elementView instanceof DEdge)) continue;
                    DEdge ve = (DEdge)elementView;
                    DSemanticDecorator edgeSourcePartView = CsServices.getService().getRelatedPartView((DSemanticDecorator)ve.getSourceNode());
                    DSemanticDecorator edgeTargetPartView = CsServices.getService().getRelatedPartView((DSemanticDecorator)ve.getTargetNode());
                    InformationsExchanger edgeSourcePart = CsServices.getService().getRelatedPart((DSemanticDecorator)ve.getSourceNode());
                    InformationsExchanger edgeTargetPart = CsServices.getService().getRelatedPart((DSemanticDecorator)ve.getTargetNode());
                    boolean related = false;
                    if (sourcePartView != null) {
                        if (sourcePartView.equals(edgeSourcePartView) && targetPart.equals(edgeTargetPart)) {
                            related = true;
                        } else if (sourcePartView.equals(edgeTargetPartView) && targetPart.equals(edgeSourcePart)) {
                            related = true;
                        }
                    }
                    if (!related) continue;
                    result.put(key, targetPart);
                }
            }
        }
        return result;
    }

    public HashMapSet<EObject, EObject> getABShowHideComponentCategoriesInitialSelection(DSemanticDecorator context) {
        HashMapSet<EObject, EObject> scope = this.getABShowHideComponentCategoriesScope(context);
        HashMapSet<EObject, EObject> result = new HashMapSet<EObject, EObject>();
        DDiagram diagram = CapellaServices.getService().getDiagramContainer((EObject)context);
        DDiagramContents ctx = new DDiagramContents(diagram);
        DiagramElementMapping edgeMapping = ctx.getMapping(MappingConstantsHelper.getMappingABComponentCategory(ctx.getDDiagram()));
        DSemanticDecorator sourcePartView = CsServices.getService().getRelatedPartView(context);
        for (EObject key : scope.keySet()) {
            Iterator iterator = scope.get(key).iterator();
            while (iterator.hasNext()) {
                EObject targetPart = (EObject)iterator.next();
                for (DDiagramElement elementView : ctx.getDiagramElements(key, edgeMapping)) {
                    if (!(elementView instanceof DEdge)) continue;
                    DEdge ve = (DEdge)elementView;
                    DSemanticDecorator edgeSourcePartView = CsServices.getService().getRelatedPartView((DSemanticDecorator)ve.getSourceNode());
                    DSemanticDecorator edgeTargetPartView = CsServices.getService().getRelatedPartView((DSemanticDecorator)ve.getTargetNode());
                    InformationsExchanger edgeSourcePart = CsServices.getService().getRelatedPart((DSemanticDecorator)ve.getSourceNode());
                    InformationsExchanger edgeTargetPart = CsServices.getService().getRelatedPart((DSemanticDecorator)ve.getTargetNode());
                    boolean related = false;
                    if (sourcePartView != null) {
                        if (sourcePartView.equals(edgeSourcePartView) && targetPart.equals(edgeTargetPart)) {
                            related = true;
                        } else if (sourcePartView.equals(edgeTargetPartView) && targetPart.equals(edgeSourcePart)) {
                            related = true;
                        }
                    }
                    if (!related) continue;
                    result.put(key, targetPart);
                }
            }
        }
        return result;
    }

    public Collection<EObject> getABSwitchPhysicalCategoriesScope(DSemanticDecorator context) {
        if (context instanceof DDiagram) {
            HashSet<EObject> values = new HashSet<EObject>();
            DDiagramContents ctx = new DDiagramContents((DDiagram)context);
            Iterable<DDiagramElement> diagramElements = ctx.getDiagramElements(ctx.getMapping(MappingConstantsHelper.getMappingABPhysicalLink(ctx.getDDiagram())));
            for (DDiagramElement element : diagramElements) {
                if (element.getTarget() == null || !(element.getTarget() instanceof PhysicalLink)) continue;
                values.addAll((Collection<EObject>)((PhysicalLink)element.getTarget()).getCategories());
            }
            return values;
        }
        HashMapSet<EObject, EObject> scope = this.getABShowHidePhysicalCategoriesScope(context);
        return scope.keySet();
    }

    public Collection<EObject> getABSwitchComponentCategoriesScope(DSemanticDecorator context) {
        if (context instanceof DDiagram) {
            HashSet<EObject> values = new HashSet<EObject>();
            DDiagramContents ctx = new DDiagramContents((DDiagram)context);
            for (DDiagramElement element : ctx.getDiagramElements(ctx.getMapping(MappingConstantsHelper.getMappingABConnection(ctx.getDDiagram())))) {
                if (element.getTarget() == null || !(element.getTarget() instanceof ComponentExchange)) continue;
                values.addAll((Collection<EObject>)((ComponentExchange)element.getTarget()).getCategories());
            }
            return values;
        }
        HashMapSet<EObject, EObject> scope = this.getABShowHideComponentCategoriesScope(context);
        return scope.keySet();
    }

    public Collection<EObject> getABSwitchPhysicalCategoriesInitialSelection(DSemanticDecorator context) {
        if (context instanceof DDiagram) {
            HashSet<EObject> values = new HashSet<EObject>();
            DDiagramContents ctx = new DDiagramContents((DDiagram)context);
            DiagramElementMapping edgeMapping = ctx.getMapping(MappingConstantsHelper.getMappingABPhysicalCategory(ctx.getDDiagram()));
            for (DDiagramElement element : ctx.getDiagramElements(edgeMapping)) {
                if (element.getTarget() == null || !(element.getTarget() instanceof CapellaElement)) continue;
                values.add(element.getTarget());
            }
            return values;
        }
        HashMapSet<EObject, EObject> result = this.getABShowHidePhysicalCategoriesInitialSelection(context);
        return result.keySet();
    }

    public Collection<EObject> getABSwitchComponentCategoriesInitialSelection(DSemanticDecorator context) {
        if (context instanceof DDiagram) {
            HashSet<EObject> values = new HashSet<EObject>();
            DDiagramContents ctx = new DDiagramContents((DDiagram)context);
            DiagramElementMapping edgeMapping = ctx.getMapping(MappingConstantsHelper.getMappingABComponentCategory(ctx.getDDiagram()));
            for (DDiagramElement element : ctx.getDiagramElements(edgeMapping)) {
                if (element.getTarget() == null || !(element.getTarget() instanceof CapellaElement)) continue;
                values.add(element.getTarget());
            }
            return values;
        }
        HashMapSet<EObject, EObject> result = this.getABShowHideComponentCategoriesInitialSelection(context);
        return result.keySet();
    }

    public Collection<EObject> getComponentCategorySources(EObject context) {
        return Collections.singletonList(context);
    }

    public Collection<EObject> getComponentCategoryTargets(EObject context) {
        return Collections.singletonList(context);
    }

    public Collection<EObject> getPhysicalCategorySources(EObject context) {
        return Collections.singletonList(context);
    }

    public Collection<EObject> getPhysicalCategoryTargets(EObject context) {
        return Collections.singletonList(context);
    }

    public boolean isABComponentCategoryPortIsA(EObject context, DSemanticDecorator containerView, ComponentPortKind kind, OrientationPortKind orientation) {
        if (containerView != null && containerView instanceof AbstractDNode) {
            InformationsExchanger sourcePart = CsServices.getService().getRelatedPart(containerView);
            for (ComponentExchange exchange : this.getRelatedComponentExchanges((EObject)sourcePart)) {
                ComponentPort cp;
                Port port;
                if (!exchange.getCategories().contains((Object)context) || (port = ComponentExchangeExt.getSourceParts((ComponentExchange)exchange).contains(sourcePart) ? ComponentExchangeExt.getSourcePort((ComponentExchange)exchange) : ComponentExchangeExt.getTargetPort((ComponentExchange)exchange)) == null || !(port instanceof ComponentPort) || (cp = (ComponentPort)port).getKind() == kind && (cp.getOrientation() == orientation || OrientationPortKind.UNSET == orientation)) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public boolean isABComponentCategoryPortStandard(EObject context, DSemanticDecorator containerView) {
        return this.isABComponentCategoryPortIsA(context, containerView, ComponentPortKind.STANDARD, OrientationPortKind.UNSET);
    }

    public boolean isABComponentCategoryPortIn(EObject context, DSemanticDecorator containerView) {
        return this.isABComponentCategoryPortIsA(context, containerView, ComponentPortKind.FLOW, OrientationPortKind.IN);
    }

    public boolean isABComponentCategoryPortOut(EObject context, DSemanticDecorator containerView) {
        return this.isABComponentCategoryPortIsA(context, containerView, ComponentPortKind.FLOW, OrientationPortKind.OUT);
    }

    public boolean isABComponentCategoryPortInOut(EObject context, DSemanticDecorator containerView) {
        return this.isABComponentCategoryPortIsA(context, containerView, ComponentPortKind.FLOW, OrientationPortKind.INOUT);
    }

    public boolean isABComponentCategorySourceOriented(DSemanticDecorator context) {
        boolean result = true;
        EObject target = context.getTarget();
        if (context instanceof DEdge) {
            DEdge edge = (DEdge)context;
            DSemanticDecorator sourceNode = (DSemanticDecorator)edge.getSourceNode();
            DSemanticDecorator targetNode = (DSemanticDecorator)edge.getTargetNode();
            InformationsExchanger sourcePart = CsServices.getService().getRelatedPart(sourceNode);
            InformationsExchanger targetPart = CsServices.getService().getRelatedPart(targetNode);
            if (target instanceof ComponentExchangeCategory) {
                ComponentExchangeCategory property = (ComponentExchangeCategory)target;
                for (EObject ce : property.getExchanges()) {
                    if (!(ce instanceof ComponentExchange)) continue;
                    ComponentExchange exchange = (ComponentExchange)ce;
                    Collection sourceParts = ComponentExchangeExt.getSourcePartsAndEntities((ComponentExchange)exchange);
                    Collection targetParts = ComponentExchangeExt.getTargetPartsAndEntities((ComponentExchange)exchange);
                    HashSet unionParts = new HashSet();
                    unionParts.addAll(sourceParts);
                    unionParts.addAll(targetParts);
                    if (!unionParts.contains(sourcePart) || !unionParts.contains(targetPart)) continue;
                    if (exchange.isOriented()) {
                        if (ComponentExchangeExt.getSourcePartsAndEntities((ComponentExchange)exchange).contains(targetPart) && ComponentExchangeExt.getTargetPartsAndEntities((ComponentExchange)exchange).contains(sourcePart)) continue;
                        result = false;
                        break;
                    }
                    result = false;
                    break;
                }
            }
        }
        return result;
    }

    public boolean isABComponentCategoryTargetOriented(DSemanticDecorator context) {
        boolean result = true;
        EObject target = context.getTarget();
        if (context instanceof DEdge) {
            DEdge edge = (DEdge)context;
            DSemanticDecorator sourceNode = (DSemanticDecorator)edge.getSourceNode();
            DSemanticDecorator targetNode = (DSemanticDecorator)edge.getTargetNode();
            InformationsExchanger sourcePart = CsServices.getService().getRelatedPart(sourceNode);
            InformationsExchanger targetPart = CsServices.getService().getRelatedPart(targetNode);
            if (target instanceof ComponentExchangeCategory) {
                ComponentExchangeCategory property = (ComponentExchangeCategory)target;
                for (EObject ce : property.getExchanges()) {
                    if (!(ce instanceof ComponentExchange)) continue;
                    ComponentExchange exchange = (ComponentExchange)ce;
                    Collection sourceParts = ComponentExchangeExt.getSourcePartsAndEntities((ComponentExchange)exchange);
                    Collection targetParts = ComponentExchangeExt.getTargetPartsAndEntities((ComponentExchange)exchange);
                    HashSet unionParts = new HashSet();
                    unionParts.addAll(sourceParts);
                    unionParts.addAll(targetParts);
                    if (!unionParts.contains(sourcePart) || !unionParts.contains(targetPart)) continue;
                    if (exchange.isOriented()) {
                        if (ComponentExchangeExt.getSourcePartsAndEntities((ComponentExchange)exchange).contains(sourcePart) && ComponentExchangeExt.getTargetPartsAndEntities((ComponentExchange)exchange).contains(targetPart)) continue;
                        result = false;
                        break;
                    }
                    result = false;
                    break;
                }
            }
        }
        return result;
    }

    public void updateABComponentCategories(DDiagramContents context) {
        Collection<DiagramElementMapping> nodeMappings;
        HashSet<DEdge> toRemoveEdges = new HashSet<DEdge>();
        HashSet<AbstractDNode> toRemoveNodes = new HashSet<AbstractDNode>();
        HashSet<AbstractDNode> toHideNodes = new HashSet<AbstractDNode>();
        DiagramElementMapping edgeMapping = context.getMapping(MappingConstantsHelper.getMappingABComponentCategory(context.getDDiagram()));
        DiagramElementMapping nodeMapping = context.getMapping(MappingConstantsHelper.getMappingABComponentCategoryPin(context.getDDiagram()));
        if (edgeMapping != null) {
            for (DDiagramElement element : context.getDiagramElements(edgeMapping)) {
                if (!(element instanceof DEdge)) continue;
                DEdge edge = (DEdge)element;
                boolean isValidEdge = this.isValidABComponentCategoryEdge((ComponentExchangeCategory)element.getTarget(), (DSemanticDecorator)edge.getSourceNode(), (DSemanticDecorator)edge.getTargetNode());
                if (isValidEdge) continue;
                toRemoveEdges.add(edge);
            }
        }
        if (nodeMapping != null) {
            for (DDiagramElement element : context.getDiagramElements(nodeMapping)) {
                if (!(element instanceof EdgeTarget)) continue;
                ArrayList edges = new ArrayList();
                edges.addAll(((EdgeTarget)element).getIncomingEdges());
                edges.addAll(((EdgeTarget)element).getOutgoingEdges());
                if (edges.size() == 0) {
                    toRemoveNodes.add((AbstractDNode)element);
                    continue;
                }
                int nbRemoved = 0;
                for (DEdge edge : edges) {
                    if (!toRemoveEdges.contains(edge)) continue;
                    ++nbRemoved;
                }
                if (nbRemoved != edges.size()) continue;
                toRemoveNodes.add((AbstractDNode)element);
            }
        }
        if (!(nodeMappings = context.getMappings(MappingConstantsHelper.getMappingABPorts(context.getDDiagram()))).isEmpty()) {
            Collection<DDiagramElement> diagElements = context.getDiagramElements(nodeMappings);
            for (DDiagramElement element : diagElements) {
                if (!(element instanceof EdgeTarget)) continue;
                ArrayList edges = new ArrayList();
                edges.addAll(((EdgeTarget)element).getIncomingEdges());
                edges.addAll(((EdgeTarget)element).getOutgoingEdges());
                if (edges.size() == 0) continue;
                int nbRemoved = 0;
                int nbHidden = 0;
                for (DEdge edge : edges) {
                    if (!context.isVisible((DDiagramElement)edge)) {
                        if (edge.getTarget() == null) continue;
                        EObject target = edge.getTarget();
                        if (target instanceof ComponentExchange && !((ComponentExchange)target).getCategories().isEmpty()) {
                            ++nbHidden;
                            continue;
                        }
                        if (!(target instanceof PhysicalLink) || ((PhysicalLink)target).getCategories().isEmpty()) continue;
                        ++nbHidden;
                        continue;
                    }
                    if (!toRemoveEdges.contains(edge)) continue;
                    ++nbRemoved;
                }
                if (nbRemoved == edges.size()) {
                    toRemoveNodes.add((AbstractDNode)element);
                    continue;
                }
                if (nbHidden + nbRemoved != edges.size()) continue;
                toHideNodes.add((AbstractDNode)element);
            }
        }
        for (DEdge edge : toRemoveEdges) {
            DiagramServices.getDiagramServices().removeEdgeView(edge);
        }
        for (AbstractDNode node : toHideNodes) {
            context.deferredHide((DDiagramElement)node);
        }
        for (AbstractDNode node : toRemoveNodes) {
            DiagramServices.getDiagramServices().removeAbstractDNodeView(node);
        }
    }

    public void updateABPhysicalCategories(DDiagramContents context) {
        int nbRemoved;
        ArrayList edges;
        HashSet<DEdge> toRemoveEdges = new HashSet<DEdge>();
        HashSet<AbstractDNode> toRemoveNodes = new HashSet<AbstractDNode>();
        HashSet<AbstractDNode> toHideNodes = new HashSet<AbstractDNode>();
        DiagramElementMapping edgeMapping = context.getMapping(MappingConstantsHelper.getMappingABPhysicalCategory(context.getDDiagram()));
        Collection<DiagramElementMapping> nodeMappings = context.getMappings(MappingConstantsHelper.getMappingABPhysicalCategoryPin(context.getDDiagram()));
        if (edgeMapping != null) {
            for (DDiagramElement element : context.getDiagramElements(edgeMapping)) {
                if (!(element instanceof DEdge)) continue;
                DEdge edge = (DEdge)element;
                boolean isValidEdge = this.isValidABPhysicalCategoryEdge((PhysicalLinkCategory)element.getTarget(), (DSemanticDecorator)edge.getSourceNode(), (DSemanticDecorator)edge.getTargetNode());
                if (isValidEdge) continue;
                toRemoveEdges.add(edge);
            }
        }
        if (!nodeMappings.isEmpty()) {
            for (DDiagramElement element : context.getDiagramElements(nodeMappings)) {
                if (!(element instanceof EdgeTarget)) continue;
                edges = new ArrayList();
                edges.addAll(((EdgeTarget)element).getIncomingEdges());
                edges.addAll(((EdgeTarget)element).getOutgoingEdges());
                if (edges.size() == 0) {
                    toRemoveNodes.add((AbstractDNode)element);
                    continue;
                }
                nbRemoved = 0;
                for (DEdge edge : edges) {
                    if (!toRemoveEdges.contains(edge)) continue;
                    ++nbRemoved;
                }
                if (nbRemoved != edges.size()) continue;
                toRemoveNodes.add((AbstractDNode)element);
            }
        }
        if (!(nodeMappings = context.getMappings(MappingConstantsHelper.getMappingABPorts(context.getDDiagram()))).isEmpty()) {
            for (DDiagramElement element : context.getDiagramElements(nodeMappings)) {
                if (!(element instanceof EdgeTarget)) continue;
                edges = new ArrayList();
                edges.addAll(((EdgeTarget)element).getIncomingEdges());
                edges.addAll(((EdgeTarget)element).getOutgoingEdges());
                if (edges.size() == 0) continue;
                nbRemoved = 0;
                int nbHidden = 0;
                for (DEdge edge : edges) {
                    if (!context.isVisible((DDiagramElement)edge)) {
                        if (edge.getTarget() == null) continue;
                        EObject target = edge.getTarget();
                        if (target instanceof ComponentExchange && !((ComponentExchange)target).getCategories().isEmpty()) {
                            ++nbHidden;
                            continue;
                        }
                        if (!(target instanceof PhysicalLink) || ((PhysicalLink)target).getCategories().isEmpty()) continue;
                        ++nbHidden;
                        continue;
                    }
                    if (!toRemoveEdges.contains(edge)) continue;
                    ++nbRemoved;
                }
                if (nbRemoved == edges.size()) {
                    toRemoveNodes.add((AbstractDNode)element);
                    continue;
                }
                if (nbHidden + nbRemoved != edges.size()) continue;
                toHideNodes.add((AbstractDNode)element);
            }
        }
        for (DEdge edge : toRemoveEdges) {
            DiagramServices.getDiagramServices().removeEdgeView(edge);
        }
        for (AbstractDNode node : toHideNodes) {
            context.deferredHide((DDiagramElement)node);
        }
        for (AbstractDNode node : toRemoveNodes) {
            DiagramServices.getDiagramServices().removeAbstractDNodeView(node);
        }
    }

    public String computeComponentCategoryLabel(ComponentExchangeCategory property) {
        return property.getName();
    }

    public String computePhysicalCategoryLabel(PhysicalLinkCategory property) {
        return property.getName();
    }

    public EObject createABComponentPortAllocation(EObject context, DSemanticDecorator sourceView, DSemanticDecorator targetView) {
        ComponentPortAllocationEnd end;
        EObject sourceTarget = sourceView.getTarget();
        EObject targetTarget = targetView.getTarget();
        DDiagram diagram = CapellaServices.getService().getDiagramContainer((EObject)sourceView);
        EdgeTarget nodeSource = null;
        EdgeTarget nodeTarget = null;
        ComponentPortAllocation exchange = null;
        InformationsExchanger sourceRelatedPart = CsServices.getService().getRelatedPart(sourceView);
        InformationsExchanger targetRelatedPart = CsServices.getService().getRelatedPart(targetView);
        Part sourcePart = null;
        Part targetPart = null;
        if (sourceRelatedPart instanceof Part) {
            sourcePart = (Part)sourceRelatedPart;
        }
        if (targetRelatedPart instanceof Part) {
            targetPart = (Part)targetRelatedPart;
        }
        PhysicalPort sourcePort = null;
        if (sourceTarget instanceof PhysicalPort) {
            sourcePort = (PhysicalPort)sourceTarget;
            nodeSource = (EdgeTarget)sourceView;
        }
        ComponentPort targetPort = null;
        if (targetTarget instanceof ComponentPort) {
            targetPort = (ComponentPort)targetTarget;
            nodeTarget = (EdgeTarget)targetView;
        }
        exchange = FaFactory.eINSTANCE.createComponentPortAllocation();
        if (CsServices.getService().isMultipartMode((ModelElement)sourceTarget)) {
            end = FaFactory.eINSTANCE.createComponentPortAllocationEnd();
            end.setPart(sourcePart);
            end.setPort((Port)sourcePort);
            exchange.setSourceElement((TraceableElement)end);
            exchange.getOwnedComponentPortAllocationEnds().add((Object)end);
            CapellaServices.getService().creationService((EObject)end);
        } else {
            exchange.setSourceElement((TraceableElement)sourcePort);
        }
        if (CsServices.getService().isMultipartMode((ModelElement)sourceTarget)) {
            end = FaFactory.eINSTANCE.createComponentPortAllocationEnd();
            end.setPart(targetPart);
            end.setPort((Port)targetPort);
            exchange.setTargetElement((TraceableElement)end);
            exchange.getOwnedComponentPortAllocationEnds().add((Object)end);
            CapellaServices.getService().creationService((EObject)end);
        } else {
            exchange.setTargetElement((TraceableElement)targetPort);
        }
        ComponentPortAllocationExt.attachToDefaultContainer((ComponentPortAllocation)exchange);
        CapellaServices.getService().creationService((EObject)exchange);
        DiagramServices.getDiagramServices().createEdge(FaServices.getFaServices().getMappingABComponentPortAllocation(diagram), nodeSource, nodeTarget, (EObject)exchange);
        return context;
    }

    @Deprecated
    public EdgeMapping getMappingABComponentCategory(DDiagram diagram) {
        String mappingName = MappingConstantsHelper.getMappingABComponentCategory(diagram);
        return DiagramServices.getDiagramServices().getEdgeMapping(diagram, mappingName);
    }

    @Deprecated
    public EdgeMapping getMappingABPhysicalCategory(DDiagram diagram) {
        String mappingName = MappingConstantsHelper.getMappingABPhysicalCategory(diagram);
        return DiagramServices.getDiagramServices().getEdgeMapping(diagram, mappingName);
    }

    @Deprecated
    public NodeMapping getMappingABComponentCategoryPin(DDiagram diagram) {
        String mappingName = MappingConstantsHelper.getMappingABComponentCategoryPin(diagram);
        return DiagramServices.getDiagramServices().getBorderedNodeMapping(diagram, mappingName);
    }

    @Deprecated
    public List<NodeMapping> getMappingABPhysicalCategoryPin(DDiagram diagram) {
        List<String> mappingNames = MappingConstantsHelper.getMappingABPhysicalCategoryPin(diagram);
        return DiagramServices.getDiagramServices().getBorderedNodeMapping(diagram, mappingNames);
    }

    @Deprecated
    public NodeMapping getMappingABPhysicalCategoryPin(DDiagram diagram, EObject semantic) {
        String mappingName = MappingConstantsHelper.getMappingABPhysicalCategoryPin(diagram, semantic);
        return DiagramServices.getDiagramServices().getBorderedNodeMapping(diagram, mappingName);
    }

    public Object getABFunctionalExchangeSemanticCandidates(DDiagram diagram) {
        return DFServices.getService().getDFFunctionalExchangeSemanticCandidates(diagram);
    }

    public Object getABPhysicalLinkSemanticCandidates(DDiagram diagram) {
        ArrayList result = new ArrayList();
        for (DDiagramElement dDiagramElement : DiagramServices.getDiagramServices().getAllNodeContainers((EObject)((DSemanticDecorator)diagram))) {
            if (!(dDiagramElement instanceof AbstractDNode)) continue;
            EObject target = dDiagramElement.getTarget();
            if (target instanceof Part) {
                result.addAll(org.polarsys.capella.core.data.helpers.cs.services.PhysicalLinkExt.getAllRelatedPhysicalLinks((Part)((Part)target)));
                continue;
            }
            if (!(target instanceof Component)) continue;
            result.addAll(org.polarsys.capella.core.data.helpers.cs.services.PhysicalLinkExt.getAllRelatedPhysicalLinks((Component)((Component)target)));
        }
        return result;
    }

    public Object getABComponentExchangeSemanticCandidates(DDiagram diagram) {
        ArrayList result = new ArrayList();
        for (DDiagramElement dDiagramElement : DiagramServices.getDiagramServices().getAllNodeContainers((EObject)((DSemanticDecorator)diagram))) {
            EObject target = dDiagramElement.getTarget();
            if (target instanceof Part) {
                result.addAll(ComponentExt.getAllRelatedComponentExchange((Part)((Part)target), (boolean)true));
                continue;
            }
            if (!(target instanceof Component)) continue;
            result.addAll(ComponentExt.getAllRelatedComponentExchange((Component)((Component)target)));
        }
        return result;
    }

    public Object getABPortAllocationSemanticCandidates(DDiagram diagram) {
        ArrayList result = new ArrayList();
        for (DDiagramElement dNode : DiagramServices.getDiagramServices().getAllAbstractNodes((EObject)((DSemanticDecorator)diagram), true)) {
            EObject target = dNode.getTarget();
            if (!(target instanceof Port)) continue;
            result.addAll(((Port)target).getOutgoingPortAllocations());
        }
        return result;
    }

    public Object getABComponentPortAllocationSemanticCandidates(DDiagram diagram) {
        ArrayList<ComponentPortAllocation> result = new ArrayList<ComponentPortAllocation>();
        for (DDiagramElement dNode : DiagramServices.getDiagramServices().getAllAbstractNodes((EObject)((DSemanticDecorator)diagram), true)) {
            EObject target = dNode.getTarget();
            if (!(target instanceof PhysicalPort)) continue;
            for (AbstractTrace trace : ((PhysicalPort)target).getOutgoingTraces()) {
                if (!(trace instanceof ComponentPortAllocation)) continue;
                result.add((ComponentPortAllocation)trace);
            }
        }
        return result;
    }
}

