/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.core.sirius.analysis;

import java.util.List;
import org.eclipse.emf.ecore.EObject;
import org.polarsys.capella.common.data.modellingcore.AbstractType;
import org.polarsys.capella.common.queries.interpretor.QueryInterpretor;
import org.polarsys.capella.common.queries.queryContext.IQueryContext;
import org.polarsys.capella.common.queries.queryContext.QueryContext;
import org.polarsys.capella.core.data.capellacore.CapellaElement;
import org.polarsys.capella.core.data.cs.Part;
import org.polarsys.capella.core.data.cs.PhysicalPort;
import org.polarsys.capella.core.data.epbs.ConfigurationItem;
import org.polarsys.capella.core.data.epbs.ConfigurationItemKind;
import org.polarsys.capella.core.data.epbs.ConfigurationItemPkg;
import org.polarsys.capella.core.data.epbs.EPBSArchitecture;
import org.polarsys.capella.core.data.epbs.EpbsFactory;
import org.polarsys.capella.core.data.pa.PhysicalComponent;
import org.polarsys.capella.core.model.helpers.BlockArchitectureExt;
import org.polarsys.capella.core.sirius.analysis.CapellaServices;
import org.polarsys.capella.core.sirius.analysis.CsServices;

public class ConfigurationItemServices {
    private static ConfigurationItemServices service = null;

    public static ConfigurationItemServices getService() {
        if (service == null) {
            service = new ConfigurationItemServices();
        }
        return service;
    }

    public List<EObject> getAllRealizablePhysicalArtefacts(CapellaElement context) {
        return QueryInterpretor.executeQuery((String)"GetAllRealizablePhysicalArtefacts__Lib", (Object)context, (IQueryContext)new QueryContext());
    }

    public boolean isParentContainedInDiagram(PhysicalPort context, List<PhysicalComponent> allPhysicalComponentInDiagram) {
        EObject container = context.eContainer();
        return container != null && allPhysicalComponentInDiagram.contains(container);
    }

    public ConfigurationItem createConfigurationItem(EObject container, ConfigurationItemKind kind) {
        AbstractType componentType;
        ConfigurationItem item = null;
        Object owner = null;
        if (container instanceof ConfigurationItem) {
            owner = container;
        } else if (container instanceof ConfigurationItemPkg) {
            owner = container;
        } else if (container instanceof Part && (componentType = CsServices.getService().getComponentType((Part)container)) instanceof ConfigurationItem) {
            owner = componentType;
        }
        if (owner == null) {
            EPBSArchitecture architecture = (EPBSArchitecture)BlockArchitectureExt.getRootBlockArchitecture((EObject)container);
            owner = architecture.getOwnedConfigurationItem() != null ? architecture.getOwnedConfigurationItem() : architecture;
        }
        if (owner != null) {
            item = EpbsFactory.eINSTANCE.createConfigurationItem();
            item.setKind(kind);
            if (item != null) {
                if (owner instanceof ConfigurationItem) {
                    ((ConfigurationItem)owner).getOwnedConfigurationItems().add((Object)item);
                } else if (owner instanceof ConfigurationItemPkg) {
                    ((ConfigurationItemPkg)owner).getOwnedConfigurationItems().add((Object)item);
                } else if (owner instanceof EPBSArchitecture) {
                    ((EPBSArchitecture)owner).setOwnedConfigurationItem(item);
                }
                CapellaServices.getService().creationService((EObject)item);
            }
        }
        return item;
    }

    public ConfigurationItem createSystemCI(EObject container) {
        ConfigurationItem ci = this.createConfigurationItem(container, ConfigurationItemKind.SYSTEM_CI);
        return ci;
    }

    public ConfigurationItem createPrimeItemCI(EObject container) {
        ConfigurationItem ci = this.createConfigurationItem(container, ConfigurationItemKind.PRIME_ITEM_CI);
        return ci;
    }

    public ConfigurationItem createNDICI(EObject container) {
        ConfigurationItem ci = this.createConfigurationItem(container, ConfigurationItemKind.NDICI);
        return ci;
    }

    public ConfigurationItem createInterfaceCI(EObject container) {
        ConfigurationItem ci = this.createConfigurationItem(container, ConfigurationItemKind.INTERFACE_CI);
        return ci;
    }

    public ConfigurationItem createHWCI(EObject container) {
        ConfigurationItem ci = this.createConfigurationItem(container, ConfigurationItemKind.HWCI);
        return ci;
    }

    public ConfigurationItem createCSCI(EObject container) {
        ConfigurationItem ci = this.createConfigurationItem(container, ConfigurationItemKind.CSCI);
        return ci;
    }

    public ConfigurationItem createCOTSCI(EObject container) {
        ConfigurationItem ci = this.createConfigurationItem(container, ConfigurationItemKind.COTSCI);
        return ci;
    }
}

