/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.core.sirius.analysis;

import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.UniqueEList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.jface.viewers.ILabelDecorator;
import org.eclipse.sirius.diagram.AbstractDNode;
import org.eclipse.sirius.diagram.DDiagram;
import org.eclipse.sirius.diagram.DDiagramElement;
import org.eclipse.sirius.diagram.DDiagramElementContainer;
import org.eclipse.sirius.diagram.DEdge;
import org.eclipse.sirius.diagram.DNode;
import org.eclipse.sirius.diagram.DNodeContainer;
import org.eclipse.sirius.diagram.DSemanticDiagram;
import org.eclipse.sirius.diagram.DragAndDropTarget;
import org.eclipse.sirius.diagram.EdgeTarget;
import org.eclipse.sirius.diagram.description.AbstractNodeMapping;
import org.eclipse.sirius.diagram.description.ContainerMapping;
import org.eclipse.sirius.diagram.description.DiagramElementMapping;
import org.eclipse.sirius.diagram.description.EdgeMapping;
import org.eclipse.sirius.diagram.description.NodeMapping;
import org.eclipse.sirius.diagram.description.filter.FilterDescription;
import org.eclipse.sirius.viewpoint.DSemanticDecorator;
import org.polarsys.capella.common.data.activity.ActivityEdge;
import org.polarsys.capella.common.data.activity.ActivityNode;
import org.polarsys.capella.common.data.activity.ActivityPackage;
import org.polarsys.capella.common.data.activity.InputPin;
import org.polarsys.capella.common.data.activity.OutputPin;
import org.polarsys.capella.common.data.activity.Pin;
import org.polarsys.capella.common.data.modellingcore.AbstractExchangeItem;
import org.polarsys.capella.common.data.modellingcore.AbstractInformationFlow;
import org.polarsys.capella.common.data.modellingcore.AbstractNamedElement;
import org.polarsys.capella.common.data.modellingcore.AbstractTrace;
import org.polarsys.capella.common.data.modellingcore.AbstractType;
import org.polarsys.capella.common.data.modellingcore.InformationsExchanger;
import org.polarsys.capella.common.data.modellingcore.ModelElement;
import org.polarsys.capella.common.data.modellingcore.TraceableElement;
import org.polarsys.capella.common.helpers.EObjectLabelProviderHelper;
import org.polarsys.capella.common.helpers.EcoreUtil2;
import org.polarsys.capella.common.sirius.decorators.loader.SiriusDecoratorsManager;
import org.polarsys.capella.core.data.capellacommon.State;
import org.polarsys.capella.core.data.capellacore.Allocation;
import org.polarsys.capella.core.data.capellacore.CapellaElement;
import org.polarsys.capella.core.data.capellacore.InvolvedElement;
import org.polarsys.capella.core.data.capellacore.Involvement;
import org.polarsys.capella.core.data.capellacore.ModellingArchitecture;
import org.polarsys.capella.core.data.capellacore.ModellingBlock;
import org.polarsys.capella.core.data.capellacore.NamedElement;
import org.polarsys.capella.core.data.cs.AbstractDeploymentLink;
import org.polarsys.capella.core.data.cs.BlockArchitecture;
import org.polarsys.capella.core.data.cs.Component;
import org.polarsys.capella.core.data.cs.CsFactory;
import org.polarsys.capella.core.data.cs.CsPackage;
import org.polarsys.capella.core.data.cs.DeploymentTarget;
import org.polarsys.capella.core.data.cs.Part;
import org.polarsys.capella.core.data.cs.PhysicalLink;
import org.polarsys.capella.core.data.cs.PhysicalLinkEnd;
import org.polarsys.capella.core.data.cs.PhysicalPort;
import org.polarsys.capella.core.data.ctx.CtxFactory;
import org.polarsys.capella.core.data.ctx.SystemFunction;
import org.polarsys.capella.core.data.epbs.ConfigurationItem;
import org.polarsys.capella.core.data.epbs.PhysicalArtifactRealization;
import org.polarsys.capella.core.data.fa.AbstractFunction;
import org.polarsys.capella.core.data.fa.ComponentExchange;
import org.polarsys.capella.core.data.fa.ComponentExchangeEnd;
import org.polarsys.capella.core.data.fa.ComponentExchangeFunctionalExchangeAllocation;
import org.polarsys.capella.core.data.fa.ComponentExchangeKind;
import org.polarsys.capella.core.data.fa.ComponentFunctionalAllocation;
import org.polarsys.capella.core.data.fa.ComponentPort;
import org.polarsys.capella.core.data.fa.ComponentPortKind;
import org.polarsys.capella.core.data.fa.ExchangeCategory;
import org.polarsys.capella.core.data.fa.FaFactory;
import org.polarsys.capella.core.data.fa.FaPackage;
import org.polarsys.capella.core.data.fa.FunctionInputPort;
import org.polarsys.capella.core.data.fa.FunctionKind;
import org.polarsys.capella.core.data.fa.FunctionOutputPort;
import org.polarsys.capella.core.data.fa.FunctionPkg;
import org.polarsys.capella.core.data.fa.FunctionPort;
import org.polarsys.capella.core.data.fa.FunctionalChain;
import org.polarsys.capella.core.data.fa.FunctionalChainInvolvement;
import org.polarsys.capella.core.data.fa.FunctionalExchange;
import org.polarsys.capella.core.data.fa.OrientationPortKind;
import org.polarsys.capella.core.data.helpers.cs.services.PhysicalLinkExt;
import org.polarsys.capella.core.data.helpers.fa.services.FunctionExt;
import org.polarsys.capella.core.data.helpers.fa.services.FunctionPkgExt;
import org.polarsys.capella.core.data.helpers.fa.services.FunctionalExt;
import org.polarsys.capella.core.data.information.ExchangeItem;
import org.polarsys.capella.core.data.information.ExchangeItemElement;
import org.polarsys.capella.core.data.information.Partition;
import org.polarsys.capella.core.data.information.Port;
import org.polarsys.capella.core.data.information.PortAllocation;
import org.polarsys.capella.core.data.interaction.AbstractCapability;
import org.polarsys.capella.core.data.interaction.AbstractFunctionAbstractCapabilityInvolvement;
import org.polarsys.capella.core.data.interaction.InteractionFactory;
import org.polarsys.capella.core.data.interaction.Scenario;
import org.polarsys.capella.core.data.la.LaFactory;
import org.polarsys.capella.core.data.la.LogicalComponent;
import org.polarsys.capella.core.data.la.LogicalFunction;
import org.polarsys.capella.core.data.oa.ActivityAllocation;
import org.polarsys.capella.core.data.oa.CommunicationMean;
import org.polarsys.capella.core.data.oa.Entity;
import org.polarsys.capella.core.data.oa.OaFactory;
import org.polarsys.capella.core.data.oa.OperationalActivity;
import org.polarsys.capella.core.data.oa.Role;
import org.polarsys.capella.core.data.pa.PaFactory;
import org.polarsys.capella.core.data.pa.PhysicalArchitecture;
import org.polarsys.capella.core.data.pa.PhysicalComponent;
import org.polarsys.capella.core.data.pa.PhysicalComponentNature;
import org.polarsys.capella.core.data.pa.PhysicalFunction;
import org.polarsys.capella.core.model.helpers.AbstractFunctionExt;
import org.polarsys.capella.core.model.helpers.BlockArchitectureExt;
import org.polarsys.capella.core.model.helpers.CapellaElementExt;
import org.polarsys.capella.core.model.helpers.ComponentExchangeExt;
import org.polarsys.capella.core.model.helpers.ComponentExt;
import org.polarsys.capella.core.model.helpers.ExchangeItemExt;
import org.polarsys.capella.core.model.helpers.FunctionalChainExt;
import org.polarsys.capella.core.model.helpers.FunctionalExchangeExt;
import org.polarsys.capella.core.model.helpers.PartExt;
import org.polarsys.capella.core.model.helpers.PhysicalArchitectureExt;
import org.polarsys.capella.core.model.helpers.PortExt;
import org.polarsys.capella.core.model.utils.CapellaLayerCheckingExt;
import org.polarsys.capella.core.sirius.analysis.CapellaServices;
import org.polarsys.capella.core.sirius.analysis.CsServices;
import org.polarsys.capella.core.sirius.analysis.DDiagramContents;
import org.polarsys.capella.core.sirius.analysis.DFServices;
import org.polarsys.capella.core.sirius.analysis.DiagramServices;
import org.polarsys.capella.core.sirius.analysis.IMappingNameConstants;
import org.polarsys.capella.core.sirius.analysis.InformationServices;
import org.polarsys.capella.core.sirius.analysis.TableCapabilitiesServices;
import org.polarsys.capella.core.sirius.analysis.constants.MappingConstantsHelper;
import org.polarsys.capella.core.sirius.analysis.showhide.AbstractShowHide;
import org.polarsys.capella.core.sirius.analysis.showhide.ShowHideExchangeCategory;
import org.polarsys.capella.core.sirius.analysis.showhide.ShowHideFunction;
import org.polarsys.capella.core.sirius.analysis.showhide.ShowHideFunctionalExchange;
import org.polarsys.capella.core.sirius.analysis.showhide.ShowHideInvisibleExchangeCategory;
import org.polarsys.capella.core.sirius.analysis.tool.HashMapSet;

public class FaServices {
    private static FaServices singleton = null;

    public static FaServices getFaServices() {
        if (singleton == null) {
            singleton = new FaServices();
        }
        return singleton;
    }

    private Object getSafeName(AbstractNamedElement fe) {
        if ("".equals(fe.getName()) || fe.getName() == null) {
            return "<undefined>";
        }
        return EObjectLabelProviderHelper.getText((EObject)fe);
    }

    public boolean isValidCreationFunctionalExchange(EObject context, EObject source) {
        if (source instanceof InputPin || !(source instanceof ActivityNode)) {
            return false;
        }
        AbstractFunction sourceFunction = FunctionExt.getRelatedFunction((ActivityNode)((ActivityNode)source));
        if (FunctionExt.isControlNodeOneOutput((AbstractFunction)sourceFunction)) {
            if (!FunctionExt.getOutGoingExchange((AbstractFunction)sourceFunction).isEmpty() && !FunctionExt.getOutGoingExchange((AbstractFunction)sourceFunction).contains(context)) {
                return false;
            }
            if (!(source instanceof OutputPin) && !sourceFunction.getOutputs().isEmpty()) {
                return false;
            }
        }
        return true;
    }

    public boolean isValidCreationFunctionalExchange(EObject context, EObject source, EObject target) {
        AbstractFunction targetFunction;
        if (target instanceof OutputPin || !(target instanceof ActivityNode)) {
            return false;
        }
        AbstractFunction sourceFunction = FunctionExt.getRelatedFunction((ActivityNode)((ActivityNode)source));
        if (sourceFunction.equals(targetFunction = FunctionExt.getRelatedFunction((ActivityNode)((ActivityNode)target)))) {
            return false;
        }
        if (EcoreUtil.isAncestor((EObject)sourceFunction, (EObject)targetFunction)) {
            return false;
        }
        if (EcoreUtil.isAncestor((EObject)targetFunction, (EObject)sourceFunction)) {
            return false;
        }
        if (FunctionExt.isControlNodeOneInput((AbstractFunction)targetFunction)) {
            if (!FunctionExt.getIncomingExchange((AbstractFunction)targetFunction).isEmpty() && !FunctionExt.getIncomingExchange((AbstractFunction)targetFunction).contains(context)) {
                return false;
            }
            if (!(target instanceof InputPin) && !targetFunction.getInputs().isEmpty()) {
                return false;
            }
        }
        return this.isValidCreationFunctionalExchange(context, source);
    }

    public List<FunctionalExchange> getAvailableFunctionalExchangesToInsert(DSemanticDecorator context) {
        ArrayList<FunctionalExchange> returnedList = new ArrayList<FunctionalExchange>();
        ArrayList allFunctionalExchanges = new ArrayList();
        ArrayList<FunctionalExchange> existingExchangesInDiagram = new ArrayList<FunctionalExchange>();
        AbstractFunction selectedFunction = null;
        if (!(context instanceof AbstractDNode)) {
            return returnedList;
        }
        for (DEdge anEdge : CapellaServices.getService().getDiagramContainer((EObject)context).getEdges()) {
            if (!(anEdge.getTarget() instanceof FunctionalExchange)) continue;
            existingExchangesInDiagram.add((FunctionalExchange)anEdge.getTarget());
        }
        if (context.getTarget() instanceof AbstractFunction) {
            selectedFunction = (AbstractFunction)context.getTarget();
            for (AbstractFunction currentFunction : FunctionExt.getAllAbstractFunctions((AbstractFunction)selectedFunction)) {
                allFunctionalExchanges.addAll(FunctionExt.getIncomingExchange((AbstractFunction)currentFunction));
                allFunctionalExchanges.addAll(FunctionExt.getOutGoingExchange((AbstractFunction)currentFunction));
            }
        }
        for (FunctionalExchange aFunctionalExchange : allFunctionalExchanges) {
            if (aFunctionalExchange.getTarget() == null || aFunctionalExchange.getSource() == null || EcoreUtil.isAncestor((EObject)selectedFunction, (EObject)aFunctionalExchange.getSource()) && EcoreUtil.isAncestor((EObject)selectedFunction, (EObject)aFunctionalExchange.getTarget())) continue;
            returnedList.add(aFunctionalExchange);
        }
        return returnedList;
    }

    public List<FunctionalExchange> getDisplayedFunctionalExchanges(DSemanticDecorator selectedElement) {
        List<FunctionalExchange> result = new ArrayList<FunctionalExchange>();
        if (selectedElement instanceof AbstractDNode) {
            result = this.getDisplayedFunctionalExchangesFromAbstractDNode((AbstractDNode)selectedElement);
            for (AbstractDNode dNodeContainer : DiagramServices.getDiagramServices().getAllNodeContainers((EObject)selectedElement)) {
                List<FunctionalExchange> subFunctionEdges = this.getDisplayedFunctionalExchangesFromAbstractDNode(dNodeContainer);
                if (subFunctionEdges.isEmpty()) continue;
                result.addAll(subFunctionEdges);
            }
            List<DNode> allNodes = DiagramServices.getDiagramServices().getAllNodes((EObject)selectedElement);
            for (DNode aDNode : allNodes) {
                List<FunctionalExchange> subFunctionEdges = this.getDisplayedFunctionalExchangesFromAbstractDNode((AbstractDNode)aDNode);
                if (subFunctionEdges.isEmpty()) continue;
                result.addAll(subFunctionEdges);
            }
        }
        return result;
    }

    public List<FunctionalExchange> getDisplayedFunctionalExchangesFromAbstractDNode(AbstractDNode selectedElement) {
        ArrayList<FunctionalExchange> returnedList = new ArrayList<FunctionalExchange>();
        ArrayList<DEdge> incomingOutgoingEdges = new ArrayList<DEdge>();
        if (selectedElement.getTarget() instanceof AbstractFunction) {
            for (DNode aNode : selectedElement.getOwnedBorderedNodes()) {
                if (aNode.getTarget() instanceof InputPin) {
                    incomingOutgoingEdges.addAll(CapellaServices.getService().getIncomingEdges((EdgeTarget)aNode));
                }
                if (!(aNode.getTarget() instanceof OutputPin)) continue;
                incomingOutgoingEdges.addAll(CapellaServices.getService().getOutgoingEdges((EdgeTarget)aNode));
            }
            if (selectedElement.getTarget() instanceof OperationalActivity) {
                incomingOutgoingEdges.addAll(CapellaServices.getService().getIncomingEdges((EdgeTarget)selectedElement));
                incomingOutgoingEdges.addAll(CapellaServices.getService().getOutgoingEdges((EdgeTarget)selectedElement));
            }
        }
        for (DEdge anEdge : incomingOutgoingEdges) {
            if (!(anEdge.getTarget() instanceof FunctionalExchange)) continue;
            returnedList.add((FunctionalExchange)anEdge.getTarget());
        }
        return returnedList;
    }

    public boolean isOriented(ComponentExchange connection) {
        return connection.isOriented();
    }

    @Deprecated
    public Collection<ComponentExchange> getDisplayedComponentExchanges(DNodeContainer selectedElement) {
        return Collections.EMPTY_SET;
    }

    @Deprecated
    public Collection<ComponentExchange> getAvailableComponentExchangesToInsert(DNodeContainer context) {
        return Collections.EMPTY_SET;
    }

    public Collection<ComponentExchange> getDisplayedConnections(DNodeContainer selectedElement) {
        HashSet<ComponentExchange> returnedList = new HashSet<ComponentExchange>();
        ArrayList<DEdge> edges = new ArrayList<DEdge>();
        for (DNode aNode : selectedElement.getOwnedBorderedNodes()) {
            if (!(aNode.getTarget() instanceof ComponentPort)) continue;
            edges.addAll(CapellaServices.getService().getIncomingEdges((EdgeTarget)aNode));
            edges.addAll(CapellaServices.getService().getOutgoingEdges((EdgeTarget)aNode));
        }
        edges.addAll(CapellaServices.getService().getIncomingEdges((EdgeTarget)selectedElement));
        edges.addAll(CapellaServices.getService().getOutgoingEdges((EdgeTarget)selectedElement));
        for (DEdge anEdge : edges) {
            String edgeMappingName = anEdge.getMapping().getName();
            if (!(anEdge.getTarget() instanceof ComponentExchange) || edgeMappingName.equals("PAB_ComputedComponentExchange") || edgeMappingName.equals("LAB_ComputedComponentExchange") || !DiagramServices.getDiagramServices().isVisible((DDiagramElement)anEdge)) continue;
            returnedList.add((ComponentExchange)anEdge.getTarget());
        }
        return returnedList;
    }

    public Collection<ComponentExchange> getAvailableConnectionsToInsert(DNodeContainer context) {
        ArrayList<ComponentExchange> returnedList = new ArrayList<ComponentExchange>();
        ArrayList<ComponentExchange> allComponentExchanges = new ArrayList<ComponentExchange>();
        EObject currentComponent = null;
        Part currentPart = null;
        if (context.getTarget() instanceof Component) {
            currentComponent = context.getTarget();
        } else if (context.getTarget() instanceof Part) {
            currentPart = (Part)context.getTarget();
            currentComponent = CsServices.getService().getComponentType((Part)context.getTarget());
        }
        if (currentComponent != null && currentComponent instanceof Component) {
            if (currentComponent instanceof Component) {
                for (ComponentPort aPort : ComponentExt.getOwnedComponentPort((Component)((Component)currentComponent))) {
                    allComponentExchanges.addAll((Collection<ComponentExchange>)aPort.getComponentExchanges());
                }
            }
            if (context.getTarget() instanceof InformationsExchanger) {
                for (AbstractInformationFlow aFlow : ((InformationsExchanger)context.getTarget()).getInformationFlows()) {
                    if (!(aFlow instanceof ComponentExchange)) continue;
                    allComponentExchanges.add((ComponentExchange)aFlow);
                }
            }
        }
        for (ComponentExchange connection : allComponentExchanges) {
            if (CsServices.getService().isMultipartMode((ModelElement)connection) && currentPart != null && !FunctionalExt.getRelatedParts((ComponentExchange)connection).contains(currentPart)) continue;
            returnedList.add(connection);
        }
        return returnedList;
    }

    public List<FunctionalExchange> getAvailableFunctionalExchangesToInsertInArchitectureBlank(AbstractDNode context) {
        ArrayList<FunctionalExchange> returnedList = new ArrayList<FunctionalExchange>();
        List<FunctionalExchange> allFunctionalExchanges = this.getAvailableFunctionalExchangesToInsert((DSemanticDecorator)context);
        AbstractFunction selectedFunction = (AbstractFunction)context.getTarget();
        block0: for (FunctionalExchange anExchange : allFunctionalExchanges) {
            AbstractFunction targetFunction = anExchange.getTarget().equals(selectedFunction) || anExchange.getTarget().eContainer().equals(selectedFunction) ? FunctionExt.getRelatedFunction((ActivityNode)anExchange.getSource()) : FunctionExt.getRelatedFunction((ActivityNode)anExchange.getTarget());
            if (!targetFunction.getAllocationBlocks().isEmpty()) {
                returnedList.add(anExchange);
                continue;
            }
            EList incomingTraces = targetFunction.getIncomingTraces();
            for (AbstractTrace abstractTrace : incomingTraces) {
                if (!(abstractTrace instanceof ActivityAllocation)) continue;
                returnedList.add(anExchange);
                continue block0;
            }
        }
        return returnedList;
    }

    private DNodeContainer getDisplayedFunctionContainer(EObject function, Collection<DNodeContainer> containers) {
        EObject currentFunction = function;
        while (currentFunction != null && currentFunction instanceof AbstractFunction) {
            for (DNodeContainer aContainer : containers) {
                if (!aContainer.getTarget().equals(currentFunction)) continue;
                return aContainer;
            }
            currentFunction = currentFunction.eContainer();
        }
        return null;
    }

    @Deprecated
    public DiagramElementMapping getMappingABRole(Role semantic, DDiagram diagram) {
        String mappingName = MappingConstantsHelper.getMappingABRole(diagram);
        return DiagramServices.getDiagramServices().getContainerMapping(diagram, mappingName);
    }

    @Deprecated
    public ContainerMapping getMappingABComponent(EObject component, DDiagram diagram) {
        String mappingName = MappingConstantsHelper.getMappingABComponent(component, diagram);
        return DiagramServices.getDiagramServices().getContainerMapping(diagram, mappingName);
    }

    @Deprecated
    public ContainerMapping getMappingABComponent(EClass clazz, DDiagram diagram) {
        String mappingName = MappingConstantsHelper.getMappingABComponent(clazz, diagram);
        return DiagramServices.getDiagramServices().getContainerMapping(diagram, mappingName);
    }

    @Deprecated
    public AbstractNodeMapping getMappingFunction(AbstractFunction function, DDiagram diagram) {
        String mappingName = MappingConstantsHelper.getMappingFunction(diagram);
        return DiagramServices.getDiagramServices().getAbstractNodeMapping(diagram, mappingName);
    }

    @Deprecated
    public AbstractNodeMapping getMappingFunctionPort(FunctionPort port, DDiagram diagram) {
        String mappingName = MappingConstantsHelper.getMappingFunctionPort(diagram);
        return DiagramServices.getDiagramServices().getBorderedNodeMapping(diagram, mappingName);
    }

    @Deprecated
    public EdgeMapping getMappingFunctionalExchange(DDiagram diagram) {
        String mappingName = MappingConstantsHelper.getMappingFunctionalExchange(diagram);
        return DiagramServices.getDiagramServices().getEdgeMapping(diagram, mappingName);
    }

    @Deprecated
    public NodeMapping getMappingABAbstractFunction(AbstractFunction function, DDiagram diagram) {
        String mappingName = MappingConstantsHelper.getMappingABAbstractFunction(diagram);
        return DiagramServices.getDiagramServices().getNodeMapping(diagram, mappingName);
    }

    @Deprecated
    public NodeMapping getMappingABFunctionPort(DDiagram diagram) {
        String mappingName = MappingConstantsHelper.getMappingABFunctionPort(diagram);
        return DiagramServices.getDiagramServices().getBorderedNodeMapping(diagram, mappingName);
    }

    @Deprecated
    public EdgeMapping getMappingABFunctionalExchange(DDiagram diagram) {
        String mappingName = MappingConstantsHelper.getMappingABFunctionalExchange(diagram);
        return DiagramServices.getDiagramServices().getEdgeMapping(diagram, mappingName);
    }

    @Deprecated
    public EdgeMapping getMappingABComponentPortAllocation(DDiagram diagram) {
        String mappingName = MappingConstantsHelper.getMappingABComponentPortAllocation(diagram);
        return DiagramServices.getDiagramServices().getEdgeMapping(diagram, mappingName);
    }

    @Deprecated
    public EdgeMapping getMappingABConnection(DDiagram diagram) {
        String mappingName = MappingConstantsHelper.getMappingABConnection(diagram);
        return DiagramServices.getDiagramServices().getEdgeMapping(diagram, mappingName);
    }

    @Deprecated
    public EdgeMapping getMappingABPhysicalLink(DDiagram diagram) {
        String mappingName = MappingConstantsHelper.getMappingABPhysicalLink(diagram);
        return DiagramServices.getDiagramServices().getEdgeMapping(diagram, mappingName);
    }

    public void showInvolvedElementsInDataFlowBlank(List<FunctionalChain> chains, DSemanticDecorator view) {
        HashMap<Object, Object> elements = new HashMap<Object, Object>();
        DDiagram diagram = CapellaServices.getService().getDiagramContainer((EObject)view);
        HashSet<Object> involveds = new HashSet<Object>();
        HashSet<AbstractFunction> involvedFunctions = new HashSet<AbstractFunction>();
        HashSet<FunctionalExchange> involvedExchanges = new HashSet<FunctionalExchange>();
        for (FunctionalChain chain : chains) {
            involveds.add(chain);
            for (FunctionalChainInvolvement involvment : FunctionalChainExt.getFlatInvolvements((FunctionalChain)chain)) {
                if (involvment == null) continue;
                InvolvedElement involved = involvment.getInvolved();
                involveds.add(involved);
                if (involved instanceof AbstractFunction) {
                    involvedFunctions.add((AbstractFunction)involved);
                    continue;
                }
                if (!(involved instanceof FunctionalExchange)) continue;
                FunctionalExchange exchange = (FunctionalExchange)involved;
                involvedExchanges.add(exchange);
                ActivityNode nodeSource = exchange.getSource();
                involveds.add(nodeSource);
                if (nodeSource instanceof Port && nodeSource.eContainer() instanceof AbstractFunction) {
                    involveds.add(nodeSource.eContainer());
                    involvedFunctions.add((AbstractFunction)nodeSource.eContainer());
                }
                ActivityNode nodeTarget = exchange.getTarget();
                involveds.add(nodeTarget);
                if (!(nodeTarget instanceof Port) || !(nodeTarget.eContainer() instanceof AbstractFunction)) continue;
                involveds.add(nodeTarget.eContainer());
                involvedFunctions.add((AbstractFunction)nodeTarget.eContainer());
            }
        }
        for (DDiagramElement element : DiagramServices.getDiagramServices().getDiagramElements((EObject)diagram)) {
            EObject target;
            if (element instanceof AbstractDNode) {
                target = element.getTarget();
                if (target == null) continue;
                if (involveds.contains(target)) {
                    elements.put(target, element);
                    continue;
                }
                if (!involveds.contains(target.eContainer())) continue;
                elements.put(target.eContainer(), element);
                continue;
            }
            if (!(element instanceof DEdge)) continue;
            target = element.getTarget();
            elements.put(target, element);
        }
        for (AbstractFunction function : involvedFunctions) {
            if (elements.containsKey(function)) continue;
            ContainerMapping mapping = this.getMappingDFFunction(function, diagram);
            elements.put(function, DiagramServices.getDiagramServices().createContainer(mapping, (EObject)function, (DragAndDropTarget)diagram, diagram));
        }
        for (FunctionalExchange exchange : involvedExchanges) {
            DDiagramElementContainer containerView;
            ActivityNode nodeSource = exchange.getSource();
            ActivityNode nodeTarget = exchange.getTarget();
            NodeMapping portMapping = this.getMappingDFFunctionPort(diagram);
            if (!elements.containsKey(nodeSource)) {
                containerView = (DDiagramElementContainer)elements.get(nodeSource.eContainer());
                elements.put(nodeSource, DiagramServices.getDiagramServices().createBorderedNode(portMapping, (EObject)nodeSource, (DragAndDropTarget)containerView, diagram));
            }
            if (!elements.containsKey(nodeTarget)) {
                containerView = (DDiagramElementContainer)elements.get(nodeTarget.eContainer());
                elements.put(nodeTarget, DiagramServices.getDiagramServices().createBorderedNode(portMapping, (EObject)nodeTarget, (DragAndDropTarget)containerView, diagram));
            }
            if (elements.containsKey(exchange)) continue;
            EdgeMapping edgeMapping = this.getMappingDFFunctionalExchange(diagram);
            EdgeTarget sourceView = (EdgeTarget)elements.get(nodeSource);
            EdgeTarget targetView = (EdgeTarget)elements.get(nodeTarget);
            DiagramServices.getDiagramServices().createEdge(edgeMapping, sourceView, targetView, (EObject)exchange);
        }
        NodeMapping endMapping = this.getMappingFunctionalChainEnd(diagram);
        for (FunctionalChain chain : chains) {
            if (elements.containsKey(chain)) continue;
            elements.put(chain, DiagramServices.getDiagramServices().createNode(endMapping, (EObject)chain, (DragAndDropTarget)diagram, diagram));
        }
    }

    @Deprecated
    private NodeMapping getMappingFunctionalChainEnd(DDiagram diagram) {
        String mappingName = MappingConstantsHelper.getMappingFunctionalChainEnd(diagram);
        return DiagramServices.getDiagramServices().getNodeMapping(diagram, mappingName);
    }

    @Deprecated
    public ContainerMapping getMappingDFFunction(AbstractFunction function, DDiagram diagram) {
        String mappingName = MappingConstantsHelper.getMappingDFFunction(diagram);
        return DiagramServices.getDiagramServices().getContainerMapping(diagram, mappingName);
    }

    private DiagramElementMapping getMappingDFAbstractFunction(AbstractFunction function, DDiagram diagram) {
        return this.getMappingDFFunction(function, diagram);
    }

    @Deprecated
    EdgeMapping getMappingDFFunctionalExchange(DDiagram diagram) {
        String mappingName = MappingConstantsHelper.getMappingDFFunctionalExchange(diagram);
        return DiagramServices.getDiagramServices().getEdgeMapping(diagram, mappingName);
    }

    @Deprecated
    private NodeMapping getMappingDFFunctionPort(DDiagram diagram) {
        String mappingName = MappingConstantsHelper.getMappingDFFunctionPort(diagram);
        return DiagramServices.getDiagramServices().getBorderedNodeMapping(diagram, mappingName);
    }

    public List<AbstractFunction> getAvailableAbstractFunctionsToInsertInDataFlowBlank(DSemanticDecorator current) {
        AbstractFunction rootFunction;
        ArrayList<AbstractFunction> returnedFunctions = new ArrayList<AbstractFunction>();
        AbstractFunction currentFunction = null;
        EObject target = current.getTarget();
        if (current instanceof DDiagram) {
            currentFunction = current.getTarget() instanceof AbstractFunction ? (AbstractFunction)current.getTarget() : this.getRootFunction(target);
            returnedFunctions.addAll(CapellaServices.getService().getAvailableFunctionsInDataFlowBlank(currentFunction));
        }
        if (target != null && current instanceof DNodeContainer && target instanceof AbstractFunction) {
            currentFunction = (AbstractFunction)target;
            returnedFunctions.addAll(FunctionExt.getAllAbstractFunctions((AbstractFunction)currentFunction));
        }
        DDiagram currentDiagram = CapellaServices.getService().getDiagramContainer((EObject)current);
        for (AbstractDNode aContainer : currentDiagram.getContainers()) {
            if (!(aContainer.getTarget() instanceof AbstractFunction)) continue;
            returnedFunctions.remove(aContainer.getTarget());
        }
        if (currentFunction != null && (rootFunction = this.getRootFunction((EObject)currentFunction)) != null && returnedFunctions.contains(rootFunction)) {
            returnedFunctions.remove(rootFunction);
        }
        return returnedFunctions;
    }

    public EObject switchFunctionalExchangesCategories(EObject context, List<ExchangeCategory> selectedExchangeCategories, DDiagram diagram) {
        AbstractDNode targetFunctionView;
        AbstractDNode sourceFunctionView;
        HashSet<DEdge> exchangeCategoryEdgesToRemove = new HashSet<DEdge>();
        HashSet<DEdge> functionalExchangeEdgesToRemove = new HashSet<DEdge>();
        HashSet<EdgeTarget> borderedNodesToCheck = new HashSet<EdgeTarget>();
        HashSet<ExchangeCategory> categoryToDisplay = new HashSet<ExchangeCategory>();
        HashSet<ExchangeCategory> categoryToHide = new HashSet<ExchangeCategory>();
        Set<ExchangeCategory> displayedCategories = this.getDisplayedExchangeCategoriesInDiagram(diagram);
        HashMap<FunctionalExchange, DEdge> functionalExchangesInDiagram = new HashMap<FunctionalExchange, DEdge>();
        for (ExchangeCategory aCategory : selectedExchangeCategories) {
            categoryToDisplay.add(aCategory);
        }
        for (ExchangeCategory aCategory : displayedCategories) {
            if (selectedExchangeCategories.contains(aCategory)) continue;
            categoryToHide.add(aCategory);
        }
        block2: for (DEdge anEdge : diagram.getEdges()) {
            if (anEdge.getTarget() instanceof ExchangeCategory && categoryToHide.contains(anEdge.getTarget())) {
                exchangeCategoryEdgesToRemove.add(anEdge);
                borderedNodesToCheck.add(anEdge.getSourceNode());
                borderedNodesToCheck.add(anEdge.getTargetNode());
            }
            if (!(anEdge.getTarget() instanceof FunctionalExchange)) continue;
            FunctionalExchange currentFunctionalExchange = (FunctionalExchange)anEdge.getTarget();
            functionalExchangesInDiagram.put(currentFunctionalExchange, anEdge);
            if (!(anEdge.getSourceNode() instanceof DNode) || !(anEdge.getTargetNode() instanceof DNode) || !DiagramServices.getDiagramServices().isABorderedNode((AbstractDNode)((DNode)anEdge.getSourceNode())) || !DiagramServices.getDiagramServices().isABorderedNode((AbstractDNode)((DNode)anEdge.getTargetNode()))) continue;
            for (ExchangeCategory aCategory : currentFunctionalExchange.getCategories()) {
                if (!categoryToDisplay.contains(aCategory)) continue;
                functionalExchangeEdgesToRemove.add(anEdge);
                borderedNodesToCheck.add(anEdge.getSourceNode());
                borderedNodesToCheck.add(anEdge.getTargetNode());
                continue block2;
            }
        }
        HashSet<FunctionalExchange> alreadyCreated = new HashSet<FunctionalExchange>();
        for (DEdge anEdge : exchangeCategoryEdgesToRemove) {
            sourceFunctionView = (AbstractDNode)anEdge.getSourceNode().eContainer();
            targetFunctionView = (AbstractDNode)anEdge.getTargetNode().eContainer();
            AbstractFunction sourceFunction = (AbstractFunction)sourceFunctionView.getTarget();
            AbstractFunction targetFunction = (AbstractFunction)targetFunctionView.getTarget();
            EList functionalExchangesOfCategory = ((ExchangeCategory)anEdge.getTarget()).getExchanges();
            Set<FunctionalExchange> exchangesToDisplay = this.getAvailableFunctionalExchangesBetweeen2Functions((List<FunctionalExchange>)functionalExchangesOfCategory, sourceFunction, targetFunction);
            for (FunctionalExchange anExchange : exchangesToDisplay) {
                boolean toRemove = false;
                for (ExchangeCategory aCategory : anExchange.getCategories()) {
                    if (!categoryToDisplay.contains(aCategory)) continue;
                    toRemove = true;
                }
                if (toRemove || alreadyCreated.contains(anExchange)) continue;
                if (functionalExchangesInDiagram.containsKey(anExchange)) {
                    DEdge currentExchangeView = (DEdge)functionalExchangesInDiagram.get(anExchange);
                    CapellaServices.getService().show((DDiagramElement)currentExchangeView.getSourceNode());
                    CapellaServices.getService().show((DDiagramElement)currentExchangeView.getTargetNode());
                    CapellaServices.getService().show((DDiagramElement)currentExchangeView);
                    continue;
                }
                this.createViewFunctionalExchange(anExchange, sourceFunctionView, targetFunctionView, diagram);
                alreadyCreated.add(anExchange);
            }
            DiagramServices.getDiagramServices().removeEdgeView(anEdge);
        }
        for (DEdge anEdge : functionalExchangeEdgesToRemove) {
            sourceFunctionView = (AbstractDNode)anEdge.getSourceNode().eContainer();
            targetFunctionView = (AbstractDNode)anEdge.getTargetNode().eContainer();
            FunctionalExchange currentExchange = (FunctionalExchange)anEdge.getTarget();
            for (ExchangeCategory aCategory : currentExchange.getCategories()) {
                if (!categoryToDisplay.contains(aCategory)) continue;
                this.createViewExchangeCategory(aCategory, sourceFunctionView, targetFunctionView, diagram);
            }
            if (!diagram.isSynchronized()) {
                DiagramServices.getDiagramServices().removeEdgeView(anEdge);
                continue;
            }
            CapellaServices.getService().hide((DDiagramElement)anEdge);
        }
        HashMap<AbstractFunction, AbstractDNode> allFunctionsInDiagram = new HashMap<AbstractFunction, AbstractDNode>();
        for (DDiagramElement aContainer : DiagramServices.getDiagramServices().getDiagramElements((EObject)diagram)) {
            if (aContainer == null || aContainer.getTarget() == null || !(aContainer instanceof AbstractDNode) || !FaServices.getFaServices().isAbstractFunctionVisibleInDFB((AbstractDNode)aContainer, diagram) || !(aContainer.getTarget() instanceof AbstractFunction)) continue;
            allFunctionsInDiagram.put((AbstractFunction)aContainer.getTarget(), (AbstractDNode)aContainer);
        }
        for (ExchangeCategory currentCategory : categoryToDisplay) {
            for (FunctionalExchange currentExchange : currentCategory.getExchanges()) {
                AbstractDNode sourceFunctionView2 = this.getBestFunctionContainer(currentExchange.getSource(), allFunctionsInDiagram);
                AbstractDNode targetFunctionView2 = this.getBestFunctionContainer(currentExchange.getTarget(), allFunctionsInDiagram);
                if (functionalExchangesInDiagram.containsKey(currentExchange) || !this.isValidCreationCategoryBetweenViews(currentExchange, sourceFunctionView2, targetFunctionView2)) continue;
                for (ExchangeCategory aCategory : currentExchange.getCategories()) {
                    if (!categoryToDisplay.contains(aCategory)) continue;
                    this.createViewExchangeCategory(aCategory, sourceFunctionView2, targetFunctionView2, diagram);
                }
            }
        }
        for (EdgeTarget aNode : borderedNodesToCheck) {
            boolean incoming = DiagramServices.getDiagramServices().getIncomingEdges(aNode, diagram).isEmpty();
            boolean outgoing = DiagramServices.getDiagramServices().getOutgoingEdges(aNode, diagram).isEmpty();
            if (!incoming) {
                incoming = true;
                for (DEdge edge : DiagramServices.getDiagramServices().getIncomingEdges(aNode, diagram)) {
                    boolean bl;
                    if (incoming) {
                        if (!exchangeCategoryEdgesToRemove.contains(edge) && !functionalExchangeEdgesToRemove.contains(edge)) {
                            bl = false;
                            continue;
                        }
                        bl = true;
                        continue;
                    }
                    bl = incoming = false;
                }
            }
            if (!outgoing) {
                outgoing = true;
                for (DEdge edge : DiagramServices.getDiagramServices().getOutgoingEdges(aNode, diagram)) {
                    boolean bl;
                    if (outgoing) {
                        if (!exchangeCategoryEdgesToRemove.contains(edge) && !functionalExchangeEdgesToRemove.contains(edge)) {
                            bl = false;
                            continue;
                        }
                        bl = true;
                        continue;
                    }
                    bl = outgoing = false;
                }
            }
            if (!incoming || !outgoing) continue;
            if (((DNode)aNode).getTarget() instanceof ExchangeCategory || !diagram.isSynchronized()) {
                DiagramServices.getDiagramServices().removeNodeView((DNode)aNode);
                continue;
            }
            if (aNode.eContainer() == null) continue;
            CapellaServices.getService().hide((DDiagramElement)((DNode)aNode));
        }
        return context;
    }

    public boolean isValidCreationCategoryBetweenViews(FunctionalExchange exchange, AbstractDNode sourceFunctionView, AbstractDNode targetFunctionView) {
        return sourceFunctionView != null && targetFunctionView != null && sourceFunctionView.getTarget() != null && targetFunctionView.getTarget() != null && sourceFunctionView != targetFunctionView && !EcoreUtil2.isContainedBy((EObject)sourceFunctionView.getTarget(), (EObject)targetFunctionView.getTarget()) && !EcoreUtil2.isContainedBy((EObject)targetFunctionView.getTarget(), (EObject)sourceFunctionView.getTarget());
    }

    private void createViewExchangeCategory(ExchangeCategory aCategory, AbstractDNode sourceFunctionView, AbstractDNode targetFunctionView, DDiagram diagram) {
        DNode sourceView = null;
        DNode targetView = null;
        String outputMappingName = MappingConstantsHelper.getMappingFunctionalExchangeCategoryOutputPin(diagram);
        String inputMappingName = MappingConstantsHelper.getMappingFunctionalExchangeCategoryInputPin(diagram);
        for (DNode aNode : sourceFunctionView.getOwnedBorderedNodes()) {
            if (!aNode.getTarget().equals(aCategory) || !aNode.getActualMapping().getName().equals(outputMappingName)) continue;
            sourceView = aNode;
        }
        for (DNode aNode : targetFunctionView.getOwnedBorderedNodes()) {
            if (!aNode.getTarget().equals(aCategory) || !aNode.getActualMapping().getName().equals(inputMappingName)) continue;
            targetView = aNode;
        }
        if (sourceView != null && targetView != null) {
            for (DEdge anEdge : DiagramServices.getDiagramServices().getOutgoingEdges((EdgeTarget)sourceView, diagram)) {
                if (!anEdge.getTargetNode().equals(targetView)) continue;
                CapellaServices.getService().show((DDiagramElement)anEdge.getSourceNode());
                CapellaServices.getService().show((DDiagramElement)anEdge.getTargetNode());
                CapellaServices.getService().show((DDiagramElement)anEdge);
                return;
            }
        }
        if (sourceView == null) {
            sourceView = this.createViewOutputPinCategory(aCategory, sourceFunctionView, diagram);
        }
        if (targetView == null) {
            targetView = this.createViewInputPinCategory(aCategory, targetFunctionView, diagram);
        }
        EdgeMapping mapping = this.getMappingExchangeCategory(diagram);
        DiagramServices.getDiagramServices().createEdge(mapping, (EdgeTarget)sourceView, (EdgeTarget)targetView, (EObject)aCategory);
    }

    public DEdge createViewFunctionalExchange(FunctionalExchange anExchange, AbstractDNode sourceFunctionView, AbstractDNode targetFunctionView, DDiagram diagram) {
        EdgeMapping mapping;
        ActivityNode source = anExchange.getSource();
        ActivityNode target = anExchange.getTarget();
        EdgeTarget sourceView = null;
        EdgeTarget targetView = null;
        if (source.equals(sourceFunctionView.getTarget()) && sourceFunctionView instanceof EdgeTarget) {
            sourceView = (EdgeTarget)sourceFunctionView;
        }
        if (sourceView == null) {
            for (DNode aBorderedNode : sourceFunctionView.getOwnedBorderedNodes()) {
                if (aBorderedNode.getTarget() == null || !aBorderedNode.getTarget().equals(source)) continue;
                sourceView = aBorderedNode;
            }
        }
        if (sourceView == null) {
            sourceView = this.createViewPin(source, sourceFunctionView, diagram);
        }
        if (target.equals(targetFunctionView.getTarget()) && targetFunctionView instanceof EdgeTarget) {
            targetView = (EdgeTarget)targetFunctionView;
        }
        if (targetView == null) {
            for (DNode aBorderedNode : targetFunctionView.getOwnedBorderedNodes()) {
                if (aBorderedNode.getTarget() == null || !aBorderedNode.getTarget().equals(target)) continue;
                targetView = aBorderedNode;
            }
        }
        if (targetView == null) {
            targetView = this.createViewPin(target, targetFunctionView, diagram);
        }
        if ((mapping = this.getMappingDFFunctionalExchange(diagram)) == null) {
            mapping = this.getMappingABFunctionalExchange(diagram);
        }
        CapellaServices.getService().show((DDiagramElement)sourceView);
        CapellaServices.getService().show((DDiagramElement)targetView);
        return DiagramServices.getDiagramServices().createEdge(mapping, sourceView, targetView, (EObject)anExchange);
    }

    private DNode createViewPin(ActivityNode modelElement, AbstractDNode containerView, DDiagram diagram) {
        NodeMapping mapping = this.getMappingDFFunctionPort(diagram);
        if (mapping == null) {
            mapping = this.getMappingABFunctionPort(diagram);
        }
        return DiagramServices.getDiagramServices().createBorderedNode(mapping, (EObject)modelElement, (DragAndDropTarget)containerView, diagram);
    }

    private DNode createViewInputPinCategory(ExchangeCategory category, AbstractDNode containerView, DDiagram diagram) {
        String mappingName = MappingConstantsHelper.getMappingFunctionalExchangeCategoryInputPin(diagram);
        NodeMapping mapping = DiagramServices.getDiagramServices().getBorderedNodeMapping(diagram, mappingName);
        return DiagramServices.getDiagramServices().createBorderedNode(mapping, (EObject)category, (DragAndDropTarget)containerView, diagram);
    }

    @Deprecated
    String getMappingNameInputPinCategory(DDiagram diagram) {
        return MappingConstantsHelper.getMappingFunctionalExchangeCategoryInputPin(diagram);
    }

    @Deprecated
    public AbstractFunction createForkFunction(EObject container) {
        return this.createDuplicateFunction(container);
    }

    public boolean isControlNode(EObject element) {
        return element instanceof AbstractFunction && FunctionExt.isControlNode((AbstractFunction)((AbstractFunction)element));
    }

    public boolean isDuplicateFunction(EObject element) {
        return element instanceof AbstractFunction && FunctionExt.isDuplicateFunction((AbstractFunction)((AbstractFunction)element));
    }

    public String computeFunctionLabel(DSemanticDecorator decorator) {
        if (decorator instanceof DDiagramElement) {
            EObject target = decorator.getTarget();
            if (target instanceof FunctionalChainInvolvement) {
                target = ((FunctionalChainInvolvement)target).getInvolved();
            }
            if (this.isControlNode(target)) {
                return this.decorateString("", decorator);
            }
            return this.decorateString(EObjectLabelProviderHelper.getText((EObject)target), decorator);
        }
        return this.decorateString("", decorator);
    }

    private String decorateString(String text, Object element) {
        for (ILabelDecorator decorator : SiriusDecoratorsManager.getDecorators()) {
            text = decorator.decorateText(text, element);
        }
        return text;
    }

    public boolean isGatherFunction(EObject element) {
        return element instanceof AbstractFunction && FunctionExt.isGatherFunction((AbstractFunction)((AbstractFunction)element));
    }

    public boolean isRouteFunction(EObject element) {
        return element instanceof AbstractFunction && FunctionExt.isRouteFunction((AbstractFunction)((AbstractFunction)element));
    }

    public boolean isSelectFunction(EObject element) {
        return element instanceof AbstractFunction && FunctionExt.isSelectFunction((AbstractFunction)((AbstractFunction)element));
    }

    public boolean isSplitFunction(EObject element) {
        return element instanceof AbstractFunction && FunctionExt.isSplitFunction((AbstractFunction)((AbstractFunction)element));
    }

    public AbstractFunction createDuplicateFunction(EObject container) {
        return this.createFunction(container, FunctionKind.DUPLICATE);
    }

    public AbstractFunction createGatherFunction(EObject container) {
        return this.createFunction(container, FunctionKind.GATHER);
    }

    public AbstractFunction createRouteFunction(EObject container) {
        return this.createFunction(container, FunctionKind.ROUTE);
    }

    public AbstractFunction createSelectFunction(EObject container) {
        return this.createFunction(container, FunctionKind.SELECT);
    }

    public AbstractFunction createSplitFunction(EObject container) {
        return this.createFunction(container, FunctionKind.SPLIT);
    }

    public AbstractFunction getParentFunctionContainer(EObject container) {
        return this.getFunctionContainer(container.eContainer());
    }

    public AbstractFunction getFunctionContainer(EObject container) {
        AbstractFunction owner = null;
        owner = container instanceof AbstractFunction ? (AbstractFunction)container : (AbstractFunction)EcoreUtil2.getFirstContainer((EObject)container, (EClass)FaPackage.Literals.ABSTRACT_FUNCTION);
        if (owner == null) {
            owner = BlockArchitectureExt.getRootFunction((BlockArchitecture)BlockArchitectureExt.getRootBlockArchitecture((EObject)container));
        }
        return owner;
    }

    public AbstractFunction allocateToComponent(AbstractFunction function, Component component) {
        ComponentFunctionalAllocation allocation = FaFactory.eINSTANCE.createComponentFunctionalAllocation();
        if (component != null) {
            allocation.setSourceElement((TraceableElement)component);
            allocation.setTargetElement((TraceableElement)function);
            component.getOwnedFunctionalAllocation().add((Object)allocation);
        }
        return function;
    }

    public AbstractFunction allocateToRole(AbstractFunction function, Role component) {
        ActivityAllocation allocation = OaFactory.eINSTANCE.createActivityAllocation();
        if (component != null) {
            allocation.setSourceElement((TraceableElement)component);
            allocation.setTargetElement((TraceableElement)function);
            component.getOwnedActivityAllocations().add((Object)allocation);
        }
        return function;
    }

    public AbstractFunction allocateToCapability(AbstractFunction function, DSemanticDecorator containerView) {
        DSemanticDiagram diagram = (DSemanticDiagram)CapellaServices.getService().getDiagramContainer((EObject)containerView);
        if (diagram != null && diagram.getTarget() != null && diagram.getTarget() instanceof AbstractCapability) {
            AbstractCapability capability = (AbstractCapability)diagram.getTarget();
            this.createAbstractFunctionAbstractCapabilityInvolvement(capability, function);
        }
        return function;
    }

    public AbstractFunction allocateToNewActor(AbstractFunction function) {
        Component actor = CsServices.getService().createActor((ModellingArchitecture)BlockArchitectureExt.getRootBlockArchitecture((EObject)function), true, null);
        this.allocateToComponent(function, actor);
        return function;
    }

    public AbstractFunction createActorFunction(EObject container) {
        return this.createFunction(container, "A ", FunctionKind.FUNCTION);
    }

    public Collection<AbstractFunction> getFirstLevelAbstractFunctions(AbstractFunction function) {
        return FunctionExt.getFirstLevelAbstractFunctions((AbstractFunction)function);
    }

    public Collection<AbstractFunction> getFirstLevelAbstractFunctions(FunctionPkg container) {
        return FunctionPkgExt.getFirstLevelAbstractFunctions((FunctionPkg)container);
    }

    public static boolean isControlNodeOneOutput(AbstractFunction function) {
        return FunctionExt.isControlNodeOneOutput((AbstractFunction)function);
    }

    public static boolean isControlNodeOneInput(AbstractFunction function) {
        return FunctionExt.isControlNodeOneInput((AbstractFunction)function);
    }

    public boolean isValidCreationFunctionInputPort(DSemanticDecorator decorator) {
        EObject target = decorator.getTarget();
        AbstractFunction function = FunctionExt.getRelatedFunction((ActivityNode)((ActivityNode)target));
        if (FunctionExt.isControlNodeOneInput((AbstractFunction)function)) {
            return function.getInputs().isEmpty();
        }
        return true;
    }

    public boolean isValidCreationFunctionOutputPort(DSemanticDecorator decorator) {
        EObject target = decorator.getTarget();
        AbstractFunction function = FunctionExt.getRelatedFunction((ActivityNode)((ActivityNode)target));
        if (FunctionExt.isControlNodeOneOutput((AbstractFunction)function)) {
            return function.getOutputs().isEmpty();
        }
        return true;
    }

    public AbstractFunction createFunction(EObject container, String prefix, FunctionKind kind) {
        OperationalActivity function = null;
        AbstractFunction owner = this.getFunctionContainer(container);
        if (owner != null) {
            if (owner instanceof OperationalActivity) {
                function = OaFactory.eINSTANCE.createOperationalActivity();
            } else if (owner instanceof SystemFunction) {
                function = CtxFactory.eINSTANCE.createSystemFunction();
            } else if (owner instanceof LogicalFunction) {
                function = LaFactory.eINSTANCE.createLogicalFunction();
            } else if (owner instanceof PhysicalFunction) {
                function = PaFactory.eINSTANCE.createPhysicalFunction();
            }
            if (function != null) {
                owner.getOwnedFunctions().add((Object)function);
                function.setKind(kind);
                if (prefix != null) {
                    CapellaServices.getService().creationService((EObject)function, prefix);
                } else {
                    CapellaServices.getService().creationService((EObject)function);
                }
            }
        }
        return function;
    }

    public AbstractFunction createFunction(EObject container) {
        return this.createFunction(container, null, FunctionKind.FUNCTION);
    }

    private AbstractFunction createFunction(EObject container, FunctionKind kind) {
        return this.createFunction(container, null, kind);
    }

    private DNode createViewOutputPinCategory(ExchangeCategory category, AbstractDNode containerView, DDiagram diagram) {
        String mappingName = MappingConstantsHelper.getMappingFunctionalExchangeCategoryOutputPin(diagram);
        NodeMapping mapping = DiagramServices.getDiagramServices().getBorderedNodeMapping(diagram, mappingName);
        return DiagramServices.getDiagramServices().createBorderedNode(mapping, (EObject)category, (DragAndDropTarget)containerView, diagram);
    }

    @Deprecated
    String getMappingNameOutputPinCategory(DDiagram diagram) {
        return MappingConstantsHelper.getMappingFunctionalExchangeCategoryOutputPin(diagram);
    }

    @Deprecated
    private EdgeMapping getMappingExchangeCategory(DDiagram diagram) {
        String mappingName = MappingConstantsHelper.getMappingFunctionalExchangeCategory(diagram);
        return DiagramServices.getDiagramServices().getEdgeMapping(diagram, mappingName);
    }

    private Set<FunctionalExchange> getAvailableFunctionalExchangesBetweeen2Functions(List<FunctionalExchange> exchanges, AbstractFunction sourceFunction, AbstractFunction targetFunction) {
        HashSet<FunctionalExchange> returnedSet = new HashSet<FunctionalExchange>();
        for (FunctionalExchange anExchange : exchanges) {
            if (!EcoreUtil.isAncestor((EObject)sourceFunction, (EObject)anExchange.getSource()) || !EcoreUtil.isAncestor((EObject)targetFunction, (EObject)anExchange.getTarget())) continue;
            returnedSet.add(anExchange);
        }
        return returnedSet;
    }

    private Set<ExchangeCategory> getVisibleExchangeCategoriesInDiagram(DDiagram diagram) {
        HashSet<ExchangeCategory> returnedList = new HashSet<ExchangeCategory>();
        for (DEdge anEdge : diagram.getEdges()) {
            if (!(anEdge.getTarget() instanceof ExchangeCategory) || returnedList.contains(anEdge.getTarget()) || !anEdge.isVisible()) continue;
            returnedList.add((ExchangeCategory)anEdge.getTarget());
        }
        return returnedList;
    }

    private Set<ExchangeCategory> getDisplayedExchangeCategoriesInDiagram(DDiagram diagram) {
        HashSet<ExchangeCategory> returnedList = new HashSet<ExchangeCategory>();
        for (DEdge anEdge : diagram.getEdges()) {
            if (!(anEdge.getTarget() instanceof ExchangeCategory) || returnedList.contains(anEdge.getTarget())) continue;
            returnedList.add((ExchangeCategory)anEdge.getTarget());
        }
        return returnedList;
    }

    public boolean isACategoryDisplayed(EObject o, DSemanticDecorator source, DSemanticDecorator target) {
        DSemanticDecorator source_d = source;
        DSemanticDecorator target_d = target;
        if (source_d instanceof DNode && !DiagramServices.getDiagramServices().isABorderedNode((AbstractDNode)((DNode)source_d))) {
            return false;
        }
        if (target_d instanceof DNode && !DiagramServices.getDiagramServices().isABorderedNode((AbstractDNode)((DNode)target_d))) {
            return false;
        }
        AbstractDNode sc = (AbstractDNode)source_d;
        AbstractDNode tc = (AbstractDNode)target_d;
        if (!(source_d.getTarget() instanceof AbstractFunction)) {
            sc = (AbstractDNode)source_d.eContainer();
        }
        if (!(target_d.getTarget() instanceof AbstractFunction)) {
            tc = (AbstractDNode)target_d.eContainer();
        }
        FunctionalExchange exchange = null;
        if (o instanceof FunctionalExchange) {
            exchange = (FunctionalExchange)o;
        }
        DDiagram diagram = CapellaServices.getService().getDiagramContainer((EObject)source_d);
        if (exchange == null) {
            return false;
        }
        for (DNode node : sc.getOwnedBorderedNodes()) {
            if (!(node.getTarget() instanceof ExchangeCategory) || !node.getActualMapping().getName().equals(MappingConstantsHelper.getMappingFunctionalExchangeCategoryOutputPin(diagram))) continue;
            for (DEdge edge : node.getOutgoingEdges()) {
                EdgeTarget targetNode;
                if (!edge.isVisible() || !(edge.getTarget() instanceof ExchangeCategory) || !exchange.getCategories().contains((Object)edge.getTarget()) || (targetNode = edge.getTargetNode()) == null) continue;
                if (!(targetNode instanceof DSemanticDecorator && ((DSemanticDecorator)targetNode).getTarget() instanceof AbstractFunction || !(targetNode.eContainer() instanceof EdgeTarget))) {
                    targetNode = (EdgeTarget)targetNode.eContainer();
                }
                if (targetNode == null || !targetNode.equals(tc)) continue;
                return true;
            }
        }
        return false;
    }

    List<DNodeContainer> getOwnedVisibleFunctionContainersInDataFlowBlank(DNodeContainer container, DDiagram diagram) {
        ArrayList<DNodeContainer> returnedList = new ArrayList<DNodeContainer>();
        HashSet containers = new HashSet();
        if (container == null) {
            containers.addAll(diagram.getContainers());
        } else {
            containers.addAll(container.getContainers());
        }
        for (AbstractDNode aSubContainer : containers) {
            if (!(aSubContainer instanceof DNodeContainer) || aSubContainer.getTarget() == null || !(aSubContainer.getTarget() instanceof AbstractFunction) || !this.isAbstractFunctionVisibleInDFB(aSubContainer, diagram)) continue;
            returnedList.add((DNodeContainer)aSubContainer);
        }
        return returnedList;
    }

    boolean isAbstractFunctionVisibleInDFB(AbstractDNode abstractFunction, DDiagram diagram) {
        return CapellaServices.getService().isVisibleInDiagram(diagram, (DDiagramElement)abstractFunction);
    }

    public List<AbstractDNode> getDisplayedAbstractFunctionViews(DSemanticDecorator view) {
        ArrayList<AbstractDNode> returnedList = new ArrayList<AbstractDNode>();
        if (view instanceof DDiagram) {
            DDiagram diagram = (DDiagram)view;
            for (AbstractDNode aContainer : diagram.getContainers()) {
                if (aContainer.getTarget() == null || !(aContainer.getTarget() instanceof AbstractFunction)) continue;
                returnedList.add(aContainer);
            }
        }
        if (view instanceof DNodeContainer) {
            DNodeContainer currentContainer = (DNodeContainer)view;
            for (AbstractDNode aContainer : currentContainer.getContainers()) {
                if (aContainer.getTarget() == null || !(aContainer.getTarget() instanceof AbstractFunction)) continue;
                returnedList.add(aContainer);
            }
        }
        return returnedList;
    }

    public List<AbstractFunction> getDisplayedAbstractFunctions(DSemanticDecorator view) {
        ArrayList<AbstractFunction> returnedList = new ArrayList<AbstractFunction>();
        for (AbstractDNode aView : this.getDisplayedAbstractFunctionViews(view)) {
            returnedList.add((AbstractFunction)aView.getTarget());
        }
        return returnedList;
    }

    public EObject showHideFunctionsInDataFlowBlank(DSemanticDecorator view, List<AbstractFunction> selectedFunctions, List<AbstractFunction> visibleFunctions, List<AbstractDNode> visibleFunctionViews) {
        DSemanticDiagram diagram = (DSemanticDiagram)CapellaServices.getService().getDiagramContainer((EObject)view);
        DDiagramContents content = new DDiagramContents((DDiagram)diagram);
        HashSet<AbstractDNode> toBeRemoved = new HashSet<AbstractDNode>();
        for (AbstractDNode aView : visibleFunctionViews) {
            if (selectedFunctions.contains(aView.getTarget())) continue;
            toBeRemoved.add(aView);
        }
        for (AbstractDNode aView : visibleFunctionViews) {
            if (!toBeRemoved.contains(aView.eContainer())) continue;
            diagram.getOwnedDiagramElements().add((Object)aView);
        }
        for (AbstractDNode aView : toBeRemoved) {
            HashSet borderedNodes = new HashSet();
            borderedNodes.addAll(aView.getOwnedBorderedNodes());
            Iterator<Object> iterator = borderedNodes.iterator();
            while (iterator.hasNext()) {
                DNode aBorderedNode = (DNode)iterator.next();
                if (aBorderedNode.getTarget() == null || !(aBorderedNode.getTarget() instanceof FunctionPort) && !(aBorderedNode.getTarget() instanceof ExchangeCategory)) continue;
                this.moveBorderedNodeIfPossible(aBorderedNode, toBeRemoved, (DDiagram)diagram);
            }
        }
        if (!(diagram.getTarget() instanceof AbstractFunction)) {
            for (AbstractDNode aView : toBeRemoved) {
                this.removeAbstractFunctionAbstractCapabilityInvolvement((AbstractCapability)diagram.getTarget(), aView.getTarget());
            }
            for (AbstractFunction aFunction : selectedFunctions) {
                this.createAbstractFunctionAbstractCapabilityInvolvement((AbstractCapability)diagram.getTarget(), aFunction);
            }
        }
        ShowHideFunction shService = new ShowHideFunction(content);
        for (AbstractDNode element : toBeRemoved) {
            AbstractShowHide.DiagramContext context = shService.new AbstractShowHide.DiagramContext();
            shService.hide(element.getTarget(), context);
        }
        HashMap<AbstractFunction, AbstractDNode> showHideCategories = new HashMap<AbstractFunction, AbstractDNode>();
        for (AbstractFunction aFunction : selectedFunctions) {
            if (visibleFunctions.contains(aFunction)) continue;
            AbstractShowHide.DiagramContext context = shService.new AbstractShowHide.DiagramContext();
            Collection<DSemanticDecorator> views = shService.showWithResult((EObject)aFunction, context);
            for (DSemanticDecorator aView : views) {
                if (!aFunction.equals(aView.getTarget()) || !(aView instanceof AbstractDNode)) continue;
                showHideCategories.put(aFunction, (AbstractDNode)aView);
            }
        }
        Set<ExchangeCategory> categories = this.getVisibleExchangeCategoriesInDiagram((DDiagram)diagram);
        for (AbstractFunction aFunction : selectedFunctions) {
            AbstractDNode node;
            if (visibleFunctions.contains(aFunction) || (node = (AbstractDNode)showHideCategories.get(aFunction)) == null || !CapellaServices.getService().isSynchronized((DDiagram)diagram)) continue;
            HashMapSet<ExchangeCategory, AbstractFunction> scope = this.getAvailableCategoriesAndFunctionsToInsertInDataFlowBlank(node, content);
            HashMapSet selectedElements = new HashMapSet(scope);
            HashMapSet<ExchangeCategory, AbstractFunction> initialSelection = FaServices.getFaServices().getCategoriesAndFunctionsInitialSelectionInDataFlowBlank((DNodeContainer)node, content);
            for (ExchangeCategory category : new ArrayList<ExchangeCategory>(scope.keySet())) {
                if (categories.contains(category)) continue;
                selectedElements.remove(category);
            }
            this.showFECategories((DSemanticDecorator)node, scope, initialSelection, selectedElements);
        }
        return view;
    }

    public void removeAbstractFunctionAbstractCapabilityInvolvement(AbstractCapability capability, EObject target) {
        HashSet<AbstractFunctionAbstractCapabilityInvolvement> toRemove = new HashSet<AbstractFunctionAbstractCapabilityInvolvement>();
        for (AbstractFunctionAbstractCapabilityInvolvement inv : capability.getOwnedAbstractFunctionAbstractCapabilityInvolvements()) {
            if (!inv.getInvolved().equals(target)) continue;
            toRemove.add(inv);
        }
        for (AbstractFunctionAbstractCapabilityInvolvement involvement : toRemove) {
            involvement.destroy();
        }
    }

    public AbstractFunctionAbstractCapabilityInvolvement createAbstractFunctionAbstractCapabilityInvolvement(AbstractCapability capability, AbstractFunction target) {
        for (AbstractFunctionAbstractCapabilityInvolvement inv : capability.getOwnedAbstractFunctionAbstractCapabilityInvolvements()) {
            if (!inv.getInvolved().equals(target)) continue;
            return inv;
        }
        AbstractFunctionAbstractCapabilityInvolvement newInv = InteractionFactory.eINSTANCE.createAbstractFunctionAbstractCapabilityInvolvement();
        newInv.setInvolved((InvolvedElement)target);
        capability.getOwnedAbstractFunctionAbstractCapabilityInvolvements().add((Object)newInv);
        CapellaServices.getService().creationService((EObject)newInv);
        return newInv;
    }

    private void moveBorderedNodeIfPossible(DNode aBorderedNode, Set<AbstractDNode> toBeRemoved, DDiagram diagram) {
        EObject container = aBorderedNode.eContainer();
        while (container != null && container instanceof DNodeContainer) {
            if (!toBeRemoved.contains(container)) {
                boolean canMove = true;
                for (DEdge anEdge : DiagramServices.getDiagramServices().getIncomingEdges((EdgeTarget)aBorderedNode, diagram)) {
                    if (!EcoreUtil.isAncestor((EObject)container, (EObject)anEdge.getSourceNode())) continue;
                    canMove = false;
                    break;
                }
                for (DEdge anEdge : DiagramServices.getDiagramServices().getOutgoingEdges((EdgeTarget)aBorderedNode, diagram)) {
                    if (!EcoreUtil.isAncestor((EObject)container, (EObject)anEdge.getTargetNode())) continue;
                    canMove = false;
                    break;
                }
                if (canMove) {
                    if (aBorderedNode.getTarget() instanceof ExchangeCategory) {
                        for (DNode node : ((DNodeContainer)container).getOwnedBorderedNodes()) {
                            if (node.getTarget() != aBorderedNode.getTarget()) continue;
                            aBorderedNode.getIncomingEdges().addAll((Collection)aBorderedNode.getIncomingEdges());
                            aBorderedNode.getOutgoingEdges().addAll((Collection)aBorderedNode.getOutgoingEdges());
                            return;
                        }
                    }
                    ((DNodeContainer)container).getOwnedBorderedNodes().add((Object)aBorderedNode);
                }
                return;
            }
            container = container.eContainer();
        }
    }

    public EObject showDFFunctionalExchange(AbstractDNode currentFunctionView, List<FunctionalExchange> scope, List<FunctionalExchange> selectedExchanges) {
        DDiagram currentDiagram = CapellaServices.getService().getDiagramContainer((EObject)currentFunctionView);
        DDiagramContents content = this.getDDiagramContents(currentDiagram);
        HashSet<FunctionalExchange> scopeSet = new HashSet<FunctionalExchange>();
        scopeSet.addAll(scope);
        HashSet<FunctionalExchange> selectedExchangesSet = new HashSet<FunctionalExchange>();
        selectedExchangesSet.addAll(selectedExchanges);
        ShowHideFunctionalExchange shService = new ShowHideFunctionalExchange(content);
        AbstractShowHide.DiagramContext context = shService.new AbstractShowHide.DiagramContext();
        List<FunctionalExchange> exchanges = this.getDisplayedFunctionalExchanges((DSemanticDecorator)currentFunctionView);
        for (FunctionalExchange exchange : exchanges) {
            if (selectedExchangesSet.contains(exchange)) {
                shService.show((EObject)exchange, context);
                selectedExchangesSet.remove(exchange);
                continue;
            }
            shService.hide((EObject)exchange, context);
        }
        for (FunctionalExchange exchange : selectedExchangesSet) {
            shService.show((EObject)exchange, context);
        }
        this.reorderFAElements(currentDiagram);
        return currentFunctionView;
    }

    public void showDFFunctionalExchange(AbstractDNode currentFunctionView, FunctionalExchange exchange, DDiagramContents context, boolean checkValid) {
        DEdge edge = context.getEdge((EObject)exchange);
        if (edge != null) {
            if (checkValid && !DFServices.getService().isValidDFFunctionalExchangeEdgeFromInternalTool((EObject)exchange, (DSemanticDecorator)edge.getSourceNode(), (DSemanticDecorator)edge.getTargetNode())) {
                return;
            }
        } else {
            EObject element;
            ActivityNode source = exchange.getSource();
            ActivityNode target = exchange.getTarget();
            AbstractFunction sourceFunction = FunctionExt.getRelatedFunction((ActivityNode)source);
            AbstractFunction targetFunction = FunctionExt.getRelatedFunction((ActivityNode)target);
            Collection<DDiagramElement> sourceViews = context.getDiagramElements((EObject)sourceFunction);
            Collection<DDiagramElement> targetViews = context.getDiagramElements((EObject)targetFunction);
            AbstractDNode sourceView = null;
            if (sourceViews.size() > 0) {
                sourceView = (AbstractDNode)sourceViews.iterator().next();
            }
            AbstractDNode targetView = null;
            if (targetViews.size() > 0) {
                targetView = (AbstractDNode)targetViews.iterator().next();
            }
            if (currentFunctionView != null) {
                boolean sourceIsChild = EcoreUtil.isAncestor((EObject)currentFunctionView.getTarget(), (EObject)source);
                boolean targetIsChild = EcoreUtil.isAncestor((EObject)currentFunctionView.getTarget(), (EObject)target);
                if (sourceIsChild && targetIsChild) {
                    return;
                }
            }
            DragAndDropTarget sourceContainerView = context.getBestContainer((EObject)sourceFunction);
            DragAndDropTarget targetContainerView = context.getBestContainer((EObject)targetFunction);
            if (sourceContainerView instanceof DDiagramElement && targetContainerView instanceof DDiagramElement) {
                EObject element2;
                DragAndDropTarget aView = sourceContainerView;
                DragAndDropTarget bView = targetContainerView;
                if (EcoreUtil.isAncestor((EObject)aView, (EObject)bView) && (element2 = context.getElement((EObject)sourceFunction, (EObject)exchange)) != null && element2 instanceof AbstractFunction && !context.getDiagramElements(element2).contains(sourceContainerView)) {
                    sourceContainerView = context.getDDiagram();
                }
                if (EcoreUtil.isAncestor((EObject)bView, (EObject)aView) && (element2 = context.getElement((EObject)targetFunction, (EObject)exchange)) != null && element2 instanceof AbstractFunction && !context.getDiagramElements(element2).contains(targetContainerView)) {
                    targetContainerView = context.getDDiagram();
                }
            }
            if (sourceView == null) {
                if (sourceContainerView != null && sourceContainerView instanceof AbstractDNode) {
                    sourceView = (AbstractDNode)sourceContainerView;
                } else {
                    element = context.getElement((EObject)sourceFunction, (EObject)exchange);
                    if (element != null && element instanceof AbstractFunction) {
                        sourceView = this.showDFAbstractFunction((AbstractFunction)element, context.getBestContainer(element), context);
                    }
                }
            }
            if (targetView == null) {
                if (targetContainerView != null && targetContainerView instanceof AbstractDNode) {
                    targetView = (AbstractDNode)targetContainerView;
                } else {
                    element = context.getElement((EObject)targetFunction, (EObject)exchange);
                    if (element != null && element instanceof AbstractFunction) {
                        targetView = this.showDFAbstractFunction((AbstractFunction)element, context.getBestContainer(element), context);
                    }
                }
            }
            if (checkValid && !DFServices.getService().isValidDFFunctionalExchangeEdgeFromInternalTool((EObject)exchange, (DSemanticDecorator)sourceView, (DSemanticDecorator)targetView)) {
                return;
            }
            if (source instanceof FunctionPort) {
                sourceView = this.showDFFunctionPort(source, sourceView, context);
            }
            if (target instanceof FunctionPort) {
                targetView = this.showDFFunctionPort(target, targetView, context);
            }
            if (sourceView != null && targetView != null) {
                DiagramElementMapping mapping = context.getMapping(MappingConstantsHelper.getMappingDFFunctionalExchange(context.getDDiagram()));
                edge = DiagramServices.getDiagramServices().createEdge((EdgeMapping)mapping, (EdgeTarget)sourceView, (EdgeTarget)targetView, (EObject)exchange);
                context.addView((DDiagramElement)edge);
            }
        }
    }

    private AbstractDNode showDFFunctionPort(ActivityNode port, AbstractDNode sourceFunction, DDiagramContents context) {
        for (DDiagramElement element : sourceFunction.getOwnedBorderedNodes()) {
            if (element.getTarget() == null || !element.getTarget().equals(port)) continue;
            return (AbstractDNode)element;
        }
        if (sourceFunction.getTarget() instanceof AbstractFunction) {
            AbstractFunction function = (AbstractFunction)sourceFunction.getTarget();
            if (CapellaServices.getService().getAvailablePins(function, context.getDDiagram(), sourceFunction).contains(port)) {
                NodeMapping mapping = (NodeMapping)context.getMapping(MappingConstantsHelper.getMappingFunctionPort(context.getDDiagram()));
                DNode element = DiagramServices.getDiagramServices().createBorderedNode(mapping, (EObject)port, (DragAndDropTarget)sourceFunction, (DDiagram)context._currentDiagram);
                context.addView((DDiagramElement)element);
                return element;
            }
        }
        return null;
    }

    public AbstractDNode showDFAbstractFunction(AbstractFunction function, DragAndDropTarget dContainer, DDiagramContents context) {
        ContainerMapping mapping = (ContainerMapping)context.getMapping(MappingConstantsHelper.getMappingDFFunction(context.getDDiagram()));
        Collection<DDiagramElement> views = context.getDiagramElements((EObject)function, (DiagramElementMapping)mapping);
        if (views.size() > 0) {
            return (AbstractDNode)views.iterator().next();
        }
        DNodeContainer element = DiagramServices.getDiagramServices().createContainer(mapping, (EObject)function, (DragAndDropTarget)context.getDDiagram(), context.getDDiagram());
        DiagramServices.getDiagramServices().getOwnedDiagramElements(dContainer).add((Object)element);
        context.addView((DDiagramElement)element);
        return element;
    }

    private void hideDFFunctionalExchange(FunctionalExchange exchange, DDiagramContents context) {
        DEdge edge;
        if (!CapellaServices.getService().isSynchronized((DDiagram)context._currentDiagram) && (edge = context.getEdge((EObject)exchange)) != null) {
            boolean outgoing;
            boolean incoming;
            EdgeTarget source = edge.getSourceNode();
            EdgeTarget target = edge.getTargetNode();
            if (source instanceof DNode) {
                DNode sourceNode = (DNode)source;
                if (DiagramServices.getDiagramServices().isABorderedNode((AbstractDNode)sourceNode)) {
                    incoming = sourceNode.getIncomingEdges().isEmpty();
                    outgoing = sourceNode.getOutgoingEdges().isEmpty();
                    if (sourceNode.getIncomingEdges().size() == 1 && sourceNode.getIncomingEdges().contains((Object)edge)) {
                        incoming = true;
                    }
                    if (sourceNode.getOutgoingEdges().size() == 1 && sourceNode.getOutgoingEdges().contains((Object)edge)) {
                        outgoing = true;
                    }
                    if (incoming && outgoing) {
                        CapellaServices.getService().deleteView((DDiagramElement)sourceNode);
                    }
                }
            }
            if (target instanceof DNode) {
                DNode targetNode = (DNode)target;
                if (DiagramServices.getDiagramServices().isABorderedNode((AbstractDNode)targetNode)) {
                    incoming = targetNode.getIncomingEdges().isEmpty();
                    outgoing = targetNode.getOutgoingEdges().isEmpty();
                    if (targetNode.getIncomingEdges().size() == 1 && targetNode.getIncomingEdges().contains((Object)edge)) {
                        incoming = true;
                    }
                    if (targetNode.getOutgoingEdges().size() == 1 && targetNode.getOutgoingEdges().contains((Object)edge)) {
                        outgoing = true;
                    }
                    if (incoming && outgoing) {
                        CapellaServices.getService().deleteView((DDiagramElement)targetNode);
                    }
                }
            }
            DiagramServices.getDiagramServices().removeEdgeView(edge);
        }
    }

    @Deprecated
    protected DNode createViewFunctionPort(ActivityNode port, DragAndDropTarget container, DDiagram diagram) {
        NodeMapping mapping = this.getMappingDFFunctionPort(diagram);
        if (mapping == null) {
            mapping = this.getMappingABFunctionPort(diagram);
        }
        return DiagramServices.getDiagramServices().createBorderedNode(mapping, (EObject)port, container, diagram);
    }

    @Deprecated
    protected AbstractDNode createViewDFAbstractFunction(AbstractFunction aFunction, DDiagram diagram) {
        return this.createViewDFFunction(aFunction, diagram);
    }

    protected DNode createViewABAbstractFunction(AbstractFunction aFunction, DragAndDropTarget container, DDiagram diagram) {
        NodeMapping mapping = this.getMappingABAbstractFunction(aFunction, diagram);
        return DiagramServices.getDiagramServices().createNode(mapping, (EObject)aFunction, container, diagram);
    }

    protected DNodeContainer createViewDFFunction(AbstractFunction aFunction, DDiagram diagram) {
        ContainerMapping mapping = this.getMappingDFFunction(aFunction, diagram);
        return DiagramServices.getDiagramServices().createContainer(mapping, (EObject)aFunction, (DragAndDropTarget)diagram, diagram);
    }

    protected DNode createViewComponentPort(Port port, DragAndDropTarget container, DDiagram diagram) {
        NodeMapping mapping = this.getMappingABComponentPort(port, diagram);
        return DiagramServices.getDiagramServices().createBorderedNode(mapping, (EObject)port, container, diagram);
    }

    protected DNode createViewPhysicalPort(Port port, DragAndDropTarget container, DDiagram diagram) {
        NodeMapping mapping = this.getMappingABPhysicalPort(port, diagram);
        return DiagramServices.getDiagramServices().createBorderedNode(mapping, (EObject)port, container, diagram);
    }

    @Deprecated
    public DNodeContainer createViewPart(EObject target, DragAndDropTarget parent, DDiagram parentDiagram) {
        Component cpnt = null;
        if (target instanceof Component) {
            cpnt = (Component)target;
        } else if (target instanceof Part) {
            cpnt = (Component)((Part)target).getAbstractType();
        }
        ContainerMapping mapping = this.getMappingABComponent((EObject)cpnt, parentDiagram);
        return DiagramServices.getDiagramServices().createContainer(mapping, target, parent, parentDiagram);
    }

    public NodeMapping getMappingABComponentPort(DDiagram diagram) {
        String mappingName = MappingConstantsHelper.getMappingABComponentPort(diagram);
        return DiagramServices.getDiagramServices().getBorderedNodeMapping(diagram, mappingName);
    }

    public List<NodeMapping> getMappingABPorts(DDiagram diagram) {
        List<String> mappingNames = MappingConstantsHelper.getMappingABPorts(diagram);
        return DiagramServices.getDiagramServices().getBorderedNodeMapping(diagram, mappingNames);
    }

    @Deprecated
    public NodeMapping getMappingABComponentPort(Port port, DDiagram diagram) {
        return this.getMappingABComponentPort(diagram);
    }

    @Deprecated
    public NodeMapping getMappingABPhysicalPort(DDiagram diagram) {
        String mappingName = MappingConstantsHelper.getMappingABPhysicalPort(diagram);
        return DiagramServices.getDiagramServices().getBorderedNodeMapping(diagram, mappingName);
    }

    @Deprecated
    public NodeMapping getMappingABPhysicalPort(Port port, DDiagram diagram) {
        return this.getMappingABPhysicalPort(diagram);
    }

    public EObject dndDFFunctionPort(FunctionPort port, NamedElement oldContainer, NamedElement newContainer) {
        if (newContainer instanceof AbstractFunction) {
            AbstractFunction newFunction = (AbstractFunction)newContainer;
            AbstractFunction oldFunction = (AbstractFunction)port.eContainer();
            if (port instanceof FunctionInputPort) {
                for (ActivityEdge anEdge : ((FunctionInputPort)port).getIncoming()) {
                    if (!(anEdge instanceof FunctionalExchange)) continue;
                    this.updateFunctionaChainInvolvementsOfFunctionalExchange((FunctionalExchange)anEdge, oldFunction, newFunction);
                }
                newFunction.getInputs().add((Object)((FunctionInputPort)port));
            } else {
                for (ActivityEdge anEdge : ((FunctionOutputPort)port).getOutgoing()) {
                    if (!(anEdge instanceof FunctionalExchange)) continue;
                    this.updateFunctionaChainInvolvementsOfFunctionalExchange((FunctionalExchange)anEdge, oldFunction, newFunction);
                }
                newFunction.getOutputs().add((Object)((FunctionOutputPort)port));
            }
        }
        return port;
    }

    public Collection<? extends EObject> getFBDSemanticFunctions(AbstractFunction root) {
        Collection<? extends EObject> result = this.getFBDSemanticAbstractFunctions(root);
        CapellaServices.getService().filter(result, FaPackage.Literals.ABSTRACT_FUNCTION);
        return result;
    }

    @Deprecated
    public Collection<? extends EObject> getFBDSemanticControlNodes(AbstractFunction root) {
        return Collections.emptyList();
    }

    public Collection<? extends EObject> getFBDSemanticAbstractFunctions(AbstractFunction root) {
        Collection<AbstractFunction> result = this.getAllAbstractFunctions(root);
        EObject container = root.eContainer();
        if (container != null && container instanceof FunctionPkg && (container = container.eContainer()) != null && container instanceof BlockArchitecture) {
            result.remove(root);
        }
        return result;
    }

    public Collection<AbstractFunction> getAllAbstractFunctions(AbstractFunction root) {
        return FunctionExt.getAllAbstractFunctions((AbstractFunction)root);
    }

    public Collection<AbstractFunction> getAllAbstractFunctions(BlockArchitecture root) {
        return FunctionExt.getAllAbstractFunctions((BlockArchitecture)root);
    }

    public Collection<AbstractFunction> getAllAbstractFunctions(FunctionPkg root) {
        return FunctionPkgExt.getAllAbstractFunctions((FunctionPkg)root);
    }

    public EObject getFBDParentFunction(AbstractFunction root) {
        return EcoreUtil2.getFirstContainer((EObject)root, (EClass)FaPackage.Literals.ABSTRACT_FUNCTION);
    }

    public EObject updateFunctionaChainInvolvementsOfFunctionalExchange(FunctionalExchange fe, AbstractFunction oldFunction, AbstractFunction newFunction) {
        for (Involvement anInvolvement : fe.getInvolvingInvolvements()) {
            if (!(anInvolvement instanceof FunctionalChainInvolvement)) continue;
            FunctionalChainInvolvement currentInvolvement = (FunctionalChainInvolvement)anInvolvement;
            FunctionalChain currentFunctionalChain = (FunctionalChain)currentInvolvement.eContainer();
            Set newFunctionInvolvements = FunctionalChainExt.getInvolvementsOf((FunctionalChain)currentFunctionalChain, (InvolvedElement)newFunction);
            FunctionalChainInvolvement newFunctionInv = newFunctionInvolvements.isEmpty() ? FunctionalChainExt.createInvolvement((FunctionalChain)currentFunctionalChain, (InvolvedElement)newFunction) : (FunctionalChainInvolvement)newFunctionInvolvements.iterator().next();
            if (!FunctionExt.getIncomingAbstractFunction((FunctionalExchange)fe).equals(oldFunction)) {
                currentInvolvement.getNextFunctionalChainInvolvements().clear();
                currentInvolvement.getNextFunctionalChainInvolvements().add((Object)newFunctionInv);
                continue;
            }
            FunctionalChainInvolvement previousInv = (FunctionalChainInvolvement)currentInvolvement.getPreviousFunctionalChainInvolvements().iterator().next();
            previousInv.getNextFunctionalChainInvolvements().remove((Object)currentInvolvement);
            newFunctionInv.getNextFunctionalChainInvolvements().add((Object)currentInvolvement);
        }
        return fe;
    }

    public EObject reconnectDFFunctionalExchangeSource(EObject functionalExchange, DSemanticDecorator edge, DSemanticDecorator oldNode, DSemanticDecorator newNode) {
        if (edge instanceof DEdge && functionalExchange instanceof FunctionalExchange) {
            this.reconnectDFFunctionalExchange((FunctionalExchange)functionalExchange, ActivityPackage.Literals.ACTIVITY_EDGE__SOURCE, (DEdge)edge, oldNode, newNode);
        }
        return functionalExchange;
    }

    public EObject reconnectDFFunctionalExchangeTarget(EObject functionalExchange, DSemanticDecorator edge, DSemanticDecorator oldNode, DSemanticDecorator newNode) {
        if (edge instanceof DEdge && functionalExchange instanceof FunctionalExchange) {
            this.reconnectDFFunctionalExchange((FunctionalExchange)functionalExchange, ActivityPackage.Literals.ACTIVITY_EDGE__SOURCE, (DEdge)edge, oldNode, newNode);
        }
        return functionalExchange;
    }

    private void reconnectDFFunctionalExchange(FunctionalExchange functionalExchange, EReference activityEdgeSource, DEdge edge, DSemanticDecorator oldNode, DSemanticDecorator newNode) {
    }

    public EObject reconnectFunctionalExchange(FunctionalExchange fe, ActivityNode source, ActivityNode target) {
        AbstractFunction oldFunction = FunctionExt.getRelatedFunction((ActivityNode)source);
        AbstractFunction newFunction = FunctionExt.getRelatedFunction((ActivityNode)target);
        this.updateFunctionaChainInvolvementsOfFunctionalExchange(fe, oldFunction, newFunction);
        if (fe.getSource().equals(source)) {
            fe.setSource(target);
        } else {
            fe.setTarget(target);
        }
        EObject commonAncestor = CapellaServices.getService().getCommonAncestor((EObject)fe.getSource(), (EObject)fe.getTarget());
        if (commonAncestor != null && commonAncestor instanceof AbstractFunction && !commonAncestor.equals(fe.eContainer())) {
            ((AbstractFunction)commonAncestor).getOwnedFunctionalExchanges().add((Object)fe);
        }
        return fe;
    }

    public boolean isFunctionalExchangeReconnectable(FunctionalExchange fe, DDiagram diagram, EObject source, EObject target) {
        HashSet<FunctionalChain> visibleFC = new HashSet<FunctionalChain>();
        for (DNode aNode : diagram.getNodes()) {
            if (aNode.getTarget() == null || !(aNode.getTarget() instanceof FunctionalChain)) continue;
            visibleFC.add((FunctionalChain)aNode.getTarget());
        }
        for (FunctionalChain aFC : fe.getInvolvingFunctionalChains()) {
            if (!visibleFC.contains(aFC)) continue;
            return true;
        }
        if (source instanceof InputPin && target instanceof OutputPin) {
            return false;
        }
        if (source instanceof OutputPin && target instanceof InputPin) {
            return false;
        }
        if (target instanceof AbstractFunction && !CapellaLayerCheckingExt.isAOrInOperationalAnalysisLayer((CapellaElement)fe)) {
            return false;
        }
        if (!(target instanceof AbstractFunction) && CapellaLayerCheckingExt.isAOrInOperationalAnalysisLayer((CapellaElement)fe)) {
            return false;
        }
        if (fe.getSource().equals(source) && !this.isValidCreationFunctionalExchange((EObject)fe, target, (EObject)fe.getTarget())) {
            return false;
        }
        return !fe.getTarget().equals(source) || this.isValidCreationFunctionalExchange((EObject)fe, (EObject)fe.getSource(), target);
    }

    public boolean isValidDndABComponentPort(EObject element, EObject newContainer) {
        return true;
    }

    public EObject dndABAbstractFunctionAllocation(AbstractFunction function, NamedElement oldContainer, NamedElement newContainer) {
        if (oldContainer.equals(newContainer)) {
            return function;
        }
        List functions = FunctionExt.getAllAbstractFunctions((AbstractFunction)function);
        Component oldComponent = null;
        Component newComponent = null;
        if (oldContainer instanceof Part) {
            oldComponent = (Component)CsServices.getService().getComponentType((Part)oldContainer);
        } else if (oldContainer instanceof Component) {
            oldComponent = (Component)oldContainer;
        }
        if (newContainer instanceof Part) {
            newComponent = (Component)CsServices.getService().getComponentType((Part)newContainer);
        } else if (newContainer instanceof Component) {
            newComponent = (Component)newContainer;
        }
        if (oldComponent != null && newComponent != null) {
            for (ComponentFunctionalAllocation allocation : new ArrayList(oldComponent.getOwnedFunctionalAllocation())) {
                if (!functions.contains(allocation.getTargetElement())) continue;
                allocation.setSourceElement((TraceableElement)newComponent);
                newComponent.getOwnedFunctionalAllocation().add((Object)allocation);
            }
        } else if (oldContainer instanceof Role && newContainer instanceof Role) {
            Role oldRole = (Role)oldContainer;
            Role newRole = (Role)newContainer;
            for (ActivityAllocation allocation : new ArrayList(oldRole.getOwnedActivityAllocations())) {
                if (!functions.contains(allocation.getTargetElement())) continue;
                allocation.setSourceElement((TraceableElement)newRole);
                newRole.getOwnedActivityAllocations().add((Object)allocation);
            }
        } else if (oldContainer instanceof Role && newComponent != null) {
            Role oldRole = (Role)oldContainer;
            ArrayList<ActivityAllocation> removeAllocationLink = new ArrayList<ActivityAllocation>();
            EList allocations = oldRole.getActivityAllocations();
            for (ActivityAllocation activityAllocation : allocations) {
                OperationalActivity activity = activityAllocation.getActivity();
                if (activity == null || !activity.equals(function)) continue;
                removeAllocationLink.add(activityAllocation);
            }
            CapellaServices.getService().removeElements(removeAllocationLink);
            this.allocateToComponent(function, newComponent);
        } else if (oldComponent != null && newContainer instanceof Role) {
            Role newRole = (Role)newContainer;
            ArrayList<ComponentFunctionalAllocation> removeAllocationLink = new ArrayList<ComponentFunctionalAllocation>();
            EList allocations = oldComponent.getOwnedFunctionalAllocation();
            for (ComponentFunctionalAllocation activityAllocation : allocations) {
                AbstractFunction fct = activityAllocation.getFunction();
                if (fct == null || !fct.equals(function)) continue;
                removeAllocationLink.add(activityAllocation);
            }
            CapellaServices.getService().removeElements(removeAllocationLink);
            this.allocateToRole(function, newRole);
        }
        if (!oldContainer.equals(newComponent)) {
            this.removeUseLessPortRealizationAndComponentExchangeAllocation(function, functions);
        }
        return function;
    }

    private void removeUseLessPortRealizationAndComponentExchangeAllocation(AbstractFunction function, Collection<AbstractFunction> functions) {
        HashSet<FunctionalExchange> functionalExchanges = new HashSet<FunctionalExchange>();
        for (AbstractFunction fct : functions) {
            for (Port port : FunctionExt.getOwnedFunctionPorts((AbstractFunction)fct)) {
                this.removeUselessPortRealizations(port, true, true, false, false);
            }
        }
        functionalExchanges.addAll(FunctionExt.getIncomingExchange((AbstractFunction)function));
        functionalExchanges.addAll(FunctionExt.getOutGoingExchange((AbstractFunction)function));
        this.removeComponentExchangeAllocations(functionalExchanges);
    }

    private void removeComponentExchangeAllocations(Collection<FunctionalExchange> functionalExchanges) {
        HashSet<ComponentExchangeFunctionalExchangeAllocation> allocations = new HashSet<ComponentExchangeFunctionalExchangeAllocation>();
        for (FunctionalExchange exchange : functionalExchanges) {
            for (ComponentExchange ce : exchange.getAllocatingComponentExchanges()) {
                for (ComponentExchangeFunctionalExchangeAllocation alloc : ce.getOutgoingComponentExchangeFunctionalExchangeAllocations()) {
                    if (!alloc.getAllocatedFunctionalExchange().equals(exchange)) continue;
                    allocations.add(alloc);
                }
            }
        }
        CapellaServices.getService().removeElements(allocations);
    }

    private boolean isValidAllocation(Allocation realization) {
        return realization.getSourceElement() != null && realization.getTargetElement() != null && realization.getSourceElement() instanceof CapellaElement && realization.getTargetElement() instanceof CapellaElement && CapellaElementExt.areInSameDecompositionAlternative((CapellaElement)((CapellaElement)realization.getSourceElement()), (CapellaElement)((CapellaElement)realization.getTargetElement()));
    }

    public HashMapSet<ExchangeCategory, AbstractFunction> getAvailableCategoriesAndFunctionsToInsertInDataFlowBlank(AbstractDNode functionView, DDiagramContents content) {
        HashMapSet<ExchangeCategory, AbstractFunction> returnedMap = new HashMapSet<ExchangeCategory, AbstractFunction>();
        ArrayList<DNodeContainer> functionContainersInDiagram = new ArrayList<DNodeContainer>();
        for (DDiagramElement element : DiagramServices.getDiagramServices().getDiagramElements((EObject)content.getDDiagram())) {
            AbstractDNode aContainer;
            if (!(element instanceof AbstractDNode) || (aContainer = (AbstractDNode)element).getTarget() == null || !(aContainer.getTarget() instanceof AbstractFunction) || !(aContainer instanceof DNodeContainer)) continue;
            functionContainersInDiagram.add((DNodeContainer)aContainer);
        }
        AbstractFunction function = (AbstractFunction)functionView.getTarget();
        for (FunctionalExchange anExchange : this.getAvailableFunctionalExchangesToInsert((DSemanticDecorator)functionView)) {
            Object targetFunction = null;
            targetFunction = EcoreUtil.isAncestor((EObject)function, (EObject)anExchange.getSource()) ? (AbstractFunction)anExchange.getTarget().eContainer() : (AbstractFunction)anExchange.getSource().eContainer();
            DNodeContainer visibleFunctionInDiagram = this.getDisplayedFunctionContainer((EObject)targetFunction, functionContainersInDiagram);
            if (visibleFunctionInDiagram != null) {
                targetFunction = this.isValidCreationCategoryBetweenViews(anExchange, functionView, (AbstractDNode)visibleFunctionInDiagram) ? (AbstractFunction)visibleFunctionInDiagram.getTarget() : null;
            }
            if (targetFunction == null) continue;
            for (ExchangeCategory aCategory : anExchange.getCategories()) {
                returnedMap.put(aCategory, (AbstractFunction)targetFunction);
            }
        }
        return returnedMap;
    }

    public HashMapSet<ExchangeCategory, AbstractFunction> getCategoriesAndFunctionsInitialSelectionInDataFlowBlank(DNodeContainer functionView, DDiagramContents content) {
        HashMapSet<ExchangeCategory, AbstractFunction> returnedMap = new HashMapSet<ExchangeCategory, AbstractFunction>();
        ArrayList<DNodeContainer> functionContainersInDiagram = new ArrayList<DNodeContainer>();
        for (DDiagramElement element : DiagramServices.getDiagramServices().getDiagramElements((EObject)content.getDDiagram())) {
            AbstractDNode aContainer;
            if (!(element instanceof AbstractDNode) || (aContainer = (AbstractDNode)element).getTarget() == null || !(aContainer.getTarget() instanceof AbstractFunction) || !(aContainer instanceof DNodeContainer)) continue;
            functionContainersInDiagram.add((DNodeContainer)aContainer);
        }
        for (DNode aBorderedNode : functionView.getOwnedBorderedNodes()) {
            DNodeContainer visibleFunctionInDiagram;
            if (aBorderedNode.getTarget() == null || !(aBorderedNode.getTarget() instanceof ExchangeCategory)) continue;
            ExchangeCategory aCategory = (ExchangeCategory)aBorderedNode.getTarget();
            for (DEdge anEdge : DiagramServices.getDiagramServices().getIncomingEdges((EdgeTarget)aBorderedNode, content.getDDiagram())) {
                if (!anEdge.isVisible()) continue;
                AbstractFunction sourceFunction = (AbstractFunction)((DNodeContainer)anEdge.getSourceNode().eContainer()).getTarget();
                visibleFunctionInDiagram = this.getDisplayedFunctionContainer((EObject)sourceFunction, functionContainersInDiagram);
                if (visibleFunctionInDiagram != null) {
                    sourceFunction = (AbstractFunction)visibleFunctionInDiagram.getTarget();
                }
                returnedMap.put(aCategory, sourceFunction);
            }
            for (DEdge anEdge : DiagramServices.getDiagramServices().getOutgoingEdges((EdgeTarget)aBorderedNode, content.getDDiagram())) {
                if (!anEdge.isVisible()) continue;
                AbstractFunction targetFunction = (AbstractFunction)((DNodeContainer)anEdge.getTargetNode().eContainer()).getTarget();
                visibleFunctionInDiagram = this.getDisplayedFunctionContainer((EObject)targetFunction, functionContainersInDiagram);
                if (visibleFunctionInDiagram != null) {
                    targetFunction = (AbstractFunction)visibleFunctionInDiagram.getTarget();
                }
                returnedMap.put(aCategory, targetFunction);
            }
        }
        return returnedMap;
    }

    public EObject createABComponentExchangeWithoutPorts(EObject context, DSemanticDecorator sourceView, DSemanticDecorator targetView) {
        DDiagram diagram = CapellaServices.getService().getDiagramContainer((EObject)sourceView);
        InformationsExchanger sourcePart = CsServices.getService().getRelatedPart(sourceView);
        InformationsExchanger targetPart = CsServices.getService().getRelatedPart(targetView);
        EdgeTarget nodeSource = (EdgeTarget)sourceView;
        EdgeTarget nodeTarget = (EdgeTarget)targetView;
        ComponentExchange exchange = FaFactory.eINSTANCE.createComponentExchange();
        exchange.setKind(ComponentExchangeKind.ASSEMBLY);
        exchange.setSource(sourcePart);
        exchange.setTarget(targetPart);
        ComponentExchangeExt.attachToDefaultContainer((ComponentExchange)exchange);
        CapellaServices.getService().creationService((EObject)exchange);
        DiagramServices.getDiagramServices().createEdge(FaServices.getFaServices().getMappingABConnection(diagram), nodeSource, nodeTarget, (EObject)exchange);
        return context;
    }

    public ActivityNode getRelatedActivityNode(DSemanticDecorator sourceView) {
        if (sourceView != null) {
            if (sourceView.getTarget() != null && sourceView.getTarget() instanceof ActivityNode) {
                return (ActivityNode)sourceView.getTarget();
            }
            if (sourceView.eContainer() != null && sourceView.eContainer() instanceof DSemanticDecorator) {
                return this.getRelatedActivityNode((DSemanticDecorator)sourceView.eContainer());
            }
        }
        return null;
    }

    public EObject createABComponentExchange(EObject context, DSemanticDecorator sourceView, DSemanticDecorator targetView) {
        return this.createABComponentExchangeWithOption(context, sourceView, targetView, false);
    }

    public EObject createABComponentExchange(EObject context, DSemanticDecorator sourceView, DSemanticDecorator targetView, boolean createComponentExchageOnType) {
        return this.createABComponentExchangeWithOption(context, sourceView, targetView, createComponentExchageOnType);
    }

    public EObject createABComponentExchangeWithOption(EObject context, DSemanticDecorator sourceView, DSemanticDecorator targetView, boolean createComponentExchageOnType) {
        EObject sourceTarget = sourceView.getTarget();
        EObject targetTarget = targetView.getTarget();
        DDiagram diagram = CapellaServices.getService().getDiagramContainer((EObject)sourceView);
        EdgeTarget nodeSource = null;
        EdgeTarget nodeTarget = null;
        CommunicationMean exchange = null;
        if (sourceTarget instanceof Entity && targetTarget instanceof Entity) {
            exchange = OaFactory.eINSTANCE.createCommunicationMean();
            exchange.setSource((InformationsExchanger)((Entity)sourceTarget));
            exchange.setTarget((InformationsExchanger)((Entity)targetTarget));
            nodeSource = (EdgeTarget)sourceView;
            nodeTarget = (EdgeTarget)targetView;
        } else {
            ComponentExchangeEnd end;
            InformationsExchanger sourceRelatedPart = CsServices.getService().getRelatedPart(sourceView);
            InformationsExchanger targetRelatedPart = CsServices.getService().getRelatedPart(targetView);
            Part sourcePart = null;
            Part targetPart = null;
            if (sourceRelatedPart instanceof Part) {
                sourcePart = (Part)sourceRelatedPart;
            }
            if (targetRelatedPart instanceof Part) {
                targetPart = (Part)targetRelatedPart;
            }
            ComponentPort sourcePort = null;
            if (sourceTarget instanceof ComponentPort) {
                sourcePort = (ComponentPort)sourceTarget;
                nodeSource = (EdgeTarget)sourceView;
            } else {
                sourcePort = FaFactory.eINSTANCE.createComponentPort();
                ((Component)sourcePart.getType()).getOwnedFeatures().add((Object)sourcePort);
                if (targetTarget instanceof ComponentPort) {
                    sourcePort.setKind(((ComponentPort)targetTarget).getKind());
                } else {
                    sourcePort.setKind(ComponentPortKind.FLOW);
                }
                if (sourcePort.getKind() == ComponentPortKind.FLOW) {
                    sourcePort.setOrientation(OrientationPortKind.OUT);
                }
                CapellaServices.getService().creationService((EObject)sourcePort);
                if (sourceView instanceof DNodeContainer) {
                    nodeSource = (EdgeTarget)CsServices.getService().createViewOrGetPort((DNodeContainer)sourceView, (Port)sourcePort).getKey();
                }
            }
            ComponentPort targetPort = null;
            if (targetTarget instanceof ComponentPort) {
                targetPort = (ComponentPort)targetTarget;
                nodeTarget = (EdgeTarget)targetView;
            } else {
                targetPort = FaFactory.eINSTANCE.createComponentPort();
                ((Component)targetPart.getType()).getOwnedFeatures().add((Object)targetPort);
                targetPort.setKind(sourcePort.getKind());
                if (targetPort.getKind() == ComponentPortKind.FLOW) {
                    targetPort.setOrientation(OrientationPortKind.IN);
                }
                CapellaServices.getService().creationService((EObject)targetPort);
                if (targetView instanceof DNodeContainer) {
                    nodeTarget = (EdgeTarget)CsServices.getService().createViewOrGetPort((DNodeContainer)targetView, (Port)targetPort).getKey();
                }
            }
            exchange = FaFactory.eINSTANCE.createComponentExchange();
            if (sourcePort.getKind() == ComponentPortKind.STANDARD || targetPort.getKind() == ComponentPortKind.STANDARD) {
                exchange.setKind(ComponentExchangeKind.ASSEMBLY);
            } else {
                exchange.setKind(ComponentExchangeKind.FLOW);
            }
            if (CsServices.getService().isMultipartMode((ModelElement)sourceTarget) && !createComponentExchageOnType) {
                end = FaFactory.eINSTANCE.createComponentExchangeEnd();
                end.setPart((Partition)sourcePart);
                end.setPort((Port)sourcePort);
                exchange.setSource((InformationsExchanger)end);
                exchange.getOwnedComponentExchangeEnds().add((Object)end);
                CapellaServices.getService().creationService((EObject)end);
            } else {
                exchange.setSource((InformationsExchanger)sourcePort);
            }
            if (CsServices.getService().isMultipartMode((ModelElement)sourceTarget) && !createComponentExchageOnType) {
                end = FaFactory.eINSTANCE.createComponentExchangeEnd();
                end.setPart((Partition)targetPart);
                end.setPort((Port)targetPort);
                exchange.setTarget((InformationsExchanger)end);
                exchange.getOwnedComponentExchangeEnds().add((Object)end);
                CapellaServices.getService().creationService((EObject)end);
            } else {
                exchange.setTarget((InformationsExchanger)targetPort);
            }
        }
        ComponentExchangeExt.attachToDefaultContainer((ComponentExchange)exchange);
        CapellaServices.getService().creationService((EObject)exchange);
        DiagramServices.getDiagramServices().createEdge(FaServices.getFaServices().getMappingABConnection(diagram), nodeSource, nodeTarget, (EObject)exchange);
        CsServices.getService().setInterpreterVariable(context, "result", (EObject)exchange);
        return context;
    }

    public EObject createIBDelegation(EObject context, DSemanticDecorator sourceView, DSemanticDecorator targetView) {
        return this.createABDelegation(context, sourceView, targetView);
    }

    public EObject createABDelegation(EObject context, DSemanticDecorator sourceView, DSemanticDecorator targetView) {
        EObject targetComponent;
        EObject sourceComponent;
        EObject sourceTarget = sourceView.getTarget();
        EObject targetTarget = targetView.getTarget();
        DDiagram diagram = CapellaServices.getService().getDiagramContainer((EObject)sourceView);
        InformationsExchanger sourceRelatedPart = CsServices.getService().getRelatedPart(sourceView);
        InformationsExchanger targetRelatedPart = CsServices.getService().getRelatedPart(targetView);
        Part sourcePart = null;
        Part targetPart = null;
        if (sourceRelatedPart instanceof Part) {
            sourcePart = (Part)sourceRelatedPart;
        }
        if (targetRelatedPart instanceof Part) {
            targetPart = (Part)targetRelatedPart;
        }
        if (sourcePart == null && (sourceComponent = CsServices.getService().getComponentType(sourceView)) != null && sourceComponent instanceof Component && ((Component)sourceComponent).getRepresentingPartitions().size() > 0 && ((Component)sourceComponent).getRepresentingPartitions().get(0) instanceof Part) {
            sourcePart = (Part)((Component)sourceComponent).getRepresentingPartitions().get(0);
        }
        if (targetPart == null && (targetComponent = CsServices.getService().getComponentType(targetView)) != null && targetComponent instanceof Component && ((Component)targetComponent).getRepresentingPartitions().size() > 0 && ((Component)targetComponent).getRepresentingPartitions().get(0) instanceof Part) {
            targetPart = (Part)((Component)targetComponent).getRepresentingPartitions().get(0);
        }
        if (sourcePart == null || targetPart == null) {
            return context;
        }
        EdgeTarget nodeSource = null;
        EdgeTarget nodeTarget = null;
        Port sourcePort = null;
        if (sourceTarget instanceof Port) {
            sourcePort = (Port)sourceTarget;
            nodeSource = (EdgeTarget)sourceView;
        } else {
            if (sourcePart.getAbstractType() instanceof PhysicalComponent && ((PhysicalComponent)sourcePart.getAbstractType()).getNature() == PhysicalComponentNature.NODE) {
                sourcePort = CsFactory.eINSTANCE.createPhysicalPort();
                ((Component)sourcePart.getType()).getOwnedFeatures().add((Object)((PhysicalPort)sourcePort));
            } else {
                sourcePort = FaFactory.eINSTANCE.createComponentPort();
                ComponentPort sourceCPort = (ComponentPort)sourcePort;
                ((Component)sourcePart.getType()).getOwnedFeatures().add((Object)sourceCPort);
                if (targetTarget instanceof ComponentPort) {
                    ComponentPort targetPort = (ComponentPort)targetTarget;
                    sourceCPort.setKind(targetPort.getKind());
                    sourceCPort.setOrientation(targetPort.getOrientation());
                } else {
                    sourceCPort.setKind(ComponentPortKind.FLOW);
                    sourceCPort.setOrientation(OrientationPortKind.IN);
                }
            }
            CapellaServices.getService().creationService((EObject)sourcePort);
            if (sourceView instanceof DNodeContainer) {
                nodeSource = (EdgeTarget)CsServices.getService().createViewOrGetPort((DNodeContainer)sourceView, sourcePort).getKey();
            }
        }
        ComponentPort targetPort = null;
        if (targetTarget instanceof ComponentPort) {
            targetPort = (ComponentPort)targetTarget;
            nodeTarget = (EdgeTarget)targetView;
        } else {
            ComponentPort targetCPort = targetPort = FaFactory.eINSTANCE.createComponentPort();
            if (sourcePort instanceof ComponentPort) {
                targetCPort.setKind(((ComponentPort)sourcePort).getKind());
                targetCPort.setOrientation(((ComponentPort)sourcePort).getOrientation());
            } else {
                targetCPort.setKind(ComponentPortKind.FLOW);
                targetCPort.setOrientation(OrientationPortKind.IN);
            }
            ((Component)targetPart.getType()).getOwnedFeatures().add((Object)targetCPort);
            CapellaServices.getService().creationService((EObject)targetPort);
            if (targetView instanceof DNodeContainer) {
                nodeTarget = (EdgeTarget)CsServices.getService().createViewOrGetPort((DNodeContainer)targetView, (Port)targetPort).getKey();
            }
        }
        ComponentExchange exchange = FaFactory.eINSTANCE.createComponentExchange();
        exchange.setKind(ComponentExchangeKind.DELEGATION);
        exchange.setSource((InformationsExchanger)sourcePort);
        if (CsServices.getService().isMultipartMode((ModelElement)sourceTarget)) {
            ComponentExchangeEnd end = FaFactory.eINSTANCE.createComponentExchangeEnd();
            end.setPart((Partition)targetPart);
            end.setPort((Port)targetPort);
            exchange.setTarget((InformationsExchanger)end);
            exchange.getOwnedComponentExchangeEnds().add((Object)end);
            CapellaServices.getService().creationService((EObject)end);
        } else {
            exchange.setTarget((InformationsExchanger)targetPort);
        }
        ComponentExchangeExt.attachToDefaultContainer((ComponentExchange)exchange);
        CapellaServices.getService().creationService((EObject)exchange);
        DiagramServices.getDiagramServices().createEdge(FaServices.getFaServices().getMappingABConnection(diagram), nodeSource, nodeTarget, (EObject)exchange);
        CsServices.getService().setInterpreterVariable(context, "result", (EObject)exchange);
        return context;
    }

    public EObject createABComponentExchangeThroughDelegation(EObject context, DSemanticDecorator sourceView, DSemanticDecorator targetView) {
        InformationsExchanger sourcePart = CsServices.getService().getRelatedPart(sourceView);
        InformationsExchanger targetPart = CsServices.getService().getRelatedPart(targetView);
        ComponentPort sourcePort = null;
        if (sourceView.getTarget() != null && sourceView.getTarget() instanceof ComponentPort) {
            sourcePort = (ComponentPort)sourceView.getTarget();
        }
        ComponentPort targetPort = null;
        if (targetView.getTarget() != null && targetView.getTarget() instanceof ComponentPort) {
            targetPort = (ComponentPort)targetView.getTarget();
        }
        if (sourcePart instanceof Part && targetPart instanceof Part) {
            Collection createdElements = ComponentExt.createComponentExchangeThroughDelegations((Part)((Part)sourcePart), (ComponentPort)sourcePort, (Part)((Part)targetPart), (ComponentPort)targetPort);
            DDiagram diagram = CapellaServices.getService().getDiagramContainer((EObject)sourceView);
            CsServices.getService().showABComponentExchange(createdElements, (DSemanticDecorator)diagram);
            CsServices.getService().setInterpreterVariable(context, "result", createdElements);
        }
        return context;
    }

    public Collection<ComponentExchange> getRelatedComponentExchanges(NamedElement componentOrPart) {
        Part part;
        ArrayList<ComponentExchange> relatedExchanges = new ArrayList<ComponentExchange>();
        if (componentOrPart instanceof Component) {
            relatedExchanges.addAll(ComponentExt.getAllRelatedComponentExchange((Component)((Component)componentOrPart)));
        } else if (componentOrPart instanceof Part && (part = (Part)componentOrPart).getAbstractType() != null && part.getAbstractType() instanceof Component) {
            Component component = (Component)((Part)componentOrPart).getAbstractType();
            if (CsServices.getService().isMultipartMode((ModelElement)componentOrPart)) {
                for (ComponentExchange exchange : ComponentExt.getAllRelatedComponentExchange((Component)component)) {
                    if (!part.equals(ComponentExchangeExt.getSourcePart((ComponentExchange)exchange)) && !part.equals(ComponentExchangeExt.getTargetPart((ComponentExchange)exchange))) continue;
                    relatedExchanges.add(exchange);
                }
            } else {
                relatedExchanges.addAll(ComponentExt.getAllRelatedComponentExchange((Component)component));
            }
        }
        return relatedExchanges;
    }

    void removeUselessExchanges(NamedElement componentOrPart) {
        Collection<ComponentExchange> relatedExchanges = this.getRelatedComponentExchanges(componentOrPart);
        HashSet<AbstractTrace> elements = new HashSet<AbstractTrace>();
        for (ComponentExchange connection : relatedExchanges) {
            EList incomingTraces = connection.getIncomingTraces();
            for (AbstractTrace abstractTrace : incomingTraces) {
                TraceableElement sourceElement = abstractTrace.getSourceElement();
                if (sourceElement == null || !(sourceElement instanceof PhysicalLink)) continue;
                elements.add(abstractTrace);
            }
        }
        CapellaServices.getService().removeElements(elements);
    }

    public EObject dndABDeployment(NamedElement pcMoved, NamedElement oldContainer, NamedElement newContainer) {
        if (pcMoved instanceof PhysicalComponent && newContainer instanceof PhysicalComponent) {
            PhysicalComponent component = (PhysicalComponent)pcMoved;
            PhysicalComponent newComponent = (PhysicalComponent)newContainer;
            this.moveComponentExchanges((Component)component);
            for (Port port : ComponentExt.getOwnedComponentPort((Component)component)) {
                this.removeUselessPortRealizations(port, false, true, false, false);
            }
            for (AbstractDeploymentLink link : new ArrayList(component.getDeployingLinks())) {
                link.setLocation((DeploymentTarget)newComponent);
                newComponent.getOwnedDeploymentLinks().add((Object)link);
            }
            this.removeUselessExchanges((NamedElement)component);
        }
        if (pcMoved instanceof Part && newContainer instanceof Part) {
            Part currentPart = (Part)pcMoved;
            Part newPart = (Part)newContainer;
            Component component = (Component)currentPart.getAbstractType();
            this.moveComponentExchanges(component);
            for (Port port : ComponentExt.getOwnedComponentPort((Component)component)) {
                this.removeUselessPortRealizations(port, false, true, false, false);
            }
            for (AbstractDeploymentLink link : new ArrayList(currentPart.getDeployingLinks())) {
                link.setLocation((DeploymentTarget)newPart);
                newPart.getOwnedDeploymentLinks().add((Object)link);
            }
            this.removeUselessExchanges((NamedElement)currentPart);
        }
        return pcMoved;
    }

    EObject removeUselessPortRealizations(Port port, boolean includeFunctionalRealization, boolean includeComponentRealization, boolean topDelegation, boolean bottomDelegation) {
        HashSet<Object> elements = new HashSet<Object>();
        if (port instanceof ComponentPort) {
            for (ComponentExchange exchange : PortExt.getDelegationComponentExchanges((ComponentPort)((ComponentPort)port))) {
                Component targetComponent;
                Component sourceComponent = ComponentExchangeExt.getSourceComponent((ComponentExchange)exchange);
                Component containingPort = targetComponent = ComponentExchangeExt.getTargetComponent((ComponentExchange)exchange);
                Component delegatedPort = sourceComponent;
                if (port.eContainer() != null && port.eContainer().equals(sourceComponent)) {
                    containingPort = sourceComponent;
                    delegatedPort = targetComponent;
                }
                if (topDelegation && CsServices.getService().getContainersOfParts(containingPort).contains(delegatedPort)) {
                    elements.add(exchange);
                    continue;
                }
                if (!bottomDelegation || !CsServices.getService().getContainersOfParts(delegatedPort).contains(containingPort)) continue;
                elements.add(exchange);
            }
        }
        HashSet allocations = new HashSet();
        allocations.addAll(port.getIncomingPortAllocations());
        allocations.addAll(port.getOutgoingPortAllocations());
        allocations.addAll(port.getIncomingPortRealizations());
        allocations.addAll(port.getOutgoingPortRealizations());
        for (Allocation realization : allocations) {
            if (!this.isValidAllocation(realization) || realization.getSourceElement() == null || realization.getTargetElement() == null) continue;
            if (includeFunctionalRealization && realization.getTargetElement() instanceof FunctionPort) {
                elements.add(realization);
            }
            if (port instanceof FunctionPort && includeComponentRealization && realization.getSourceElement() instanceof FunctionPort) {
                elements.add(realization);
            }
            if (!includeComponentRealization || !(realization.getTargetElement() instanceof ComponentPort) && !(realization.getTargetElement() instanceof PhysicalPort)) continue;
            elements.add(realization);
        }
        CapellaServices.getService().removeElements(elements);
        return port;
    }

    public EObject dndABFunctionPort(FunctionPort port, NamedElement oldContainer, NamedElement newContainer) {
        this.removeUselessPortRealizations((Port)port, true, true, false, false);
        if (newContainer instanceof AbstractFunction) {
            AbstractFunction newFunction = (AbstractFunction)newContainer;
            AbstractFunction oldFunction = (AbstractFunction)port.eContainer();
            if (port instanceof FunctionInputPort) {
                for (ActivityEdge anEdge : ((FunctionInputPort)port).getIncoming()) {
                    if (!(anEdge instanceof FunctionalExchange)) continue;
                    this.updateFunctionaChainInvolvementsOfFunctionalExchange((FunctionalExchange)anEdge, oldFunction, newFunction);
                }
                newFunction.getInputs().add((Object)((FunctionInputPort)port));
            } else {
                for (ActivityEdge anEdge : ((FunctionOutputPort)port).getOutgoing()) {
                    if (!(anEdge instanceof FunctionalExchange)) continue;
                    this.updateFunctionaChainInvolvementsOfFunctionalExchange((FunctionalExchange)anEdge, oldFunction, newFunction);
                }
                newFunction.getOutputs().add((Object)((FunctionOutputPort)port));
            }
        }
        this.moveFunctionalExchanges(port);
        this.removeComponentExchangeAllocations(this.getFunctionalExchanges((Port)port));
        return port;
    }

    public EObject dndABPhysicalPort(PhysicalPort port, Part oldContainer, Part newContainer) {
        if (!port.eContainer().equals(newContainer.getType())) {
            this.removeUselessExchanges((NamedElement)port);
            this.removeUselessPortRealizations((Port)port, true, true, false, false);
            ((Component)newContainer.getType()).getOwnedFeatures().add((Object)port);
            this.updateExchanges(port, oldContainer, newContainer);
        }
        return port;
    }

    public EObject dndABComponentPort(ComponentPort port, Part oldContainer, Part newContainer) {
        if (!port.eContainer().equals(newContainer.getType())) {
            this.removeUselessExchanges((NamedElement)port);
            this.removeUselessPortRealizations((Port)port, true, true, false, false);
            ((Component)newContainer.getType()).getOwnedFeatures().add((Object)port);
            this.updateComponentExchanges(port, oldContainer, newContainer);
        }
        return port;
    }

    protected void moveComponent(Component component, Component container) {
        if (container instanceof LogicalComponent && component instanceof LogicalComponent) {
            ((LogicalComponent)container).getOwnedLogicalComponents().add((Object)((LogicalComponent)component));
        } else if (container instanceof PhysicalComponent && component instanceof PhysicalComponent) {
            ((PhysicalComponent)container).getOwnedPhysicalComponents().add((Object)((PhysicalComponent)component));
        }
    }

    protected void moveComponentExchange(ComponentExchange exchange) {
        ComponentExchangeExt.attachToDefaultContainer((ComponentExchange)exchange);
    }

    protected void moveFunctionalExchange(FunctionalExchange exchange) {
        EObject ancestor = CapellaServices.getService().getCommonAncestor((EObject)exchange.getSource(), (EObject)exchange.getTarget());
        if (ancestor != exchange.eContainer() && ancestor instanceof AbstractFunction) {
            ((AbstractFunction)ancestor).getOwnedFunctionalExchanges().add((Object)exchange);
        }
    }

    protected void movePhysicalLink(PhysicalLink exchange) {
        EObject container;
        Part target;
        Part source = PhysicalLinkExt.getSourcePart((PhysicalLink)exchange);
        if (source == null) {
            source = PhysicalLinkExt.getSourcePort((PhysicalLink)exchange);
        }
        if ((target = PhysicalLinkExt.getTargetPart((PhysicalLink)exchange)) == null) {
            target = PhysicalLinkExt.getTargetPort((PhysicalLink)exchange);
        }
        if ((container = ComponentExt.getFirstCommonComponentAncestor((EObject)source, (EObject)target)) == null || !(container instanceof PhysicalComponent)) {
            container = BlockArchitectureExt.getFirstComponent((ModellingArchitecture)ComponentExt.getRootBlockArchitecture((ModelElement)exchange));
        }
        if (container != exchange.eContainer()) {
            ((PhysicalComponent)container).getOwnedPhysicalLinks().add((Object)exchange);
        }
    }

    protected void updateExchanges(PhysicalPort port, Part oldPart, Part newPart) {
        for (PhysicalLink exchange : PhysicalLinkExt.getAllRelatedPhysicalLinks((PhysicalPort)port)) {
            if (exchange.getOwnedPhysicalLinkEnds().size() > 0) {
                for (PhysicalLinkEnd anEnd : exchange.getOwnedPhysicalLinkEnds()) {
                    if (!anEnd.getPort().equals(port) || !anEnd.getPart().equals(oldPart)) continue;
                    anEnd.setPart(newPart);
                }
            }
            this.movePhysicalLink(exchange);
        }
    }

    protected void moveComponentExchanges(ComponentPort port) {
        for (ComponentExchange exchange : port.getComponentExchanges()) {
            this.moveComponentExchange(exchange);
        }
    }

    protected void moveComponentExchanges(Component component) {
        for (ComponentPort port : ComponentExt.getOwnedComponentPort((Component)component)) {
            this.moveComponentExchanges(port);
        }
    }

    protected void updateComponentExchanges(ComponentPort port, Part oldPart, Part newPart) {
        for (ComponentExchange exchange : port.getComponentExchanges()) {
            if (exchange.getOwnedComponentExchangeEnds().size() > 0) {
                for (ComponentExchangeEnd anEnd : exchange.getOwnedComponentExchangeEnds()) {
                    if (anEnd.getPort() == null || !anEnd.getPort().equals(port) || anEnd.getPart() == null || !anEnd.getPart().equals(oldPart)) continue;
                    anEnd.setPart((Partition)newPart);
                }
            }
            if (oldPart != null && oldPart.equals(exchange.getSource())) {
                exchange.setSource((InformationsExchanger)newPart);
            }
            if (oldPart != null && oldPart.equals(exchange.getTarget())) {
                exchange.setTarget((InformationsExchanger)newPart);
            }
            this.moveComponentExchange(exchange);
        }
    }

    protected void moveFunctionalExchanges(FunctionPort port) {
        ArrayList<FunctionalExchange> functionalExchanges = new ArrayList<FunctionalExchange>();
        EList edges = port instanceof FunctionInputPort ? ((FunctionInputPort)port).getIncoming() : ((FunctionOutputPort)port).getOutgoing();
        for (ActivityEdge edge : new ArrayList(edges)) {
            if (!(edge instanceof FunctionalExchange)) continue;
            functionalExchanges.add((FunctionalExchange)edge);
        }
        for (FunctionalExchange exchange : functionalExchanges) {
            this.moveFunctionalExchange(exchange);
        }
        this.removeComponentExchangeAllocations(functionalExchanges);
    }

    public Collection<? extends AbstractFunction> getTableRootAbstractFunctions(BlockArchitecture architecture) {
        return this.getOwnedAbstractFunctions(this.getRootFunction((EObject)architecture));
    }

    public Collection<? extends FunctionPkg> getTableRootAbstractFunctionPkgs(BlockArchitecture architecture) {
        return this.getOwnedAbstractFunctionPkgs(this.getRootFunction((EObject)architecture));
    }

    public Collection<? extends AbstractFunction> getOwnedAbstractFunctions(AbstractFunction function) {
        return function.getOwnedFunctions();
    }

    public Collection<? extends AbstractFunction> getOwnedAbstractFunctions(FunctionPkg functionPkg) {
        return FunctionPkgExt.getOwnedFunctions((FunctionPkg)functionPkg);
    }

    public Collection<? extends FunctionPkg> getOwnedAbstractFunctionPkgs(FunctionPkg function) {
        return FunctionPkgExt.getOwnedFunctionPkgs((FunctionPkg)function);
    }

    public Collection<? extends FunctionPkg> getOwnedAbstractFunctionPkgs(AbstractFunction function) {
        return FunctionExt.getOwnedFunctionPkgs((AbstractFunction)function);
    }

    public AbstractFunction getTableRootFunction(EObject element) {
        return this.getRootFunction(element);
    }

    public AbstractFunction getRootFunction(EObject element) {
        return BlockArchitectureExt.getRootFunction((BlockArchitecture)BlockArchitectureExt.getRootBlockArchitecture((EObject)element));
    }

    protected Collection<FunctionalExchange> getFunctionalExchanges(Port port) {
        HashSet<FunctionalExchange> exchanges = new HashSet();
        if (port instanceof ComponentPort) {
            exchanges = FunctionalExt.getFunctionalExchanges((ComponentPort)((ComponentPort)port));
        } else if (port instanceof FunctionPort) {
            EList edges = port instanceof FunctionInputPort ? ((FunctionInputPort)port).getIncoming() : ((FunctionOutputPort)port).getOutgoing();
            for (ActivityEdge edge : new ArrayList(edges)) {
                if (!(edge instanceof FunctionalExchange)) continue;
                exchanges.add((FunctionalExchange)edge);
            }
        }
        return exchanges;
    }

    public boolean isNodeWithoutEdge(EObject context, DDiagram diagram, EClass node, EClass edge) {
        if (diagram != null && context instanceof DSemanticDecorator) {
            DSemanticDecorator decorator = (DSemanticDecorator)context;
            if (decorator.getTarget() == null || !node.isInstance((Object)decorator.getTarget())) {
                return true;
            }
            if (context instanceof EdgeTarget) {
                EdgeTarget target = (EdgeTarget)context;
                for (DEdge incoming : target.getIncomingEdges()) {
                    if (incoming.getTarget() == null || !edge.isInstance((Object)incoming.getTarget())) continue;
                    return true;
                }
                for (DEdge outgoing : target.getOutgoingEdges()) {
                    if (outgoing.getTarget() == null || !edge.isInstance((Object)outgoing.getTarget())) continue;
                    return true;
                }
            }
        }
        return false;
    }

    public boolean isComponentPortWithoutInterfaces(EObject context, DDiagram diagram) {
        return this.isNodeWithoutEdge(context, diagram, FaPackage.Literals.COMPONENT_PORT, CsPackage.Literals.INTERFACE);
    }

    public boolean isPhysicalPortWithoutLinks(EObject context, DDiagram diagram) {
        return this.isNodeWithoutEdge(context, diagram, CsPackage.Literals.PHYSICAL_PORT, CsPackage.Literals.PHYSICAL_LINK);
    }

    public boolean isComponentPortWithoutExchanges(EObject context, DDiagram diagram) {
        return this.isNodeWithoutEdge(context, diagram, FaPackage.Literals.COMPONENT_PORT, FaPackage.Literals.COMPONENT_EXCHANGE);
    }

    public boolean isFunctionPortWithoutExchanges(EObject context, DDiagram diagram) {
        return this.isNodeWithoutEdge(context, diagram, FaPackage.Literals.FUNCTION_PORT, FaPackage.Literals.FUNCTIONAL_EXCHANGE);
    }

    /*
     * Unable to fully structure code
     */
    public void reorderFAElements(DDiagram diagram) {
        elementsInDiagram = new Hashtable<EObject, DDiagramElement>();
        toBeMoved = new HashSet<DDiagramElement>();
        functionPortsInDiagram = new HashSet<FunctionPort>();
        allFunctionsInDiagram = new HashMap<AbstractFunction, AbstractDNode>();
        content = new DDiagramContents(diagram);
        for (DDiagramElement aContainer : diagram.getContainers()) {
            if (aContainer == null || aContainer.getTarget() == null || !FaServices.getFaServices().isAbstractFunctionVisibleInDFB((AbstractDNode)aContainer, diagram)) continue;
            elementsInDiagram.put(aContainer.getTarget(), aContainer);
            if (!(aContainer.getTarget() instanceof AbstractFunction)) continue;
            allFunctionsInDiagram.put((AbstractFunction)aContainer.getTarget(), (AbstractDNode)aContainer);
        }
        for (DNode aNode : diagram.getNodes()) {
            if (aNode == null || aNode.getTarget() == null || !(aNode.getTarget() instanceof FunctionPort)) continue;
            functionPortsInDiagram.add((FunctionPort)aNode.getTarget());
        }
        block2: for (DDiagramElement anElement : elementsInDiagram.values()) {
            parent = anElement.getTarget().eContainer();
            if (!(anElement.eContainer() instanceof DNodeContainer) || EcoreUtil.isAncestor((EObject)(actualParentContainer = ((DNodeContainer)anElement.eContainer()).getTarget()), (EObject)anElement.getTarget())) ** GOTO lbl37
            diagram.getOwnedDiagramElements().add((Object)anElement);
            toBeMoved.add(anElement);
            continue;
lbl-1000:
            // 1 sources

            {
                parentGraphicalElement = (DDiagramElement)elementsInDiagram.get(parent);
                if (parentGraphicalElement != null && parentGraphicalElement instanceof DNodeContainer && CapellaServices.getService().isVisibleInDiagram(diagram, parentGraphicalElement) && this.canContainSubContainer(parentGraphicalElement)) {
                    nodeContainer = (DNodeContainer)parentGraphicalElement;
                    if (nodeContainer.getOwnedDiagramElements().contains((Object)anElement)) continue block2;
                    diagram.getOwnedDiagramElements().add((Object)anElement);
                    toBeMoved.add(anElement);
                    continue block2;
                }
                parent = parent.eContainer();
lbl37:
                // 2 sources

                ** while (parent instanceof AbstractFunction || parent instanceof FunctionPkg)
            }
lbl38:
            // 1 sources

        }
        block4: for (DDiagramElement anElement : toBeMoved) {
            parent = anElement.getTarget().eContainer();
            while (parent instanceof AbstractFunction || parent instanceof FunctionPkg) {
                parentGraphicalElement = (DDiagramElement)elementsInDiagram.get(parent);
                if (parentGraphicalElement != null && parentGraphicalElement instanceof DNodeContainer && !(nodeContainer = (DNodeContainer)parentGraphicalElement).getOwnedDiagramElements().contains((Object)anElement)) {
                    nodeContainer.getOwnedDiagramElements().add((Object)anElement);
                    continue block4;
                }
                parent = parent.eContainer();
            }
        }
        ownedVisibleFunctionContainers = new HashSet<DNodeContainer>();
        for (DDiagramElement anElement : diagram.getOwnedDiagramElements()) {
            if (!(anElement instanceof DNodeContainer) || !(anElement.getTarget() instanceof AbstractFunction) || !FaServices.getFaServices().isAbstractFunctionVisibleInDFB((AbstractDNode)((DNodeContainer)anElement), diagram)) continue;
            ownedVisibleFunctionContainers.add((DNodeContainer)anElement);
        }
        if (!(((DSemanticDiagram)diagram).getTarget() instanceof OperationalActivity)) {
            for (DNodeContainer aContainer : ownedVisibleFunctionContainers) {
                this.updateBorderedNodes(aContainer, content, null, allFunctionsInDiagram);
            }
        }
    }

    public boolean canContainSubContainer(DDiagramElement aContainer) {
        if (!(aContainer instanceof DNodeContainer)) {
            return false;
        }
        DSemanticDiagram currentDiagram = (DSemanticDiagram)CapellaServices.getService().getDiagramContainer((EObject)aContainer);
        if (currentDiagram.getDescription().getName().contains("Contextual")) {
            return aContainer.getTarget().equals(currentDiagram.getTarget());
        }
        return true;
    }

    protected FunctionContainer updateBorderedNodes(DNodeContainer container, DDiagramContents content, FunctionContainer parentContainer, Map<AbstractFunction, AbstractDNode> functions) {
        FunctionContainer currentContainer = new FunctionContainer(container, parentContainer, content.getDDiagram(), functions);
        DDiagram diagram = content.getDDiagram();
        if (currentContainer.getParent() != null) {
            for (Map.Entry entry : currentContainer.getParent().getFunctionPorts().entrySet()) {
                AbstractFunction best;
                if (((DNode)entry.getValue()).eContainer() == null || ((DDiagramElement)((DNode)entry.getValue()).eContainer()).getTarget() == null || (best = this.getBestPortFunctionContainer((ActivityNode)((Pin)entry.getKey()), (AbstractFunction)((DDiagramElement)((DNode)entry.getValue()).eContainer()).getTarget(), currentContainer.getFunction())) == null || !best.equals(currentContainer.getFunction())) continue;
                if (currentContainer.getFunctionPorts().containsKey(entry.getKey())) {
                    this.removeNodeAndMoveEdges((DNode)entry.getValue(), currentContainer.getFunctionPorts().get(entry.getKey()), content.getDDiagram());
                    continue;
                }
                currentContainer.getContainer().getOwnedBorderedNodes().add((Object)((DNode)entry.getValue()));
                currentContainer.getFunctionPorts().put((FunctionPort)entry.getKey(), (DNode)entry.getValue());
            }
        }
        if (parentContainer != null) {
            parentContainer.setIncomingOutgoingExchangeCategories(content.getDDiagram());
            HashMapSet<ExchangeCategory, AbstractFunction> hashMapSet = FaServices.getFaServices().getAvailableCategoriesAndFunctionsToInsertInDataFlowBlank((AbstractDNode)currentContainer.getContainer(), content);
            String outputMappingName = MappingConstantsHelper.getMappingFunctionalExchangeCategoryOutputPin(diagram);
            String inputMappingName = MappingConstantsHelper.getMappingFunctionalExchangeCategoryInputPin(diagram);
            for (DNode aNode : parentContainer.getCategoryNodes()) {
                ExchangeCategory currentCategory;
                if (!CapellaServices.getService().isSynchronized(content.getDDiagram()) && !parentContainer.getCategoryNodesToRemove().contains(aNode) || !aNode.isVisible() || !hashMapSet.containsKey(currentCategory = (ExchangeCategory)aNode.getTarget())) continue;
                if (aNode.getActualMapping().getName().equals(outputMappingName)) {
                    for (DEdge anEdge : DiagramServices.getDiagramServices().getOutgoingEdges((EdgeTarget)aNode, diagram)) {
                        if (anEdge.getTargetNode() == null || anEdge.getTargetNode().eContainer() == null) continue;
                        DNodeContainer targetFunctionContainer = (DNodeContainer)anEdge.getTargetNode().eContainer();
                        if (!hashMapSet.get(currentCategory).contains(targetFunctionContainer.getTarget())) continue;
                        FaServices.getFaServices().createViewExchangeCategory(currentCategory, (AbstractDNode)container, (AbstractDNode)targetFunctionContainer, diagram);
                        if (currentContainer.getOutgoingExchangeCategories().containsKey(currentCategory)) continue;
                        currentContainer.getOutgoingExchangeCategories().put(currentCategory, this.getBorderedNode(container, (EObject)currentCategory, outputMappingName));
                    }
                }
                if (!aNode.getActualMapping().getName().equals(inputMappingName)) continue;
                for (DEdge anEdge : DiagramServices.getDiagramServices().getIncomingEdges((EdgeTarget)aNode, diagram)) {
                    if (anEdge.getSourceNode() == null || anEdge.getSourceNode().eContainer() == null) continue;
                    DNodeContainer sourceFunctionContainer = (DNodeContainer)anEdge.getSourceNode().eContainer();
                    if (!hashMapSet.get(currentCategory).contains(sourceFunctionContainer.getTarget())) continue;
                    FaServices.getFaServices().createViewExchangeCategory(currentCategory, (AbstractDNode)sourceFunctionContainer, (AbstractDNode)container, diagram);
                    if (currentContainer.getIncomingExchangeCategories().containsKey(currentCategory)) continue;
                    currentContainer.getIncomingExchangeCategories().put(currentCategory, this.getBorderedNode(container, (EObject)currentCategory, inputMappingName));
                }
            }
        }
        currentContainer.initCategoryNodesToRemove(functions);
        for (DDiagramElement dDiagramElement : container.getOwnedDiagramElements()) {
            if (dDiagramElement instanceof DNodeContainer && dDiagramElement.getTarget() != null && dDiagramElement.getTarget() instanceof AbstractFunction && FaServices.getFaServices().isAbstractFunctionVisibleInDFB((AbstractDNode)((DNodeContainer)dDiagramElement), diagram)) {
                this.updateBorderedNodes((DNodeContainer)dDiagramElement, content, currentContainer, functions);
            }
            if (!(dDiagramElement instanceof DNodeContainer) || dDiagramElement.getTarget() == null || !(dDiagramElement.getTarget() instanceof AbstractFunction) || FaServices.getFaServices().isAbstractFunctionVisibleInDFB((AbstractDNode)((DNodeContainer)dDiagramElement), diagram)) continue;
            this.moveUpBorderedNodes((DNodeContainer)dDiagramElement, diagram, currentContainer);
        }
        for (DNode dNode : currentContainer.getCategoryNodesToRemove()) {
            DiagramServices.getDiagramServices().removeNodeView(dNode);
        }
        return currentContainer;
    }

    public void moveUpBorderedNodes(DNodeContainer container, DDiagram diagram, FunctionContainer parentContainer) {
        HashSet ownedDiagramElements = new HashSet();
        ownedDiagramElements.addAll(container.getOwnedDiagramElements());
        HashSet ownedBorderedNodes = new HashSet();
        ownedBorderedNodes.addAll(container.getOwnedBorderedNodes());
        String outputMappingName = MappingConstantsHelper.getMappingFunctionalExchangeCategoryOutputPin(diagram);
        String inputMappingName = MappingConstantsHelper.getMappingFunctionalExchangeCategoryInputPin(diagram);
        for (DNode aBorderedNode : ownedBorderedNodes) {
            DNode newNode;
            if (aBorderedNode.getTarget() != null && aBorderedNode.getTarget() instanceof FunctionPort && CapellaServices.getService().isVisibleInDiagram(diagram, (DDiagramElement)aBorderedNode) && !CapellaServices.getService().isSynchronized(diagram)) {
                if (parentContainer.getFunctionPorts().containsKey(aBorderedNode.getTarget())) {
                    this.removeNodeAndMoveEdges(aBorderedNode, parentContainer.getFunctionPorts().get(aBorderedNode.getTarget()), diagram);
                } else {
                    parentContainer.getContainer().getOwnedBorderedNodes().add((Object)aBorderedNode);
                    parentContainer.getFunctionPorts().put((FunctionPort)aBorderedNode.getTarget(), aBorderedNode);
                }
            }
            if (aBorderedNode.getTarget() == null || !(aBorderedNode.getTarget() instanceof ExchangeCategory) || !CapellaServices.getService().isVisibleInDiagram(diagram, (DDiagramElement)aBorderedNode)) continue;
            if (aBorderedNode.getActualMapping().getName().equals(inputMappingName)) {
                if (!parentContainer.getIncomingExchangeCategories().containsKey(aBorderedNode.getTarget())) {
                    newNode = FaServices.getFaServices().createViewInputPinCategory((ExchangeCategory)aBorderedNode.getTarget(), (AbstractDNode)parentContainer.getContainer(), diagram);
                    parentContainer.getIncomingExchangeCategories().put((ExchangeCategory)aBorderedNode.getTarget(), newNode);
                }
                this.removeNodeAndMoveEdges(aBorderedNode, parentContainer.getIncomingExchangeCategories().get(aBorderedNode.getTarget()), diagram);
            }
            if (!aBorderedNode.getActualMapping().getName().equals(outputMappingName)) continue;
            if (!parentContainer.getOutgoingExchangeCategories().containsKey(aBorderedNode.getTarget())) {
                newNode = FaServices.getFaServices().createViewOutputPinCategory((ExchangeCategory)aBorderedNode.getTarget(), (AbstractDNode)parentContainer.getContainer(), diagram);
                parentContainer.getOutgoingExchangeCategories().put((ExchangeCategory)aBorderedNode.getTarget(), newNode);
            }
            this.removeNodeAndMoveEdges(aBorderedNode, parentContainer.getOutgoingExchangeCategories().get(aBorderedNode.getTarget()), diagram);
        }
    }

    protected AbstractFunction getBestPortFunctionContainer(ActivityNode port, AbstractFunction function1, AbstractFunction function2) {
        EObject container = port.eContainer();
        while (container != null && container instanceof AbstractFunction) {
            if (container.equals(function1)) {
                return function1;
            }
            if (container.equals(function2)) {
                return function2;
            }
            container = container.eContainer();
        }
        return null;
    }

    protected void removeNodeAndMoveEdges(DNode toBeRemoved, DNode existingChildNode, DDiagram diagram) {
        boolean toMove;
        HashSet<DEdge> incomingExchanges = new HashSet<DEdge>();
        HashSet<DEdge> outgoingExchanges = new HashSet<DEdge>();
        incomingExchanges.addAll(DiagramServices.getDiagramServices().getIncomingEdges((EdgeTarget)existingChildNode, diagram));
        outgoingExchanges.addAll(DiagramServices.getDiagramServices().getOutgoingEdges((EdgeTarget)existingChildNode, diagram));
        for (DEdge anEdge : DiagramServices.getDiagramServices().getIncomingEdges((EdgeTarget)toBeRemoved, diagram)) {
            toMove = true;
            for (DEdge anExistingEdge : incomingExchanges) {
                if (anExistingEdge.getTarget() == null || anExistingEdge.getSourceNode() == null || !anExistingEdge.getTarget().equals(anEdge.getTarget()) || !anExistingEdge.getSourceNode().equals(anEdge.getSourceNode())) continue;
                toMove = false;
            }
            if (toMove) {
                anEdge.setTargetNode((EdgeTarget)existingChildNode);
                continue;
            }
            DiagramServices.getDiagramServices().removeEdgeView(anEdge);
        }
        for (DEdge anEdge : DiagramServices.getDiagramServices().getOutgoingEdges((EdgeTarget)toBeRemoved, diagram)) {
            toMove = true;
            for (DEdge anExistingEdge : outgoingExchanges) {
                if (anExistingEdge.getTarget() == null || anExistingEdge.getTargetNode() == null || !anExistingEdge.getTarget().equals(anEdge.getTarget()) || !anExistingEdge.getTargetNode().equals(anEdge.getTargetNode())) continue;
                toMove = false;
            }
            if (toMove) {
                anEdge.setSourceNode((EdgeTarget)existingChildNode);
                continue;
            }
            DiagramServices.getDiagramServices().removeEdgeView(anEdge);
        }
        DiagramServices.getDiagramServices().removeNodeView(toBeRemoved);
    }

    public AbstractDNode getBestFunctionContainer(ActivityNode port, Map<AbstractFunction, AbstractDNode> functions) {
        if (port == null || port.eContainer() == null) {
            return null;
        }
        EObject functionContainer = port.eContainer();
        while (functionContainer != null && functionContainer instanceof AbstractFunction) {
            if (functions.containsKey(functionContainer)) {
                return functions.get(functionContainer);
            }
            functionContainer = functionContainer.eContainer();
        }
        return null;
    }

    public DNode getBorderedNode(DNodeContainer container, EObject target, String mappingName) {
        DNode returnedNode = null;
        for (DNode aBorderedNode : container.getOwnedBorderedNodes()) {
            if (aBorderedNode.getTarget() == null || !aBorderedNode.getTarget().equals(target) || !aBorderedNode.getActualMapping().getName().equals(mappingName)) continue;
            return aBorderedNode;
        }
        return returnedNode;
    }

    public List<AbstractFunction> getShowableParentOfAllocatedFunctions(AbstractFunction parent, List<AbstractFunction> showableLeaves) {
        return showableLeaves;
    }

    public List<AbstractFunction> getShowableAllocatedFunctions(EObject componentOrPart, DNodeContainer containerView) {
        ArrayList<AbstractFunction> showableFunctions = new ArrayList<AbstractFunction>();
        if (componentOrPart instanceof Part) {
            showableFunctions.addAll((Collection<AbstractFunction>)((Component)CsServices.getService().getComponentType((Part)componentOrPart)).getAllocatedFunctions());
        } else if (componentOrPart instanceof Component) {
            showableFunctions.addAll((Collection<AbstractFunction>)((Component)componentOrPart).getAllocatedFunctions());
        }
        Set<AbstractFunction> leaves = this.getLeavesFunctionsOfSubComponentsNotDisplayed(componentOrPart, containerView);
        Set allFunctions = AbstractFunctionExt.getRecursiveAllocatedFunctions(leaves, leaves);
        showableFunctions.addAll(allFunctions);
        return showableFunctions;
    }

    protected Set<AbstractFunction> getLeavesFunctionsOfSubComponentsNotDisplayed(EObject componentOrPart, DNodeContainer containerView) {
        HashSet<AbstractFunction> leaveFunctions = new HashSet<AbstractFunction>();
        if (componentOrPart instanceof Part) {
            leaveFunctions.addAll((Collection<AbstractFunction>)((Component)((Part)componentOrPart).getAbstractType()).getAllocatedFunctions());
        } else if (componentOrPart instanceof Component) {
            leaveFunctions.addAll((Collection<AbstractFunction>)((Component)componentOrPart).getAllocatedFunctions());
        }
        if (componentOrPart instanceof Entity) {
            Entity entity = (Entity)componentOrPart;
            for (Role role : entity.getAllocatedRoles()) {
                if (DiagramServices.getDiagramServices().isOnDiagram(containerView, (EObject)role)) continue;
                leaveFunctions.addAll((Collection<AbstractFunction>)role.getAllocatedOperationalActivities());
            }
        }
        HashSet subComponents = new HashSet();
        if (componentOrPart instanceof Component) {
            subComponents.addAll(ComponentExt.getSubUsedComponents((Component)((Component)componentOrPart)));
        } else if (componentOrPart instanceof Part) {
            subComponents.addAll(PartExt.getSubUsedAndDeployedParts((Part)((Part)componentOrPart)));
        }
        for (EObject subComponent : subComponents) {
            if (DiagramServices.getDiagramServices().isOnDiagram(containerView, subComponent)) continue;
            leaveFunctions.addAll(this.getLeavesFunctionsOfSubComponentsNotDisplayed(subComponent, containerView));
        }
        return leaveFunctions;
    }

    public List<AbstractFunction> getShowableAllocatedOperationalActivities(Role role) {
        return AbstractFunctionExt.getAllocatedOperationalActivities((Role)role);
    }

    @Deprecated
    public DNodeContainer createViewDeployedPart(EObject target, DragAndDropTarget parent, DDiagram parentDiagram) {
        ContainerMapping mapping = this.getMappingABDeployedElement(parentDiagram);
        return DiagramServices.getDiagramServices().createContainer(mapping, target, parent, parentDiagram);
    }

    @Deprecated
    public ContainerMapping getMappingABDeployedElement(DDiagram diagram) {
        String mappingName = MappingConstantsHelper.getMappingABDeployedElement(diagram);
        return DiagramServices.getDiagramServices().getContainerMapping(diagram, mappingName);
    }

    public boolean isLeaf(EObject function) {
        return FunctionExt.isLeaf((AbstractFunction)((AbstractFunction)function));
    }

    public List<AbstractFunction> getAllLeafAbstractFunctions(BlockArchitecture arch) {
        return FunctionExt.getAllLeafAbstractFunctions((BlockArchitecture)arch);
    }

    public AbstractFunction getOutgoingAbstractFunction(FunctionalExchange fe) {
        return FunctionExt.getOutGoingAbstractFunction((FunctionalExchange)fe);
    }

    public EObject insertRemoveAllocatedFunctions(DNodeContainer containerView, List<AbstractFunction> selectedFunctions) {
        HashMap<AbstractFunction, DNode> visibleFunctions = new HashMap<AbstractFunction, DNode>();
        for (DDiagramElement aElement : containerView.getOwnedDiagramElements()) {
            if (aElement.getTarget() == null || !(aElement.getTarget() instanceof AbstractFunction) || !(aElement instanceof DNode)) continue;
            visibleFunctions.put((AbstractFunction)aElement.getTarget(), (DNode)aElement);
        }
        block1: for (Map.Entry me : visibleFunctions.entrySet()) {
            if (!selectedFunctions.contains(me.getKey())) {
                DiagramServices.getDiagramServices().removeNodeView((DNode)me.getValue());
                continue;
            }
            for (AbstractFunction aParentFunction : FunctionExt.getParentFunctions((AbstractFunction)((AbstractFunction)me.getKey()))) {
                if (!selectedFunctions.contains(aParentFunction)) continue;
                DiagramServices.getDiagramServices().removeNodeView((DNode)me.getValue());
                continue block1;
            }
        }
        for (AbstractFunction aSelectedFunction : selectedFunctions) {
            if (visibleFunctions.containsKey(aSelectedFunction)) continue;
            boolean toAdd = true;
            for (AbstractFunction aParentFunction : FunctionExt.getParentFunctions((AbstractFunction)aSelectedFunction)) {
                if (!selectedFunctions.contains(aParentFunction)) continue;
                toAdd = false;
                break;
            }
            if (!toAdd) continue;
            this.createViewABAbstractFunction(aSelectedFunction, (DragAndDropTarget)containerView, CapellaServices.getService().getDiagramContainer((EObject)containerView));
        }
        return containerView;
    }

    public List<AbstractFunction> getAllLeafFunctions(BlockArchitecture blockArchitecture) {
        List allAbstractFunctions = FunctionExt.getAllLeafAbstractFunctions((BlockArchitecture)blockArchitecture);
        if (!allAbstractFunctions.isEmpty()) {
            return allAbstractFunctions;
        }
        return new ArrayList<AbstractFunction>(0);
    }

    public List<AbstractFunction> getAllLeafFunctions(ModellingBlock block) {
        BlockArchitecture archi = BlockArchitectureExt.getRootBlockArchitecture((EObject)block);
        return this.getAllLeafFunctions(archi);
    }

    public List<FunctionalChain> getAllFunctionalChains(BlockArchitecture blockArchitecture) {
        ArrayList<FunctionalChain> functionalChains = new ArrayList<FunctionalChain>(0);
        List allAbstractFunctions = FunctionExt.getAllAbstractFunctions((BlockArchitecture)blockArchitecture);
        for (AbstractFunction abstractFunction : allAbstractFunctions) {
            functionalChains.addAll((Collection<FunctionalChain>)abstractFunction.getOwnedFunctionalChains());
        }
        TableCapabilitiesServices cap = new TableCapabilitiesServices();
        Collection<AbstractCapability> allCapabilities = cap.getAllCapabilities(blockArchitecture);
        for (AbstractCapability abstractCapability : allCapabilities) {
            functionalChains.addAll((Collection<FunctionalChain>)abstractCapability.getOwnedFunctionalChains());
        }
        return functionalChains;
    }

    public List<FunctionalChain> getAllFunctionalChains(ModellingBlock block) {
        BlockArchitecture archi = BlockArchitectureExt.getRootBlockArchitecture((EObject)block);
        return this.getAllFunctionalChains(archi);
    }

    public EObject dndABPhysicalArtifacts(CapellaElement node, NamedElement oldContainer, NamedElement newContainer) {
        AbstractType componentType;
        if (oldContainer.equals(newContainer)) {
            return node;
        }
        BlockArchitecture arch = BlockArchitectureExt.getRootBlockArchitecture((EObject)node);
        if (!(arch instanceof PhysicalArchitecture)) {
            return node;
        }
        ArrayList<PhysicalComponent> physicalArtifacts = new ArrayList<PhysicalComponent>(0);
        List allPhysicalComponents = PhysicalArchitectureExt.getAllPhysicalComponents((PhysicalArchitecture)((PhysicalArchitecture)arch));
        for (PhysicalComponent physicalComponent : allPhysicalComponents) {
            physicalArtifacts.add(physicalComponent);
            physicalArtifacts.addAll((Collection<PhysicalComponent>)physicalComponent.getOwnedPhysicalLinks());
            physicalArtifacts.addAll(ComponentExt.getOwnedPhysicalPort((Component)physicalComponent));
        }
        ConfigurationItem oldComponent = null;
        ConfigurationItem newComponent = null;
        if (oldContainer instanceof Part) {
            componentType = CsServices.getService().getComponentType((Part)oldContainer);
            if (componentType != null && componentType instanceof ConfigurationItem) {
                oldComponent = (ConfigurationItem)componentType;
            }
        } else if (oldContainer instanceof ConfigurationItem) {
            oldComponent = (ConfigurationItem)oldContainer;
        }
        if (newContainer instanceof Part) {
            componentType = CsServices.getService().getComponentType((Part)newContainer);
            if (componentType != null && componentType instanceof ConfigurationItem) {
                newComponent = (ConfigurationItem)componentType;
            }
        } else if (newContainer instanceof ConfigurationItem) {
            newComponent = (ConfigurationItem)newContainer;
        }
        if (oldComponent != null && newComponent != null) {
            TraceableElement targetElement;
            EList oldArtifactRealizations = oldComponent.getOwnedPhysicalArtifactRealizations();
            EList newArtifactRealizations = newComponent.getOwnedPhysicalArtifactRealizations();
            ArrayList<TraceableElement> newArtifactRealizationsTarget = new ArrayList<TraceableElement>();
            for (PhysicalArtifactRealization artifactRealization : newArtifactRealizations) {
                targetElement = artifactRealization.getTargetElement();
                if (targetElement == null) continue;
                newArtifactRealizationsTarget.add(targetElement);
            }
            for (PhysicalArtifactRealization artifactRealization : oldArtifactRealizations) {
                targetElement = artifactRealization.getTargetElement();
                if (targetElement == null || !physicalArtifacts.contains(targetElement) || !node.equals(targetElement) || newArtifactRealizationsTarget.contains(targetElement)) continue;
                artifactRealization.setSourceElement((TraceableElement)newComponent);
                newComponent.getOwnedPhysicalArtifactRealizations().add((Object)artifactRealization);
            }
        }
        return node;
    }

    public String getComponentExchangeLabel(ComponentExchange exchange, DDiagram diagram) {
        if (exchange == null || this.isHideComponentExchangesNamesEnable((EObject)exchange, (EObject)diagram) || this.isHideCommunicationMeansNamesEnable((EObject)exchange, (EObject)diagram)) {
            return "";
        }
        boolean showExchangeItems = false;
        boolean showFunctionalExchangeName = false;
        boolean showExchangeItemsWithOutFE = false;
        for (FilterDescription filter : diagram.getActivatedFilters()) {
            if (filter.getName().equals("Show Exchange Items on Component Exchanges")) {
                showExchangeItems = true;
            }
            if (filter.getName().equals("Show Allocated Functional Exchanges on Component Exchanges")) {
                showFunctionalExchangeName = true;
            }
            if (!filter.getName().equals("Show Exchange Items on Component Exchange without Functional Exchanges")) continue;
            showExchangeItemsWithOutFE = true;
        }
        StringBuilder result = new StringBuilder();
        if (showFunctionalExchangeName) {
            ArrayList<FunctionalExchange> fes = new ArrayList<FunctionalExchange>();
            for (ComponentExchangeFunctionalExchangeAllocation allocation : exchange.getOutgoingComponentExchangeFunctionalExchangeAllocations()) {
                if (allocation.getAllocatedFunctionalExchange() == null || fes.contains(allocation.getAllocatedFunctionalExchange())) continue;
                fes.add(allocation.getAllocatedFunctionalExchange());
            }
            int index = 0;
            if (!showExchangeItemsWithOutFE) {
                for (FunctionalExchange fe : fes) {
                    this.getExchangeWithExchangeItemsLabel((AbstractNamedElement)fe, false, true, showExchangeItems, showExchangeItemsWithOutFE, result, this.getRelatedExchangeItems(fe));
                    if (++index >= fes.size()) continue;
                    result.append(", ");
                }
            }
            if (fes.size() == 0) {
                List<AbstractExchangeItem> exchangedItems = this.getRelatedExchangeItems(exchange, false);
                this.getExchangeWithExchangeItemsLabel((AbstractNamedElement)exchange, false, !showExchangeItems && !showExchangeItemsWithOutFE || exchangedItems.isEmpty(), showExchangeItems, showExchangeItemsWithOutFE, result, exchangedItems);
            }
        } else {
            UniqueEList exchangedItems = new UniqueEList(0);
            if (showExchangeItems) {
                exchangedItems.addAll(this.getRelatedExchangeItems(exchange, true));
            }
            if (showExchangeItemsWithOutFE) {
                exchangedItems.addAll(this.getRelatedExchangeItems(exchange, false));
            }
            this.getExchangeWithExchangeItemsLabel((AbstractNamedElement)exchange, false, !showExchangeItems && !showExchangeItemsWithOutFE, showExchangeItems, showExchangeItemsWithOutFE, result, (List<AbstractExchangeItem>)exchangedItems);
        }
        return result.toString();
    }

    public String getFunctionalExchangeLabel(FunctionalExchange exchange, DDiagram diagram) {
        if (exchange == null) {
            return this.decorateString("", exchange);
        }
        if (this.isHideFunctionalExchangesNamesEnable((EObject)exchange, diagram) || this.isHideInteractionsNamesEnable((EObject)exchange, diagram)) {
            return Character.toString(' ');
        }
        boolean showExchangeItems = false;
        boolean showExchangeItemsParameters = false;
        boolean showFunctionalExchanges = false;
        boolean showFEEI = false;
        boolean showFEParams = false;
        boolean showFEEIParams = false;
        for (FilterDescription filter : diagram.getActivatedFilters()) {
            if (filter.getName().equals("Show ExchangeItems")) {
                showExchangeItems = true;
            }
            if (filter.getName().equals("Show ExchangeItems parameters")) {
                showExchangeItemsParameters = true;
            }
            if (filter.getName().equals("Show Functional Exchanges")) {
                showFunctionalExchanges = true;
            }
            if (filter.getName().equals(IMappingNameConstants.SHOW_FUNCTIONAL_EXCHANGES_ECHANGE_ITEMS)) {
                showFEEI = true;
            }
            if (filter.getName().equals(IMappingNameConstants.SHOW_FUNCTIONAL_EXCHANGES_PARAMS)) {
                showFEParams = true;
            }
            if (!filter.getName().equals(IMappingNameConstants.SHOW_FUNCTIONAL_EXCHANGES_ECHANGE_ITEMS_PARAMS)) continue;
            showFEEIParams = true;
        }
        if (showFEEI) {
            return this.decorateString(this.getFEEIMessageName(exchange), exchange);
        }
        if (showFEEIParams || showFEParams) {
            return this.decorateString(this.showFeEiParams(exchange, showFEEIParams), exchange);
        }
        StringBuilder result = new StringBuilder();
        int indice = 0;
        if (showFunctionalExchanges || showExchangeItems || showExchangeItemsParameters) {
            if (showFunctionalExchanges) {
                result.append(this.getSafeName((AbstractNamedElement)exchange));
            }
            if (showExchangeItems || showExchangeItemsParameters) {
                EList selectEIList = exchange.getExchangedItems();
                if (selectEIList.size() != 0) {
                    result.append("[");
                }
                for (AbstractExchangeItem ei : selectEIList) {
                    result.append(InformationServices.getEILabel(ei, showExchangeItemsParameters));
                    if (++indice >= selectEIList.size()) continue;
                    result.append(", ");
                }
                if (selectEIList.size() != 0) {
                    result.append("]");
                }
            }
        } else {
            result.append(EObjectLabelProviderHelper.getText((EObject)exchange));
        }
        return this.decorateString(result.toString(), exchange);
    }

    private String showFeEiParams(FunctionalExchange exchange, boolean showEIName) {
        StringBuilder result = new StringBuilder();
        EList selectEIList = exchange.getExchangedItems();
        result.append(this.getSafeName((AbstractNamedElement)exchange));
        int indice = 0;
        if (showEIName) {
            result.append(" ");
            result.append("[");
            for (AbstractExchangeItem ei : selectEIList) {
                result.append(InformationServices.getEILabel(ei, true));
                if (++indice >= selectEIList.size()) continue;
                result.append(", ");
            }
            result.append("]");
        } else {
            result.append("(");
            ArrayList eies = new ArrayList();
            for (AbstractExchangeItem aei : selectEIList) {
                if (!(aei instanceof ExchangeItem)) continue;
                ExchangeItem ei = (ExchangeItem)aei;
                eies.addAll(ei.getOwnedElements());
            }
            for (ExchangeItemElement eie : eies) {
                AbstractType type = eie.getAbstractType();
                if (type != null) {
                    result.append(this.getSafeName((AbstractNamedElement)type));
                } else {
                    result.append("<undefined>");
                }
                if (++indice >= eies.size()) continue;
                result.append(", ");
            }
            result.append(")");
        }
        return result.toString();
    }

    private String getFEEIMessageName(FunctionalExchange exchange) {
        StringBuilder result = new StringBuilder();
        EList selectEIList = exchange.getExchangedItems();
        result.append(EObjectLabelProviderHelper.getText((EObject)exchange));
        result.append(" ");
        result.append("[");
        int indice = 0;
        for (AbstractExchangeItem ei : selectEIList) {
            result.append(InformationServices.getEILabel(ei, false));
            if (++indice >= selectEIList.size()) continue;
            result.append(", ");
        }
        result.append("]");
        return result.toString();
    }

    private List<AbstractExchangeItem> getRelatedExchangeItems(ComponentExchange exchange, boolean inDepth) {
        ArrayList<AbstractExchangeItem> exchangedItems = new ArrayList<AbstractExchangeItem>();
        exchangedItems.addAll((Collection<AbstractExchangeItem>)exchange.getConvoyedInformations());
        if (inDepth) {
            for (ComponentExchangeFunctionalExchangeAllocation allocation : exchange.getOutgoingComponentExchangeFunctionalExchangeAllocations()) {
                if (allocation.getAllocatedFunctionalExchange() == null) continue;
                for (AbstractExchangeItem abstractExchangeItem : this.getRelatedExchangeItems(allocation.getAllocatedFunctionalExchange())) {
                    if (exchangedItems.contains(abstractExchangeItem)) continue;
                    exchangedItems.add(abstractExchangeItem);
                }
            }
        }
        return exchangedItems;
    }

    private List<AbstractExchangeItem> getRelatedExchangeItems(FunctionalExchange exchange) {
        ArrayList<AbstractExchangeItem> exchangedItems = new ArrayList<AbstractExchangeItem>();
        exchangedItems.addAll((Collection<AbstractExchangeItem>)exchange.getExchangedItems());
        if (exchangedItems.size() == 0) {
            for (CapellaElement capellaElement : AbstractFunctionExt.getExchangeSourceAndTargetPorts((FunctionalExchange)exchange)) {
                FunctionInputPort inPutPort;
                if (capellaElement instanceof FunctionInputPort) {
                    inPutPort = (FunctionInputPort)capellaElement;
                    for (ExchangeItem abstractExchangeItem : inPutPort.getIncomingExchangeItems()) {
                        if (exchangedItems.contains(abstractExchangeItem)) continue;
                        exchangedItems.add((AbstractExchangeItem)abstractExchangeItem);
                    }
                    continue;
                }
                if (!(capellaElement instanceof FunctionOutputPort)) continue;
                inPutPort = (FunctionOutputPort)capellaElement;
                for (ExchangeItem abstractExchangeItem : inPutPort.getOutgoingExchangeItems()) {
                    if (exchangedItems.contains(abstractExchangeItem)) continue;
                    exchangedItems.add((AbstractExchangeItem)abstractExchangeItem);
                }
            }
        }
        return exchangedItems;
    }

    private void getExchangeWithExchangeItemsLabel(AbstractNamedElement exchange, boolean showExchangeItemsParameters, boolean showName, boolean showExchangeItems, boolean showExchangeItemsWithOutFE, StringBuilder result, List<AbstractExchangeItem> exchangedItems) {
        int indice = 0;
        if (showName) {
            result.append(exchange.getName());
        }
        if (showExchangeItems || showExchangeItemsWithOutFE) {
            if (showName && exchangedItems.size() > 0) {
                result.append(" (");
            }
            for (AbstractExchangeItem ei : exchangedItems) {
                result.append(ExchangeItemExt.getEILabel((AbstractExchangeItem)ei, (boolean)showExchangeItemsParameters));
                if (++indice >= exchangedItems.size()) continue;
                result.append(", ");
            }
            if (showName && exchangedItems.size() > 0) {
                result.append(")");
            }
        }
    }

    public DDiagramContents getDDiagramContents(DDiagram diagram) {
        return new DDiagramContents(diagram);
    }

    public void showABFunctionalChains(DDiagram diagram, Collection<EObject> chains) {
        this.showABFunctionalChains(diagram, chains, this.getDDiagramContents(diagram));
    }

    public void showDFFunctionalChains(DDiagram diagram, Collection<EObject> chains) {
        this.showDFFunctionalChains(diagram, chains, this.getDDiagramContents(diagram));
    }

    public void showABFunctionalChains(DDiagram diagram, Collection<EObject> chains, DDiagramContents context) {
        for (EObject object : chains) {
            if (context.getNode(object) != null) continue;
            this.createViewABFunctionalChain(diagram, object);
        }
    }

    public void showDFFunctionalChains(DDiagram diagram, Collection<EObject> chains, DDiagramContents context) {
        for (EObject object : chains) {
            if (context.getNode(object) != null) continue;
            this.createViewDFFunctionalChain(diagram, object);
        }
    }

    private DNode createViewABFunctionalChain(DDiagram diagram, EObject object) {
        NodeMapping mapping = this.getMappingABFunctionalChain(object, diagram);
        return DiagramServices.getDiagramServices().createNode(mapping, object, (DragAndDropTarget)diagram, diagram);
    }

    private DNode createViewDFFunctionalChain(DDiagram diagram, EObject object) {
        NodeMapping mapping = this.getMappingDFFunctionalChain(object, diagram);
        return DiagramServices.getDiagramServices().createNode(mapping, object, (DragAndDropTarget)diagram, diagram);
    }

    public NodeMapping getMappingABFunctionalChain(EObject port, DDiagram diagram) {
        String mappingName = MappingConstantsHelper.getMappingABFunctionalChain(diagram);
        return DiagramServices.getDiagramServices().getNodeMapping(diagram, mappingName);
    }

    public NodeMapping getMappingDFFunctionalChain(EObject port, DDiagram diagram) {
        String mappingName = MappingConstantsHelper.getMappingDFFunctionalChain(diagram);
        return DiagramServices.getDiagramServices().getNodeMapping(diagram, mappingName);
    }

    public void showDFContextualElements(DDiagramContents diagramContent, Collection<EObject> contextualElements) {
        HashSet<AbstractFunction> contextualFunctions = new HashSet<AbstractFunction>();
        HashSet<FunctionalExchange> contextualFunctionalExchanges = new HashSet<FunctionalExchange>();
        HashSet<EObject> contextualFunctionalChains = new HashSet<EObject>();
        HashSet<EObject> contextualModes = new HashSet<EObject>();
        HashSet<EObject> contextualScenarios = new HashSet<EObject>();
        for (EObject contextualElement : contextualElements) {
            if (contextualElement instanceof AbstractFunction) {
                contextualFunctions.add((AbstractFunction)contextualElement);
                for (AbstractFunction function : FunctionExt.getAllAbstractFunctions((AbstractFunction)((AbstractFunction)contextualElement))) {
                    AbstractFunction target;
                    AbstractFunction source;
                    for (FunctionalExchange exchange : FunctionExt.getIncomingExchange((AbstractFunction)function)) {
                        source = FunctionalExchangeExt.getSourceFunction((FunctionalExchange)exchange);
                        target = FunctionalExchangeExt.getTargetFunction((FunctionalExchange)exchange);
                        if (source == null || target == null || EcoreUtil2.isContainedBy((EObject)source, (EObject)contextualElement) && EcoreUtil2.isContainedBy((EObject)target, (EObject)contextualElement)) continue;
                        contextualFunctionalExchanges.add(exchange);
                    }
                    for (FunctionalExchange exchange : FunctionExt.getOutGoingExchange((AbstractFunction)function)) {
                        source = FunctionalExchangeExt.getSourceFunction((FunctionalExchange)exchange);
                        target = FunctionalExchangeExt.getTargetFunction((FunctionalExchange)exchange);
                        if (source == null || target == null || EcoreUtil2.isContainedBy((EObject)source, (EObject)contextualElement) && EcoreUtil2.isContainedBy((EObject)target, (EObject)contextualElement)) continue;
                        contextualFunctionalExchanges.add(exchange);
                    }
                }
                continue;
            }
            if (contextualElement instanceof FunctionalChain) {
                contextualFunctionalChains.add(contextualElement);
                for (FunctionalChainInvolvement involvement : FunctionalChainExt.getInvolvementsOf((FunctionalChain)((FunctionalChain)contextualElement), (EClass)FaPackage.Literals.ABSTRACT_FUNCTION)) {
                    contextualFunctions.add((AbstractFunction)involvement.getInvolved());
                }
                for (FunctionalChainInvolvement involvement : FunctionalChainExt.getInvolvementsOf((FunctionalChain)((FunctionalChain)contextualElement), (EClass)FaPackage.Literals.FUNCTIONAL_EXCHANGE)) {
                    contextualFunctionalExchanges.add((FunctionalExchange)involvement.getInvolved());
                }
                continue;
            }
            if (contextualElement instanceof Scenario) {
                contextualScenarios.add(contextualElement);
                continue;
            }
            if (!(contextualElement instanceof State)) continue;
            contextualModes.add(contextualElement);
        }
        for (AbstractFunction function : contextualFunctions) {
            this.showDFAbstractFunction(function, diagramContent.getBestContainer((EObject)function), diagramContent);
        }
        DDiagramContents extendedContent = new DDiagramContents(diagramContent){

            @Override
            public EObject getElement(EObject object, EObject context) {
                if (context instanceof FunctionalExchange) {
                    FunctionalExchange exchange = (FunctionalExchange)context;
                    AbstractFunction sourceExchange = FunctionalExchangeExt.getSourceFunction((FunctionalExchange)exchange);
                    AbstractFunction targetExchange = FunctionalExchangeExt.getTargetFunction((FunctionalExchange)exchange);
                    AbstractFunction brother = null;
                    AbstractFunction brother2 = null;
                    if (object.equals(sourceExchange)) {
                        brother = targetExchange;
                        brother2 = sourceExchange;
                    } else if (object.equals(targetExchange)) {
                        brother = sourceExchange;
                        brother2 = targetExchange;
                    }
                    if (brother != null) {
                        AbstractFunction parent = brother;
                        while (parent != null) {
                            AbstractFunction parent2 = brother2;
                            while (parent2 != null) {
                                if (this.isVisible((EObject)parent, (EObject)parent2)) {
                                    return parent2;
                                }
                                parent2 = parent2.eContainer();
                            }
                            parent = parent.eContainer();
                        }
                    }
                }
                return object;
            }

            @Override
            public Collection<EObject> getParents(EObject object, EObject context) {
                return super.getParents(object, context);
            }

            private boolean isVisible(EObject brother, EObject brother2) {
                EObject parent = brother.eContainer();
                return parent instanceof AbstractFunction && brother2 instanceof AbstractFunction && FunctionExt.getFirstLevelAbstractFunctions((AbstractFunction)((AbstractFunction)parent)).contains(brother2);
            }
        };
        for (FunctionalExchange functionalExchange : contextualFunctionalExchanges) {
            this.showDFFunctionalExchange(null, functionalExchange, extendedContent, true);
        }
        this.showDFFunctionalChains(diagramContent.getDDiagram(), contextualFunctionalChains, diagramContent);
        DFServices.getService().showDFScenarios((DSemanticDecorator)diagramContent.getDDiagram(), contextualScenarios);
        DFServices.getService().showDFStateModes((DSemanticDecorator)diagramContent.getDDiagram(), contextualModes);
    }

    public boolean isFunction(AbstractFunction element) {
        return FunctionExt.isFunction((AbstractFunction)element);
    }

    public boolean isActorFunction(AbstractFunction element) {
        return FunctionExt.isActorFunction((AbstractFunction)element);
    }

    public boolean isAllLeavesFunctionActorALlocated(AbstractFunction element) {
        int j = 0;
        if (element == null || this.isLeaf((EObject)element)) {
            return false;
        }
        List leaves = FunctionExt.getAllLeafAbstractFunctions((AbstractFunction)element);
        int i = leaves.size();
        for (AbstractFunction af : leaves) {
            if (!FunctionExt.isActorFunction((AbstractFunction)af)) continue;
            ++j;
        }
        return i != 0 && i == j;
    }

    private boolean isDiagramFilterEnable(EObject exchange, EObject diagram, String filterName) {
        DDiagram diag;
        if (diagram != null && (diag = CapellaServices.getService().getDiagramContainer(diagram)) != null) {
            EList activatedFilters = diag.getActivatedFilters();
            for (FilterDescription filterDescription : activatedFilters) {
                if (filterDescription == null || !filterDescription.getName().equalsIgnoreCase(filterName)) continue;
                return true;
            }
        }
        return false;
    }

    public boolean isHideFunctionalExchangesNamesEnable(EObject fe, DDiagram diagram) {
        return this.isDiagramFilterEnable(fe, (EObject)diagram, "Hide Functional Exchanges names");
    }

    public boolean isHideComponentExchangesNamesEnable(EObject ce, EObject view) {
        return this.isDiagramFilterEnable(ce, view, "Hide Component Exchanges names");
    }

    public boolean isHideCommunicationMeansNamesEnable(EObject ce, EObject view) {
        return this.isDiagramFilterEnable(ce, view, "Hide Communication Means names");
    }

    public boolean isHideInteractionsNamesEnable(EObject fe, DDiagram diagram) {
        return this.isDiagramFilterEnable(fe, (EObject)diagram, "Hide Interactions names");
    }

    public boolean isHidePhysicalLinksNamesEnable(EObject pl, EObject view) {
        return this.isDiagramFilterEnable(pl, view, "Hide Physical Links names");
    }

    public String getExchangeCenterLabel(EObject exchange, DDiagram diagram) {
        String centerLabel = Character.toString(' ');
        if (exchange != null && exchange instanceof FunctionalExchange) {
            FunctionalExchange fe = (FunctionalExchange)exchange;
            if (!this.isHideFunctionalExchangesNamesEnable(exchange, diagram)) {
                return fe.getName();
            }
        }
        return centerLabel;
    }

    public String getPhysicalLinkCenterLabel(EObject exchange, DDiagram diagram) {
        String centerLabel = Character.toString(' ');
        if (exchange != null && exchange instanceof PhysicalLink) {
            PhysicalLink pl = (PhysicalLink)exchange;
            if (!this.isHidePhysicalLinksNamesEnable(exchange, (EObject)diagram)) {
                return pl.getName();
            }
        }
        return centerLabel;
    }

    @Deprecated
    public NodeMapping getMappingFECategoryOutputPin(DDiagram diagram) {
        String mappingName = MappingConstantsHelper.getMappingFunctionalExchangeCategoryOutputPin(diagram);
        return DiagramServices.getDiagramServices().getBorderedNodeMapping(diagram, mappingName);
    }

    @Deprecated
    public NodeMapping getMappingFECategoryInputPin(DDiagram diagram) {
        String mappingName = MappingConstantsHelper.getMappingFunctionalExchangeCategoryInputPin(diagram);
        return DiagramServices.getDiagramServices().getBorderedNodeMapping(diagram, mappingName);
    }

    @Deprecated
    public EdgeMapping getMappingFECategory(DDiagram diagram) {
        return this.getMappingExchangeCategory(diagram);
    }

    public EObject switchFECategories(DSemanticDecorator context, Collection<EObject> scope, Collection<EObject> initialSelection, Collection<EObject> selectedElements) {
        DDiagram currentDiagram = CapellaServices.getService().getDiagramContainer((EObject)context);
        DDiagramContents content = new DDiagramContents(currentDiagram);
        return this.switchFECategories(content, context, selectedElements, true);
    }

    @Deprecated
    public EObject switchFECategories(DDiagramContents content, DSemanticDecorator context, Collection<EObject> selectedElements) {
        return this.switchFECategories(content, context, selectedElements, true);
    }

    public EObject switchFECategories(DDiagramContents content, DSemanticDecorator context, Collection<EObject> selectedElements, boolean showHiddenExchanges) {
        HashMapSet<EObject, Map.Entry<EObject, EObject>> scopeSource;
        EObject sourceViewTarget;
        FaServices.getFaServices().updateFECategories(content);
        this.switchFEInvisibleCategories(content, context, selectedElements);
        DDiagram currentDiagram = content.getDDiagram();
        HashSet<DDiagramElement> sourceViews = new HashSet<DDiagramElement>();
        if (context instanceof DDiagramElement) {
            sourceViews.add((DDiagramElement)context);
        }
        if (sourceViews.isEmpty()) {
            for (DDiagramElement element : content.getDiagramElements(content.getMapping(MappingConstantsHelper.getMappingABAbstractFunction(currentDiagram)))) {
                sourceViews.add(element);
            }
        }
        ShowHideExchangeCategory categories = new ShowHideExchangeCategory(content);
        AbstractShowHide.DiagramContext ctx = categories.new AbstractShowHide.DiagramContext();
        if (context instanceof DDiagramElement) {
            ctx.setVariable("spv", Collections.singletonList(context));
        }
        for (DDiagramElement sourceView : sourceViews) {
            sourceViewTarget = sourceView.getTarget();
            if (sourceViewTarget == null) continue;
            scopeSource = this.getShowHideSubFECategoriesScope((DSemanticDecorator)sourceView);
            for (EObject key : scopeSource.keySet()) {
                Map.Entry srcTarMap;
                Iterator iterator;
                if (selectedElements.contains(key)) {
                    iterator = scopeSource.get(key).iterator();
                    while (iterator.hasNext()) {
                        srcTarMap = (Map.Entry)iterator.next();
                        this.showFECategory(categories, ctx, (ExchangeCategory)key, (EObject)srcTarMap.getKey(), (EObject)srcTarMap.getValue(), true);
                    }
                    continue;
                }
                iterator = scopeSource.get(key).iterator();
                while (iterator.hasNext()) {
                    srcTarMap = (Map.Entry)iterator.next();
                    this.showFECategory(categories, ctx, (ExchangeCategory)key, FaServices.getBestFunctionContainer((EObject)srcTarMap.getKey(), content), FaServices.getBestFunctionContainer((EObject)srcTarMap.getValue(), content), false);
                }
            }
        }
        ctx = categories.new AbstractShowHide.DiagramContext();
        for (DDiagramElement sourceView : sourceViews) {
            sourceViewTarget = sourceView.getTarget();
            if (sourceViewTarget == null) continue;
            scopeSource = this.getShowHideSubFECategoriesScope((DSemanticDecorator)sourceView);
            for (EObject key : scopeSource.keySet()) {
                if (selectedElements.contains(key)) {
                    for (FunctionalExchange exchange : FunctionExt.getAllExchanges((AbstractFunction)((AbstractFunction)sourceViewTarget))) {
                        if (!exchange.getCategories().contains((Object)key)) continue;
                        categories.hide((EObject)exchange, ctx);
                    }
                    continue;
                }
                if (!showHiddenExchanges) continue;
                for (FunctionalExchange exchange : FunctionExt.getAllExchanges((AbstractFunction)((AbstractFunction)sourceViewTarget))) {
                    if (!exchange.getCategories().contains((Object)key)) continue;
                    categories.show((EObject)exchange, ctx);
                }
            }
        }
        FaServices.getFaServices().updateFECategories(content);
        content.commitDeferredActions();
        return context;
    }

    public EObject switchFEInvisibleCategories(DDiagramContents content, DSemanticDecorator context, Collection<EObject> selectedElements) {
        DDiagram currentDiagram = content.getDDiagram();
        HashSet<DDiagramElement> invisibleCategoryEdges = new HashSet<DDiagramElement>();
        for (DDiagramElement element : content.getDiagramElements(content.getMapping(MappingConstantsHelper.getMappingFunctionalExchangeCategory(currentDiagram)))) {
            if (element.isVisible()) continue;
            invisibleCategoryEdges.add(element);
        }
        for (DDiagramElement categoryEdge : invisibleCategoryEdges) {
            EObject categoryObj = categoryEdge.getTarget();
            EObject srcFunc = ((DDiagramElement)((DEdge)categoryEdge).getSourceNode().eContainer()).getTarget();
            EObject tarFunc = ((DDiagramElement)((DEdge)categoryEdge).getTargetNode().eContainer()).getTarget();
            if (categoryObj == null || !(categoryObj instanceof ExchangeCategory)) continue;
            ShowHideInvisibleExchangeCategory invCatSwitch = new ShowHideInvisibleExchangeCategory(content);
            AbstractShowHide.DiagramContext ctx = invCatSwitch.new AbstractShowHide.DiagramContext();
            if (selectedElements.contains(categoryObj)) {
                this.showFECategory(invCatSwitch, ctx, (ExchangeCategory)categoryObj, srcFunc, tarFunc, true);
                continue;
            }
            this.showFECategory(invCatSwitch, ctx, (ExchangeCategory)categoryObj, srcFunc, tarFunc, false);
        }
        content.commitDeferredActions();
        return context;
    }

    public static EObject getBestFunctionContainer(EObject abstractFunction, DDiagramContents content) {
        if (abstractFunction != null && abstractFunction instanceof AbstractFunction) {
            if (!content.getDiagramElements(abstractFunction).isEmpty()) {
                boolean bVisible = false;
                for (DDiagramElement element : content.getDiagramElements(abstractFunction)) {
                    if (!element.isVisible()) continue;
                    bVisible = true;
                }
                if (bVisible) {
                    return abstractFunction;
                }
            }
            DragAndDropTarget node = content.getBestContainer(abstractFunction);
            if (abstractFunction instanceof AbstractFunction && node instanceof DDiagram) {
                return null;
            }
            if (node instanceof DSemanticDecorator && !(node instanceof DDiagram)) {
                return ((DSemanticDecorator)node).getTarget();
            }
            return abstractFunction.eContainer();
        }
        return null;
    }

    public void updateFECategories(DDiagramContents context) {
        Collection<DiagramElementMapping> nodeMappings;
        HashSet<DEdge> toRemoveEdges = new HashSet<DEdge>();
        HashSet<AbstractDNode> toRemoveNodes = new HashSet<AbstractDNode>();
        HashSet<AbstractDNode> toHideNodes = new HashSet<AbstractDNode>();
        DiagramElementMapping edgeMapping = context.getMapping(MappingConstantsHelper.getMappingFunctionalExchangeCategory(context.getDDiagram()));
        DiagramElementMapping nodeMapping = context.getMapping(MappingConstantsHelper.getMappingFunctionalExchangeCategoryOutputPin(context.getDDiagram()));
        if (edgeMapping != null) {
            for (DDiagramElement element : context.getDiagramElements(edgeMapping)) {
                if (!(element instanceof DEdge)) continue;
                DEdge edge = (DEdge)element;
                boolean isValidEdge = this.isValidFECategoryEdge((ExchangeCategory)element.getTarget(), (DSemanticDecorator)edge.getSourceNode(), (DSemanticDecorator)edge.getTargetNode());
                if (isValidEdge) continue;
                toRemoveEdges.add(edge);
            }
        }
        if (nodeMapping != null) {
            for (DDiagramElement element : context.getDiagramElements(nodeMapping)) {
                if (!(element instanceof EdgeTarget)) continue;
                ArrayList edges = new ArrayList();
                edges.addAll(((EdgeTarget)element).getIncomingEdges());
                edges.addAll(((EdgeTarget)element).getOutgoingEdges());
                if (edges.size() == 0) {
                    toRemoveNodes.add((AbstractDNode)element);
                    continue;
                }
                int nbRemoved = 0;
                for (DEdge edge : edges) {
                    if (!toRemoveEdges.contains(edge)) continue;
                    ++nbRemoved;
                }
                if (nbRemoved != edges.size()) continue;
                toRemoveNodes.add((AbstractDNode)element);
            }
        }
        if (!(nodeMappings = context.getMappings(MappingConstantsHelper.getMappingABPorts(context.getDDiagram()))).isEmpty()) {
            Collection<DDiagramElement> diagElements = context.getDiagramElements(nodeMappings);
            for (DDiagramElement element : diagElements) {
                if (!(element instanceof EdgeTarget)) continue;
                ArrayList edges = new ArrayList();
                edges.addAll(((EdgeTarget)element).getIncomingEdges());
                edges.addAll(((EdgeTarget)element).getOutgoingEdges());
                if (edges.size() == 0) continue;
                int nbRemoved = 0;
                int nbHidden = 0;
                for (DEdge edge : edges) {
                    if (!context.isVisible((DDiagramElement)edge)) {
                        if (edge.getTarget() == null) continue;
                        EObject target = edge.getTarget();
                        if (target instanceof ComponentExchange && !((ComponentExchange)target).getCategories().isEmpty()) {
                            ++nbHidden;
                            continue;
                        }
                        if (!(target instanceof PhysicalLink) || ((PhysicalLink)target).getCategories().isEmpty()) continue;
                        ++nbHidden;
                        continue;
                    }
                    if (!toRemoveEdges.contains(edge)) continue;
                    ++nbRemoved;
                }
                if (nbRemoved == edges.size()) {
                    toRemoveNodes.add((AbstractDNode)element);
                    continue;
                }
                if (nbHidden + nbRemoved != edges.size()) continue;
                toHideNodes.add((AbstractDNode)element);
            }
        }
        for (DEdge edge : toRemoveEdges) {
            DiagramServices.getDiagramServices().removeEdgeView(edge);
        }
        for (AbstractDNode node : toHideNodes) {
            context.deferredHide((DDiagramElement)node);
        }
        for (AbstractDNode node : toRemoveNodes) {
            DiagramServices.getDiagramServices().removeAbstractDNodeView(node);
        }
    }

    public HashMapSet<EObject, EObject> getShowHideFECategoriesScope(DSemanticDecorator context) {
        HashMapSet<EObject, EObject> result = new HashMapSet<EObject, EObject>();
        EObject abstractFunction = context.getTarget();
        if (abstractFunction != null && abstractFunction instanceof AbstractFunction) {
            for (FunctionalExchange fe : FunctionExt.getOutGoingExchange((AbstractFunction)((AbstractFunction)abstractFunction))) {
                for (ExchangeCategory value : fe.getCategories()) {
                    result.put((EObject)value, (EObject)FunctionExt.getOutGoingAbstractFunction((FunctionalExchange)fe));
                }
            }
            for (FunctionalExchange fe : FunctionExt.getIncomingExchange((AbstractFunction)((AbstractFunction)abstractFunction))) {
                for (ExchangeCategory value : fe.getCategories()) {
                    result.put((EObject)value, (EObject)FunctionExt.getIncomingAbstractFunction((FunctionalExchange)fe));
                }
            }
        }
        return result;
    }

    public HashMapSet<EObject, Map.Entry<EObject, EObject>> getShowHideSubFECategoriesScope(DSemanticDecorator context, List<FunctionalExchange> allExchanges) {
        HashMapSet<EObject, Map.Entry<EObject, EObject>> result = new HashMapSet<EObject, Map.Entry<EObject, EObject>>();
        for (FunctionalExchange fe : allExchanges) {
            for (ExchangeCategory value : fe.getCategories()) {
                AbstractMap.SimpleEntry<AbstractFunction, AbstractFunction> srcTar = new AbstractMap.SimpleEntry<AbstractFunction, AbstractFunction>(FunctionExt.getIncomingAbstractFunction((FunctionalExchange)fe), FunctionExt.getOutGoingAbstractFunction((FunctionalExchange)fe));
                result.put((EObject)value, srcTar);
            }
        }
        return result;
    }

    public HashMapSet<EObject, Map.Entry<EObject, EObject>> getShowHideSubFECategoriesScope(DSemanticDecorator context) {
        EObject abstractFunction = context.getTarget();
        if (abstractFunction != null && abstractFunction instanceof AbstractFunction) {
            List allExchanges = FunctionExt.getAllExchanges((AbstractFunction)((AbstractFunction)abstractFunction));
            return this.getShowHideSubFECategoriesScope(context, allExchanges);
        }
        return new HashMapSet<EObject, Map.Entry<EObject, EObject>>();
    }

    public Collection<EObject> getSwitchFECategoriesScope(DSemanticDecorator context) {
        if (context instanceof DDiagram) {
            HashSet<EObject> values = new HashSet<EObject>();
            DDiagramContents ctx = new DDiagramContents((DDiagram)context);
            EdgeMapping dfFEMapping = this.getMappingDFFunctionalExchange(ctx.getDDiagram());
            EdgeMapping abFEMapping = this.getMappingABFunctionalExchange(ctx.getDDiagram());
            for (DDiagramElement element : ctx.getDiagramElements((DiagramElementMapping)dfFEMapping)) {
                if (element.getTarget() == null || !(element.getTarget() instanceof FunctionalExchange)) continue;
                values.addAll((Collection<EObject>)((FunctionalExchange)element.getTarget()).getCategories());
            }
            for (DDiagramElement element : ctx.getDiagramElements((DiagramElementMapping)abFEMapping)) {
                if (element.getTarget() == null || !(element.getTarget() instanceof FunctionalExchange)) continue;
                values.addAll((Collection<EObject>)((FunctionalExchange)element.getTarget()).getCategories());
            }
            return values;
        }
        HashMapSet<EObject, EObject> scope = this.getShowHideFECategoriesScope(context);
        return scope.keySet();
    }

    public Collection<FunctionalExchange> getRelatedFunctionalExchanges(EObject element) {
        if (element instanceof ExchangeCategory) {
            return ((ExchangeCategory)element).getExchanges();
        }
        return Collections.emptyList();
    }

    public boolean isValidFECategoryEdge(ExchangeCategory category, DSemanticDecorator source, DSemanticDecorator target) {
        return true;
    }

    private void showFECategory(AbstractShowHide categories, AbstractShowHide.DiagramContext context, ExchangeCategory key, EObject source, EObject target, boolean b) {
        context.setVariable("sourceParts", Collections.singletonList(source));
        context.setVariable("targetParts", Collections.singletonList(target));
        if (b) {
            categories.show((EObject)key, context);
        } else {
            categories.hide((EObject)key, context);
        }
    }

    public EObject showFECategories(DSemanticDecorator context, HashMapSet<EObject, EObject> scope, HashMapSet<EObject, EObject> initialSelection, HashMapSet<EObject, EObject> selectedElements) {
        Iterator iterator;
        DDiagram currentDiagram = CapellaServices.getService().getDiagramContainer((EObject)context);
        DDiagramContents content = new DDiagramContents(currentDiagram);
        EObject source = context.getTarget();
        ShowHideExchangeCategory shService = new ShowHideExchangeCategory(content);
        AbstractShowHide.DiagramContext ctx = shService.new AbstractShowHide.DiagramContext();
        if (context instanceof DDiagramElement) {
            ctx.setVariable("spv", Collections.singletonList(context));
        }
        for (EObject key : scope.keySet()) {
            iterator = scope.get(key).iterator();
            while (iterator.hasNext()) {
                EObject value = (EObject)iterator.next();
                if (selectedElements.containsKey(key) && selectedElements.get(key).contains(value) || !initialSelection.containsKey(key) || !initialSelection.get(key).contains(value)) continue;
                this.showFECategory(shService, ctx, (ExchangeCategory)key, source, value, false);
                this.showFECategory(shService, ctx, (ExchangeCategory)key, value, source, false);
            }
        }
        for (EObject key : selectedElements.keySet()) {
            iterator = selectedElements.get(key).iterator();
            while (iterator.hasNext()) {
                EObject target = (EObject)iterator.next();
                this.showFECategory(shService, ctx, (ExchangeCategory)key, source, target, true);
                this.showFECategory(shService, ctx, (ExchangeCategory)key, target, source, true);
            }
        }
        content.commitDeferredActions();
        return context;
    }

    public Collection<EObject> getSwitchFECategoriesInitialSelection(DSemanticDecorator context) {
        if (context instanceof DDiagram) {
            HashSet<EObject> values = new HashSet<EObject>();
            DDiagramContents ctx = new DDiagramContents((DDiagram)context);
            for (DDiagramElement element : ctx.getDiagramElements((DiagramElementMapping)this.getMappingExchangeCategory(ctx.getDDiagram()))) {
                if (element.getTarget() == null || !(element.getTarget() instanceof CapellaElement)) continue;
                values.add(element.getTarget());
            }
            return values;
        }
        HashMapSet<EObject, EObject> result = this.getShowHideFECategoriesInitialSelection(context);
        return result.keySet();
    }

    public HashMapSet<EObject, EObject> getShowHideFECategoriesInitialSelection(DSemanticDecorator context) {
        HashMapSet<EObject, EObject> scope = this.getShowHideFECategoriesScope(context);
        HashMapSet<EObject, EObject> result = new HashMapSet<EObject, EObject>();
        DDiagram diagram = CapellaServices.getService().getDiagramContainer((EObject)context);
        EdgeMapping edgeMapping = this.getMappingExchangeCategory(diagram);
        DDiagramContents content = new DDiagramContents(diagram);
        for (EObject key : scope.keySet()) {
            Iterator iterator = scope.get(key).iterator();
            while (iterator.hasNext()) {
                EObject targetPart = (EObject)iterator.next();
                for (DDiagramElement elementView : content.getDiagramElements(key, (DiagramElementMapping)edgeMapping)) {
                    if (!(elementView instanceof DEdge)) continue;
                    result.put(key, targetPart);
                }
            }
        }
        return result;
    }

    public boolean isAFunctionOutputPort(EObject activityNode) {
        return activityNode instanceof FunctionOutputPort;
    }

    public boolean isNotLeafAndisAllLeavesFunctionActorAllocated(AbstractFunction function) {
        return !this.isLeaf((EObject)function) && this.isAllLeavesFunctionActorALlocated(function);
    }

    public boolean isAOutputPin(PortAllocation portAllocation) {
        return portAllocation.getAllocatedPort() instanceof OutputPin;
    }

    public boolean isNotLeaf(EObject systemFunction) {
        return !this.isLeaf(systemFunction);
    }

    public class FunctionContainer {
        DNodeContainer container;
        FunctionContainer parent;
        AbstractFunction function;
        Map<ExchangeCategory, DNode> incomingExchangeCategories;
        Map<ExchangeCategory, DNode> outgoingExchangeCategories;
        Set<DNode> categoryNodesToRemove;
        Map<FunctionPort, DNode> functionPorts;

        public FunctionContainer(DNodeContainer container, FunctionContainer parent, DDiagram diagram, Map<AbstractFunction, AbstractDNode> functions) {
            this.container = container;
            this.parent = parent;
            this.function = (AbstractFunction)container.getTarget();
            this.incomingExchangeCategories = new HashMap<ExchangeCategory, DNode>();
            this.outgoingExchangeCategories = new HashMap<ExchangeCategory, DNode>();
            this.functionPorts = new HashMap<FunctionPort, DNode>();
            this.categoryNodesToRemove = new HashSet<DNode>();
            String outputMappingName = MappingConstantsHelper.getMappingFunctionalExchangeCategoryOutputPin(diagram);
            String inputMappingName = MappingConstantsHelper.getMappingFunctionalExchangeCategoryInputPin(diagram);
            for (DNode aNode : container.getOwnedBorderedNodes()) {
                if (aNode.getTarget() != null && aNode.getTarget() instanceof FunctionPort) {
                    this.functionPorts.put((FunctionPort)aNode.getTarget(), aNode);
                }
                if (aNode.getTarget() != null && aNode.getActualMapping().getName().equals(inputMappingName)) {
                    this.incomingExchangeCategories.put((ExchangeCategory)aNode.getTarget(), aNode);
                }
                if (aNode.getTarget() == null || !aNode.getActualMapping().getName().equals(outputMappingName)) continue;
                this.outgoingExchangeCategories.put((ExchangeCategory)aNode.getTarget(), aNode);
            }
        }

        public void initCategoryNodesToRemove(Map<AbstractFunction, AbstractDNode> functions) {
            AbstractDNode sourcePortContainer;
            AbstractDNode targetPortContainer;
            boolean toRemove;
            for (Map.Entry<ExchangeCategory, DNode> me : this.incomingExchangeCategories.entrySet()) {
                toRemove = true;
                for (FunctionalExchange anExchange : me.getKey().getExchanges()) {
                    targetPortContainer = FaServices.this.getBestFunctionContainer(anExchange.getTarget(), functions);
                    sourcePortContainer = FaServices.this.getBestFunctionContainer(anExchange.getSource(), functions);
                    if (targetPortContainer == null || sourcePortContainer == null || !targetPortContainer.equals(this.container)) continue;
                    toRemove = false;
                    break;
                }
                if (!toRemove) continue;
                this.categoryNodesToRemove.add(me.getValue());
            }
            for (Map.Entry<ExchangeCategory, DNode> me : this.outgoingExchangeCategories.entrySet()) {
                toRemove = true;
                for (FunctionalExchange anExchange : me.getKey().getExchanges()) {
                    targetPortContainer = FaServices.this.getBestFunctionContainer(anExchange.getTarget(), functions);
                    sourcePortContainer = FaServices.this.getBestFunctionContainer(anExchange.getSource(), functions);
                    if (targetPortContainer == null || sourcePortContainer == null || !sourcePortContainer.equals(this.container)) continue;
                    toRemove = false;
                    break;
                }
                if (!toRemove) continue;
                this.categoryNodesToRemove.add(me.getValue());
            }
        }

        public FunctionContainer getParent() {
            return this.parent;
        }

        public DNodeContainer getContainer() {
            return this.container;
        }

        public AbstractFunction getFunction() {
            return this.function;
        }

        public Map<ExchangeCategory, DNode> getIncomingExchangeCategories() {
            return this.incomingExchangeCategories;
        }

        public Map<ExchangeCategory, DNode> getOutgoingExchangeCategories() {
            return this.outgoingExchangeCategories;
        }

        public Set<DNode> getCategoryNodes() {
            HashSet<DNode> nodes = new HashSet<DNode>();
            nodes.addAll(this.getIncomingExchangeCategories().values());
            nodes.addAll(this.getOutgoingExchangeCategories().values());
            return nodes;
        }

        public Set<DNode> getCategoryNodesToRemove() {
            return this.categoryNodesToRemove;
        }

        public void setIncomingOutgoingExchangeCategories(DDiagram diagram) {
            this.incomingExchangeCategories = new HashMap<ExchangeCategory, DNode>();
            this.outgoingExchangeCategories = new HashMap<ExchangeCategory, DNode>();
            String outputMappingName = MappingConstantsHelper.getMappingFunctionalExchangeCategoryOutputPin(diagram);
            String inputMappingName = MappingConstantsHelper.getMappingFunctionalExchangeCategoryInputPin(diagram);
            for (DNode aNode : this.getContainer().getOwnedBorderedNodes()) {
                if (aNode.getTarget() != null && aNode.getActualMapping().getName().equals(inputMappingName)) {
                    this.incomingExchangeCategories.put((ExchangeCategory)aNode.getTarget(), aNode);
                }
                if (aNode.getTarget() == null || !aNode.getActualMapping().getName().equals(outputMappingName)) continue;
                this.outgoingExchangeCategories.put((ExchangeCategory)aNode.getTarget(), aNode);
            }
        }

        public Map<FunctionPort, DNode> getFunctionPorts() {
            return this.functionPorts;
        }
    }
}

