/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.core.sirius.analysis;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.sirius.diagram.AbstractDNode;
import org.eclipse.sirius.diagram.DDiagram;
import org.eclipse.sirius.diagram.DDiagramElement;
import org.eclipse.sirius.diagram.DDiagramElementContainer;
import org.eclipse.sirius.diagram.DEdge;
import org.eclipse.sirius.diagram.DNode;
import org.eclipse.sirius.diagram.DNodeList;
import org.eclipse.sirius.diagram.DragAndDropTarget;
import org.eclipse.sirius.diagram.EdgeTarget;
import org.eclipse.sirius.diagram.description.AbstractNodeMapping;
import org.eclipse.sirius.diagram.description.ContainerMapping;
import org.eclipse.sirius.diagram.description.EdgeMapping;
import org.eclipse.sirius.diagram.description.NodeMapping;
import org.eclipse.sirius.viewpoint.DSemanticDecorator;
import org.polarsys.capella.core.data.capellacore.CapellaElement;
import org.polarsys.capella.core.data.cs.AbstractActor;
import org.polarsys.capella.core.data.cs.BlockArchitecture;
import org.polarsys.capella.core.data.cs.Component;
import org.polarsys.capella.core.data.cs.CsFactory;
import org.polarsys.capella.core.data.cs.CsPackage;
import org.polarsys.capella.core.data.cs.Interface;
import org.polarsys.capella.core.data.cs.InterfacePkg;
import org.polarsys.capella.core.data.cs.Part;
import org.polarsys.capella.core.data.epbs.ConfigurationItem;
import org.polarsys.capella.core.data.fa.ComponentPort;
import org.polarsys.capella.core.data.information.ExchangeItem;
import org.polarsys.capella.core.data.pa.PhysicalComponent;
import org.polarsys.capella.core.data.pa.PhysicalComponentNature;
import org.polarsys.capella.core.model.helpers.BlockArchitectureExt;
import org.polarsys.capella.core.model.helpers.CapellaElementExt;
import org.polarsys.capella.core.model.helpers.ComponentExt;
import org.polarsys.capella.core.sirius.analysis.CapellaServices;
import org.polarsys.capella.core.sirius.analysis.CsServices;
import org.polarsys.capella.core.sirius.analysis.DDiagramContents;
import org.polarsys.capella.core.sirius.analysis.DiagramServices;
import org.polarsys.capella.core.sirius.analysis.InformationServices;
import org.polarsys.capella.core.sirius.analysis.showhide.AbstractShowHide;
import org.polarsys.capella.core.sirius.analysis.showhide.ShowHideIDRelationships;

public class IBServices {
    private static IBServices service = null;

    public static IBServices getService() {
        if (service == null) {
            service = new IBServices();
        }
        return service;
    }

    public EObject showHideIDExchangeItems(EObject context, List<CapellaElement> selectedOperations, DDiagram diagram) {
        HashMap<CapellaElement, AbstractDNode> visibleElements = new HashMap<CapellaElement, AbstractDNode>();
        for (DDiagramElement dDiagramElement : DiagramServices.getDiagramServices().getDiagramElements((EObject)diagram)) {
            if (!(dDiagramElement instanceof AbstractDNode) || dDiagramElement.getTarget() == null || !(dDiagramElement.getTarget() instanceof ExchangeItem)) continue;
            visibleElements.put((CapellaElement)dDiagramElement.getTarget(), (AbstractDNode)dDiagramElement);
        }
        for (Map.Entry entry : visibleElements.entrySet()) {
            if (selectedOperations.contains(entry.getKey())) continue;
            if (entry.getValue() instanceof DNodeList) {
                DiagramServices.getDiagramServices().removeContainerView((EObject)entry.getValue());
                continue;
            }
            if (!(entry.getValue() instanceof DNode)) continue;
            DiagramServices.getDiagramServices().removeNodeView((DNode)entry.getValue());
        }
        for (CapellaElement capellaElement : selectedOperations) {
            EObject container = CapellaServices.getService().getBestGraphicalContainer((EObject)capellaElement, diagram, CsPackage.Literals.COMPONENT);
            if (visibleElements.containsKey(capellaElement)) continue;
            this.createIDExchangeItemView((DragAndDropTarget)container, capellaElement, diagram);
        }
        return context;
    }

    protected AbstractDNode createIDExchangeItemView(DragAndDropTarget containerView, CapellaElement aOperation, DDiagram diagram) {
        AbstractNodeMapping mapping = IBServices.getService().getMappingIDExchangeItem((EObject)aOperation, diagram);
        return DiagramServices.getDiagramServices().createAbstractDNode(mapping, (EObject)aOperation, containerView, diagram);
    }

    public AbstractNodeMapping getMappingIDInterface(EObject context, DDiagram diagram) {
        boolean isContainerMapping = true;
        String mappingName = "";
        if ("Interfaces Diagram Blank".equals(diagram.getDescription().getName())) {
            mappingName = "IDB_Interface";
        } else if ("Contextual Component Detailed Interfaces".equals(diagram.getDescription().getName())) {
            mappingName = "FullInterface1";
        } else if ("Contextual Component External Interfaces".equals(diagram.getDescription().getName())) {
            mappingName = "CA_Interface";
            isContainerMapping = false;
        } else if ("Contextual Component Internal Interfaces".equals(diagram.getDescription().getName())) {
            mappingName = "CCII_Interface";
            isContainerMapping = false;
        }
        if (isContainerMapping) {
            ContainerMapping mapping = DiagramServices.getDiagramServices().getContainerMapping(diagram, mappingName);
            return mapping;
        }
        NodeMapping mapping = DiagramServices.getDiagramServices().getNodeMapping(diagram, mappingName);
        return mapping;
    }

    public PhysicalComponentNature getIBCreationNature(EObject current, EObject container) {
        PhysicalComponentNature result = PhysicalComponentNature.BEHAVIOR;
        if (container instanceof PhysicalComponent && ((PhysicalComponent)container).getNature() == PhysicalComponentNature.NODE) {
            result = PhysicalComponentNature.NODE;
        }
        return result;
    }

    public EdgeMapping getMappingIDCommunicationLink(EObject context, DDiagram diagram) {
        String mappingName = "";
        if ("Interfaces Diagram Blank".equals(diagram.getDescription().getName())) {
            mappingName = "IDB_CommunicationLink";
        } else if ("Contextual Component Detailed Interfaces".equals(diagram.getDescription().getName())) {
            mappingName = "CCDI_CommunicationLink";
        } else if ("Contextual Component External Interfaces".equals(diagram.getDescription().getName())) {
            mappingName = "CCEI_CommunicationLink";
        } else if ("Contextual Component Internal Interfaces".equals(diagram.getDescription().getName())) {
            mappingName = "CCII_CommunicationLink";
        }
        EdgeMapping mapping = DiagramServices.getDiagramServices().getEdgeMapping(diagram, mappingName);
        return mapping;
    }

    public EObject createIDInterfaceView(DragAndDropTarget context, CapellaElement aOperation, DDiagram diagram) {
        AbstractNodeMapping mapping = this.getMappingIDInterface((EObject)aOperation, diagram);
        return DiagramServices.getDiagramServices().createAbstractDNode(mapping, (EObject)aOperation, context, diagram);
    }

    public EdgeMapping getMappingIDGeneralization(EObject context, DDiagram diagram) {
        String mappingName = "";
        if ("Interfaces Diagram Blank".equals(diagram.getDescription().getName())) {
            mappingName = "IDB_Generalization";
        } else if ("Contextual Component Detailed Interfaces".equals(diagram.getDescription().getName())) {
            mappingName = "CCDI_Generalization";
        } else if ("Contextual Component External Interfaces".equals(diagram.getDescription().getName())) {
            mappingName = "CCEI_Generalization";
        } else if ("Contextual Component Internal Interfaces".equals(diagram.getDescription().getName())) {
            mappingName = "CCII_Generalization";
        }
        EdgeMapping mapping = DiagramServices.getDiagramServices().getEdgeMapping(diagram, mappingName);
        return mapping;
    }

    public EdgeMapping getMappingIDInterfaceUse(EObject context, DDiagram diagram) {
        String mappingName = "";
        if ("Interfaces Diagram Blank".equals(diagram.getDescription().getName())) {
            mappingName = "IDB_UseInterface";
        } else if ("Contextual Component Detailed Interfaces".equals(diagram.getDescription().getName())) {
            mappingName = "use1";
        } else if ("Contextual Component External Interfaces".equals(diagram.getDescription().getName())) {
            mappingName = "CA_use2";
        } else if ("Contextual Component Internal Interfaces".equals(diagram.getDescription().getName())) {
            mappingName = "CCII_UseInterface";
        }
        EdgeMapping mapping = DiagramServices.getDiagramServices().getEdgeMapping(diagram, mappingName);
        return mapping;
    }

    public EdgeMapping getMappingIDInterfaceImplementation(EObject context, DDiagram diagram) {
        String mappingName = "";
        if ("Interfaces Diagram Blank".equals(diagram.getDescription().getName())) {
            mappingName = "IDB_ImplementInterface";
        } else if ("Contextual Component Detailed Interfaces".equals(diagram.getDescription().getName())) {
            mappingName = "imp1";
        } else if ("Contextual Component External Interfaces".equals(diagram.getDescription().getName())) {
            mappingName = "CA_imp2";
        } else if ("Contextual Component Internal Interfaces".equals(diagram.getDescription().getName())) {
            mappingName = "CCII_ImplementInterface";
        }
        EdgeMapping mapping = DiagramServices.getDiagramServices().getEdgeMapping(diagram, mappingName);
        return mapping;
    }

    public EdgeMapping getMappingIDInterfaceProvide(EObject context, DDiagram diagram) {
        String mappingName = "";
        if ("Interfaces Diagram Blank".equals(diagram.getDescription().getName())) {
            mappingName = "IDB_PinProvidedInterface";
        } else if ("Contextual Component Detailed Interfaces".equals(diagram.getDescription().getName())) {
            mappingName = "CCDI_PinProvidedInterface";
        } else if ("Contextual Component External Interfaces".equals(diagram.getDescription().getName())) {
            mappingName = "CCEI_PinProvidedInterface";
        } else if ("Contextual Component Internal Interfaces".equals(diagram.getDescription().getName())) {
            mappingName = "CCII_PinProvidedInterface";
        }
        EdgeMapping mapping = DiagramServices.getDiagramServices().getEdgeMapping(diagram, mappingName);
        return mapping;
    }

    public EdgeMapping getMappingIDInterfaceRequire(EObject context, DDiagram diagram) {
        String mappingName = "";
        if ("Interfaces Diagram Blank".equals(diagram.getDescription().getName())) {
            mappingName = "IDB_PinRequiredInterface";
        } else if ("Contextual Component Detailed Interfaces".equals(diagram.getDescription().getName())) {
            mappingName = "CCDI_PinRequiredInterface";
        } else if ("Contextual Component External Interfaces".equals(diagram.getDescription().getName())) {
            mappingName = "CCEI_PinRequiredInterface";
        } else if ("Contextual Component Internal Interfaces".equals(diagram.getDescription().getName())) {
            mappingName = "CCII_PinRequiredInterface";
        }
        EdgeMapping mapping = DiagramServices.getDiagramServices().getEdgeMapping(diagram, mappingName);
        return mapping;
    }

    public AbstractNodeMapping getMappingIDComponent(EObject element, DDiagram diagram) {
        boolean isContainerMapping = true;
        String mappingName = "";
        if ("Interfaces Diagram Blank".equals(diagram.getDescription().getName())) {
            mappingName = "IDB_Component";
        } else if ("Contextual Component Detailed Interfaces".equals(diagram.getDescription().getName())) {
            mappingName = "System 1";
        } else if ("Contextual Component External Interfaces".equals(diagram.getDescription().getName())) {
            mappingName = "CA_Component";
        } else if ("Contextual Component Internal Interfaces".equals(diagram.getDescription().getName())) {
            mappingName = "CCII_Component";
        }
        if (isContainerMapping) {
            ContainerMapping mapping = DiagramServices.getDiagramServices().getContainerMapping(diagram, mappingName);
            return mapping;
        }
        NodeMapping mapping = DiagramServices.getDiagramServices().getNodeMapping(diagram, mappingName);
        return mapping;
    }

    public AbstractNodeMapping getMappingIDComponentPort(EObject element, DDiagram diagram) {
        String mappingName = "";
        if ("Interfaces Diagram Blank".equals(diagram.getDescription().getName())) {
            mappingName = "IDB_Port";
        } else if ("Contextual Component Detailed Interfaces".equals(diagram.getDescription().getName())) {
            mappingName = "CCDI_Port";
        } else if ("Contextual Component External Interfaces".equals(diagram.getDescription().getName())) {
            mappingName = "CCEI_Port";
        } else if ("Contextual Component Internal Interfaces".equals(diagram.getDescription().getName())) {
            mappingName = "CCII_Port";
        }
        NodeMapping mapping = DiagramServices.getDiagramServices().getBorderedNodeMapping(diagram, mappingName);
        return mapping;
    }

    public AbstractNodeMapping getMappingIDExchangeItem(EObject context, DDiagram diagram) {
        boolean isContainerMapping = true;
        String mappingName = "";
        if ("Interfaces Diagram Blank".equals(diagram.getDescription().getName())) {
            mappingName = "IDB_ExchangeItem";
        } else if ("Contextual Component Detailed Interfaces".equals(diagram.getDescription().getName())) {
            mappingName = "CCDI_ExchangeItem";
        } else if ("Contextual Component External Interfaces".equals(diagram.getDescription().getName())) {
            mappingName = "CCEI_ExchangeItem";
            isContainerMapping = false;
        } else if ("Contextual Component Internal Interfaces".equals(diagram.getDescription().getName())) {
            mappingName = "CCII_ExchangeItem";
            isContainerMapping = false;
        }
        if (isContainerMapping) {
            ContainerMapping mapping = DiagramServices.getDiagramServices().getContainerMapping(diagram, mappingName);
            return mapping;
        }
        NodeMapping mapping = DiagramServices.getDiagramServices().getNodeMapping(diagram, mappingName);
        return mapping;
    }

    public Interface createCCDIInterface(DSemanticDecorator containerView) {
        EObject container = containerView.getTarget();
        if (container != null) {
            EObject target = CsServices.getService().getParentContainer(container);
            InterfacePkg pkg = null;
            if (target instanceof BlockArchitecture) {
                pkg = BlockArchitectureExt.getInterfacePkg((BlockArchitecture)((BlockArchitecture)target));
            } else if (target instanceof Component) {
                pkg = ComponentExt.getInterfacePkg((Component)((Component)target));
            }
            if (pkg != null) {
                Interface itf = CsFactory.eINSTANCE.createInterface();
                pkg.getOwnedInterfaces().add((Object)itf);
                CapellaElementExt.creationService((EObject)itf);
                this.createIDInterfaceView((DragAndDropTarget)containerView, (CapellaElement)itf, CapellaServices.getService().getDiagramContainer((EObject)containerView));
                return itf;
            }
        }
        return null;
    }

    @Deprecated
    public Collection<EObject> getAvailableInterfacesAndLinksFromComponentToInsert(EObject containerView) {
        return this.getIDInsertRemoveRelationshipsScope(containerView);
    }

    @Deprecated
    public Collection<EObject> getExistingInterfacesAndLinksFromDiagram(EObject containerView) {
        return this.getIDInsertRemoveRelationshipsInitialSelection(containerView, this.getAvailableInterfacesAndLinksFromComponentToInsert(containerView));
    }

    public Collection<EObject> getIDInsertRemoveRelationshipsScope(EObject context) {
        ArrayList<EObject> result = new ArrayList<EObject>();
        EObject target = context;
        if (target instanceof DSemanticDecorator) {
            return this.getIDInsertRemoveRelationshipsScope(((DSemanticDecorator)context).getTarget());
        }
        if (target instanceof Component) {
            EList usedInterfaceLinks;
            Component component = (Component)target;
            EList implementedInterfaceLinks = component.getImplementedInterfaceLinks();
            if (implementedInterfaceLinks != null) {
                result.addAll((Collection<EObject>)implementedInterfaceLinks);
            }
            if ((usedInterfaceLinks = component.getUsedInterfaceLinks()) != null) {
                result.addAll((Collection<EObject>)usedInterfaceLinks);
            }
            result.addAll(CsServices.getService().getRelatedCommunicationLinks(component));
            result.addAll((Collection<EObject>)component.getSuperGeneralizations());
            result.addAll((Collection<EObject>)component.getSubGeneralizations());
        } else if (target instanceof ComponentPort) {
            EList requitedInterfaces;
            ComponentPort port = (ComponentPort)target;
            EList providedInterfaces = port.getProvidedInterfaces();
            if (providedInterfaces != null) {
                result.addAll((Collection<EObject>)providedInterfaces);
            }
            if ((requitedInterfaces = port.getRequiredInterfaces()) != null) {
                result.addAll((Collection<EObject>)requitedInterfaces);
            }
        } else if (target instanceof Interface) {
            Interface itf = (Interface)target;
            result.addAll((Collection<EObject>)itf.getSuperGeneralizations());
            result.addAll((Collection<EObject>)itf.getSubGeneralizations());
        }
        return result;
    }

    public List<EObject> getIDInsertRemoveRelationshipsInitialSelection(EObject sourceView, Collection scope) {
        ArrayList<EObject> result;
        block3: {
            EObject sourceTarget;
            DDiagram diagramContainer;
            block4: {
                result = new ArrayList<EObject>();
                diagramContainer = CapellaServices.getService().getDiagramContainer(sourceView);
                sourceTarget = ((DSemanticDecorator)sourceView).getTarget();
                if (sourceTarget == null || diagramContainer == null) break block3;
                if (!(sourceTarget instanceof Component) && !(sourceTarget instanceof Interface)) break block4;
                for (Object capellaElement : scope) {
                    if (!DiagramServices.getDiagramServices().isOnDiagram(diagramContainer, (EObject)capellaElement)) continue;
                    result.add((EObject)capellaElement);
                }
                break block3;
            }
            if (!(sourceTarget instanceof ComponentPort)) break block3;
            for (Object capellaElement : scope) {
                if (!DiagramServices.getDiagramServices().isOnDiagram(diagramContainer, (EObject)capellaElement)) continue;
                EList outgoingEdges = ((DNode)sourceView).getOutgoingEdges();
                for (DEdge dEdge : outgoingEdges) {
                    EdgeTarget edgeSNode = dEdge.getSourceNode();
                    EdgeTarget edgeTNode = dEdge.getTargetNode();
                    if (edgeSNode == null || edgeTNode == null) continue;
                    EObject edgeSTarget = ((DSemanticDecorator)edgeSNode).getTarget();
                    EObject edgeTTarget = ((DSemanticDecorator)edgeTNode).getTarget();
                    if (edgeSTarget == null || edgeTTarget == null || !edgeSTarget.equals(sourceTarget) || !edgeTTarget.equals(capellaElement)) continue;
                    result.add((EObject)capellaElement);
                }
            }
        }
        return result;
    }

    public EObject insertRemoveIDRelationships(EObject sourceView, Collection scope, Collection initialSelection, Collection selectedElements) {
        AbstractShowHide.DiagramContext context;
        DDiagram diagram = CapellaServices.getService().getDiagramContainer(sourceView);
        DDiagramContents content = new DDiagramContents(diagram);
        EObject semantic = ((DSemanticDecorator)sourceView).getTarget();
        ShowHideIDRelationships shService = new ShowHideIDRelationships(content);
        for (Object object : selectedElements) {
            context = shService.new AbstractShowHide.DiagramContext();
            context.setVariable("sourceComponent", sourceView);
            if (semantic instanceof ComponentPort) {
                if (object instanceof Interface && ((ComponentPort)semantic).getProvidedInterfaces().contains(object)) {
                    context.setVariable("provided", object);
                    shService.show(semantic, context);
                    continue;
                }
                if (!(object instanceof Interface) || !((ComponentPort)semantic).getRequiredInterfaces().contains(object)) continue;
                context.setVariable("required", object);
                shService.show(semantic, context);
                continue;
            }
            shService.show((EObject)object, context);
        }
        for (Object object : initialSelection) {
            context = shService.new AbstractShowHide.DiagramContext();
            context.setVariable("sourceComponent", sourceView);
            if (selectedElements.contains(object)) continue;
            if (semantic instanceof ComponentPort) {
                if (object instanceof Interface && ((ComponentPort)semantic).getProvidedInterfaces().contains(object)) {
                    context.setVariable("provided", object);
                    shService.hide(semantic, context);
                    continue;
                }
                if (!(object instanceof Interface) || !((ComponentPort)semantic).getRequiredInterfaces().contains(object)) continue;
                context.setVariable("required", object);
                shService.hide(semantic, context);
                continue;
            }
            shService.hide((EObject)object, context);
        }
        return sourceView;
    }

    public EObject showHideInterfaces(EObject context, List<CapellaElement> selectedInterfaces, List<CapellaElement> scope, DDiagram diagram) {
        HashMap<CapellaElement, AbstractDNode> visibleElements = new HashMap<CapellaElement, AbstractDNode>();
        for (DDiagramElement dDiagramElement : DiagramServices.getDiagramServices().getDiagramElements((EObject)diagram)) {
            EObject target = dDiagramElement.getTarget();
            if (!(dDiagramElement instanceof AbstractDNode) || target == null || !(target instanceof Interface)) continue;
            visibleElements.put((CapellaElement)target, (AbstractDNode)dDiagramElement);
        }
        for (Map.Entry entry : visibleElements.entrySet()) {
            AbstractDNode node;
            if (selectedInterfaces.contains(entry.getKey()) || !scope.contains(entry.getKey()) || !(node = (AbstractDNode)entry.getValue()).isVisible()) continue;
            if (node instanceof DDiagramElementContainer || node instanceof DDiagram) {
                DiagramServices.getDiagramServices().removeContainerView((EObject)entry.getValue());
                continue;
            }
            if (!(node instanceof DNode)) continue;
            DiagramServices.getDiagramServices().removeNodeView((DNode)entry.getValue());
        }
        for (CapellaElement capellaElement : selectedInterfaces) {
            EObject container = CapellaServices.getService().getBestGraphicalContainer((EObject)capellaElement, diagram, CsPackage.Literals.INTERFACE);
            if (visibleElements.containsKey(capellaElement)) continue;
            this.createIDInterfaceView((DragAndDropTarget)container, capellaElement, diagram);
        }
        return context;
    }

    public boolean isValidCreationCCDIInterface(DSemanticDecorator containerView) {
        return (containerView instanceof DDiagram || !(containerView.getTarget() instanceof AbstractActor)) && !(((DSemanticDecorator)CapellaServices.getService().getDiagramContainer((EObject)containerView)).getTarget() instanceof ConfigurationItem);
    }

    public boolean isValidCreationIBDelegationExchange(EObject root, DSemanticDecorator preSourceView, DSemanticDecorator preTargetView) {
        return CsServices.getService().isValidCreationABDelegationExchange(root, preSourceView, preTargetView);
    }

    public Object getIBInterfaceUseSemanticCandidates(DDiagram diagram) {
        ArrayList result = new ArrayList();
        for (DDiagramElement dNode : DiagramServices.getDiagramServices().getAllAbstractNodes((EObject)diagram, false)) {
            EObject target = dNode.getTarget();
            if (!(target instanceof Component)) continue;
            result.addAll(((Component)target).getUsedInterfaceLinks());
        }
        return result;
    }

    public Object getIBInterfaceImplementationSemanticCandidates(DDiagram diagram) {
        ArrayList result = new ArrayList();
        for (DDiagramElement dNode : DiagramServices.getDiagramServices().getAllAbstractNodes((EObject)diagram, false)) {
            EObject target = dNode.getTarget();
            if (!(target instanceof Component)) continue;
            result.addAll(((Component)target).getImplementedInterfaceLinks());
        }
        return result;
    }

    public Object getIBComponentExchangeSemanticCandidates(DDiagram diagram) {
        ArrayList result = new ArrayList();
        for (DDiagramElement dNode : DiagramServices.getDiagramServices().getAllAbstractNodes((EObject)diagram, false)) {
            EObject target = dNode.getTarget();
            if (target instanceof Part) {
                result.addAll(ComponentExt.getAllRelatedComponentExchange((Part)((Part)target), (boolean)true));
                continue;
            }
            if (!(target instanceof Component)) continue;
            result.addAll(ComponentExt.getAllRelatedComponentExchange((Component)((Component)target)));
        }
        return result;
    }

    public Object getIBGeneralizationSemanticCandidates(DDiagram diagram) {
        return InformationServices.getService().getCDBGeneralizationSemanticCandidates(diagram);
    }

    public Object getIBCommunicationLinkSemanticCandidates(DDiagram diagram) {
        ArrayList result = new ArrayList();
        for (DDiagramElement dNode : DiagramServices.getDiagramServices().getAllAbstractNodes((EObject)diagram, false)) {
            EObject target = dNode.getTarget();
            if (!(target instanceof Component)) continue;
            result.addAll(((Component)target).getOwnedCommunicationLinks());
        }
        return result;
    }

    public Object getIBExchangeItemAllocationSemanticCandidates(DDiagram diagram) {
        ArrayList result = new ArrayList();
        for (DDiagramElement dNode : DiagramServices.getDiagramServices().getAllAbstractNodes((EObject)diagram, false)) {
            EObject target = dNode.getTarget();
            if (!(target instanceof Interface)) continue;
            result.addAll(((Interface)target).getOwnedExchangeItemAllocations());
        }
        return result;
    }
}

