/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.core.sirius.analysis.refresh.extension;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.sirius.diagram.AbstractDNode;
import org.eclipse.sirius.diagram.DDiagram;
import org.eclipse.sirius.diagram.DDiagramElement;
import org.eclipse.sirius.diagram.DEdge;
import org.eclipse.sirius.diagram.DragAndDropTarget;
import org.eclipse.sirius.diagram.EdgeTarget;
import org.eclipse.sirius.diagram.FoldingFilter;
import org.eclipse.sirius.diagram.FoldingPointFilter;
import org.eclipse.sirius.diagram.GraphicalFilter;
import org.eclipse.sirius.diagram.business.api.refresh.IRefreshExtension;
import org.polarsys.capella.core.data.cs.Component;
import org.polarsys.capella.core.sirius.analysis.CsServices;
import org.polarsys.capella.core.sirius.analysis.DiagramServices;

public class BreakdownRefreshExtension
implements IRefreshExtension {
    public void beforeRefresh(DDiagram dDiagram_p) {
        this.repairCollapsedElements(dDiagram_p);
    }

    protected boolean isDirectlyCollapsed(DDiagramElement element) {
        for (GraphicalFilter filter : element.getGraphicalFilters()) {
            if (!(filter instanceof FoldingFilter)) continue;
            return true;
        }
        return false;
    }

    private boolean isCollapsedParent(DDiagramElement parent_p) {
        if (!this.isDirectlyCollapsed(parent_p) && parent_p instanceof EdgeTarget) {
            EdgeTarget edgeTarget = (EdgeTarget)parent_p;
            for (DEdge edge : edgeTarget.getIncomingEdges()) {
                if (edge.getSourceNode() == null || !(edge.getSourceNode() instanceof DDiagramElement) || !this.isDirectlyCollapsed((DDiagramElement)edge.getSourceNode())) continue;
                return true;
            }
            return false;
        }
        return true;
    }

    private void unfold(DDiagramElement element_p) {
        ArrayList<GraphicalFilter> filters = new ArrayList<GraphicalFilter>();
        for (GraphicalFilter filter : element_p.getGraphicalFilters()) {
            if (filter instanceof FoldingFilter) {
                filters.add(filter);
            }
            if (!(filter instanceof FoldingPointFilter)) continue;
            filters.add(filter);
        }
        for (GraphicalFilter filter : filters) {
            element_p.getGraphicalFilters().remove((Object)filter);
        }
    }

    protected void repairCollapsedElements(DDiagram diagram_p) {
        Map<EObject, DragAndDropTarget> elements = DiagramServices.getDiagramServices().getMapOfDiagramNodes(diagram_p);
        HashSet<DDiagramElement> toUnfold = new HashSet<DDiagramElement>();
        HashSet<DDiagramElement> toFold = new HashSet<DDiagramElement>();
        block0: for (DDiagramElement element : DiagramServices.getDiagramServices().getDiagramElements((EObject)diagram_p)) {
            if (!(element instanceof AbstractDNode)) continue;
            boolean elementIsCollapsed = this.isDirectlyCollapsed(element);
            LinkedList<EObject> parents = new LinkedList<EObject>();
            LinkedList<EObject> visitedObjects = new LinkedList<EObject>();
            EObject target = element.getTarget();
            if (target == null) continue;
            parents.addAll(this.getContainers(target));
            while (parents.size() > 0) {
                EObject targetParent = (EObject)parents.removeFirst();
                if (visitedObjects.contains(targetParent)) continue;
                visitedObjects.add(targetParent);
                DragAndDropTarget viewParent = elements.get(targetParent);
                if (viewParent != null && viewParent instanceof DDiagramElement) {
                    boolean parentIsDirectlyCollapsed = this.isDirectlyCollapsed((DDiagramElement)viewParent);
                    boolean parentIsUndirectlyCollapsed = this.isCollapsedParent((DDiagramElement)viewParent);
                    if (elementIsCollapsed && !parentIsDirectlyCollapsed) {
                        toUnfold.add(element);
                        continue block0;
                    }
                    if (!elementIsCollapsed && parentIsDirectlyCollapsed) {
                        toFold.add(element);
                        continue block0;
                    }
                    if (elementIsCollapsed && parentIsDirectlyCollapsed && !parentIsUndirectlyCollapsed) {
                        toUnfold.add(element);
                        continue block0;
                    }
                    if (parentIsDirectlyCollapsed) {
                        continue block0;
                    }
                } else if (viewParent == null) {
                    toUnfold.add(element);
                }
                if (targetParent == null) continue;
                parents.addAll(this.getContainers(targetParent));
            }
        }
        for (DDiagramElement element : toUnfold) {
            List<EObject> parents = this.getBreakdownParents(element);
            if (parents.size() <= 1) continue;
            boolean contains = false;
            for (EObject semanticParent : this.getContainers(element.getTarget())) {
                if (!parents.contains(semanticParent)) continue;
                contains = true;
            }
            if (contains) continue;
            this.unfold(element);
        }
    }

    private Collection<EObject> getContainers(EObject e) {
        ArrayList<EObject> parents = new ArrayList<EObject>();
        if (e instanceof Component) {
            parents.addAll(CsServices.getService().getContainersOfParts((Component)e));
        } else {
            parents.add(e.eContainer());
        }
        return parents;
    }

    private List<EObject> getBreakdownParents(DDiagramElement element_p) {
        LinkedList<DDiagramElement> parents = new LinkedList<DDiagramElement>();
        LinkedList<DDiagramElement> visitedElements = new LinkedList<DDiagramElement>();
        LinkedList<EObject> visitedObjects = new LinkedList<EObject>();
        parents.add(element_p);
        while (parents.size() > 0) {
            DDiagramElement parent = (DDiagramElement)parents.removeFirst();
            if (!visitedElements.contains(parent)) {
                visitedElements.add(parent);
                visitedObjects.add(parent.getTarget());
                EdgeTarget edgeTarget = (EdgeTarget)parent;
                if (edgeTarget != element_p) continue;
                for (DEdge edge : edgeTarget.getOutgoingEdges()) {
                    if (edge.getTargetNode() == null || !(edge.getTargetNode() instanceof DDiagramElement)) continue;
                    parents.addLast((DDiagramElement)edge.getTargetNode());
                }
                continue;
            }
            if (visitedElements.contains(parent)) continue;
            visitedElements.add(parent);
            visitedObjects.add(parent.getTarget());
        }
        return visitedObjects;
    }

    public void postRefresh(DDiagram dDiagram_p) {
    }
}

