/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.core.sirius.analysis.refresh.extension;

import java.util.LinkedList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.sirius.diagram.DDiagram;
import org.eclipse.sirius.diagram.DNode;
import org.eclipse.sirius.diagram.business.api.refresh.IRefreshExtension;
import org.eclipse.sirius.diagram.description.NodeMapping;
import org.eclipse.sirius.viewpoint.DSemanticDecorator;
import org.polarsys.capella.core.data.capellacore.GeneralizableElement;
import org.polarsys.capella.core.data.ctx.Actor;
import org.polarsys.capella.core.data.ctx.ActorMissionInvolvement;
import org.polarsys.capella.core.data.ctx.Capability;
import org.polarsys.capella.core.data.ctx.Mission;
import org.polarsys.capella.core.sirius.analysis.DiagramServices;
import org.polarsys.capella.core.sirius.analysis.refresh.extension.AbstractRefreshExtension;

public class ContextualMissionRefreshExtension
extends AbstractRefreshExtension
implements IRefreshExtension {
    public void beforeRefresh(DDiagram diagram) {
        DNode container;
        if (((DSemanticDecorator)diagram).getTarget() == null) {
            return;
        }
        LinkedList<Actor> actors = new LinkedList<Actor>();
        LinkedList capabilities = new LinkedList();
        LinkedList<Mission> missions = new LinkedList<Mission>();
        NodeMapping actorNodeMapping = DiagramServices.getDiagramServices().getNodeMapping(diagram, "ActorNode");
        NodeMapping capaNodeMapping = DiagramServices.getDiagramServices().getNodeMapping(diagram, "CapNode");
        NodeMapping missionNodeMapping = DiagramServices.getDiagramServices().getNodeMapping(diagram, "MissionNode");
        Mission currentMission = (Mission)((DSemanticDecorator)diagram).getTarget();
        for (ActorMissionInvolvement inv : currentMission.getInvolvedActors()) {
            actors.add(inv.getActor());
            for (GeneralizableElement elt : inv.getActor().getSuper()) {
                if (!(elt instanceof Actor)) continue;
                actors.add((Actor)elt);
            }
        }
        missions.add(currentMission);
        capabilities.addAll(currentMission.getExploitedCapabilities());
        for (Actor actor : actors) {
            if (DiagramServices.getDiagramServices().isOnDiagram(diagram, (EObject)actor)) continue;
            container = actorNodeMapping.createNode((EObject)actor, (EObject)currentMission, diagram);
            diagram.getOwnedDiagramElements().add((Object)container);
        }
        for (Capability cap : capabilities) {
            if (DiagramServices.getDiagramServices().isOnDiagram(diagram, (EObject)cap)) continue;
            container = capaNodeMapping.createNode((EObject)cap, (EObject)currentMission, diagram);
            diagram.getOwnedDiagramElements().add((Object)container);
        }
        for (Mission mission : missions) {
            if (DiagramServices.getDiagramServices().isOnDiagram(diagram, (EObject)mission)) continue;
            container = missionNodeMapping.createNode((EObject)mission, (EObject)currentMission, diagram);
            diagram.getOwnedDiagramElements().add((Object)container);
        }
    }

    public void postRefresh(DDiagram diagram) {
    }
}

