/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.core.sirius.analysis.refresh.extension;

import java.util.List;
import org.apache.log4j.Logger;
import org.eclipse.sirius.diagram.DDiagram;
import org.eclipse.sirius.diagram.business.api.refresh.IRefreshExtension;
import org.eclipse.sirius.diagram.description.ContainerMapping;
import org.eclipse.sirius.viewpoint.DRepresentation;
import org.polarsys.capella.core.diagram.helpers.ContextualDiagramHelper;
import org.polarsys.capella.core.sirius.analysis.CsServices;
import org.polarsys.capella.core.sirius.analysis.DDiagramContents;
import org.polarsys.capella.core.sirius.analysis.DiagramServices;
import org.polarsys.capella.core.sirius.analysis.FaServices;
import org.polarsys.capella.core.sirius.analysis.FunctionalChainServices;
import org.polarsys.capella.core.sirius.analysis.refresh.extension.AbstractRefreshExtension;
import org.polarsys.capella.core.sirius.analysis.refresh.extension.Messages;

public class EntityArchitectureBlankRefreshExtension
extends AbstractRefreshExtension
implements IRefreshExtension {
    public void beforeRefresh(DDiagram diagram_p) {
        List contextualElements = ContextualDiagramHelper.getService().getContextualElements((DRepresentation)diagram_p);
        DDiagramContents context = FaServices.getFaServices().getDDiagramContents(diagram_p);
        try {
            CsServices.getService().showABContextualElements(context, contextualElements);
        }
        catch (Exception e) {
            Logger.getLogger((String)"Diagrams Management").error((Object)Messages.RefreshExtension_ErrorOnContextualElements, (Throwable)e);
        }
        try {
            CsServices.getService().refreschEntitiesArchitecture(this.getComponentMapping(diagram_p), diagram_p);
        }
        catch (Exception e) {
            Logger.getLogger((String)"Diagrams Management").error((Object)Messages.RefreshExtension_ErrorOnReordering, (Throwable)e);
        }
    }

    public void postRefresh(DDiagram diagram_p) {
        try {
            FunctionalChainServices.getFunctionalChainServices().updateFunctionalChainStyles(diagram_p);
        }
        catch (Exception e) {
            Logger.getLogger((String)"Diagrams Management").error((Object)Messages.RefreshExtension_ErrorOnUpdateFunctionalChainStyle, (Throwable)e);
        }
    }

    public ContainerMapping getComponentMapping(DDiagram diagram_p) {
        if (diagram_p.getDescription().getName().equals("Operational Entity Blank")) {
            return DiagramServices.getDiagramServices().getContainerMapping(diagram_p, "OAB_Entity1");
        }
        return null;
    }
}

