/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.core.sirius.analysis.showhide;

import java.util.Collection;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.sirius.diagram.DDiagramElement;
import org.eclipse.sirius.diagram.DEdge;
import org.eclipse.sirius.diagram.EdgeTarget;
import org.eclipse.sirius.diagram.description.AbstractNodeMapping;
import org.eclipse.sirius.diagram.description.DiagramElementMapping;
import org.eclipse.sirius.diagram.description.EdgeMapping;
import org.eclipse.sirius.viewpoint.DSemanticDecorator;
import org.polarsys.capella.core.data.fa.AbstractFunction;
import org.polarsys.capella.core.data.fa.ExchangeCategory;
import org.polarsys.capella.core.data.fa.FunctionInputPort;
import org.polarsys.capella.core.data.fa.FunctionOutputPort;
import org.polarsys.capella.core.data.fa.FunctionPort;
import org.polarsys.capella.core.data.fa.FunctionalExchange;
import org.polarsys.capella.core.sirius.analysis.ABServices;
import org.polarsys.capella.core.sirius.analysis.DDiagramContents;
import org.polarsys.capella.core.sirius.analysis.constants.MappingConstantsHelper;
import org.polarsys.capella.core.sirius.analysis.showhide.AbstractShowHide;
import org.polarsys.capella.core.sirius.analysis.showhide.ShowHideFunctionalExchange;
import org.polarsys.capella.core.sirius.analysis.tool.HashMapSet;

public class ShowHideInvisibleExchangeCategory
extends ShowHideFunctionalExchange {
    public ShowHideInvisibleExchangeCategory(DDiagramContents content_p) {
        super(content_p);
    }

    @Override
    protected boolean isValidNodeView(DDiagramElement semanticView_p, DSemanticDecorator containerView_p) {
        return super.isValidNodeView(semanticView_p, containerView_p);
    }

    @Override
    protected boolean isValidSemanticView(EObject semantic_p, DSemanticDecorator semanticView_p, AbstractShowHide.DiagramContext context_p) {
        return super.isValidSemanticView(semantic_p, semanticView_p, context_p);
    }

    @Override
    protected boolean mustHide(DDiagramElement view_p, AbstractShowHide.DiagramContext context_p) {
        EObject target;
        if (view_p.getDiagramElementMapping() instanceof AbstractNodeMapping && (target = view_p.getTarget()) != null && (target instanceof FunctionPort || target instanceof ExchangeCategory)) {
            boolean result = true;
            if (result) {
                for (DEdge edge : ((EdgeTarget)view_p).getIncomingEdges()) {
                    if (!this.getContent().isVisible((DDiagramElement)edge)) continue;
                    result = false;
                    break;
                }
            }
            if (result) {
                for (DEdge edge : ((EdgeTarget)view_p).getOutgoingEdges()) {
                    if (!this.getContent().isVisible((DDiagramElement)edge)) continue;
                    result = false;
                    break;
                }
            }
            return result;
        }
        return super.mustHide(view_p, context_p);
    }

    @Override
    protected boolean mustShow(AbstractShowHide.ContextItemElement originCouple_p, AbstractShowHide.DiagramContext context_p, HashMapSet<String, DSemanticDecorator> relatedViews_p) {
        EObject semantic = originCouple_p.getValue();
        AbstractShowHide.ContextItemElement lastContext = context_p.getLast();
        if (semantic instanceof ExchangeCategory) {
            AbstractFunction source = (AbstractFunction)((Collection)context_p.getLastVariable("sourceParts").getValue()).iterator().next();
            AbstractFunction target = (AbstractFunction)((Collection)context_p.getLastVariable("targetParts").getValue()).iterator().next();
            ExchangeCategory category = (ExchangeCategory)semantic;
            if ("source".equals(lastContext.getKey())) {
                return ABServices.getService().isSourceTargetCategoryFunction(source, target, category);
            }
            if ("target".equals(lastContext.getKey())) {
                return ABServices.getService().isSourceTargetCategoryFunction(source, target, category);
            }
            return ABServices.getService().isSourceTargetCategoryFunction(source, target, category);
        }
        return super.mustShow(originCouple_p, context_p, relatedViews_p);
    }

    @Override
    public HashMapSet<String, EObject> getRelatedObjects(EObject semantic_p, AbstractShowHide.DiagramContext context_p) {
        HashMapSet<String, EObject> value = super.getRelatedObjects(semantic_p, context_p);
        AbstractShowHide.ContextItemElement lastContext = context_p.getLast();
        if (lastContext.getValue() instanceof ExchangeCategory) {
            if ("source".equals(lastContext.getKey()) && lastContext.getValue() instanceof ExchangeCategory) {
                AbstractShowHide.ContextItemVariable variable = context_p.getLastVariable("sourceParts");
                EObject container = this.getContainer((AbstractFunction)((Collection)variable.getValue()).iterator().next());
                if (container != null) {
                    value.put("container", container);
                }
            } else if ("target".equals(lastContext.getKey()) && lastContext.getValue() instanceof ExchangeCategory) {
                AbstractShowHide.ContextItemVariable variable = context_p.getLastVariable("targetParts");
                EObject container = this.getContainer((AbstractFunction)((Collection)variable.getValue()).iterator().next());
                if (container != null) {
                    value.put("container", container);
                }
            } else {
                value.put("source", semantic_p);
                value.put("target", semantic_p);
            }
        }
        return value;
    }

    private EObject getContainer(AbstractFunction abstractFunction) {
        if (abstractFunction != null && abstractFunction instanceof AbstractFunction && !this.getContent().getDiagramElements((EObject)abstractFunction).isEmpty()) {
            return abstractFunction;
        }
        return null;
    }

    @Override
    public DiagramElementMapping getMapping(EObject semantic_p, AbstractShowHide.DiagramContext context_p, HashMapSet<String, DSemanticDecorator> relatedViews_p) {
        DiagramElementMapping mapping = super.getMapping(semantic_p, context_p, relatedViews_p);
        AbstractShowHide.ContextItemElement lastContext = context_p.getLast();
        if (lastContext.getValue() instanceof ExchangeCategory) {
            if ("source".equals(lastContext.getKey())) {
                String mappingName = MappingConstantsHelper.getMappingFunctionalExchangeCategoryOutputPin(this.getContent().getDDiagram());
                mapping = this.getContent().getMapping(mappingName);
            } else if ("target".equals(lastContext.getKey())) {
                String mappingName = MappingConstantsHelper.getMappingFunctionalExchangeCategoryInputPin(this.getContent().getDDiagram());
                mapping = this.getContent().getMapping(mappingName);
            } else {
                String mappingName = MappingConstantsHelper.getMappingFunctionalExchangeCategory(this.getContent().getDDiagram());
                mapping = this.getContent().getMapping(mappingName);
            }
        }
        return mapping;
    }

    @Override
    protected boolean isValidEdgeView(DEdge edge_p, DSemanticDecorator sourceView_p, DSemanticDecorator targetView_p) {
        if (sourceView_p.equals(edge_p.getTargetNode()) && targetView_p.equals(edge_p.getSourceNode())) {
            String mappingName = MappingConstantsHelper.getMappingFunctionalExchangeCategory(this.getContent().getDDiagram());
            DiagramElementMapping categoryMapping = this.getContent().getMapping(mappingName);
            if (categoryMapping.equals(edge_p.getActualMapping())) {
                return true;
            }
        }
        return super.isValidEdgeView(edge_p, sourceView_p, targetView_p);
    }

    @Override
    protected Collection<DSemanticDecorator> retrieveDefaultContainer(EObject semantic_p, AbstractShowHide.DiagramContext context_p, Collection<DSemanticDecorator> targetViews_p) {
        return super.retrieveDefaultContainer(semantic_p, context_p, targetViews_p);
    }

    @Override
    protected boolean mustHide(AbstractShowHide.ContextItemElement originCouple_p, AbstractShowHide.DiagramContext context_p) {
        EObject semantic = originCouple_p.getValue();
        if (semantic instanceof AbstractFunction) {
            return false;
        }
        if (semantic instanceof FunctionalExchange) {
            return true;
        }
        if (semantic instanceof FunctionInputPort) {
            return true;
        }
        if (semantic instanceof FunctionOutputPort) {
            return true;
        }
        return semantic instanceof ExchangeCategory;
    }

    @Override
    protected boolean hideInsteadOfRemoveView(DDiagramElement element_p, AbstractShowHide.DiagramContext context_p) {
        EObject target = element_p.getTarget();
        if (target != null && (target instanceof FunctionalExchange || target instanceof FunctionPort)) {
            return this.getContent().getDDiagram().isSynchronized();
        }
        return super.hideInsteadOfRemoveView(element_p, context_p);
    }

    @Override
    protected Collection<DDiagramElement> showNodes(DSemanticDecorator containerView_p, EObject semantic_p, DDiagramContents content_p, AbstractNodeMapping mapping_p) {
        Collection<DDiagramElement> nodes = super.showNodes(containerView_p, semantic_p, content_p, mapping_p);
        if (semantic_p instanceof FunctionPort) {
            for (DDiagramElement element : nodes) {
                this.getContent().deferredShow(element);
            }
        }
        return nodes;
    }

    @Override
    protected Collection<DDiagramElement> showEdges(DSemanticDecorator source_p, DSemanticDecorator target_p, EObject exchange_p, DDiagramContents content_p, EdgeMapping edgeMapping_p) {
        Collection<DDiagramElement> nodes = super.showEdges(source_p, target_p, exchange_p, content_p, edgeMapping_p);
        if (exchange_p instanceof FunctionalExchange) {
            for (DDiagramElement element : nodes) {
                this.getContent().deferredShow(element);
            }
        }
        return nodes;
    }
}

