/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.core.sirius.analysis.showhide;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.sirius.diagram.DDiagramElement;
import org.eclipse.sirius.diagram.description.DiagramElementMapping;
import org.eclipse.sirius.viewpoint.DSemanticDecorator;
import org.polarsys.capella.common.data.modellingcore.IState;
import org.polarsys.capella.common.helpers.EObjectExt;
import org.polarsys.capella.core.data.capellacommon.CapellacommonPackage;
import org.polarsys.capella.core.data.capellacommon.Pseudostate;
import org.polarsys.capella.core.data.capellacommon.State;
import org.polarsys.capella.core.sirius.analysis.DDiagramContents;
import org.polarsys.capella.core.sirius.analysis.constants.MappingConstantsHelper;
import org.polarsys.capella.core.sirius.analysis.showhide.AbstractShowHide;
import org.polarsys.capella.core.sirius.analysis.tool.HashMapSet;

public class ShowHideSMStateMode
extends AbstractShowHide {
    public static final String CONTEXTUAL_CONTAINER = "CONTEXTUAL_CONTAINER";
    public static final String CONTEXTUAL_CONTAINER_VIEW = "CONTEXTUAL_CONTAINER_VIEW";
    private DDiagramContents content;

    public ShowHideSMStateMode(DDiagramContents content_p) {
        super(content_p);
        this.content = content_p;
    }

    @Override
    public HashMapSet<String, EObject> getRelatedObjects(EObject semantic_p, AbstractShowHide.DiagramContext context_p) {
        AbstractShowHide.ContextItemElement lastContext = context_p.getLast();
        HashMapSet<String, EObject> value = super.getRelatedObjects(semantic_p, context_p);
        EObject lastCtxValue = lastContext.getValue();
        ArrayList<EObject> result = new ArrayList<EObject>();
        if (lastCtxValue instanceof IState) {
            List referencers = EObjectExt.getReferencers((EObject)lastCtxValue, (EReference)CapellacommonPackage.Literals.REGION__INVOLVED_STATES);
            for (EObject s : referencers) {
                result.add(s.eContainer());
            }
        }
        value.putAll("container", result);
        return value;
    }

    @Override
    protected boolean mustHide(AbstractShowHide.ContextItemElement originCouple_p, AbstractShowHide.DiagramContext context_p) {
        AbstractShowHide.ContextItemElement item;
        EObject semantic = originCouple_p.getValue();
        if (semantic != (item = context_p.getLast("root")).getValue()) {
            return false;
        }
        return semantic instanceof IState;
    }

    @Override
    protected boolean mustHide(DDiagramElement view_p, AbstractShowHide.DiagramContext context_p) {
        return true;
    }

    @Override
    protected boolean isValidSemanticView(EObject semantic_p, DSemanticDecorator semanticView_p, AbstractShowHide.DiagramContext context_p) {
        AbstractShowHide.ContextItemElement element = context_p.getLast("root");
        if (element == null) {
            return true;
        }
        if (semantic_p != element.getValue() && semanticView_p instanceof DDiagramElement) {
            AbstractShowHide.ContextItemVariable clickedStateVar = context_p.getLastVariable(CONTEXTUAL_CONTAINER_VIEW);
            return semanticView_p == clickedStateVar.getValue() || EcoreUtil.isAncestor((EObject)((EObject)clickedStateVar.getValue()), (EObject)semanticView_p) || EcoreUtil.isAncestor((EObject)semanticView_p, (EObject)((EObject)clickedStateVar.getValue()));
        }
        return true;
    }

    @Override
    public DiagramElementMapping getMapping(EObject semantic_p, AbstractShowHide.DiagramContext context_p, HashMapSet<String, DSemanticDecorator> relatedViews_p) {
        DiagramElementMapping mapping = super.getMapping(semantic_p, context_p, relatedViews_p);
        Object containerViews = relatedViews_p.get("container");
        AbstractShowHide.ContextItemVariable clickedStateVar = context_p.getLastVariable(CONTEXTUAL_CONTAINER_VIEW);
        EObject eContainer = semantic_p.eContainer();
        EObject parent = eContainer.eContainer();
        if (!containerViews.isEmpty()) {
            parent = ((DSemanticDecorator)containerViews.iterator().next()).getTarget();
        }
        if (parent instanceof State && !containerViews.isEmpty()) {
            if (semantic_p instanceof State) {
                mapping = this.getContent().getMapping(MappingConstantsHelper.getMappingSMInnerStateMode(semantic_p, this.getContent().getDDiagram()));
            }
            if (semantic_p instanceof Pseudostate) {
                mapping = this.getContent().getMapping(MappingConstantsHelper.getMappingSMInnerPseudostate(semantic_p, this.getContent().getDDiagram()));
            }
        } else {
            if (semantic_p instanceof State) {
                mapping = this.getContent().getMapping(MappingConstantsHelper.getMappingSMStateMode(semantic_p, this.getContent().getDDiagram()));
            }
            if (semantic_p instanceof Pseudostate) {
                mapping = this.getContent().getMapping(MappingConstantsHelper.getMappingSMPseudostate(semantic_p, this.getContent().getDDiagram()));
            }
        }
        return mapping;
    }

    @Override
    protected Collection<DSemanticDecorator> retrieveDefaultContainer(EObject semantic_p, AbstractShowHide.DiagramContext context_p, Collection<DSemanticDecorator> targetViews_p) {
        if (semantic_p instanceof IState) {
            return Collections.singletonList((DSemanticDecorator)this.getContent().getDDiagram());
        }
        return super.retrieveDefaultContainer(semantic_p, context_p, targetViews_p);
    }
}

