/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.common.model.copypaste;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.Platform;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.edit.command.CopyCommand;
import org.eclipse.emf.edit.command.InitializeCopyCommand;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.polarsys.capella.common.model.copypaste.SharedCopyPasteElements;

public class SharedInitializeCopyCommand
extends InitializeCopyCommand {
    private static final String REFERENCE_NAME_ATTRIBUTE = "referenceName";
    private static final String PLUGIN_ID = "org.polarsys.capella.common.model.DroppedReferencesOnCopy";
    private static Map<PendingQualification, Object> pendingReferences = new HashMap<PendingQualification, Object>();
    private static List<String> droppedReferences = null;

    public SharedInitializeCopyCommand(EditingDomain domain, EObject owner, CopyCommand.Helper copyHelper) {
        super(domain, owner, copyHelper);
    }

    protected Collection<? extends EAttribute> getAttributesToCopy() {
        LinkedHashSet attributesToCopy = new LinkedHashSet(super.getAttributesToCopy());
        attributesToCopy.remove(this.owner.eClass().getEIDAttribute());
        return attributesToCopy;
    }

    protected void copyReferences() {
        block0: for (EReference reference : this.getReferencesToCopy()) {
            boolean copiedTargetRequired;
            if (this.isDroppedReference(reference) || !reference.isChangeable() || reference.isDerived() || !this.isReferenceSet(reference)) continue;
            EReference reverseReference = reference.getEOpposite();
            Object value = this.owner.eGet((EStructuralFeature)reference);
            if (value == null) {
                value = pendingReferences.get(new PendingQualification(this.owner, reference));
                if (value == null) {
                    this.copy.eSet((EStructuralFeature)reference, null);
                    continue;
                }
                this.copy.eSet((EStructuralFeature)reference, value);
                continue;
            }
            boolean bl = copiedTargetRequired = reverseReference != null || reference.isContainment();
            if (reference.isMany()) {
                List valueList = (List)value;
                EList copyList = (EList)this.copy.eGet((EStructuralFeature)reference);
                if (valueList.isEmpty()) {
                    copyList.clear();
                    continue;
                }
                int index = 0;
                for (EObject item : valueList) {
                    EObject target = this.copyHelper.getCopyTarget(item, copiedTargetRequired);
                    if (target == null) continue block0;
                    if (reverseReference != null) {
                        int position = copyList.indexOf((Object)target);
                        if (position == -1) {
                            copyList.add(index, (Object)target);
                        } else {
                            copyList.move(index, (Object)target);
                        }
                    } else {
                        copyList.add((Object)target);
                    }
                    ++index;
                }
                continue;
            }
            EObject target = this.copyHelper.getCopyTarget((EObject)value, copiedTargetRequired);
            if (target != null) {
                this.copy.eSet((EStructuralFeature)reference, (Object)target);
                continue;
            }
            pendingReferences.put(new PendingQualification(this.copy, reference), value);
        }
    }

    private boolean isDroppedReference(EReference reference) {
        if (droppedReferences == null) {
            this.loadDroppedReferences();
        }
        return droppedReferences.contains(reference.getName());
    }

    private void loadDroppedReferences() {
        IExtensionRegistry extensionRegistry = Platform.getExtensionRegistry();
        IConfigurationElement[] elementsForPlugin = extensionRegistry.getConfigurationElementsFor(PLUGIN_ID);
        droppedReferences = new ArrayList<String>(elementsForPlugin.length);
        IConfigurationElement[] iConfigurationElementArray = elementsForPlugin;
        int n = elementsForPlugin.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement configurationElement = iConfigurationElementArray[n2];
            String refName = configurationElement.getAttribute(REFERENCE_NAME_ATTRIBUTE);
            droppedReferences.add(refName);
            ++n2;
        }
    }

    public void doExecute() {
        super.doExecute();
        SharedCopyPasteElements.getInstance().put(this.copy, this.owner);
    }

    private boolean isReferenceSet(EReference reference) {
        PendingQualification pq = new PendingQualification(this.owner, reference);
        return this.owner.eIsSet((EStructuralFeature)reference) || pendingReferences.containsKey(pq);
    }

    public class PendingQualification {
        private EObject src;
        private EReference reference;

        public PendingQualification(EObject src, EReference reference) {
            this.src = src;
            this.reference = reference;
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof PendingQualification)) {
                return false;
            }
            PendingQualification other = (PendingQualification)obj;
            return this.src.equals(other.src) && this.reference.equals(other.reference);
        }

        public int hashCode() {
            return this.src.hashCode() + this.reference.hashCode();
        }
    }
}

