/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.common.platform.sirius.ted;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.URIConverter;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.sirius.business.api.session.Session;
import org.eclipse.sirius.business.api.session.factory.SessionFactory;
import org.eclipse.sirius.business.internal.movida.Movida;
import org.eclipse.sirius.business.internal.movida.registry.ViewpointRegistry;
import org.eclipse.sirius.business.internal.movida.registry.ViewpointURIConverter;
import org.eclipse.sirius.business.internal.session.SessionFactoryImpl;
import org.eclipse.sirius.business.internal.session.danalysis.DAnalysisSessionImpl;
import org.eclipse.sirius.viewpoint.DAnalysis;
import org.polarsys.capella.common.ef.ExecutionManagerRegistry;
import org.polarsys.capella.common.ef.command.AbstractReadWriteCommand;
import org.polarsys.capella.common.ef.command.ICommand;
import org.polarsys.capella.common.mdsofa.common.helper.ExtensionPointHelper;
import org.polarsys.capella.common.platform.sirius.ted.IDerivedSemanticResourceProvider;
import org.polarsys.capella.common.platform.sirius.ted.MetadataException;
import org.polarsys.capella.common.platform.sirius.ted.NoMetadataException;
import org.polarsys.capella.common.platform.sirius.ted.PlatformSiriusTedActivator;
import org.polarsys.capella.common.platform.sirius.ted.WrongCapellaVersionException;
import org.polarsys.kitalpha.ad.metadata.helpers.MetadataHelper;
import org.polarsys.kitalpha.ad.services.manager.ViewpointManager;

public class SiriusSessionFactory
extends SessionFactoryImpl
implements SessionFactory {
    protected void configureDomain(TransactionalEditingDomain transactionalEditingDomain, URI sessionResourceUri) {
        if (Movida.isEnabled()) {
            transactionalEditingDomain.getResourceSet().setURIConverter((URIConverter)new ViewpointURIConverter((ViewpointRegistry)org.eclipse.sirius.business.api.componentization.ViewpointRegistry.getInstance()));
        }
    }

    protected Session createSession(DAnalysis analysis, final TransactionalEditingDomain transactionalEditingDomain) {
        return new DAnalysisSessionImpl(analysis){

            public Collection<Resource> getSemanticResources() {
                ArrayList<Resource> semanticResources = new ArrayList<Resource>(super.getSemanticResources());
                semanticResources.addAll(new DerivedResourcesHelper().getDerivedSemanticResources(transactionalEditingDomain, semanticResources));
                return Collections.unmodifiableCollection(semanticResources);
            }
        };
    }

    protected void checkResource(URI sessionResourceURI, ResourceSet resourceSet) {
        new SessionMetadataHelper().checkMetadata(sessionResourceURI, resourceSet);
    }

    protected void createAdditionalResources(Collection<Resource> additionalResources, TransactionalEditingDomain transactionalEditingDomain, URI sessionResourceURI, IProgressMonitor monitor) {
        Resource metadataResource = new SessionMetadataHelper().createMetadataResource(transactionalEditingDomain, sessionResourceURI, monitor);
        if (metadataResource != null) {
            additionalResources.add(metadataResource);
        }
    }

    protected void completeSessionCreation(Session session, Collection<Resource> additionalResources, IProgressMonitor monitor) {
        if (additionalResources.size() == 1) {
            new SessionMetadataHelper().registerMetadataResource(additionalResources.iterator().next(), session, monitor);
        }
    }

    public static class DerivedResourcesHelper {
        private static List<IDerivedSemanticResourceProvider> _derivedSemanticResourceProviders;
        private static final String DERIVED_SEMANTIC_RESOURCE_PROVIDER_EXTENSION_ID = "derivedSemanticResourceProvider";

        public Collection<Resource> getDerivedSemanticResources(TransactionalEditingDomain editingDomain, Collection<Resource> nonDerivedSemanticResources) {
            ArrayList<Resource> derivedSemanticResources = new ArrayList<Resource>();
            for (IDerivedSemanticResourceProvider provider : this.getAllDerivedSemanticResourceProviders()) {
                for (Resource resource : provider.getDerivedSemanticResources(editingDomain)) {
                    if (nonDerivedSemanticResources.contains(resource) || derivedSemanticResources.contains(resource)) continue;
                    derivedSemanticResources.add(resource);
                }
            }
            return derivedSemanticResources;
        }

        protected List<IDerivedSemanticResourceProvider> getAllDerivedSemanticResourceProviders() {
            if (_derivedSemanticResourceProviders == null) {
                _derivedSemanticResourceProviders = new ArrayList<IDerivedSemanticResourceProvider>();
                List<IConfigurationElement> BQProvider = Arrays.asList(ExtensionPointHelper.getConfigurationElements((String)PlatformSiriusTedActivator.getDefault().getPluginId(), (String)DERIVED_SEMANTIC_RESOURCE_PROVIDER_EXTENSION_ID));
                for (IConfigurationElement configurationElement : BQProvider) {
                    IDerivedSemanticResourceProvider contrib = (IDerivedSemanticResourceProvider)ExtensionPointHelper.createInstance((IConfigurationElement)configurationElement, (String)"class");
                    if (contrib == null) continue;
                    _derivedSemanticResourceProviders.add(contrib);
                }
            }
            return _derivedSemanticResourceProviders;
        }
    }

    public static class SessionMetadataHelper {
        public void checkMetadata(URI sessionResourceURI, ResourceSet set) {
            if (sessionResourceURI.isPlatform() && SessionMetadataHelper.isCapellaProject(sessionResourceURI)) {
                if (!ViewpointManager.getInstance((ResourceSet)set).hasMetadata()) {
                    throw new NoMetadataException(MetadataHelper.getViewpointMetadata((ResourceSet)set).getExpectedMetadataStorageURI().toPlatformString(true));
                }
                IStatus result = ViewpointManager.checkViewpointsCompliancy((ResourceSet)set);
                if (!result.isOK()) {
                    IStatus capella = ViewpointManager.checkViewpointCompliancy((ResourceSet)set, (String)"org.polarsys.capella.core.viewpoint");
                    if (!capella.isOK()) {
                        throw new WrongCapellaVersionException(capella);
                    }
                    throw new MetadataException(result);
                }
            }
        }

        public void registerMetadataResource(Resource resource, final Session session, final IProgressMonitor monitor) {
            if (resource != null && session != null) {
                final URI metadataResourceURI = resource.getURI();
                ExecutionManagerRegistry.getInstance().getExecutionManager((EditingDomain)session.getTransactionalEditingDomain()).execute((ICommand)new AbstractReadWriteCommand(){

                    public void run() {
                        session.addSemanticResource(metadataResourceURI, monitor);
                    }
                });
            }
        }

        public Resource createMetadataResource(TransactionalEditingDomain domain, URI resourceURI, IProgressMonitor monitor) {
            SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)2);
            try {
                if (!SessionMetadataHelper.isCapellaProject(resourceURI)) {
                    return null;
                }
                URI uri = resourceURI.trimFileExtension().appendFileExtension("afm");
                progress.beginTask("Create an empty metadata resource", 1);
                Resource resource = MetadataHelper.getViewpointMetadata((ResourceSet)domain.getResourceSet()).initMetadataStorage(uri);
                progress.worked(1);
                try {
                    progress.beginTask("Save metadata model", 1);
                    resource.save(Collections.emptyMap());
                }
                catch (Exception exception) {
                    // empty catch block
                }
                progress.worked(1);
                Resource resource2 = resource;
                return resource2;
            }
            finally {
                progress.done();
            }
        }

        protected static boolean isCapellaProject(URI uri) {
            try {
                if (uri.isPlatformResource()) {
                    IFile file = ResourcesPlugin.getWorkspace().getRoot().getFile((IPath)new Path(uri.toPlatformString(true)));
                    IProject project = file.getProject();
                    return project.hasNature("org.polarsys.capella.project.nature") || project.hasNature("org.polarsys.capella.library.nature");
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            return false;
        }
    }
}

