/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.internal.ccvs.core.resources;

import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.team.core.TeamException;
import org.eclipse.team.core.variants.CachedResourceVariant;
import org.eclipse.team.internal.ccvs.core.CVSException;
import org.eclipse.team.internal.ccvs.core.CVSTag;
import org.eclipse.team.internal.ccvs.core.ICVSFolder;
import org.eclipse.team.internal.ccvs.core.ICVSRemoteFolder;
import org.eclipse.team.internal.ccvs.core.ICVSRemoteResource;
import org.eclipse.team.internal.ccvs.core.ICVSRepositoryLocation;
import org.eclipse.team.internal.ccvs.core.resources.RemoteFolder;
import org.eclipse.team.internal.ccvs.core.syncinfo.ResourceSyncInfo;
import org.eclipse.team.internal.ccvs.core.util.Util;

public abstract class RemoteResource
extends CachedResourceVariant
implements ICVSRemoteResource {
    protected RemoteFolder parent;
    protected String name;
    private int workspaceSyncState = 0;

    public RemoteResource(RemoteFolder parent, String name) {
        this.parent = parent;
        this.name = name;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getRelativePath(ICVSFolder ancestor) throws CVSException {
        return Util.appendPath(this.parent.getRelativePath(ancestor), this.getName());
    }

    @Override
    public ICVSRemoteResource getRemoteParent() {
        return this.parent;
    }

    @Override
    public abstract String getRepositoryRelativePath();

    @Override
    public abstract ICVSRepositoryLocation getRepository();

    public int getWorkspaceSyncState() {
        return this.workspaceSyncState;
    }

    public void setWorkspaceSyncState(int workspaceSyncState) {
        this.workspaceSyncState = workspaceSyncState;
    }

    @Override
    public void delete() {
    }

    @Override
    public boolean exists() {
        return true;
    }

    @Override
    public boolean exists(IProgressMonitor monitor) throws TeamException {
        return this.parent.exists(this, monitor);
    }

    @Override
    public ICVSFolder getParent() {
        return this.parent;
    }

    @Override
    public boolean isIgnored() {
        return false;
    }

    @Override
    public boolean isManaged() {
        return this.parent != null;
    }

    @Override
    public boolean isModified(IProgressMonitor monitor) throws CVSException {
        return true;
    }

    @Override
    public void unmanage(IProgressMonitor monitor) throws CVSException {
    }

    @Override
    public abstract ResourceSyncInfo getSyncInfo();

    @Override
    public boolean equals(Object target) {
        if (this == target) {
            return true;
        }
        if (!(target instanceof RemoteResource)) {
            return false;
        }
        RemoteResource remote = (RemoteResource)target;
        return remote.isContainer() == this.isContainer() && remote.getRepository().equals(this.getRepository()) && remote.getRepositoryRelativePath().equals(this.getRepositoryRelativePath());
    }

    @Override
    public void setIgnoredAs(String pattern) throws CVSException {
        Assert.isTrue((boolean)false);
    }

    @Override
    public IResource getIResource() {
        return null;
    }

    public abstract ICVSRemoteResource forTag(ICVSRemoteFolder var1, CVSTag var2);

    public int hashCode() {
        return this.getRepositoryRelativePath().hashCode();
    }

    public abstract byte[] getSyncBytes();

    public String toString() {
        return "Remote " + (this.isContainer() ? "Folder: " : "File: ") + this.getName();
    }

    public String getCachePath() {
        ICVSRepositoryLocation location = this.getRepository();
        Path path = new Path(null, location.getHost());
        path = path.append(location.getRootDirectory());
        path = path.append(this.parent.getRepositoryRelativePath());
        path = path.append(String.valueOf(this.getName()) + ' ' + this.getContentIdentifier());
        return path.toString();
    }

    protected String getCacheId() {
        return "org.eclipse.team.cvs.core";
    }

    public byte[] asBytes() {
        return this.getSyncBytes();
    }
}

