/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.common.flexibility.properties.property;

import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.preferences.IScopeContext;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.polarsys.capella.common.flexibility.properties.property.AbstractProperty;
import org.polarsys.capella.common.flexibility.properties.property.IDefaultValueProperty;
import org.polarsys.capella.common.flexibility.properties.schema.IPropertyContext;
import org.polarsys.capella.common.flexibility.properties.schema.PropertiesSchemaConstants;

public class BooleanDefaultValueProperty
extends AbstractProperty
implements IDefaultValueProperty {
    @Override
    public Object getType() {
        return Boolean.class;
    }

    public IScopeContext getScope() {
        return InstanceScope.INSTANCE;
    }

    @Override
    public Object getValue(IPropertyContext context) {
        String argument = this.getParameter(PropertiesSchemaConstants.PropertiesSchema_PROPERTY_PREFERENCE__DEFAULT);
        return Boolean.valueOf(argument);
    }

    @Override
    public Object toType(Object value, IPropertyContext context) {
        Boolean result = Boolean.TRUE;
        try {
            if (value instanceof Boolean) {
                result = (Boolean)value;
            } else if (value instanceof String) {
                result = Boolean.valueOf((String)value);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return result;
    }

    @Override
    public IStatus validate(Object newValue, IPropertyContext context) {
        if (newValue == null) {
            return Status.CANCEL_STATUS;
        }
        return Status.OK_STATUS;
    }

    @Override
    public Object getDefaultValue(IPropertyContext context) {
        String argument = this.getParameter(PropertiesSchemaConstants.PropertiesSchema_PROPERTY_PREFERENCE__DEFAULT);
        return (boolean)((Boolean)this.toType(argument, context));
    }
}

