/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.common.flexibility.properties.property;

import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.polarsys.capella.common.flexibility.properties.property.IDefaultValueProperty;
import org.polarsys.capella.common.flexibility.properties.property.PropertyPreference;
import org.polarsys.capella.common.flexibility.properties.schema.IPropertyContext;
import org.polarsys.capella.common.flexibility.properties.schema.PropertiesSchemaConstants;

public class StringPropertyPreference
extends PropertyPreference
implements IDefaultValueProperty {
    @Override
    public Object getType() {
        return String.class;
    }

    @Override
    public Object getDefaultValue(IPropertyContext context) {
        String argument = this.getParameter(PropertiesSchemaConstants.PropertiesSchema_PROPERTY_PREFERENCE__DEFAULT);
        return this.toType(argument, context);
    }

    @Override
    public IStatus validate(Object newValue, IPropertyContext context) {
        try {
            if (newValue != null) {
                String value = String.valueOf(newValue);
                String validOnEmpty = this.getParameter(PropertiesSchemaConstants.PropertiesSchema_STRING_PROPERTY__EMPTY_IS_VALID);
                if (validOnEmpty != null && "false".equals(validOnEmpty) && value.length() == 0) {
                    return new Status(4, this.getId(), "Empty value isn't valid");
                }
            }
            return Status.OK_STATUS;
        }
        catch (Exception e) {
            return new Status(4, this.getId(), e.getMessage());
        }
    }
}

