/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.core.model.skeleton.helpers;

import java.util.Collection;
import java.util.Collections;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.command.CommandWrapper;
import org.eclipse.emf.common.command.CompoundCommand;
import org.eclipse.emf.common.command.IdentityCommand;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.edit.command.CommandParameter;
import org.eclipse.emf.edit.command.CreateChildCommand;
import org.eclipse.emf.edit.command.SetCommand;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.polarsys.capella.common.data.modellingcore.AbstractNamedElement;
import org.polarsys.capella.common.data.modellingcore.ModellingcorePackage;
import org.polarsys.capella.core.data.capellacore.CapellacorePackage;
import org.polarsys.capella.core.data.capellacore.ModellingArchitecture;
import org.polarsys.capella.core.data.capellamodeller.SystemEngineering;
import org.polarsys.capella.core.data.cs.BlockArchitecture;
import org.polarsys.capella.core.data.cs.CsFactory;
import org.polarsys.capella.core.data.ctx.System;
import org.polarsys.capella.core.data.ctx.SystemAnalysis;
import org.polarsys.capella.core.data.ctx.SystemFunction;
import org.polarsys.capella.core.data.ctx.SystemFunctionPkg;
import org.polarsys.capella.core.data.fa.FaPackage;
import org.polarsys.capella.core.data.la.LaFactory;
import org.polarsys.capella.core.data.la.LaPackage;
import org.polarsys.capella.core.data.la.LogicalArchitecture;
import org.polarsys.capella.core.model.helpers.naming.NamingConstants;
import org.polarsys.capella.core.model.skeleton.helpers.CommonStructureHelper;

public class LAStructureHelper {
    public static SystemAnalysis getSystemAnalysis(SystemEngineering systemEngineering_p) {
        if (systemEngineering_p != null) {
            for (ModellingArchitecture arch : systemEngineering_p.getOwnedArchitectures()) {
                if (!(arch instanceof SystemAnalysis)) continue;
                return (SystemAnalysis)arch;
            }
        }
        return null;
    }

    public static SystemFunction getRootSystemFunction(SystemEngineering systemEngineering_p) {
        SystemFunctionPkg functionPkg;
        SystemAnalysis systemAnalysis = LAStructureHelper.getSystemAnalysis(systemEngineering_p);
        if (systemAnalysis != null && (functionPkg = (SystemFunctionPkg)systemAnalysis.getOwnedFunctionPkg()) != null && !functionPkg.getOwnedSystemFunctions().isEmpty()) {
            return (SystemFunction)functionPkg.getOwnedSystemFunctions().get(0);
        }
        return null;
    }

    public static System getRootSystem(SystemEngineering systemEngineering_p) {
        SystemAnalysis systemAnalysis = LAStructureHelper.getSystemAnalysis(systemEngineering_p);
        if (systemAnalysis != null) {
            return systemAnalysis.getOwnedSystem();
        }
        return null;
    }

    public static Command getLogicalArchitectureCreationCmd(final EditingDomain editingDomain_p, final SystemEngineering systemEngineering_p) {
        CompoundCommand cmd = new CompoundCommand();
        final Command createLogicalArchitectureCmd = CreateChildCommand.create((EditingDomain)editingDomain_p, (Object)systemEngineering_p, (Object)new CommandParameter((Object)systemEngineering_p, (Object)CapellacorePackage.Literals.ABSTRACT_MODELLING_STRUCTURE__OWNED_ARCHITECTURES, (Object)LaFactory.eINSTANCE.createLogicalArchitecture(NamingConstants.CreateLogicalArchCmd_name)), (Collection)Collections.EMPTY_LIST);
        cmd.append(createLogicalArchitectureCmd);
        CommandWrapper createLogicalArchitectureContentCmd = new CommandWrapper(){

            public Command createCommand() {
                Object createdLogicalArchitecture;
                Collection res = createLogicalArchitectureCmd.getResult();
                if (res.size() == 1 && (createdLogicalArchitecture = res.iterator().next()) instanceof LogicalArchitecture) {
                    return LAStructureHelper.getLogicalArchitectureCreationCmd(editingDomain_p, systemEngineering_p, (LogicalArchitecture)createdLogicalArchitecture);
                }
                return new IdentityCommand();
            }
        };
        cmd.append((Command)createLogicalArchitectureContentCmd);
        return cmd;
    }

    public static Command getLogicalArchitectureCreationCmd(EditingDomain editingDomain_p, SystemEngineering systemEngineering_p, LogicalArchitecture logicalArchitecture_p) {
        CompoundCommand cmd = new CompoundCommand();
        SystemAnalysis systemAnalysis = LAStructureHelper.getSystemAnalysis(systemEngineering_p);
        cmd.append(CommonStructureHelper.getLinkCreationCmd(editingDomain_p, LaPackage.Literals.SYSTEM_ANALYSIS_REALIZATION, LaPackage.Literals.LOGICAL_ARCHITECTURE__OWNED_SYSTEM_ANALYSIS_REALIZATIONS, ModellingcorePackage.Literals.ABSTRACT_TRACE__SOURCE_ELEMENT, (EObject)logicalArchitecture_p, ModellingcorePackage.Literals.ABSTRACT_TRACE__TARGET_ELEMENT, (EObject)systemAnalysis));
        cmd.append(CommonStructureHelper.getRequirementPkgCreationCmd(editingDomain_p, (BlockArchitecture)logicalArchitecture_p));
        cmd.append(LAStructureHelper.getLogicalFunctionPkgCreationCmd(editingDomain_p, systemEngineering_p, logicalArchitecture_p));
        cmd.append(CommonStructureHelper.getCapabilityRealizationPkgCreationCmd(editingDomain_p, (BlockArchitecture)logicalArchitecture_p));
        cmd.append(CommonStructureHelper.getInterfacePkgCreationCmd(editingDomain_p, (BlockArchitecture)logicalArchitecture_p));
        cmd.append(CommonStructureHelper.getDataPkgCreationCmd(editingDomain_p, (BlockArchitecture)logicalArchitecture_p));
        cmd.append(LAStructureHelper.getLogicalActorPkgCreationCmd(editingDomain_p, logicalArchitecture_p));
        cmd.append(LAStructureHelper.getRootLogicalComponentCreationCmd(editingDomain_p, systemEngineering_p, logicalArchitecture_p));
        return cmd;
    }

    public static Command getRootLogicalComponentCreationCmd(final EditingDomain editingDomain_p, final SystemEngineering systemEngineering_p, LogicalArchitecture logicalArchitecture_p) {
        CompoundCommand cmd = new CompoundCommand();
        final Command createLogicalContextCmd = CreateChildCommand.create((EditingDomain)editingDomain_p, (Object)logicalArchitecture_p, (Object)new CommandParameter((Object)logicalArchitecture_p, (Object)LaPackage.Literals.LOGICAL_ARCHITECTURE__OWNED_LOGICAL_CONTEXT, (Object)LaFactory.eINSTANCE.createLogicalContext(NamingConstants.CreateLogicalArchCmd_logicalContext_name)), (Collection)Collections.EMPTY_LIST);
        cmd.append(createLogicalContextCmd);
        final Command createLogicalComponentCmd = CreateChildCommand.create((EditingDomain)editingDomain_p, (Object)logicalArchitecture_p, (Object)new CommandParameter((Object)logicalArchitecture_p, (Object)LaPackage.Literals.LOGICAL_ARCHITECTURE__OWNED_LOGICAL_COMPONENT, (Object)LaFactory.eINSTANCE.createLogicalComponent(NamingConstants.CreateLogicalArchCmd_logicalComponent_name)), (Collection)Collections.EMPTY_LIST);
        cmd.append(createLogicalComponentCmd);
        CommandWrapper createSystemRealizationCmd = new CommandWrapper(){

            public Command createCommand() {
                Object createdLogicalComponent;
                Collection res = createLogicalComponentCmd.getResult();
                if (res.size() == 1 && (createdLogicalComponent = res.iterator().next()) instanceof EObject) {
                    System rootSystem = LAStructureHelper.getRootSystem(systemEngineering_p);
                    return CommonStructureHelper.getLinkCreationCmd(editingDomain_p, LaPackage.Literals.SYSTEM_REALIZATION, LaPackage.Literals.LOGICAL_COMPONENT__OWNED_SYSTEM_REALIZATIONS, ModellingcorePackage.Literals.ABSTRACT_TRACE__SOURCE_ELEMENT, (EObject)createdLogicalComponent, ModellingcorePackage.Literals.ABSTRACT_TRACE__TARGET_ELEMENT, (EObject)rootSystem);
                }
                return new IdentityCommand();
            }
        };
        cmd.append((Command)createSystemRealizationCmd);
        CommandWrapper createPartCmd = new CommandWrapper(){

            public Command createCommand() {
                Object createdContext;
                Collection res = createLogicalContextCmd.getResult();
                if (res.size() == 1 && (createdContext = res.iterator().next()) instanceof EObject) {
                    return CreateChildCommand.create((EditingDomain)editingDomain_p, createdContext, (Object)new CommandParameter(createdContext, (Object)CapellacorePackage.Literals.CLASSIFIER__OWNED_FEATURES, (Object)CsFactory.eINSTANCE.createPart()), (Collection)Collections.EMPTY_LIST);
                }
                return new IdentityCommand();
            }
        };
        cmd.append((Command)createPartCmd);
        CommandWrapper setPartNameCmd = new CommandWrapper((Command)createPartCmd, createLogicalComponentCmd, editingDomain_p){
            private final /* synthetic */ Command val$createPartCmd;
            private final /* synthetic */ Command val$createLogicalComponentCmd;
            private final /* synthetic */ EditingDomain val$editingDomain_p;
            {
                this.val$createPartCmd = command;
                this.val$createLogicalComponentCmd = command2;
                this.val$editingDomain_p = editingDomain;
            }

            public Command createCommand() {
                Collection res1 = this.val$createPartCmd.getResult();
                Collection res2 = this.val$createLogicalComponentCmd.getResult();
                if (res1.size() == 1 && res2.size() == 1) {
                    Object createdPart = res1.iterator().next();
                    Object createdLogicalComponent = res2.iterator().next();
                    if (createdPart instanceof EObject && createdLogicalComponent instanceof EObject) {
                        return new SetCommand(this.val$editingDomain_p, (EObject)createdPart, (EStructuralFeature)ModellingcorePackage.Literals.ABSTRACT_NAMED_ELEMENT__NAME, (Object)((AbstractNamedElement)createdLogicalComponent).getName());
                    }
                }
                return new IdentityCommand();
            }
        };
        cmd.append((Command)setPartNameCmd);
        CommandWrapper setPartTypeCmd = new CommandWrapper((Command)createPartCmd, createLogicalComponentCmd, editingDomain_p){
            private final /* synthetic */ Command val$createPartCmd;
            private final /* synthetic */ Command val$createLogicalComponentCmd;
            private final /* synthetic */ EditingDomain val$editingDomain_p;
            {
                this.val$createPartCmd = command;
                this.val$createLogicalComponentCmd = command2;
                this.val$editingDomain_p = editingDomain;
            }

            public Command createCommand() {
                Collection res1 = this.val$createPartCmd.getResult();
                Collection res2 = this.val$createLogicalComponentCmd.getResult();
                if (res1.size() == 1 && res2.size() == 1) {
                    Object createdPart = res1.iterator().next();
                    Object createdLogicalComponent = res2.iterator().next();
                    if (createdPart instanceof EObject && createdLogicalComponent instanceof EObject) {
                        return new SetCommand(this.val$editingDomain_p, (EObject)createdPart, (EStructuralFeature)ModellingcorePackage.Literals.ABSTRACT_TYPED_ELEMENT__ABSTRACT_TYPE, createdLogicalComponent);
                    }
                }
                return new IdentityCommand();
            }
        };
        cmd.append((Command)setPartTypeCmd);
        return cmd;
    }

    public static Command getLogicalActorPkgCreationCmd(EditingDomain editingDomain_p, LogicalArchitecture logicalArchitecture_p) {
        return CreateChildCommand.create((EditingDomain)editingDomain_p, (Object)logicalArchitecture_p, (Object)new CommandParameter((Object)logicalArchitecture_p, (Object)LaPackage.Literals.LOGICAL_ARCHITECTURE__OWNED_LOGICAL_ACTOR_PKG, (Object)LaFactory.eINSTANCE.createLogicalActorPkg(NamingConstants.CreateLogicalArchCmd_actors_pkg_name)), (Collection)Collections.EMPTY_LIST);
    }

    public static Command getLogicalFunctionPkgCreationCmd(final EditingDomain editingDomain_p, SystemEngineering systemEngineering_p, LogicalArchitecture logicalArchitecture_p) {
        CompoundCommand cmd = new CompoundCommand();
        final Command createLogicalFunctionPkgCmd = CreateChildCommand.create((EditingDomain)editingDomain_p, (Object)logicalArchitecture_p, (Object)new CommandParameter((Object)logicalArchitecture_p, (Object)FaPackage.Literals.ABSTRACT_FUNCTIONAL_ARCHITECTURE__OWNED_FUNCTION_PKG, (Object)LaFactory.eINSTANCE.createLogicalFunctionPkg(NamingConstants.CreateLogicalArchCmd_logicalFunctions_pkg_name)), (Collection)Collections.EMPTY_LIST);
        cmd.append(createLogicalFunctionPkgCmd);
        CommandWrapper createLogicalFunctionCmd = new CommandWrapper(){

            public Command createCommand() {
                Object createdLogicalFunctionPkg;
                Collection res = createLogicalFunctionPkgCmd.getResult();
                if (res.size() == 1 && (createdLogicalFunctionPkg = res.iterator().next()) instanceof EObject) {
                    return CreateChildCommand.create((EditingDomain)editingDomain_p, createdLogicalFunctionPkg, (Object)new CommandParameter(createdLogicalFunctionPkg, (Object)LaPackage.Literals.LOGICAL_FUNCTION_PKG__OWNED_LOGICAL_FUNCTIONS, (Object)LaFactory.eINSTANCE.createLogicalFunction(NamingConstants.CreateLogicalArchCmd_logicalFunction_root_name)), (Collection)Collections.EMPTY_LIST);
                }
                return new IdentityCommand();
            }
        };
        cmd.append((Command)createLogicalFunctionCmd);
        CommandWrapper createSystemFunctionRealizationCmd = new CommandWrapper((Command)createLogicalFunctionCmd, systemEngineering_p, editingDomain_p){
            private final /* synthetic */ Command val$createLogicalFunctionCmd;
            private final /* synthetic */ SystemEngineering val$systemEngineering_p;
            private final /* synthetic */ EditingDomain val$editingDomain_p;
            {
                this.val$createLogicalFunctionCmd = command;
                this.val$systemEngineering_p = systemEngineering;
                this.val$editingDomain_p = editingDomain;
            }

            public Command createCommand() {
                Object createdLogicalFunction;
                Collection res = this.val$createLogicalFunctionCmd.getResult();
                if (res.size() == 1 && (createdLogicalFunction = res.iterator().next()) instanceof EObject) {
                    SystemFunction rootSystemFunction = LAStructureHelper.getRootSystemFunction(this.val$systemEngineering_p);
                    return CommonStructureHelper.getLinkCreationCmd(this.val$editingDomain_p, FaPackage.Literals.FUNCTION_REALIZATION, FaPackage.Literals.ABSTRACT_FUNCTION__OWNED_FUNCTION_REALIZATIONS, ModellingcorePackage.Literals.ABSTRACT_TRACE__SOURCE_ELEMENT, (EObject)createdLogicalFunction, ModellingcorePackage.Literals.ABSTRACT_TRACE__TARGET_ELEMENT, (EObject)rootSystemFunction);
                }
                return new IdentityCommand();
            }
        };
        cmd.append((Command)createSystemFunctionRealizationCmd);
        return cmd;
    }
}

