/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.core.model.skeleton.helpers;

import java.util.Collection;
import java.util.Collections;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.command.CommandWrapper;
import org.eclipse.emf.common.command.CompoundCommand;
import org.eclipse.emf.common.command.IdentityCommand;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.edit.command.CommandParameter;
import org.eclipse.emf.edit.command.CreateChildCommand;
import org.eclipse.emf.edit.command.SetCommand;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.polarsys.capella.common.data.modellingcore.AbstractNamedElement;
import org.polarsys.capella.common.data.modellingcore.ModellingcorePackage;
import org.polarsys.capella.core.data.capellacore.CapellacorePackage;
import org.polarsys.capella.core.data.capellacore.ModellingArchitecture;
import org.polarsys.capella.core.data.capellamodeller.SystemEngineering;
import org.polarsys.capella.core.data.cs.BlockArchitecture;
import org.polarsys.capella.core.data.cs.CsFactory;
import org.polarsys.capella.core.data.fa.FaPackage;
import org.polarsys.capella.core.data.la.LogicalArchitecture;
import org.polarsys.capella.core.data.la.LogicalComponent;
import org.polarsys.capella.core.data.la.LogicalFunction;
import org.polarsys.capella.core.data.la.LogicalFunctionPkg;
import org.polarsys.capella.core.data.pa.PaFactory;
import org.polarsys.capella.core.data.pa.PaPackage;
import org.polarsys.capella.core.data.pa.PhysicalArchitecture;
import org.polarsys.capella.core.model.helpers.naming.NamingConstants;
import org.polarsys.capella.core.model.skeleton.helpers.CommonStructureHelper;

public class PAStructureHelper {
    public static LogicalArchitecture getLogicalArchitecture(SystemEngineering systemEngineering_p) {
        if (systemEngineering_p != null) {
            for (ModellingArchitecture arch : systemEngineering_p.getOwnedArchitectures()) {
                if (!(arch instanceof LogicalArchitecture)) continue;
                return (LogicalArchitecture)arch;
            }
        }
        return null;
    }

    public static LogicalFunction getRootLogicalFunction(SystemEngineering systemEngineering_p) {
        LogicalFunctionPkg functionPkg;
        LogicalArchitecture logicalArchitecture = PAStructureHelper.getLogicalArchitecture(systemEngineering_p);
        if (logicalArchitecture != null && (functionPkg = (LogicalFunctionPkg)logicalArchitecture.getOwnedFunctionPkg()) != null && !functionPkg.getOwnedLogicalFunctions().isEmpty()) {
            return (LogicalFunction)functionPkg.getOwnedLogicalFunctions().get(0);
        }
        return null;
    }

    public static LogicalComponent getRootLogicalComponent(SystemEngineering systemEngineering_p) {
        LogicalArchitecture logicalArchitecture = PAStructureHelper.getLogicalArchitecture(systemEngineering_p);
        if (logicalArchitecture != null) {
            return logicalArchitecture.getOwnedLogicalComponent();
        }
        return null;
    }

    public static Command getPhysicalArchitectureCreationCmd(final EditingDomain editingDomain_p, final SystemEngineering systemEngineering_p) {
        CompoundCommand cmd = new CompoundCommand();
        final Command createPhysicalArchitectureCmd = CreateChildCommand.create((EditingDomain)editingDomain_p, (Object)systemEngineering_p, (Object)new CommandParameter((Object)systemEngineering_p, (Object)CapellacorePackage.Literals.ABSTRACT_MODELLING_STRUCTURE__OWNED_ARCHITECTURES, (Object)PaFactory.eINSTANCE.createPhysicalArchitecture(NamingConstants.CreatePhysicalArchCmd_name)), (Collection)Collections.EMPTY_LIST);
        cmd.append(createPhysicalArchitectureCmd);
        CommandWrapper createPhysicalArchitectureContentCmd = new CommandWrapper(){

            public Command createCommand() {
                Object createdPhysicalArchitecture;
                Collection res = createPhysicalArchitectureCmd.getResult();
                if (res.size() == 1 && (createdPhysicalArchitecture = res.iterator().next()) instanceof PhysicalArchitecture) {
                    return PAStructureHelper.getPhysicalArchitectureCreationCmd(editingDomain_p, systemEngineering_p, (PhysicalArchitecture)createdPhysicalArchitecture);
                }
                return new IdentityCommand();
            }
        };
        cmd.append((Command)createPhysicalArchitectureContentCmd);
        return cmd;
    }

    public static Command getPhysicalArchitectureCreationCmd(EditingDomain editingDomain_p, SystemEngineering systemEngineering_p, PhysicalArchitecture physicalArchitecture_p) {
        CompoundCommand cmd = new CompoundCommand();
        LogicalArchitecture logicalArchitecture = PAStructureHelper.getLogicalArchitecture(systemEngineering_p);
        cmd.append(CommonStructureHelper.getLinkCreationCmd(editingDomain_p, PaPackage.Literals.LOGICAL_ARCHITECTURE_REALIZATION, PaPackage.Literals.PHYSICAL_ARCHITECTURE__OWNED_LOGICAL_ARCHITECTURE_REALIZATIONS, ModellingcorePackage.Literals.ABSTRACT_TRACE__SOURCE_ELEMENT, (EObject)physicalArchitecture_p, ModellingcorePackage.Literals.ABSTRACT_TRACE__TARGET_ELEMENT, (EObject)logicalArchitecture));
        cmd.append(CommonStructureHelper.getRequirementPkgCreationCmd(editingDomain_p, (BlockArchitecture)physicalArchitecture_p));
        cmd.append(PAStructureHelper.getPhysicalFunctionPkgCreationCmd(editingDomain_p, systemEngineering_p, physicalArchitecture_p));
        cmd.append(CommonStructureHelper.getCapabilityRealizationPkgCreationCmd(editingDomain_p, (BlockArchitecture)physicalArchitecture_p));
        cmd.append(CommonStructureHelper.getInterfacePkgCreationCmd(editingDomain_p, (BlockArchitecture)physicalArchitecture_p));
        cmd.append(CommonStructureHelper.getDataPkgCreationCmd(editingDomain_p, (BlockArchitecture)physicalArchitecture_p));
        cmd.append(PAStructureHelper.getPhysicalActorPkgCreationCmd(editingDomain_p, physicalArchitecture_p));
        cmd.append(PAStructureHelper.getRootPhysicalComponentCreationCmd(editingDomain_p, systemEngineering_p, physicalArchitecture_p));
        return cmd;
    }

    public static Command getRootPhysicalComponentCreationCmd(final EditingDomain editingDomain_p, final SystemEngineering systemEngineering_p, PhysicalArchitecture physicalArchitecture_p) {
        CompoundCommand cmd = new CompoundCommand();
        final Command createPhysicalContextCmd = CreateChildCommand.create((EditingDomain)editingDomain_p, (Object)physicalArchitecture_p, (Object)new CommandParameter((Object)physicalArchitecture_p, (Object)PaPackage.Literals.PHYSICAL_ARCHITECTURE__OWNED_PHYSICAL_CONTEXT, (Object)PaFactory.eINSTANCE.createPhysicalContext(NamingConstants.CreatePhysicalArchCmd_physicalContext_name)), (Collection)Collections.EMPTY_LIST);
        cmd.append(createPhysicalContextCmd);
        final Command createPhysicalComponentCmd = CreateChildCommand.create((EditingDomain)editingDomain_p, (Object)physicalArchitecture_p, (Object)new CommandParameter((Object)physicalArchitecture_p, (Object)PaPackage.Literals.PHYSICAL_ARCHITECTURE__OWNED_PHYSICAL_COMPONENT, (Object)PaFactory.eINSTANCE.createPhysicalComponent(NamingConstants.CreatePhysicalArchCmd_physicalComponent_name)), (Collection)Collections.EMPTY_LIST);
        cmd.append(createPhysicalComponentCmd);
        CommandWrapper createLogicalComponentRealizationCmd = new CommandWrapper(){

            public Command createCommand() {
                Object createdPhysicalComponent;
                Collection res = createPhysicalComponentCmd.getResult();
                if (res.size() == 1 && (createdPhysicalComponent = res.iterator().next()) instanceof EObject) {
                    LogicalComponent rootLogicalComponent = PAStructureHelper.getRootLogicalComponent(systemEngineering_p);
                    return CommonStructureHelper.getLinkCreationCmd(editingDomain_p, PaPackage.Literals.LOGICAL_COMPONENT_REALIZATION, PaPackage.Literals.PHYSICAL_COMPONENT__OWNED_LOGICAL_COMPONENT_REALIZATIONS, ModellingcorePackage.Literals.ABSTRACT_TRACE__SOURCE_ELEMENT, (EObject)createdPhysicalComponent, ModellingcorePackage.Literals.ABSTRACT_TRACE__TARGET_ELEMENT, (EObject)rootLogicalComponent);
                }
                return new IdentityCommand();
            }
        };
        cmd.append((Command)createLogicalComponentRealizationCmd);
        CommandWrapper createPartCmd = new CommandWrapper(){

            public Command createCommand() {
                Object createdContext;
                Collection res = createPhysicalContextCmd.getResult();
                if (res.size() == 1 && (createdContext = res.iterator().next()) instanceof EObject) {
                    return CreateChildCommand.create((EditingDomain)editingDomain_p, createdContext, (Object)new CommandParameter(createdContext, (Object)CapellacorePackage.Literals.CLASSIFIER__OWNED_FEATURES, (Object)CsFactory.eINSTANCE.createPart()), (Collection)Collections.EMPTY_LIST);
                }
                return new IdentityCommand();
            }
        };
        cmd.append((Command)createPartCmd);
        CommandWrapper setPartNameCmd = new CommandWrapper((Command)createPartCmd, createPhysicalComponentCmd, editingDomain_p){
            private final /* synthetic */ Command val$createPartCmd;
            private final /* synthetic */ Command val$createPhysicalComponentCmd;
            private final /* synthetic */ EditingDomain val$editingDomain_p;
            {
                this.val$createPartCmd = command;
                this.val$createPhysicalComponentCmd = command2;
                this.val$editingDomain_p = editingDomain;
            }

            public Command createCommand() {
                Collection res1 = this.val$createPartCmd.getResult();
                Collection res2 = this.val$createPhysicalComponentCmd.getResult();
                if (res1.size() == 1 && res2.size() == 1) {
                    Object createdPart = res1.iterator().next();
                    Object createdPhysicalComponent = res2.iterator().next();
                    if (createdPart instanceof EObject && createdPhysicalComponent instanceof EObject) {
                        return new SetCommand(this.val$editingDomain_p, (EObject)createdPart, (EStructuralFeature)ModellingcorePackage.Literals.ABSTRACT_NAMED_ELEMENT__NAME, (Object)((AbstractNamedElement)createdPhysicalComponent).getName());
                    }
                }
                return new IdentityCommand();
            }
        };
        cmd.append((Command)setPartNameCmd);
        CommandWrapper setPartTypeCmd = new CommandWrapper((Command)createPartCmd, createPhysicalComponentCmd, editingDomain_p){
            private final /* synthetic */ Command val$createPartCmd;
            private final /* synthetic */ Command val$createPhysicalComponentCmd;
            private final /* synthetic */ EditingDomain val$editingDomain_p;
            {
                this.val$createPartCmd = command;
                this.val$createPhysicalComponentCmd = command2;
                this.val$editingDomain_p = editingDomain;
            }

            public Command createCommand() {
                Collection res1 = this.val$createPartCmd.getResult();
                Collection res2 = this.val$createPhysicalComponentCmd.getResult();
                if (res1.size() == 1 && res2.size() == 1) {
                    Object createdPart = res1.iterator().next();
                    Object createdPhysicalComponent = res2.iterator().next();
                    if (createdPart instanceof EObject && createdPhysicalComponent instanceof EObject) {
                        return new SetCommand(this.val$editingDomain_p, (EObject)createdPart, (EStructuralFeature)ModellingcorePackage.Literals.ABSTRACT_TYPED_ELEMENT__ABSTRACT_TYPE, createdPhysicalComponent);
                    }
                }
                return new IdentityCommand();
            }
        };
        cmd.append((Command)setPartTypeCmd);
        return cmd;
    }

    public static Command getPhysicalActorPkgCreationCmd(EditingDomain editingDomain_p, PhysicalArchitecture physicalArchitecture_p) {
        return CreateChildCommand.create((EditingDomain)editingDomain_p, (Object)physicalArchitecture_p, (Object)new CommandParameter((Object)physicalArchitecture_p, (Object)PaPackage.Literals.PHYSICAL_ARCHITECTURE__OWNED_PHYSICAL_ACTOR_PKG, (Object)PaFactory.eINSTANCE.createPhysicalActorPkg(NamingConstants.CreatePhysicalArchCmd_actors_pkg_name)), (Collection)Collections.EMPTY_LIST);
    }

    public static Command getPhysicalFunctionPkgCreationCmd(final EditingDomain editingDomain_p, SystemEngineering systemEngineering_p, PhysicalArchitecture physicalArchitecture_p) {
        CompoundCommand cmd = new CompoundCommand();
        final Command createPhysicalFunctionPkgCmd = CreateChildCommand.create((EditingDomain)editingDomain_p, (Object)physicalArchitecture_p, (Object)new CommandParameter((Object)physicalArchitecture_p, (Object)FaPackage.Literals.ABSTRACT_FUNCTIONAL_ARCHITECTURE__OWNED_FUNCTION_PKG, (Object)PaFactory.eINSTANCE.createPhysicalFunctionPkg(NamingConstants.CreatePhysicalArchCmd_physicalFunctions_pkg_name)), (Collection)Collections.EMPTY_LIST);
        cmd.append(createPhysicalFunctionPkgCmd);
        CommandWrapper createPhysicalFunctionCmd = new CommandWrapper(){

            public Command createCommand() {
                Object createdPhysicalFunctionPkg;
                Collection res = createPhysicalFunctionPkgCmd.getResult();
                if (res.size() == 1 && (createdPhysicalFunctionPkg = res.iterator().next()) instanceof EObject) {
                    return CreateChildCommand.create((EditingDomain)editingDomain_p, createdPhysicalFunctionPkg, (Object)new CommandParameter(createdPhysicalFunctionPkg, (Object)PaPackage.Literals.PHYSICAL_FUNCTION_PKG__OWNED_PHYSICAL_FUNCTIONS, (Object)PaFactory.eINSTANCE.createPhysicalFunction(NamingConstants.CreatePhysicalArchCmd_physicalFunction_root_name)), (Collection)Collections.EMPTY_LIST);
                }
                return new IdentityCommand();
            }
        };
        cmd.append((Command)createPhysicalFunctionCmd);
        CommandWrapper createLogicalFunctionRealizationCmd = new CommandWrapper((Command)createPhysicalFunctionCmd, systemEngineering_p, editingDomain_p){
            private final /* synthetic */ Command val$createPhysicalFunctionCmd;
            private final /* synthetic */ SystemEngineering val$systemEngineering_p;
            private final /* synthetic */ EditingDomain val$editingDomain_p;
            {
                this.val$createPhysicalFunctionCmd = command;
                this.val$systemEngineering_p = systemEngineering;
                this.val$editingDomain_p = editingDomain;
            }

            public Command createCommand() {
                Object createdPhysicalFunction;
                Collection res = this.val$createPhysicalFunctionCmd.getResult();
                if (res.size() == 1 && (createdPhysicalFunction = res.iterator().next()) instanceof EObject) {
                    LogicalFunction rootLogicalFunction = PAStructureHelper.getRootLogicalFunction(this.val$systemEngineering_p);
                    return CommonStructureHelper.getLinkCreationCmd(this.val$editingDomain_p, FaPackage.Literals.FUNCTION_REALIZATION, FaPackage.Literals.ABSTRACT_FUNCTION__OWNED_FUNCTION_REALIZATIONS, ModellingcorePackage.Literals.ABSTRACT_TRACE__SOURCE_ELEMENT, (EObject)createdPhysicalFunction, ModellingcorePackage.Literals.ABSTRACT_TRACE__TARGET_ELEMENT, (EObject)rootLogicalFunction);
                }
                return new IdentityCommand();
            }
        };
        cmd.append((Command)createLogicalFunctionRealizationCmd);
        return cmd;
    }
}

