/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.core.platform.sirius.ui.navigator.actions.providers;

import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.ISharedImages;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.actions.ActionFactory;
import org.eclipse.ui.actions.BaseSelectionListenerAction;
import org.eclipse.ui.actions.TextActionHandler;
import org.eclipse.ui.navigator.CommonActionProvider;
import org.eclipse.ui.navigator.ICommonActionExtensionSite;
import org.eclipse.ui.navigator.ICommonViewerSite;
import org.eclipse.ui.navigator.ICommonViewerWorkbenchSite;
import org.polarsys.capella.core.platform.sirius.ui.actions.CapellaCopyAction;
import org.polarsys.capella.core.platform.sirius.ui.actions.CapellaCutAction;
import org.polarsys.capella.core.platform.sirius.ui.actions.CapellaDeleteAction;
import org.polarsys.capella.core.platform.sirius.ui.actions.CapellaPasteAction;
import org.polarsys.capella.core.platform.sirius.ui.navigator.actions.RenameAction;
import org.polarsys.capella.core.platform.sirius.ui.navigator.actions.SelectionHelper;
import org.polarsys.capella.core.platform.sirius.ui.navigator.actions.SortContentAction;
import org.polarsys.capella.core.platform.sirius.ui.navigator.actions.SortSelectionAction;
import org.polarsys.capella.core.platform.sirius.ui.navigator.actions.move.MoveDownAction;
import org.polarsys.capella.core.platform.sirius.ui.navigator.actions.move.MoveUpAction;
import org.polarsys.capella.core.platform.sirius.ui.navigator.view.CapellaCommonNavigator;
import org.polarsys.capella.core.ui.resources.CapellaUIResourcesPlugin;

public class EditCommonActionProvider
extends CommonActionProvider {
    private BaseSelectionListenerAction copyAction;
    private BaseSelectionListenerAction cutAction;
    private CapellaDeleteAction deleteAction;
    private BaseSelectionListenerAction moveDown;
    private BaseSelectionListenerAction moveUp;
    private BaseSelectionListenerAction sortContent;
    private BaseSelectionListenerAction sortSelection;
    private BaseSelectionListenerAction pasteAction;
    private RenameAction renameAction;

    public void dispose() {
        ISelectionProvider selectionProvider = this.getActionSite().getViewSite().getSelectionProvider();
        if (this.cutAction != null) {
            selectionProvider.removeSelectionChangedListener((ISelectionChangedListener)this.cutAction);
            this.cutAction = null;
        }
        if (this.copyAction != null) {
            selectionProvider.removeSelectionChangedListener((ISelectionChangedListener)this.copyAction);
            this.copyAction = null;
        }
        if (this.pasteAction != null) {
            selectionProvider.removeSelectionChangedListener((ISelectionChangedListener)this.pasteAction);
            this.pasteAction = null;
        }
        if (this.deleteAction != null) {
            selectionProvider.removeSelectionChangedListener((ISelectionChangedListener)this.deleteAction);
            this.deleteAction.dispose();
            this.deleteAction = null;
        }
        if (this.moveUp != null) {
            selectionProvider.removeSelectionChangedListener((ISelectionChangedListener)this.moveUp);
            this.moveUp = null;
        }
        if (this.moveDown != null) {
            selectionProvider.removeSelectionChangedListener((ISelectionChangedListener)this.moveDown);
            this.moveDown = null;
        }
        if (this.sortContent != null) {
            selectionProvider.removeSelectionChangedListener((ISelectionChangedListener)this.sortContent);
            this.sortContent = null;
        }
        if (this.sortSelection != null) {
            selectionProvider.removeSelectionChangedListener((ISelectionChangedListener)this.sortSelection);
            this.sortSelection = null;
        }
        if (this.renameAction != null) {
            selectionProvider.removeSelectionChangedListener((ISelectionChangedListener)this.renameAction);
            this.renameAction = null;
        }
        super.dispose();
    }

    public void fillActionBars(IActionBars actionBars) {
        actionBars.setGlobalActionHandler(ActionFactory.CUT.getId(), (IAction)this.cutAction);
        actionBars.setGlobalActionHandler(ActionFactory.COPY.getId(), (IAction)this.copyAction);
        actionBars.setGlobalActionHandler(ActionFactory.PASTE.getId(), (IAction)this.pasteAction);
        actionBars.setGlobalActionHandler(ActionFactory.DELETE.getId(), (IAction)this.deleteAction);
        actionBars.setGlobalActionHandler(ActionFactory.RENAME.getId(), (IAction)this.renameAction);
        TextActionHandler textActionHandler = new TextActionHandler(actionBars);
        textActionHandler.setCutAction((IAction)this.cutAction);
        textActionHandler.setCopyAction((IAction)this.copyAction);
        textActionHandler.setPasteAction((IAction)this.pasteAction);
        textActionHandler.setDeleteAction((IAction)this.deleteAction);
        this.renameAction.setTextActionHandler(textActionHandler);
    }

    public void fillContextMenu(IMenuManager menu) {
        menu.appendToGroup("group.edit", (IAction)this.cutAction);
        menu.appendToGroup("group.edit", (IAction)this.copyAction);
        menu.appendToGroup("group.edit", (IAction)this.pasteAction);
        menu.appendToGroup("group.edit", (IAction)this.deleteAction);
        menu.appendToGroup("group.edit", (IContributionItem)new Separator());
        menu.appendToGroup("group.edit", (IAction)this.moveUp);
        menu.appendToGroup("group.edit", (IAction)this.sortContent);
        menu.appendToGroup("group.edit", (IAction)this.sortSelection);
        menu.appendToGroup("group.edit", (IAction)this.moveDown);
        menu.appendToGroup("group.edit", (IContributionItem)new Separator());
    }

    public void init(ICommonActionExtensionSite site) {
        super.init(site);
        ICommonViewerSite commonViewSite = site.getViewSite();
        if (!(commonViewSite instanceof ICommonViewerWorkbenchSite)) {
            return;
        }
        ICommonViewerWorkbenchSite commonViewerWorkbenchSite = (ICommonViewerWorkbenchSite)commonViewSite;
        CapellaCommonNavigator activePart = (CapellaCommonNavigator)commonViewerWorkbenchSite.getPart();
        ISharedImages sharedImages = PlatformUI.getWorkbench().getSharedImages();
        ISelectionProvider selectionProvider = commonViewSite.getSelectionProvider();
        this.cutAction = new CapellaCutAction(site.getStructuredViewer());
        this.cutAction.setActionDefinitionId("org.eclipse.ui.edit.cut");
        this.cutAction.setImageDescriptor(sharedImages.getImageDescriptor("IMG_TOOL_CUT"));
        this.cutAction.setDisabledImageDescriptor(sharedImages.getImageDescriptor("IMG_TOOL_CUT_DISABLED"));
        SelectionHelper.registerToSelectionChanges((ISelectionChangedListener)this.cutAction, selectionProvider);
        this.copyAction = new CapellaCopyAction(site.getStructuredViewer()){

            public void run() {
                super.run();
                EditCommonActionProvider.this.pasteAction.selectionChanged(this.getStructuredSelection());
            }
        };
        this.copyAction.setActionDefinitionId("org.eclipse.ui.edit.copy");
        this.copyAction.setImageDescriptor(sharedImages.getImageDescriptor("IMG_TOOL_COPY"));
        this.copyAction.setDisabledImageDescriptor(sharedImages.getImageDescriptor("IMG_TOOL_COPY_DISABLED"));
        SelectionHelper.registerToSelectionChanges((ISelectionChangedListener)this.copyAction, selectionProvider);
        this.pasteAction = new CapellaPasteAction();
        this.pasteAction.setActionDefinitionId("org.eclipse.ui.edit.paste");
        this.pasteAction.setImageDescriptor(sharedImages.getImageDescriptor("IMG_TOOL_PASTE"));
        this.pasteAction.setDisabledImageDescriptor(sharedImages.getImageDescriptor("IMG_TOOL_PASTE_DISABLED"));
        SelectionHelper.registerToSelectionChanges((ISelectionChangedListener)this.pasteAction, selectionProvider);
        this.deleteAction = new CapellaDeleteAction();
        this.deleteAction.setActionDefinitionId("org.eclipse.ui.edit.delete");
        this.deleteAction.setImageDescriptor(sharedImages.getImageDescriptor("IMG_TOOL_DELETE"));
        this.deleteAction.setDisabledImageDescriptor(sharedImages.getImageDescriptor("IMG_TOOL_DELETE_DISABLED"));
        SelectionHelper.registerToSelectionChanges((ISelectionChangedListener)this.deleteAction, selectionProvider);
        this.moveUp = new MoveUpAction();
        SelectionHelper.registerToSelectionChanges((ISelectionChangedListener)this.moveUp, selectionProvider);
        this.moveDown = new MoveDownAction();
        SelectionHelper.registerToSelectionChanges((ISelectionChangedListener)this.moveDown, selectionProvider);
        this.sortContent = new SortContentAction();
        this.sortContent.setImageDescriptor(CapellaUIResourcesPlugin.getDefault().getImageDescriptor("full/obj16/capella_sort.gif"));
        this.sortContent.setDisabledImageDescriptor(CapellaUIResourcesPlugin.getDefault().getImageDescriptor("full/obj16/capella_sort_disabled.gif"));
        SelectionHelper.registerToSelectionChanges((ISelectionChangedListener)this.sortContent, selectionProvider);
        this.sortSelection = new SortSelectionAction();
        this.sortSelection.setImageDescriptor(CapellaUIResourcesPlugin.getDefault().getImageDescriptor("full/obj16/capella_sort.gif"));
        this.sortSelection.setDisabledImageDescriptor(CapellaUIResourcesPlugin.getDefault().getImageDescriptor("full/obj16/capella_sort_disabled.gif"));
        SelectionHelper.registerToSelectionChanges((ISelectionChangedListener)this.sortSelection, selectionProvider);
        this.renameAction = new RenameAction(activePart);
        this.renameAction.setActionDefinitionId("org.eclipse.ui.edit.rename");
        SelectionHelper.registerToSelectionChanges((ISelectionChangedListener)this.renameAction, selectionProvider);
    }
}

